/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.difflib;

import java.io.Serializable;
import java.util.List;
import munit.internal.console.AnsiColors$;
import munit.internal.console.Printers$;
import munit.internal.difflib.DiffUtils$;
import munit.internal.difflib.Patch;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005Ua\u0001B\r\u001b\u0001\u0005B\u0001\u0002\u000e\u0001\u0003\u0006\u0004%\t!\u000e\u0005\t}\u0001\u0011\t\u0011)A\u0005m!Aq\b\u0001BC\u0002\u0013\u0005Q\u0007\u0003\u0005A\u0001\t\u0005\t\u0015!\u00037\u0011\u0015\t\u0005\u0001\"\u0001C\u0011\u001d9\u0005A1A\u0005\u0002UBa\u0001\u0013\u0001!\u0002\u00131\u0004bB%\u0001\u0005\u0004%\t!\u000e\u0005\u0007\u0015\u0002\u0001\u000b\u0011\u0002\u001c\t\u000f-\u0003!\u0019!C\u0001\u0019\"1\u0001\u000b\u0001Q\u0001\n5Cq!\u0015\u0001C\u0002\u0013\u0005A\n\u0003\u0004S\u0001\u0001\u0006I!\u0014\u0005\b'\u0002\u0011\r\u0011\"\u00016\u0011\u0019!\u0006\u0001)A\u0005m!)Q\u000b\u0001C\u0001-\")!\f\u0001C\u00017\"9\u0001\rAI\u0001\n\u0003\t\u0007\"\u00027\u0001\t\u0003i\u0007\"\u00028\u0001\t\u0013y\u0007\"\u0002=\u0001\t\u0013I\b\"B>\u0001\t\u0013a\bbBA\u0001\u0001\u0011%\u00111\u0001\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0005\u0011!\u0015N\u001a4\u000b\u0005ma\u0012a\u00023jM\u001ad\u0017N\u0019\u0006\u0003;y\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002?\u0005)Q.\u001e8ji\u000e\u00011c\u0001\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"!K\u0019\u000f\u0005)zcBA\u0016/\u001b\u0005a#BA\u0017!\u0003\u0019a$o\\8u}%\tQ%\u0003\u00021I\u00059\u0001/Y2lC\u001e,\u0017B\u0001\u001a4\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\t\u0001D%\u0001\u0005pER\f\u0017N\\3e+\u00051\u0004CA\u001c<\u001d\tA\u0014\b\u0005\u0002,I%\u0011!\bJ\u0001\u0007!J,G-\u001a4\n\u0005qj$AB*ue&twM\u0003\u0002;I\u0005IqN\u0019;bS:,G\rI\u0001\tKb\u0004Xm\u0019;fI\u0006IQ\r\u001f9fGR,G\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007\r+e\t\u0005\u0002E\u00015\t!\u0004C\u00035\u000b\u0001\u0007a\u0007C\u0003@\u000b\u0001\u0007a'A\u0007pER\f\u0017N\\3e\u00072,\u0017M\\\u0001\u000f_\n$\u0018-\u001b8fI\u000ecW-\u00198!\u00035)\u0007\u0010]3di\u0016$7\t\\3b]\u0006qQ\r\u001f9fGR,Gm\u00117fC:\u0004\u0013!D8ci\u0006Lg.\u001a3MS:,7/F\u0001N!\rIcJN\u0005\u0003\u001fN\u00121aU3r\u00039y'\r^1j]\u0016$G*\u001b8fg\u0002\nQ\"\u001a=qK\u000e$X\r\u001a'j]\u0016\u001c\u0018AD3ya\u0016\u001cG/\u001a3MS:,7\u000fI\u0001\fk:Lg-[3e\t&4g-\u0001\u0007v]&4\u0017.\u001a3ES\u001a4\u0007%A\u0004jg\u0016k\u0007\u000f^=\u0016\u0003]\u0003\"a\t-\n\u0005e##a\u0002\"p_2,\u0017M\\\u0001\rGJ,\u0017\r^3SKB|'\u000f\u001e\u000b\u0004mqs\u0006\"B/\u0012\u0001\u00041\u0014!\u0002;ji2,\u0007bB0\u0012!\u0003\u0005\raV\u0001\u001baJLg\u000e^(ci\u0006Lg.\u001a3BgN#(/\u001b9NCJ<\u0017N\\\u0001\u0017GJ,\u0017\r^3SKB|'\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\t!M\u000b\u0002XG.\nA\r\u0005\u0002fU6\taM\u0003\u0002hQ\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003S\u0012\n!\"\u00198o_R\fG/[8o\u0013\tYgMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAc\u0019:fCR,G)\u001b4g\u001f:d\u0017PU3q_J$H#\u0001\u001c\u0002)\u0005\u0004\b/\u001a8e\t&4gm\u00148msJ+\u0007o\u001c:u)\t\u00018\u000f\u0005\u0002$c&\u0011!\u000f\n\u0002\u0005+:LG\u000fC\u0003u)\u0001\u0007Q/\u0001\u0002tEB\u0011\u0011F^\u0005\u0003oN\u0012Qb\u0015;sS:<')^5mI\u0016\u0014\u0018!D1t'R\u0014\u0018\u000e]'be\u001eLg\u000e\u0006\u00027u\")A'\u0006a\u0001m\u00051\u0001.Z1eKJ$2!^?\u0000\u0011\u0015qh\u00031\u00017\u0003\u0005!\b\"\u0002;\u0017\u0001\u0004)\u0018!E2sK\u0006$X-\u00168jM&,G\rR5gMR)a'!\u0002\u0002\n!1\u0011qA\fA\u00025\u000b\u0001b\u001c:jO&t\u0017\r\u001c\u0005\u0007\u0003\u00179\u0002\u0019A'\u0002\u000fI,g/[:fI\u0006q1\u000f\u001d7ji&sGo\u001c'j]\u0016\u001cHcA'\u0002\u0012!1\u00111\u0003\rA\u0002Y\naa\u001d;sS:<\u0007")
public class Diff
implements Serializable {
    private final String obtained;
    private final String expected;
    private final String obtainedClean;
    private final String expectedClean;
    private final Seq<String> obtainedLines;
    private final Seq<String> expectedLines;
    private final String unifiedDiff;

    public String obtained() {
        return this.obtained;
    }

    public String expected() {
        return this.expected;
    }

    public String obtainedClean() {
        return this.obtainedClean;
    }

    public String expectedClean() {
        return this.expectedClean;
    }

    public Seq<String> obtainedLines() {
        return this.obtainedLines;
    }

    public Seq<String> expectedLines() {
        return this.expectedLines;
    }

    public String unifiedDiff() {
        return this.unifiedDiff;
    }

    public boolean isEmpty() {
        return this.unifiedDiff().isEmpty();
    }

    public String createReport(String title, boolean printObtainedAsStripMargin) {
        BoxedUnit boxedUnit;
        StringBuilder sb = new StringBuilder();
        Object object = StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(title)) ? sb.append(title).append("\n") : BoxedUnit.UNIT;
        if (this.obtainedClean().length() < 1000) {
            this.header("Obtained", sb).append("\n");
            StringBuilder stringBuilder = printObtainedAsStripMargin ? sb.append(this.asStripMargin(this.obtainedClean())) : sb.append(this.obtainedClean());
            boxedUnit = sb.append("\n");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.appendDiffOnlyReport(sb);
        return sb.toString();
    }

    public boolean createReport$default$2() {
        return true;
    }

    public String createDiffOnlyReport() {
        StringBuilder out = new StringBuilder();
        this.appendDiffOnlyReport(out);
        return out.toString();
    }

    private void appendDiffOnlyReport(StringBuilder sb) {
        this.header("Diff", sb);
        sb.append(new java.lang.StringBuilder(25).append(" (").append(AnsiColors$.MODULE$.LightRed()).append("- obtained").append(AnsiColors$.MODULE$.Reset()).append(", ").append(AnsiColors$.MODULE$.LightGreen()).append("+ expected").append(AnsiColors$.MODULE$.Reset()).append(")").toString()).append("\n");
        sb.append(this.unifiedDiff());
    }

    private String asStripMargin(String obtained) {
        String string;
        if (!obtained.contains("\n")) {
            string = Printers$.MODULE$.print(obtained, Printers$.MODULE$.print$default$2());
        } else {
            StringBuilder out = new StringBuilder();
            Iterator lines = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(obtained.trim()));
            out.append(new java.lang.StringBuilder(9).append("    \"\"\"|").append(lines.next()).append("\n").toString());
            lines.foreach((Function1 & Serializable)line -> out.append("       |").append(line).append("\n"));
            out.append("       |\"\"\".stripMargin");
            string = out.toString();
        }
        return string;
    }

    private StringBuilder header(String t, StringBuilder sb) {
        return sb.append(AnsiColors$.MODULE$.c(new java.lang.StringBuilder(3).append("=> ").append(t).toString(), AnsiColors$.MODULE$.Bold()));
    }

    private String createUnifiedDiff(Seq<String> original, Seq<String> revised) {
        Patch<String> diff = DiffUtils$.MODULE$.diff((List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(revised).asJava());
        String result = diff.getDeltas().isEmpty() ? "" : ((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(DiffUtils$.MODULE$.generateUnifiedDiff("obtained", "expected", (List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava(), diff, 1)).asScala()).iterator().drop(2).filterNot((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("@@"))).map((Function1 & Serializable)line -> line.isEmpty() ? line : (StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(line)) == ' ' ? new java.lang.StringBuilder(1).append((String)line).append("\u2219").toString() : line)).map((Function1 & Serializable)line -> line.startsWith("-") ? AnsiColors$.MODULE$.c((String)line, AnsiColors$.MODULE$.LightRed()) : (line.startsWith("+") ? AnsiColors$.MODULE$.c((String)line, AnsiColors$.MODULE$.LightGreen()) : line)).mkString("\n");
        return result;
    }

    private Seq<String> splitIntoLines(String string) {
        return ArrayOps$.MODULE$.toIndexedSeq$extension(Predef$.MODULE$.refArrayOps((Object[])string.trim().replace("\r\n", "\n").split("\n")));
    }

    public Diff(String obtained, String expected) {
        this.obtained = obtained;
        this.expected = expected;
        this.obtainedClean = AnsiColors$.MODULE$.filterAnsi(obtained);
        this.expectedClean = AnsiColors$.MODULE$.filterAnsi(expected);
        this.obtainedLines = this.splitIntoLines(this.obtainedClean());
        this.expectedLines = this.splitIntoLines(this.expectedClean());
        this.unifiedDiff = this.createUnifiedDiff(this.obtainedLines(), this.expectedLines());
    }
}

