/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import munit.Clue;
import munit.Clues;
import munit.Location;
import munit.internal.console.AnsiColors$;
import munit.internal.console.Printers$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0005m3Aa\u0002\u0005\u0001\u001f!)!\u0005\u0001C\u0001G!9a\u0005\u0001b\u0001\n\u00139\u0003BB#\u0001A\u0003%\u0001\u0006C\u0003G\u0001\u0011\u0005q\tC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003G\u0001\u0011\u00051KA\u0003MS:,7O\u0003\u0002\n\u0015\u000591m\u001c8t_2,'BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'\"A\u0007\u0002\u000b5,h.\u001b;\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9rD\u0004\u0002\u0019;9\u0011\u0011\u0004H\u0007\u00025)\u00111DD\u0001\u0007yI|w\u000e\u001e \n\u0003MI!A\b\n\u0002\u000fA\f7m[1hK&\u0011\u0001%\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003=I\ta\u0001P5oSRtD#\u0001\u0013\u0011\u0005\u0015\u0002Q\"\u0001\u0005\u0002\u0013\u0019LG.Z2bG\",W#\u0001\u0015\u0011\t%r\u0003GO\u0007\u0002U)\u00111\u0006L\u0001\b[V$\u0018M\u00197f\u0015\ti##\u0001\u0006d_2dWm\u0019;j_:L!a\f\u0016\u0003\u00075\u000b\u0007\u000f\u0005\u00022q5\t!G\u0003\u00024i\u0005!a-\u001b7f\u0015\t)d'A\u0002oS>T\u0011aN\u0001\u0005U\u00064\u0018-\u0003\u0002:e\t!\u0001+\u0019;i!\r\t2(P\u0005\u0003yI\u0011Q!\u0011:sCf\u0004\"A\u0010\"\u000f\u0005}\u0002\u0005CA\r\u0013\u0013\t\t%#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0007\u0012\u0013aa\u0015;sS:<'BA!\u0013\u0003)1\u0017\u000e\\3dC\u000eDW\rI\u0001\u000bM>\u0014X.\u0019;MS:,GcA\u001fI\u001d\")\u0011\n\u0002a\u0001\u0015\u0006AAn\\2bi&|g\u000e\u0005\u0002L\u00196\tA\"\u0003\u0002N\u0019\tAAj\\2bi&|g\u000eC\u0003P\t\u0001\u0007Q(A\u0004nKN\u001c\u0018mZ3\u0002\u0015\u0019|'/\\1u!\u0006$\b\u000e\u0006\u0002>%\")\u0011*\u0002a\u0001\u0015R!Q\bV+W\u0011\u0015Ie\u00011\u0001K\u0011\u0015ye\u00011\u0001>\u0011\u00159f\u00011\u0001Y\u0003\u0015\u0019G.^3t!\tY\u0015,\u0003\u0002[\u0019\t)1\t\\;fg\u0002")
public class Lines
implements Serializable {
    private final Map<Path, String[]> filecache = (Map)Map$.MODULE$.empty();

    private Map<Path, String[]> filecache() {
        return this.filecache;
    }

    public String formatLine(Location location, String message) {
        return this.formatLine(location, message, new Clues((List<Clue<?>>)Nil$.MODULE$));
    }

    public String formatPath(Location location) {
        return location.path();
    }

    public String formatLine(Location location, String message, Clues clues) {
        String string;
        try {
            Object object;
            Path path = Paths.get(location.path(), new String[0]);
            String[] lines = (String[])this.filecache().getOrElseUpdate((Object)path, (Function0 & Serializable)() -> (String[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(path)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)));
            String[] slice = (String[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps((Object[])lines), location.line() - 2, location.line() + 1);
            scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
            if (slice.length >= 2) {
                int width = ((Object)BoxesRunTime.boxToInteger((int)(location.line() + 1))).toString().length() + 1;
                boolean isMultilineMessage = StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(message), '\n');
                out.append(this.formatPath(location)).append(':').append(((Object)BoxesRunTime.boxToInteger((int)location.line())).toString());
                Object object2 = message.length() > 0 && !isMultilineMessage ? out.append(" ").append(message) : BoxedUnit.UNIT;
                out.append('\n').append(Lines.format$1(location.line() - 1, width)).append(slice[0]).append('\n').append(AnsiColors$.MODULE$.Reversed()).append(Lines.format$1(location.line(), width)).append(slice[1]).append(AnsiColors$.MODULE$.Reset());
                Object object3 = slice.length >= 3 ? out.append('\n').append(Lines.format$1(location.line() + 1, width)).append(slice[2]) : BoxedUnit.UNIT;
                Object object4 = isMultilineMessage ? out.append('\n').append(message) : BoxedUnit.UNIT;
                object = clues.values().nonEmpty() ? out.append('\n').append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 == null || (option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                throw throwable;
            }
            String string2 = clues.values().isEmpty() ? message : new StringBuilder(1).append(message).append("\n").append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())).toString();
            string = string2;
        }
        return string;
    }

    private static final String format$1(int n, int width$1) {
        return StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(new StringBuilder(1).append(n).append(":").toString()), width$1, ' ');
    }
}

