/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import java.io.Serializable;
import java.nio.file.Path;
import munit.Clue;
import munit.Clues;
import munit.Location;
import munit.diff.console.AnsiColors$;
import munit.internal.console.Printers$;
import munit.internal.io.PlatformIO$Files$;
import munit.internal.io.PlatformIO$Path$;
import munit.internal.io.PlatformIO$Paths$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.sys.package$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u000514A\u0001C\u0005\u0001!!)1\u0005\u0001C\u0001I!9q\u0005\u0001b\u0001\n\u0013A\u0003BB&\u0001A\u0003%\u0011\u0006C\u0003M\u0001\u0011\u0005Q\nC\u0003W\u0001\u0011\u0005q\u000bC\u0003Z\u0001\u0011\u0005!\fC\u0003M\u0001\u0011\u0005AMA\u0003MS:,7O\u0003\u0002\u000b\u0017\u000591m\u001c8t_2,'B\u0001\u0007\u000e\u0003!Ig\u000e^3s]\u0006d'\"\u0001\b\u0002\u000b5,h.\u001b;\u0004\u0001M\u0019\u0001!E\f\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g!\tA\u0002E\u0004\u0002\u001a=9\u0011!$H\u0007\u00027)\u0011AdD\u0001\u0007yI|w\u000e\u001e \n\u0003QI!aH\n\u0002\u000fA\f7m[1hK&\u0011\u0011E\t\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0006\u0003?M\ta\u0001P5oSRtD#A\u0013\u0011\u0005\u0019\u0002Q\"A\u0005\u0002\u0013\u0019LG.Z2bG\",W#A\u0015\u0011\t)z\u0013\u0007Q\u0007\u0002W)\u0011A&L\u0001\b[V$\u0018M\u00197f\u0015\tq3#\u0001\u0006d_2dWm\u0019;j_:L!\u0001M\u0016\u0003\u00075\u000b\u0007\u000f\u0005\u00023{9\u00111G\u000f\b\u0003iar!!N\u001c\u000f\u0005i1\u0014\"\u0001\b\n\u00051i\u0011BA\u001d\f\u0003\tIw.\u0003\u0002<y\u0005Q\u0001\u000b\\1uM>\u0014X.S(\u000b\u0005eZ\u0011B\u0001 @\u0005\u0011\u0001\u0016\r\u001e5\u000b\u0005mb\u0004c\u0001\nB\u0007&\u0011!i\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003\t\"s!!\u0012$\u0011\u0005i\u0019\u0012BA$\u0014\u0003\u0019\u0001&/\u001a3fM&\u0011\u0011J\u0013\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u001d\u001b\u0012A\u00034jY\u0016\u001c\u0017m\u00195fA\u0005Qam\u001c:nCRd\u0015N\\3\u0015\u0007\rsE\u000bC\u0003P\t\u0001\u0007\u0001+\u0001\u0005m_\u000e\fG/[8o!\t\t&+D\u0001\u000e\u0013\t\u0019VB\u0001\u0005M_\u000e\fG/[8o\u0011\u0015)F\u00011\u0001D\u0003\u001diWm]:bO\u0016\f!BZ8s[\u0006$\b+\u0019;i)\t\u0019\u0005\fC\u0003P\u000b\u0001\u0007\u0001+\u0001\u0005gS:$\u0007+\u0019;i)\u0011\t4,X0\t\u000bq3\u0001\u0019A\"\u0002\u0007\r<H\rC\u0003_\r\u0001\u00071)\u0001\u0003qCRD\u0007\"\u00021\u0007\u0001\u0004\t\u0017aA7bqB\u0011!CY\u0005\u0003GN\u00111!\u00138u)\u0011\u0019UMZ4\t\u000b=;\u0001\u0019\u0001)\t\u000bU;\u0001\u0019A\"\t\u000b!<\u0001\u0019A5\u0002\u000b\rdW/Z:\u0011\u0005ES\u0017BA6\u000e\u0005\u0015\u0019E.^3t\u0001")
public class Lines
implements Serializable {
    private final Map<Path, String[]> filecache = (Map)Map$.MODULE$.empty();

    private Map<Path, String[]> filecache() {
        return this.filecache;
    }

    public String formatLine(Location location, String message) {
        return this.formatLine(location, message, new Clues((List<Clue<?>>)Nil$.MODULE$));
    }

    public String formatPath(Location location) {
        return location.path();
    }

    public Path findPath(String cwd, String path, int max) {
        Path p = PlatformIO$Paths$.MODULE$.get(cwd).resolve(path);
        if (PlatformIO$Files$.MODULE$.exists(p)) {
            return p;
        }
        if (max < 1) {
            throw package$.MODULE$.error(new StringBuilder(14).append(path).append(" was not found").toString());
        }
        if (cwd.contains("\\")) {
            return this.findPath(Lines.getParentPath$1(cwd, "\\"), path, max - 1);
        }
        return this.findPath(Lines.getParentPath$1(cwd, "/"), path, max - 1);
    }

    public String formatLine(Location location, String message, Clues clues) {
        String string;
        try {
            Object object;
            Path path = this.findPath(((Object)PlatformIO$Path$.MODULE$.workingDirectory()).toString(), location.path(), 3);
            String[] lines = (String[])this.filecache().getOrElseUpdate((Object)path, (Function0 & Serializable)() -> (String[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(PlatformIO$Files$.MODULE$.readAllLines(path)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)));
            String[] slice = (String[])ArrayOps$.MODULE$.slice$extension(Predef$.MODULE$.refArrayOps((Object[])lines), location.line() - 2, location.line() + 1);
            scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
            if (slice.length >= 2) {
                int width = Integer.toString(location.line() + 1).length() + 1;
                boolean isMultilineMessage = StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(message), '\n');
                out.append(this.formatPath(location)).append(':').append(Integer.toString(location.line()));
                Object object2 = message.length() > 0 && !isMultilineMessage ? out.append(" ").append(message) : BoxedUnit.UNIT;
                out.append('\n').append(Lines.format$1(location.line() - 1, width)).append(slice[0]).append('\n').append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reversed())).append(Lines.format$1(location.line(), width)).append(slice[1]).append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset()));
                Object object3 = slice.length >= 3 ? out.append('\n').append(Lines.format$1(location.line() + 1, width)).append(slice[2]) : BoxedUnit.UNIT;
                Object object4 = isMultilineMessage ? out.append('\n').append(message) : BoxedUnit.UNIT;
                object = clues.values().nonEmpty() ? out.append('\n').append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                string = clues.values().isEmpty() ? message : new StringBuilder(1).append(message).append("\n").append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())).toString();
            }
            throw throwable;
        }
        return string;
    }

    private static final String getParentPath$1(String somePath, String sep) {
        String somePath1 = somePath.endsWith(sep) ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(somePath), sep.length()) : somePath;
        String string = sep;
        String string2 = "\\";
        String sep1 = !(string != null ? !string.equals(string2) : string2 != null) ? "\\\\" : sep;
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.dropRight$extension(Predef$.MODULE$.refArrayOps((Object[])somePath1.split(sep1)), 1)).mkString(sep);
    }

    private static final String format$1(int n, int width$1) {
        return StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(new StringBuilder(1).append(n).append(":").toString()), width$1, ' ');
    }
}

