/*
 * Decompiled with CFR 0.152.
 */
package munit;

import dotty.runtime.function.JFunction1;
import dotty.runtime.function.JFunction2;
import java.io.Serializable;
import munit.FailException;
import munit.FunSuite;
import munit.GenericTest;
import munit.TestValues;
import munit.internal.FutureCompat$;
import munit.package$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public interface TestTransforms {
    public static List munitTestTransforms$(TestTransforms $this) {
        return $this.munitTestTransforms();
    }

    default public List<TestTransform> munitTestTransforms() {
        return (List)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new TestTransform[]{this.munitFailTransform(), this.munitFlakyTransform()}));
    }

    public static GenericTest munitTestTransform$(TestTransforms $this, GenericTest test) {
        return $this.munitTestTransform(test);
    }

    default public GenericTest munitTestTransform(GenericTest test) {
        GenericTest genericTest;
        try {
            genericTest = (GenericTest)this.munitTestTransforms().foldLeft((Object)test, (Function2)(JFunction2 & Serializable)(x$1, x$2) -> {
                Tuple2 tuple2 = Tuple2$.MODULE$.apply(x$1, x$2);
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                GenericTest t = (GenericTest)tuple2._1();
                TestTransform fn = (TestTransform)tuple2._2();
                return fn.apply(t);
            });
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3;
                Throwable e = throwable3 = (Throwable)option.get();
                genericTest = test.withBody((Function0 & Serializable)() -> Future$.MODULE$.failed(e));
            }
            throw throwable;
        }
        return genericTest;
    }

    public static TestTransform munitFailTransform$(TestTransforms $this) {
        return $this.munitFailTransform();
    }

    default public TestTransform munitFailTransform() {
        return new TestTransform(this, "fail", (Function1<GenericTest<Future<Object>>, GenericTest<Future<Object>>>)(JFunction1 & Serializable)t -> t.tags().apply((Object)package$.MODULE$.Fail()) ? t.withBodyMap((JFunction1 & Serializable)_$1 -> FutureCompat$.MODULE$.ExtensionFuture(_$1).transformCompat((JFunction1 & Serializable)x$1 -> {
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Object value = ((Success)try_).value();
                Failure$ failure$ = Failure$.MODULE$;
                throw new FailException(((FunSuite)this).munitLines().formatLine(t.location(), "expected failure but test passed"), t.location());
            }
            if (!(try_ instanceof Failure)) {
                throw new MatchError((Object)try_);
            }
            Throwable exception = ((Failure)try_).exception();
            return Success$.MODULE$.apply((Object)BoxedUnit.UNIT);
        }, ((FunSuite)this).munitExecutionContext())) : t);
    }

    public static boolean munitFlakyOK$(TestTransforms $this) {
        return $this.munitFlakyOK();
    }

    default public boolean munitFlakyOK() {
        return "true".equals(System.getenv("MUNIT_FLAKY_OK"));
    }

    public static TestTransform munitFlakyTransform$(TestTransforms $this) {
        return $this.munitFlakyTransform();
    }

    default public TestTransform munitFlakyTransform() {
        return new TestTransform(this, "flaky", (Function1<GenericTest<Future<Object>>, GenericTest<Future<Object>>>)(JFunction1 & Serializable)t -> t.tags().apply((Object)package$.MODULE$.Flaky()) ? t.withBodyMap((JFunction1 & Serializable)_$2 -> FutureCompat$.MODULE$.ExtensionFuture(_$2).transformCompat((JFunction1 & Serializable)x$1 -> {
            Success success;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Object value = ((Success)try_).value();
                success = Success$.MODULE$.apply(value);
                return success;
            } else {
                if (!(try_ instanceof Failure)) throw new MatchError((Object)try_);
                Throwable exception = ((Failure)try_).exception();
                if (!this.munitFlakyOK()) throw exception;
                success = Success$.MODULE$.apply((Object)new TestValues.FlakyFailure(exception));
            }
            return success;
        }, ((FunSuite)this).munitExecutionContext())) : t);
    }

    public final class TestTransform
    implements Function1<GenericTest<Future<Object>>, GenericTest<Future<Object>>> {
        private final String name;
        private final Function1<GenericTest<Future<Object>>, GenericTest<Future<Object>>> fn;
        private final TestTransforms $outer;

        public TestTransform(TestTransforms $outer, String name, Function1<GenericTest<Future<Object>>, GenericTest<Future<Object>>> fn) {
            this.name = name;
            this.fn = fn;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public String name() {
            return this.name;
        }

        public GenericTest apply(GenericTest v1) {
            return (GenericTest)this.fn.apply((Object)v1);
        }

        public final TestTransforms munit$TestTransforms$TestTransform$$$outer() {
            return this.$outer;
        }
    }
}

