/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.difflib;

import dotty.runtime.function.JFunction1;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import munit.internal.difflib.Delta;
import munit.internal.difflib.MyersDiff;
import munit.internal.difflib.Patch;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class DiffUtils$
implements Serializable {
    public static final DiffUtils$ MODULE$ = new DiffUtils$();

    private DiffUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DiffUtils$.class);
    }

    public List<String> generateUnifiedDiff(String original, String revised, List<String> originalLines, Patch<String> patch, int contextSize) {
        ArrayList<String> arrayList;
        if (!patch.getDeltas().isEmpty()) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add("--- " + original);
            ret.add("+++ " + revised);
            ArrayList<Delta<String>> patchDeltas = new ArrayList<Delta<String>>(patch.getDeltas());
            ArrayList<Delta<String>> deltas = new ArrayList<Delta<String>>();
            ObjectRef delta = ObjectRef.create((Object)((Delta)patchDeltas.get(0)));
            deltas.add((Delta)delta.elem);
            if (patchDeltas.size() > 1) {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), patchDeltas.size()).foreach((Function1)(JFunction1.mcVI.sp & Serializable)i -> {
                    boolean bl;
                    int position = ((Delta)delta$1.elem).getOriginal().getPosition();
                    Delta nextDelta = (Delta)patchDeltas.get(i);
                    if (position + ((Delta)delta$1.elem).getOriginal().size() + contextSize >= nextDelta.getOriginal().getPosition() - contextSize) {
                        bl = deltas.add(nextDelta);
                    } else {
                        ArrayList<String> curBlock = this.processDeltas(originalLines, deltas, contextSize);
                        ret.addAll(curBlock);
                        deltas.clear();
                        bl = deltas.add(nextDelta);
                    }
                    Delta delta = nextDelta;
                    delta$1.elem = delta;
                });
            }
            ArrayList<String> curBlock = this.processDeltas(originalLines, deltas, contextSize);
            ret.addAll(curBlock);
            arrayList = ret;
        } else {
            arrayList = new ArrayList<String>();
        }
        return arrayList;
    }

    public Patch<String> diff(List<String> original, List<String> revised) {
        return new MyersDiff<String>().diff(original, revised);
    }

    private ArrayList<String> processDeltas(List<String> origLines, List<Delta<String>> deltas, int contextSize) {
        int contextStart;
        int revStart;
        ArrayList<String> buffer = new ArrayList<String>();
        int origTotal = 0;
        int revTotal = 0;
        int line = 0;
        Delta<String> curDelta = deltas.get(0);
        int origStart = curDelta.getOriginal().getPosition() + 1 - contextSize;
        if (origStart < 1) {
            origStart = 1;
        }
        if ((revStart = curDelta.getRevised().getPosition() + 1 - contextSize) < 1) {
            revStart = 1;
        }
        if ((contextStart = curDelta.getOriginal().getPosition() - contextSize) < 0) {
            contextStart = 0;
        }
        line = contextStart;
        while (line < curDelta.getOriginal().getPosition()) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
            ++line;
        }
        buffer.addAll(this.getDeltaText(curDelta));
        origTotal += curDelta.getOriginal().getLines().size();
        revTotal += curDelta.getRevised().getLines().size();
        int deltaIndex = 1;
        while (deltaIndex < deltas.size()) {
            int intermediateStart;
            Delta<String> nextDelta = deltas.get(deltaIndex);
            line = intermediateStart = curDelta.getOriginal().getPosition() + curDelta.getOriginal().getLines().size();
            while (line < nextDelta.getOriginal().getPosition()) {
                buffer.add(" " + origLines.get(line));
                ++origTotal;
                ++revTotal;
                ++line;
            }
            buffer.addAll(this.getDeltaText(nextDelta));
            origTotal += nextDelta.getOriginal().getLines().size();
            revTotal += nextDelta.getRevised().getLines().size();
            curDelta = nextDelta;
            ++deltaIndex;
        }
        line = contextStart = curDelta.getOriginal().getPosition() + curDelta.getOriginal().getLines().size();
        while (line < contextStart + contextSize && line < origLines.size()) {
            buffer.add(" " + origLines.get(line));
            ++origTotal;
            ++revTotal;
            ++line;
        }
        StringBuffer header = new StringBuffer();
        header.append("@@ -");
        header.append(origStart);
        header.append(",");
        header.append(origTotal);
        header.append(" +");
        header.append(revStart);
        header.append(",");
        header.append(revTotal);
        header.append(" @@");
        buffer.add(0, header.toString());
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<String> getDeltaText(Delta<String> delta) {
        void var2_2;
        ArrayList buffer = new ArrayList();
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(delta.getOriginal().getLines()).asScala()).foreach((Function1)(JFunction1 & Serializable)line -> buffer.add("-" + line));
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(delta.getRevised().getLines()).asScala()).foreach((Function1)(JFunction1 & Serializable)line -> buffer.add("+" + line));
        return var2_2;
    }
}

