/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import munit.Clue;
import munit.Clues;
import munit.Location;
import munit.internal.console.AnsiColors$;
import munit.internal.console.Printers$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001U3Aa\u0002\u0005\u0001\u001f!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0013q\u0002BB \u0001A\u0003%q\u0004C\u0003A\u0001\u0011\u0005\u0011\tC\u0003K\u0001\u0011\u00051\nC\u0003A\u0001\u0011\u0005QJA\u0003MS:,7O\u0003\u0002\n\u0015\u000591m\u001c8t_2,'BA\u0006\r\u0003!Ig\u000e^3s]\u0006d'\"A\u0007\u0002\u000b5,h.\u001b;\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t\tr#\u0003\u0002\u0019%\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012a\u0007\t\u00039\u0001i\u0011\u0001C\u0001\nM&dWmY1dQ\u0016,\u0012a\b\t\u0005A\u0015:\u0013'D\u0001\"\u0015\t\u00113%A\u0004nkR\f'\r\\3\u000b\u0005\u0011\u0012\u0012AC2pY2,7\r^5p]&\u0011a%\t\u0002\u0004\u001b\u0006\u0004\bC\u0001\u00150\u001b\u0005I#B\u0001\u0016,\u0003\u00111\u0017\u000e\\3\u000b\u00051j\u0013a\u00018j_*\ta&\u0001\u0003kCZ\f\u0017B\u0001\u0019*\u0005\u0011\u0001\u0016\r\u001e5\u0011\u0007E\u0011D'\u0003\u00024%\t)\u0011I\u001d:bsB\u0011Q\u0007\u0010\b\u0003mi\u0002\"a\u000e\n\u000e\u0003aR!!\u000f\b\u0002\rq\u0012xn\u001c;?\u0013\tY$#\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e\u0013\u0003)1\u0017\u000e\\3dC\u000eDW\rI\u0001\u000bM>\u0014X.\u0019;MS:,Gc\u0001\u001bC\u0011\")1\t\u0002a\u0001\t\u0006AAn\\2bi&|g\u000e\u0005\u0002F\r6\tA\"\u0003\u0002H\u0019\tAAj\\2bi&|g\u000eC\u0003J\t\u0001\u0007A'A\u0004nKN\u001c\u0018mZ3\u0002\u0015\u0019|'/\\1u!\u0006$\b\u000e\u0006\u00025\u0019\")1)\u0002a\u0001\tR!AGT(Q\u0011\u0015\u0019e\u00011\u0001E\u0011\u0015Ie\u00011\u00015\u0011\u0015\tf\u00011\u0001S\u0003\u0015\u0019G.^3t!\t)5+\u0003\u0002U\u0019\t)1\t\\;fg\u0002")
public class Lines
implements scala.Serializable {
    private final Map<Path, String[]> filecache = Map$.MODULE$.empty();

    private Map<Path, String[]> filecache() {
        return this.filecache;
    }

    public String formatLine(Location location, String message) {
        return this.formatLine(location, message, new Clues((List<Clue<?>>)Nil$.MODULE$));
    }

    public String formatPath(Location location) {
        return location.path();
    }

    public String formatLine(Location location, String message, Clues clues) {
        String string;
        try {
            Object object;
            Path path = Paths.get(location.path(), new String[0]);
            String[] lines = (String[])this.filecache().getOrElseUpdate((Object)path, (Function0 & Serializable & scala.Serializable)() -> (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(Files.readAllLines(path)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)));
            String[] slice = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).slice(location.line() - 2, location.line() + 1);
            scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
            if (slice.length >= 2) {
                int width = Integer.toString(location.line() + 1).length() + 1;
                boolean isMultilineMessage = new StringOps(Predef$.MODULE$.augmentString(message)).contains((Object)BoxesRunTime.boxToCharacter((char)'\n'));
                out.append(this.formatPath(location)).append(':').append(Integer.toString(location.line()));
                Object object2 = message.length() > 0 && !isMultilineMessage ? out.append(" ").append(message) : BoxedUnit.UNIT;
                out.append('\n').append(Lines.format$1(location.line() - 1, width)).append(slice[0]).append('\n').append(AnsiColors$.MODULE$.Reversed()).append(Lines.format$1(location.line(), width)).append(slice[1]).append(AnsiColors$.MODULE$.Reset());
                Object object3 = slice.length >= 3 ? out.append('\n').append(Lines.format$1(location.line() + 1, width)).append(slice[2]) : BoxedUnit.UNIT;
                Object object4 = isMultilineMessage ? out.append('\n').append(message) : BoxedUnit.UNIT;
                object = clues.values().nonEmpty() ? out.append('\n').append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            String string2 = clues.values().isEmpty() ? message : new StringBuilder(1).append(message).append("\n").append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())).toString();
            string = string2;
        }
        return string;
    }

    private static final String format$1(int n, int width$1) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1).append(n).append(":").toString())).padTo(width$1, (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom());
    }
}

