/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.difflib;

import java.io.Serializable;
import java.util.List;
import munit.internal.console.AnsiColors$;
import munit.internal.console.Printers$;
import munit.internal.difflib.DiffUtils$;
import munit.internal.difflib.Patch;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;

public class Diff
implements Serializable {
    private final String obtained;
    private final String expected;
    private final String obtainedClean;
    private final String expectedClean;
    private final Seq obtainedLines;
    private final Seq expectedLines;
    private final String unifiedDiff;

    public Diff(String obtained, String expected) {
        this.obtained = obtained;
        this.expected = expected;
        this.obtainedClean = AnsiColors$.MODULE$.filterAnsi(obtained);
        this.expectedClean = AnsiColors$.MODULE$.filterAnsi(expected);
        this.obtainedLines = this.splitIntoLines(this.obtainedClean());
        this.expectedLines = this.splitIntoLines(this.expectedClean());
        this.unifiedDiff = this.createUnifiedDiff(this.obtainedLines(), this.expectedLines());
    }

    public String obtained() {
        return this.obtained;
    }

    public String expected() {
        return this.expected;
    }

    public String obtainedClean() {
        return this.obtainedClean;
    }

    public String expectedClean() {
        return this.expectedClean;
    }

    public Seq<String> obtainedLines() {
        return this.obtainedLines;
    }

    public Seq<String> expectedLines() {
        return this.expectedLines;
    }

    public String unifiedDiff() {
        return this.unifiedDiff;
    }

    public boolean isEmpty() {
        return this.unifiedDiff().isEmpty();
    }

    public String createReport(String title, boolean printObtainedAsStripMargin) {
        StringBuilder sb = new StringBuilder();
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(title))) {
            sb.append(title).append("\n");
        }
        if (this.obtainedClean().length() < 1000) {
            this.header("Obtained", sb).append("\n");
            StringBuilder stringBuilder = printObtainedAsStripMargin ? sb.append(this.asStripMargin(this.obtainedClean())) : sb.append(this.obtainedClean());
            sb.append("\n");
        }
        this.appendDiffOnlyReport(sb);
        return sb.toString();
    }

    public boolean createReport$default$2() {
        return true;
    }

    public String createDiffOnlyReport() {
        StringBuilder out = new StringBuilder();
        this.appendDiffOnlyReport(out);
        return out.toString();
    }

    private void appendDiffOnlyReport(StringBuilder sb) {
        this.header("Diff", sb);
        sb.append(new java.lang.StringBuilder(25).append(" (").append(AnsiColors$.MODULE$.LightRed()).append("- obtained").append(AnsiColors$.MODULE$.Reset()).append(", ").append(AnsiColors$.MODULE$.LightGreen()).append("+ expected").append(AnsiColors$.MODULE$.Reset()).append(")").toString()).append("\n");
        sb.append(this.unifiedDiff());
    }

    private String asStripMargin(String obtained) {
        String string;
        if (!obtained.contains("\n")) {
            string = Printers$.MODULE$.print(obtained, Printers$.MODULE$.print$default$2());
        } else {
            StringBuilder out = new StringBuilder();
            Iterator lines = StringOps$.MODULE$.linesIterator$extension(Predef$.MODULE$.augmentString(obtained.trim()));
            String head = lines.hasNext() ? (String)lines.next() : "";
            out.append(new java.lang.StringBuilder(9).append("    \"\"\"|").append(head).append("\n").toString());
            lines.foreach((Function1 & Serializable)line -> out.append("       |").append(line).append("\n"));
            out.append("       |\"\"\".stripMargin");
            string = out.toString();
        }
        return string;
    }

    private StringBuilder header(String t, StringBuilder sb) {
        return sb.append(AnsiColors$.MODULE$.c(new java.lang.StringBuilder(3).append("=> ").append(t).toString(), AnsiColors$.MODULE$.Bold()));
    }

    private String createUnifiedDiff(Seq<String> original, Seq<String> revised) {
        Patch<String> diff = DiffUtils$.MODULE$.diff((List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(revised).asJava());
        String result = diff.getDeltas().isEmpty() ? "" : ((IterableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(DiffUtils$.MODULE$.generateUnifiedDiff("obtained", "expected", (List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava(), diff, 1)).asScala()).iterator().drop(2).filterNot((Function1 & Serializable)_$1 -> _$1.startsWith("@@")).map((Function1 & Serializable)line -> line.isEmpty() ? line : (StringOps$.MODULE$.last$extension(Predef$.MODULE$.augmentString(line)) == ' ' ? new java.lang.StringBuilder(1).append((String)line).append("\u2219").toString() : line)).map((Function1 & Serializable)line -> line.startsWith("-") ? AnsiColors$.MODULE$.c((String)line, AnsiColors$.MODULE$.LightRed()) : (line.startsWith("+") ? AnsiColors$.MODULE$.c((String)line, AnsiColors$.MODULE$.LightGreen()) : line)).mkString("\n");
        return result;
    }

    private Seq<String> splitIntoLines(String string) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])string.trim().replace("\r\n", "\n").split("\n"));
        return ArrayOps$.MODULE$.toIndexedSeq$extension(object);
    }
}

