/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.io.Serializable;
import munit.internal.junitinterface.CustomRunners;
import munit.internal.junitinterface.JUnitRunner;
import munit.internal.junitinterface.RunSettings;
import munit.internal.junitinterface.Settings;
import munit.internal.junitinterface.Settings$;
import munit.internal.junitinterface.TagsFilter;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Runner;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;
import scala.runtime.function.JProcedure1;

public abstract class JUnitFramework
implements Framework {
    public String name() {
        return "Scala.js JUnit test framework";
    }

    public abstract CustomRunners customRunners();

    public Fingerprint[] fingerprints() {
        return (Fingerprint[])this.customRunners().runners().toArray(ClassTag$.MODULE$.apply(Fingerprint.class));
    }

    public Runner runner(String[] args, String[] remoteArgs, ClassLoader testClassLoader) {
        return new JUnitRunner(args, remoteArgs, this.parseRunSettings(args), testClassLoader, this.customRunners());
    }

    public Runner slaveRunner(String[] args, String[] remoteArgs, ClassLoader testClassLoader, Function1<String, BoxedUnit> send) {
        return new JUnitRunner(args, remoteArgs, this.parseRunSettings(args), testClassLoader, this.customRunners());
    }

    private RunSettings parseRunSettings(String[] args) {
        Settings defaults = Settings$.MODULE$.defaults();
        BooleanRef verbose = BooleanRef.create((boolean)false);
        BooleanRef noColor = BooleanRef.create((boolean)false);
        BooleanRef decodeScalaNames = BooleanRef.create((boolean)false);
        BooleanRef logAssert = BooleanRef.create((boolean)false);
        BooleanRef notLogExceptionClass = BooleanRef.create((boolean)false);
        BooleanRef useSbtLoggers = BooleanRef.create((boolean)false);
        BooleanRef trimStackTraces = BooleanRef.create((boolean)defaults.trimStackTraces());
        ObjectRef includeTags = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ObjectRef excludeTags = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1)(JProcedure1 & Serializable)str -> {
            String string = str;
            switch (string == null ? 0 : string.hashCode()) {
                case 1492: {
                    boolean bl;
                    if (!"-a".equals(string)) break;
                    logAssert$1.elem = bl = true;
                    return;
                }
                case 1494: {
                    boolean bl;
                    if (!"-c".equals(string)) break;
                    notLogExceptionClass$1.elem = bl = true;
                    return;
                }
                case 1505: {
                    boolean bl;
                    if (!"-n".equals(string)) break;
                    noColor$1.elem = bl = true;
                    return;
                }
                case 1510: {
                    boolean bl;
                    if (!"-s".equals(string)) break;
                    decodeScalaNames$1.elem = bl = true;
                    return;
                }
                case 1513: {
                    boolean bl;
                    if (!"-v".equals(string)) break;
                    verbose$1.elem = bl = true;
                    return;
                }
            }
            String s = string;
            if (s.startsWith("-tests=")) {
                throw new UnsupportedOperationException("-tests");
            }
            String s2 = string;
            if (s2.startsWith("--tests=")) {
                throw new UnsupportedOperationException("--tests");
            }
            String s3 = string;
            if (s3.startsWith("--ignore-runners=")) {
                throw new UnsupportedOperationException("--ignore-runners");
            }
            String s4 = string;
            if (s4.startsWith("--run-listener=")) {
                throw new UnsupportedOperationException("--run-listener");
            }
            String s5 = string;
            if (s5.startsWith("--exclude-tags=")) {
                Set set = (Set)((Set)excludeTags$1.elem).$plus((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s5), "--exclude-tags="));
                excludeTags$1.elem = set;
                set = null;
                return;
            }
            String s6 = string;
            if (s6.startsWith("--include-tags=")) {
                Set set = (Set)((Set)includeTags$1.elem).$plus((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s6), "--include-tags="));
                includeTags$1.elem = set;
                set = null;
                return;
            }
            String s7 = string;
            if (s7.startsWith("--include-categories=")) {
                throw new UnsupportedOperationException("--include-categories");
            }
            String s8 = string;
            if (s8.startsWith("--exclude-categories=")) {
                throw new UnsupportedOperationException("--exclude-categories");
            }
            String s9 = string;
            if (s9.startsWith("-D") && s9.contains("=")) {
                throw new UnsupportedOperationException("-Dkey=value");
            }
            String s10 = string;
            if (!s10.startsWith("-") && !s10.startsWith("+")) {
                throw new UnsupportedOperationException(s10);
            }
        });
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])args);
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1)(JProcedure1 & Serializable)s -> {
            String string = s;
            switch (string == null ? 0 : string.hashCode()) {
                case 1403: {
                    boolean bl;
                    if (!"+F".equals(string)) break;
                    trimStackTraces$1.elem = bl = true;
                    return;
                }
                case 1430: {
                    boolean bl;
                    if (!"+a".equals(string)) break;
                    logAssert$2.elem = bl = false;
                    return;
                }
                case 1432: {
                    boolean bl;
                    if (!"+c".equals(string)) break;
                    notLogExceptionClass$2.elem = bl = false;
                    return;
                }
                case 1441: {
                    boolean bl;
                    if (!"+l".equals(string)) break;
                    useSbtLoggers$1.elem = bl = true;
                    return;
                }
                case 1443: {
                    boolean bl;
                    if (!"+n".equals(string)) break;
                    noColor$2.elem = bl = false;
                    return;
                }
                case 1448: {
                    boolean bl;
                    if (!"+s".equals(string)) break;
                    decodeScalaNames$2.elem = bl = false;
                    return;
                }
                case 1451: {
                    boolean bl;
                    if (!"+v".equals(string)) break;
                    verbose$2.elem = bl = false;
                    return;
                }
                case 1465: {
                    boolean bl;
                    if (!"-F".equals(string)) break;
                    trimStackTraces$1.elem = bl = false;
                    return;
                }
                case 1503: {
                    boolean bl;
                    if (!"-l".equals(string)) break;
                    useSbtLoggers$1.elem = bl = false;
                    return;
                }
            }
        });
        return new RunSettings(!noColor.elem, decodeScalaNames.elem, verbose.elem, logAssert.elem, notLogExceptionClass.elem, useSbtLoggers.elem, trimStackTraces.elem, new TagsFilter((Set<String>)((Set)includeTags.elem), (Set<String>)((Set)excludeTags.elem)));
    }
}

