/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.difflib;

import java.util.List;
import munit.internal.console.AnsiColors$;
import munit.internal.console.Printers$;
import munit.internal.difflib.DiffUtils$;
import munit.internal.difflib.Patch;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ua\u0001B\r\u001b\u0001\u0005B\u0001b\u000b\u0001\u0003\u0006\u0004%\t\u0001\f\u0005\tq\u0001\u0011\t\u0011)A\u0005[!A\u0011\b\u0001BC\u0002\u0013\u0005A\u0006\u0003\u0005;\u0001\t\u0005\t\u0015!\u0003.\u0011\u0015Y\u0004\u0001\"\u0001=\u0011\u001d\t\u0005A1A\u0005\u00021BaA\u0011\u0001!\u0002\u0013i\u0003bB\"\u0001\u0005\u0004%\t\u0001\f\u0005\u0007\t\u0002\u0001\u000b\u0011B\u0017\t\u000f\u0015\u0003!\u0019!C\u0001\r\"1\u0001\u000b\u0001Q\u0001\n\u001dCq!\u0015\u0001C\u0002\u0013\u0005a\t\u0003\u0004S\u0001\u0001\u0006Ia\u0012\u0005\b'\u0002\u0011\r\u0011\"\u0001-\u0011\u0019!\u0006\u0001)A\u0005[!)Q\u000b\u0001C\u0001-\")!\f\u0001C\u00017\"9\u0001\rAI\u0001\n\u0003\t\u0007\"\u00027\u0001\t\u0003i\u0007\"\u00028\u0001\t\u0013y\u0007\"\u0002=\u0001\t\u0013I\b\"B>\u0001\t\u0013a\bbBA\u0001\u0001\u0011%\u00111\u0001\u0005\b\u0003\u001b\u0001A\u0011BA\b\u0005\u0011!\u0015N\u001a4\u000b\u0005ma\u0012a\u00023jM\u001ad\u0017N\u0019\u0006\u0003;y\t\u0001\"\u001b8uKJt\u0017\r\u001c\u0006\u0002?\u0005)Q.\u001e8ji\u000e\u00011c\u0001\u0001#QA\u00111EJ\u0007\u0002I)\tQ%A\u0003tG\u0006d\u0017-\u0003\u0002(I\t1\u0011I\\=SK\u001a\u0004\"aI\u0015\n\u0005)\"#\u0001D*fe&\fG.\u001b>bE2,\u0017\u0001C8ci\u0006Lg.\u001a3\u0016\u00035\u0002\"AL\u001b\u000f\u0005=\u001a\u0004C\u0001\u0019%\u001b\u0005\t$B\u0001\u001a!\u0003\u0019a$o\\8u}%\u0011A\u0007J\u0001\u0007!J,G-\u001a4\n\u0005Y:$AB*ue&twM\u0003\u00025I\u0005IqN\u0019;bS:,G\rI\u0001\tKb\u0004Xm\u0019;fI\u0006IQ\r\u001f9fGR,G\rI\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0007uz\u0004\t\u0005\u0002?\u00015\t!\u0004C\u0003,\u000b\u0001\u0007Q\u0006C\u0003:\u000b\u0001\u0007Q&A\u0007pER\f\u0017N\\3e\u00072,\u0017M\\\u0001\u000f_\n$\u0018-\u001b8fI\u000ecW-\u00198!\u00035)\u0007\u0010]3di\u0016$7\t\\3b]\u0006qQ\r\u001f9fGR,Gm\u00117fC:\u0004\u0013!D8ci\u0006Lg.\u001a3MS:,7/F\u0001H!\rAU*\f\b\u0003\u0013.s!\u0001\r&\n\u0003\u0015J!\u0001\u0014\u0013\u0002\u000fA\f7m[1hK&\u0011aj\u0014\u0002\u0004'\u0016\f(B\u0001'%\u00039y'\r^1j]\u0016$G*\u001b8fg\u0002\nQ\"\u001a=qK\u000e$X\r\u001a'j]\u0016\u001c\u0018AD3ya\u0016\u001cG/\u001a3MS:,7\u000fI\u0001\fk:Lg-[3e\t&4g-\u0001\u0007v]&4\u0017.\u001a3ES\u001a4\u0007%A\u0004jg\u0016k\u0007\u000f^=\u0016\u0003]\u0003\"a\t-\n\u0005e##a\u0002\"p_2,\u0017M\\\u0001\rGJ,\u0017\r^3SKB|'\u000f\u001e\u000b\u0004[qs\u0006\"B/\u0012\u0001\u0004i\u0013!\u0002;ji2,\u0007bB0\u0012!\u0003\u0005\raV\u0001\u001baJLg\u000e^(ci\u0006Lg.\u001a3BgN#(/\u001b9NCJ<\u0017N\\\u0001\u0017GJ,\u0017\r^3SKB|'\u000f\u001e\u0013eK\u001a\fW\u000f\u001c;%eU\t!M\u000b\u0002XG.\nA\r\u0005\u0002fU6\taM\u0003\u0002hQ\u0006IQO\\2iK\u000e\\W\r\u001a\u0006\u0003S\u0012\n!\"\u00198o_R\fG/[8o\u0013\tYgMA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fAc\u0019:fCR,G)\u001b4g\u001f:d\u0017PU3q_J$H#A\u0017\u0002)\u0005\u0004\b/\u001a8e\t&4gm\u00148msJ+\u0007o\u001c:u)\t\u00018\u000f\u0005\u0002$c&\u0011!\u000f\n\u0002\u0005+:LG\u000fC\u0003u)\u0001\u0007Q/\u0001\u0002tEB\u0011\u0001J^\u0005\u0003o>\u0013Qb\u0015;sS:<')^5mI\u0016\u0014\u0018!D1t'R\u0014\u0018\u000e]'be\u001eLg\u000e\u0006\u0002.u\")1&\u0006a\u0001[\u00051\u0001.Z1eKJ$2!^?\u0000\u0011\u0015qh\u00031\u0001.\u0003\u0005!\b\"\u0002;\u0017\u0001\u0004)\u0018!E2sK\u0006$X-\u00168jM&,G\rR5gMR)Q&!\u0002\u0002\n!1\u0011qA\fA\u0002\u001d\u000b\u0001b\u001c:jO&t\u0017\r\u001c\u0005\u0007\u0003\u00179\u0002\u0019A$\u0002\u000fI,g/[:fI\u0006q1\u000f\u001d7ji&sGo\u001c'j]\u0016\u001cHcA$\u0002\u0012!1\u00111\u0003\rA\u00025\naa\u001d;sS:<\u0007")
public class Diff
implements Serializable {
    private final String obtained;
    private final String expected;
    private final String obtainedClean;
    private final String expectedClean;
    private final Seq<String> obtainedLines;
    private final Seq<String> expectedLines;
    private final String unifiedDiff;

    public String obtained() {
        return this.obtained;
    }

    public String expected() {
        return this.expected;
    }

    public String obtainedClean() {
        return this.obtainedClean;
    }

    public String expectedClean() {
        return this.expectedClean;
    }

    public Seq<String> obtainedLines() {
        return this.obtainedLines;
    }

    public Seq<String> expectedLines() {
        return this.expectedLines;
    }

    public String unifiedDiff() {
        return this.unifiedDiff;
    }

    public boolean isEmpty() {
        return this.unifiedDiff().isEmpty();
    }

    public String createReport(String title, boolean printObtainedAsStripMargin) {
        BoxedUnit boxedUnit;
        StringBuilder sb = new StringBuilder();
        Object object = new StringOps(Predef$.MODULE$.augmentString(title)).nonEmpty() ? sb.append(title).append("\n") : BoxedUnit.UNIT;
        if (this.obtainedClean().length() < 1000) {
            this.header("Obtained", sb).append("\n");
            StringBuilder stringBuilder = printObtainedAsStripMargin ? sb.append(this.asStripMargin(this.obtainedClean())) : sb.append(this.obtainedClean());
            boxedUnit = sb.append("\n");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.appendDiffOnlyReport(sb);
        return sb.toString();
    }

    public boolean createReport$default$2() {
        return true;
    }

    public String createDiffOnlyReport() {
        StringBuilder out = new StringBuilder();
        this.appendDiffOnlyReport(out);
        return out.toString();
    }

    private void appendDiffOnlyReport(StringBuilder sb) {
        this.header("Diff", sb);
        String red = AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.LightRed());
        String reset = AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset());
        String green = AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.LightGreen());
        sb.append(new java.lang.StringBuilder(25).append(" (").append(red).append("- obtained").append(reset).append(", ").append(green).append("+ expected").append(reset).append(")").toString());
        sb.append("\n");
        sb.append(this.unifiedDiff());
    }

    private String asStripMargin(String obtained) {
        if (!obtained.contains("\n")) {
            return Printers$.MODULE$.print(obtained, Printers$.MODULE$.print$default$2());
        }
        StringBuilder out = new StringBuilder();
        Iterator lines = new StringOps(Predef$.MODULE$.augmentString(obtained.trim())).linesIterator();
        String head = lines.hasNext() ? (String)lines.next() : "";
        out.append(new java.lang.StringBuilder(9).append("    \"\"\"|").append(head).append("\n").toString());
        lines.foreach((Function1 & java.io.Serializable & Serializable)line -> out.append("       |").append(line).append("\n"));
        out.append("       |\"\"\".stripMargin");
        return out.toString();
    }

    private StringBuilder header(String t, StringBuilder sb) {
        return sb.append(AnsiColors$.MODULE$.c(new java.lang.StringBuilder(3).append("=> ").append(t).toString(), AnsiColors$.MODULE$.Bold()));
    }

    private String createUnifiedDiff(Seq<String> original, Seq<String> revised) {
        Patch<String> diff = DiffUtils$.MODULE$.diff((List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(revised).asJava());
        String result = diff.getDeltas().isEmpty() ? "" : ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(DiffUtils$.MODULE$.generateUnifiedDiff("obtained", "expected", (List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava(), diff, 1)).asScala()).iterator().drop(2).filterNot((Function1 & java.io.Serializable & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.startsWith("@@"))).map((Function1 & java.io.Serializable & Serializable)line -> {
            if (line.isEmpty()) {
                return line;
            }
            if (BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(line)).last()) == ' ') {
                return new java.lang.StringBuilder(1).append((String)line).append("\u2219").toString();
            }
            return line;
        }).map((Function1 & java.io.Serializable & Serializable)line -> {
            if (line.startsWith("-")) {
                return AnsiColors$.MODULE$.c((String)line, AnsiColors$.MODULE$.LightRed());
            }
            if (line.startsWith("+")) {
                return AnsiColors$.MODULE$.c((String)line, AnsiColors$.MODULE$.LightGreen());
            }
            return line;
        }).mkString("\n");
        return result;
    }

    private Seq<String> splitIntoLines(String string) {
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])string.trim().replace("\r\n", "\n").split("\n"))).toIndexedSeq();
    }

    public Diff(String obtained, String expected) {
        this.obtained = obtained;
        this.expected = expected;
        this.obtainedClean = AnsiColors$.MODULE$.filterAnsi(obtained);
        this.expectedClean = AnsiColors$.MODULE$.filterAnsi(expected);
        this.obtainedLines = this.splitIntoLines(this.obtainedClean());
        this.expectedLines = this.splitIntoLines(this.expectedClean());
        this.unifiedDiff = this.createUnifiedDiff(this.obtainedLines(), this.expectedLines());
    }
}

