/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.io.Serializable;
import munit.internal.PlatformCompat$;
import munit.internal.console.AnsiColors$;
import munit.internal.junitinterface.JUnitEvent;
import munit.internal.junitinterface.JUnitEvent$;
import munit.internal.junitinterface.RunSettings;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Logger;
import sbt.testing.OptionalThrowable;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.Status$;
import sbt.testing.TaskDef;
import sbt.testing.TestSelector;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005\u0015h\u0001B\u0013'\u00055B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u001d!\u0006A1A\u0005\nUCa!\u0017\u0001!\u0002\u00131\u0006\"\u0002.\u0001\t\u0003Y\u0006\"B0\u0001\t\u0003\u0001\u0007\"\u00028\u0001\t\u0003y\u0007\"B9\u0001\t\u0003\u0011\bbBA\u0005\u0001\u0011\u0005\u00111\u0002\u0005\b\u0003'\u0001A\u0011AA\u000b\u0011\u001d\ty\u0002\u0001C\u0005\u0003CAq!a\n\u0001\t\u0013\tI\u0003C\u0005\u0002B\u0001\t\n\u0011\"\u0003\u0002D!9\u0011\u0011\f\u0001\u0005\n\u0005m\u0003bBA9\u0001\u0011%\u00111\u000f\u0005\b\u0003c\u0002A\u0011BA>\u0011\u001d\t\u0019\t\u0001C\u0005\u0003\u000bCq!!#\u0001\t\u0013\tY\tC\u0004\u00020\u0002!I!!-\t\u000f\u0005m\u0006\u0001\"\u0003\u0002>\"9\u0011\u0011\u0019\u0001\u0005\n\u0005\r\u0007bBAe\u0001\u0011%\u00111\u001a\u0005\n\u0003\u001f\u0004!\u0019!C\u0005\u0003#D\u0001\"a5\u0001A\u0003%\u0011q\r\u0005\n\u0003+\u0004!\u0019!C\u0005\u0003#D\u0001\"a6\u0001A\u0003%\u0011q\r\u0005\n\u00033\u0004!\u0019!C\u0005\u0003#D\u0001\"a7\u0001A\u0003%\u0011q\r\u0005\n\u0003;\u0004!\u0019!C\u0005\u0003#D\u0001\"a8\u0001A\u0003%\u0011q\r\u0005\n\u0003C\u0004!\u0019!C\u0005\u0003#D\u0001\"a9\u0001A\u0003%\u0011qM\u0003\u0007\u0003K\u0002A!a\u001a\u0003\u001b)+f.\u001b;SKB|'\u000f^3s\u0015\t9\u0003&\u0001\bkk:LG/\u001b8uKJ4\u0017mY3\u000b\u0005%R\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0003-\nQ!\\;oSR\u001c\u0001a\u0005\u0002\u0001]A\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\fA\"\u001a<f]RD\u0015M\u001c3mKJ\u0004\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\u000fQ,7\u000f^5oO*\t!(A\u0002tERL!\u0001P\u001c\u0003\u0019\u00153XM\u001c;IC:$G.\u001a:\u0002\u000f1|wmZ3sgB\u0019qfP!\n\u0005\u0001\u0003$!B!se\u0006L\bC\u0001\u001cC\u0013\t\u0019uG\u0001\u0004M_\u001e<WM]\u0001\tg\u0016$H/\u001b8hgB\u0011aiR\u0007\u0002M%\u0011\u0001J\n\u0002\f%Vt7+\u001a;uS:<7/A\u0004uCN\\G)\u001a4\u0011\u0005YZ\u0015B\u0001'8\u0005\u001d!\u0016m]6EK\u001a\fa\u0001P5oSRtD#B(Q#J\u001b\u0006C\u0001$\u0001\u0011\u0015!T\u00011\u00016\u0011\u0015iT\u00011\u0001?\u0011\u0015!U\u00011\u0001F\u0011\u0015IU\u00011\u0001K\u0003=I7/\u00118tSN+\b\u000f]8si\u0016$W#\u0001,\u0011\u0005=:\u0016B\u0001-1\u0005\u001d\u0011un\u001c7fC:\f\u0001#[:B]NL7+\u001e9q_J$X\r\u001a\u0011\u0002-I,\u0007o\u001c:u)\u0016\u001cHoU;ji\u0016\u001cF/\u0019:uK\u0012$\u0012\u0001\u0018\t\u0003_uK!A\u0018\u0019\u0003\tUs\u0017\u000e^\u0001\u0012e\u0016\u0004xN\u001d;UKN$8\u000b^1si\u0016$GC\u0001/b\u0011\u0015\u0011\u0017\u00021\u0001d\u0003\u0019iW\r\u001e5pIB\u0011Am\u001b\b\u0003K&\u0004\"A\u001a\u0019\u000e\u0003\u001dT!\u0001\u001b\u0017\u0002\rq\u0012xn\u001c;?\u0013\tQ\u0007'\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u000161\u0003E\u0011X\r]8siR+7\u000f^%h]>\u0014X\r\u001a\u000b\u00039BDQA\u0019\u0006A\u0002\r\f\u0011D]3q_J$\u0018i]:v[B$\u0018n\u001c8WS>d\u0017\r^5p]R!Al\u001d;z\u0011\u0015\u00117\u00021\u0001d\u0011\u0015)8\u00021\u0001w\u00035!\u0018.\\3J]N+7m\u001c8egB\u0011qf^\u0005\u0003qB\u0012a\u0001R8vE2,\u0007\"\u0002>\f\u0001\u0004Y\u0018!A3\u0011\u0007q\f\u0019A\u0004\u0002~\u007f:\u0011aM`\u0005\u0002c%\u0019\u0011\u0011\u0001\u0019\u0002\u000fA\f7m[1hK&!\u0011QAA\u0004\u0005%!\u0006N]8xC\ndWMC\u0002\u0002\u0002A\n\u0001C]3q_J$H+Z:u!\u0006\u001c8/\u001a3\u0015\u000bq\u000bi!a\u0004\t\u000b\td\u0001\u0019A2\t\r\u0005EA\u00021\u0001w\u00035)G.\u00199tK\u0012l\u0015\u000e\u001c7jg\u0006\u0001\"/\u001a9peR$Vm\u001d;GC&dW\r\u001a\u000b\b9\u0006]\u0011\u0011DA\u000f\u0011\u0015\u0011W\u00021\u0001d\u0011\u0019\tY\"\u0004a\u0001w\u0006\u0011Q\r\u001f\u0005\u0007\u0003#i\u0001\u0019\u0001<\u0002\u000bQ\u0014\u0018mY3\u0015\u0007q\u000b\u0019\u0003\u0003\u0004\u0002&9\u0001\ra_\u0001\u0002i\u0006IQ-\\5u\u000bZ,g\u000e\u001e\u000b\b9\u0006-\u0012QFA\u001c\u0011\u0015\u0011w\u00021\u0001d\u0011\u001d\tyc\u0004a\u0001\u0003c\taa\u001d;biV\u001c\bc\u0001\u001c\u00024%\u0019\u0011QG\u001c\u0003\rM#\u0018\r^;t\u0011%\tId\u0004I\u0001\u0002\u0004\tY$A\u0005uQJ|w/\u00192mKB\u0019a'!\u0010\n\u0007\u0005}rGA\tPaRLwN\\1m)\"\u0014xn^1cY\u0016\f1#Z7ji\u00163XM\u001c;%I\u00164\u0017-\u001e7uIM*\"!!\u0012+\t\u0005m\u0012qI\u0016\u0003\u0003\u0013\u0002B!a\u0013\u0002V5\u0011\u0011Q\n\u0006\u0005\u0003\u001f\n\t&A\u0005v]\u000eDWmY6fI*\u0019\u00111\u000b\u0019\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0002X\u00055#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006\u0019An\\4\u0015\u000bq\u000bi&!\u001c\t\u000f\u0005}\u0013\u00031\u0001\u0002b\u0005)A.\u001a<fYB\u0019\u00111\r\u0013\u000e\u0003\u0001\u0011Q\u0001T3wK2\u00042aLA5\u0013\r\tY\u0007\r\u0002\u0004\u0013:$\bBBA8#\u0001\u00071-A\u0001t\u0003I1\u0017\u000e\u001c;fe\u0006s7/[%g\u001d\u0016,G-\u001a3\u0015\u000b\r\f)(!\u001f\t\r\u0005]$\u00031\u0001B\u0003\u0005a\u0007BBA8%\u0001\u00071\rF\u0003d\u0003{\n\t\t\u0003\u0004\u0002\u0000M\u0001\rAV\u0001\u0011SN\u001cu\u000e\\8s'V\u0004\bo\u001c:uK\u0012Da!a\u001c\u0014\u0001\u0004\u0019\u0017\u0001\u00037pOR\u0013\u0018mY3\u0015\u0007q\u000b9\t\u0003\u0004\u0002&Q\u0001\ra_\u0001\u0012Y><7\u000b^1dWR\u0013\u0018mY3QCJ$Hc\u0003/\u0002\u000e\u0006\u0005\u0016QUAU\u0003WCq!a\b\u0016\u0001\u0004\ty\t\u0005\u00030\u007f\u0005E\u0005\u0003BAJ\u0003;k!!!&\u000b\t\u0005]\u0015\u0011T\u0001\u0005Y\u0006twM\u0003\u0002\u0002\u001c\u0006!!.\u0019<b\u0013\u0011\ty*!&\u0003#M#\u0018mY6Ue\u0006\u001cW-\u00127f[\u0016tG\u000fC\u0004\u0002$V\u0001\r!a\u001a\u0002\u00035Dq!a*\u0016\u0001\u0004\t9'\u0001\bge\u0006lWm]%o\u0007>lWn\u001c8\t\r\u0005\u0015R\u00031\u0001|\u0011\u0019\ti+\u0006a\u0001G\u0006aA/Z:u\r&dWMT1nK\u0006!Bn\\4Ti\u0006\u001c7\u000e\u0016:bG\u0016\f5oQ1vg\u0016$r\u0001XAZ\u0003o\u000bI\fC\u0004\u00026Z\u0001\r!a$\u0002\u0017\r\fWo]3e)J\f7-\u001a\u0005\u0007\u0003K1\u0002\u0019A>\t\r\u00055f\u00031\u0001d\u0003A1\u0017N\u001c3UKN$h)\u001b7f\u001d\u0006lW\rF\u0002d\u0003\u007fCq!a\b\u0018\u0001\u0004\ty)A\rti\u0006\u001c7\u000e\u0016:bG\u0016,E.Z7f]R$vn\u0015;sS:<G#B2\u0002F\u0006\u001d\u0007B\u0002>\u0019\u0001\u0004\t\t\n\u0003\u0004\u0002.b\u0001\raY\u0001\u000bM>\u0014X.\u0019;US6,GcA2\u0002N\"1\u0011\u0011C\rA\u0002Y\fQ\u0001\u0016:bG\u0016,\"!a\u001a\u0002\rQ\u0013\u0018mY3!\u0003\u0015!UMY;h\u0003\u0019!UMY;hA\u0005!\u0011J\u001c4p\u0003\u0015IeNZ8!\u0003\u00119\u0016M\u001d8\u0002\u000b]\u000b'O\u001c\u0011\u0002\u000b\u0015\u0013(o\u001c:\u0002\r\u0015\u0013(o\u001c:!\u0001")
public final class JUnitReporter {
    private final EventHandler eventHandler;
    private final Logger[] loggers;
    private final RunSettings settings;
    private final TaskDef taskDef;
    private final boolean isAnsiSupported;
    private final int Trace;
    private final int Debug;
    private final int Info;
    private final int Warn;
    private final int Error;

    private boolean isAnsiSupported() {
        return this.isAnsiSupported;
    }

    public void reportTestSuiteStarted() {
        this.log(this.Info(), AnsiColors$.MODULE$.c(new StringBuilder(1).append(this.taskDef.fullyQualifiedName()).append(":").toString(), AnsiColors$.MODULE$.GREEN()));
    }

    public void reportTestStarted(String method) {
        if (this.settings.verbose()) {
            this.log(this.Info(), new StringBuilder(8).append(method).append(" started").toString());
            return;
        }
    }

    public void reportTestIgnored(String method) {
        if (this.settings.verbose()) {
            this.log(this.Info(), AnsiColors$.MODULE$.c(new StringBuilder(14).append("==> i ").append(method).append(" ignored").toString(), AnsiColors$.MODULE$.YELLOW()));
        }
        this.emitEvent(method, Status$.MODULE$.Ignored(), this.emitEvent$default$3());
    }

    public void reportAssumptionViolation(String method, double timeInSeconds, Throwable e) {
        if (this.settings.verbose()) {
            this.log(this.Info(), AnsiColors$.MODULE$.c(new StringBuilder(14).append("==> s ").append(method).append(" skipped").toString(), AnsiColors$.MODULE$.YELLOW()));
        }
        this.emitEvent(method, Status$.MODULE$.Skipped(), new OptionalThrowable(e));
    }

    public void reportTestPassed(String method, double elapsedMillis) {
        this.log(this.Info(), new StringBuilder(1).append(AnsiColors$.MODULE$.c(new StringBuilder(4).append("  + ").append(method).toString(), AnsiColors$.MODULE$.GREEN())).append(" ").append(this.formatTime(elapsedMillis)).toString());
        this.emitEvent(method, Status$.MODULE$.Success(), this.emitEvent$default$3());
    }

    public void reportTestFailed(String method, Throwable ex, double elapsedMillis) {
        this.log(this.Info(), new scala.collection.mutable.StringBuilder().append(AnsiColors$.MODULE$.c(new StringBuilder(7).append("==> X ").append(this.taskDef.fullyQualifiedName()).append(".").append(method).toString(), AnsiColors$.MODULE$.LightRed())).append(" ").append(this.formatTime(elapsedMillis)).append(" ").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).toString());
        this.trace(ex);
        this.emitEvent(method, Status$.MODULE$.Failure(), new OptionalThrowable(ex));
    }

    private void trace(Throwable t) {
        if (!(t instanceof AssertionError) || this.settings.logAssert()) {
            this.logTrace(t);
            return;
        }
    }

    private void emitEvent(String method, Status status, OptionalThrowable throwable) {
        String testName = new StringBuilder(1).append(this.taskDef.fullyQualifiedName()).append(".").append(this.settings.decodeName(method)).toString();
        TestSelector selector = new TestSelector(testName);
        this.eventHandler.handle((Event)new JUnitEvent(this.taskDef, testName, status, (Selector)selector, throwable, JUnitEvent$.MODULE$.$lessinit$greater$default$6()));
    }

    private OptionalThrowable emitEvent$default$3() {
        return new OptionalThrowable();
    }

    private void log(int level, String s) {
        if (this.settings.useSbtLoggers()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.loggers)).foreach((Function1 & Serializable & scala.Serializable)l -> {
                JUnitReporter.$anonfun$log$1(this, s, level, l);
                return BoxedUnit.UNIT;
            });
            return;
        }
        int n = level;
        if ((this.Debug() == n ? true : this.Trace() == n) && !this.settings.verbose()) {
            return;
        }
        Predef$.MODULE$.println((Object)this.filterAnsiIfNeeded(this.isAnsiSupported(), s));
    }

    private String filterAnsiIfNeeded(Logger l, String s) {
        return this.filterAnsiIfNeeded(l.ansiCodesSupported(), s);
    }

    private String filterAnsiIfNeeded(boolean isColorSupported, String s) {
        if (isColorSupported && this.settings.color()) {
            return s;
        }
        return AnsiColors$.MODULE$.filterAnsi(s);
    }

    private void logTrace(Throwable t) {
        StackTraceElement[] trace = (StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])t.getStackTrace())).dropWhile((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)JUnitReporter.$anonfun$logTrace$1(p)));
        String testFileName = this.settings.color() ? this.findTestFileName(trace) : null;
        int i = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trace)).indexWhere((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)JUnitReporter.$anonfun$logTrace$2(p))) - 1;
        int m = i > 0 ? i : trace.length - 1;
        this.logStackTracePart(trace, m, trace.length - m - 1, t, testFileName);
    }

    private void logStackTracePart(StackTraceElement[] trace, int m, int framesInCommon, Throwable t, String testFileName) {
        int top;
        int m0 = m;
        int m2 = m;
        for (int i2 = top = 0; i2 <= m2; ++i2) {
            if (!trace[i2].toString().startsWith("org.junit.") && !trace[i2].toString().startsWith("org.hamcrest.")) continue;
            if (i2 == top) {
                ++top;
                continue;
            }
            m2 = i2 - 1;
            boolean bl = false;
            while (m2 > top && !bl) {
                String s = trace[m2].toString();
                if (!s.startsWith("java.lang.reflect.") && !s.startsWith("sun.reflect.")) {
                    bl = true;
                    continue;
                }
                --m2;
            }
            i2 = m2;
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(top), m2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.log(this.Error(), this.stackTraceElementToString(trace[i], testFileName)));
        if (m0 != m2) {
            this.log(this.Error(), "    ...");
        } else if (framesInCommon != 0) {
            this.log(this.Error(), new StringBuilder(13).append("    ... ").append(framesInCommon).append(" more").toString());
        }
        this.logStackTraceAsCause(trace, t.getCause(), testFileName);
    }

    private void logStackTraceAsCause(StackTraceElement[] causedTrace, Throwable t, String testFileName) {
        if (t != null) {
            StackTraceElement[] trace = t.getStackTrace();
            int m = trace.length - 1;
            for (int n = causedTrace.length - 1; m >= 0 && n >= 0; --m, --n) {
                StackTraceElement stackTraceElement = trace[m];
                StackTraceElement stackTraceElement2 = causedTrace[n];
                if (stackTraceElement != null ? !((Object)stackTraceElement).equals(stackTraceElement2) : stackTraceElement2 != null) break;
            }
            this.log(this.Error(), new StringBuilder(11).append("Caused by: ").append(t).toString());
            this.logStackTracePart(trace, m, trace.length - 1 - m, t, testFileName);
            return;
        }
    }

    private String findTestFileName(StackTraceElement[] trace) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trace)).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JUnitReporter.$anonfun$findTestFileName$1(this, x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getFileName()).orNull(Predef$.MODULE$.$conforms());
    }

    private String stackTraceElementToString(StackTraceElement e, String testFileName) {
        String string;
        boolean highlight = this.settings.color() && e.getFileName() != null && e.getFileName().contains("file:/");
        boolean canHighlight = !PlatformCompat$.MODULE$.isNative();
        scala.collection.mutable.StringBuilder stringBuilder = new scala.collection.mutable.StringBuilder().append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset())).append(!canHighlight ? "" : (highlight ? AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Bold()) : AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.DarkGrey()))).append("    at ").append(this.settings.decodeName(new StringBuilder(0).append(e.getClassName()).append('.').append(e.getMethodName()).toString())).append('(');
        if (e.isNativeMethod()) {
            string = "Native Method";
        } else if (e.getFileName() == null) {
            string = "Unknown Source";
        } else {
            int file = e.getFileName().indexOf("file:/");
            int https = file >= 0 ? file : e.getFileName().indexOf("https:/");
            String filename = https >= 0 ? e.getFileName().substring(https) : e.getFileName();
            string = e.getLineNumber() >= 0 ? new StringBuilder(1).append(filename).append(":").append(e.getLineNumber()).toString() : filename;
        }
        return stringBuilder.append(string).append(')').append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset())).toString();
    }

    private String formatTime(double elapsedMillis) {
        return AnsiColors$.MODULE$.c(new StringOps(Predef$.MODULE$.augmentString("%.2fs")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(elapsedMillis / 1000.0))})), AnsiColors$.MODULE$.DarkGrey());
    }

    private int Trace() {
        return this.Trace;
    }

    private int Debug() {
        return this.Debug;
    }

    private int Info() {
        return this.Info;
    }

    private int Warn() {
        return this.Warn;
    }

    private int Error() {
        return this.Error;
    }

    public static final /* synthetic */ void $anonfun$log$1(JUnitReporter $this, String s$1, int level$1, Logger l) {
        String msg = $this.filterAnsiIfNeeded(l, s$1);
        int n = level$1;
        if ($this.Debug() == n) {
            l.debug(msg);
            return;
        }
        if ($this.Info() == n) {
            l.info(msg);
            return;
        }
        if ($this.Warn() == n) {
            l.warn(msg);
            return;
        }
        if ($this.Error() == n) {
            l.error(msg);
            return;
        }
        l.error(msg);
    }

    public static final /* synthetic */ boolean $anonfun$logTrace$1(StackTraceElement p) {
        return p.getFileName() != null && (p.getFileName().contains("StackTrace.scala") || p.getFileName().contains("Throwables.scala"));
    }

    public static final /* synthetic */ boolean $anonfun$logTrace$2(StackTraceElement p) {
        return p.getFileName() != null && p.getFileName().contains("JUnitExecuteTest.scala");
    }

    public static final /* synthetic */ boolean $anonfun$findTestFileName$1(JUnitReporter $this, StackTraceElement x$2) {
        String string = x$2.getClassName();
        String string2 = $this.taskDef.fullyQualifiedName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JUnitReporter(EventHandler eventHandler, Logger[] loggers, RunSettings settings, TaskDef taskDef) {
        this.eventHandler = eventHandler;
        this.loggers = loggers;
        this.settings = settings;
        this.taskDef = taskDef;
        this.isAnsiSupported = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])loggers)).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.ansiCodesSupported())) && settings.color();
        this.Trace = 0;
        this.Debug = 1;
        this.Info = 2;
        this.Warn = 3;
        this.Error = 4;
    }
}

