/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import java.io.Serializable;
import java.nio.file.Path;
import munit.Clue;
import munit.Clues;
import munit.Location;
import munit.diff.console.AnsiColors$;
import munit.internal.console.Printers$;
import munit.internal.io.PlatformIO$Files$;
import munit.internal.io.PlatformIO$Path$;
import munit.internal.io.PlatformIO$Paths$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001\u00194A\u0001C\u0005\u0001!!)!\u0004\u0001C\u00017!9a\u0004\u0001b\u0001\n\u0013y\u0002BB#\u0001A\u0003%\u0001\u0005C\u0003G\u0001\u0011\u0005q\tC\u0003Q\u0001\u0011\u0005\u0011\u000bC\u0003T\u0001\u0011\u0005A\u000bC\u0003G\u0001\u0011\u0005aLA\u0003MS:,7O\u0003\u0002\u000b\u0017\u000591m\u001c8t_2,'B\u0001\u0007\u000e\u0003!Ig\u000e^3s]\u0006d'\"\u0001\b\u0002\u000b5,h.\u001b;\u0004\u0001M\u0019\u0001!E\f\u0011\u0005I)R\"A\n\u000b\u0003Q\tQa]2bY\u0006L!AF\n\u0003\r\u0005s\u0017PU3g!\t\u0011\u0002$\u0003\u0002\u001a'\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012\u0001\b\t\u0003;\u0001i\u0011!C\u0001\nM&dWmY1dQ\u0016,\u0012\u0001\t\t\u0005C\u0019B#(D\u0001#\u0015\t\u0019C%A\u0004nkR\f'\r\\3\u000b\u0005\u0015\u001a\u0012AC2pY2,7\r^5p]&\u0011qE\t\u0002\u0004\u001b\u0006\u0004\bCA\u00158\u001d\tQCG\u0004\u0002,e9\u0011A&\r\b\u0003[Aj\u0011A\f\u0006\u0003_=\ta\u0001\u0010:p_Rt\u0014\"\u0001\b\n\u00051i\u0011BA\u001a\f\u0003\tIw.\u0003\u00026m\u0005Q\u0001\u000b\\1uM>\u0014X.S(\u000b\u0005MZ\u0011B\u0001\u001d:\u0005\u0011\u0001\u0016\r\u001e5\u000b\u0005U2\u0004c\u0001\n<{%\u0011Ah\u0005\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003}\ts!a\u0010!\u0011\u00055\u001a\u0012BA!\u0014\u0003\u0019\u0001&/\u001a3fM&\u00111\t\u0012\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005\u0005\u001b\u0012A\u00034jY\u0016\u001c\u0017m\u00195fA\u0005Qam\u001c:nCRd\u0015N\\3\u0015\u0007uBe\nC\u0003J\t\u0001\u0007!*\u0001\u0005m_\u000e\fG/[8o!\tYE*D\u0001\u000e\u0013\tiUB\u0001\u0005M_\u000e\fG/[8o\u0011\u0015yE\u00011\u0001>\u0003\u001diWm]:bO\u0016\f!BZ8s[\u0006$\b+\u0019;i)\ti$\u000bC\u0003J\u000b\u0001\u0007!*\u0001\u0005gS:$\u0007+\u0019;i)\u0011ASkV-\t\u000bY3\u0001\u0019A\u001f\u0002\u0007\r<H\rC\u0003Y\r\u0001\u0007Q(\u0001\u0003qCRD\u0007\"\u0002.\u0007\u0001\u0004Y\u0016aA7bqB\u0011!\u0003X\u0005\u0003;N\u00111!\u00138u)\u0011it\fY1\t\u000b%;\u0001\u0019\u0001&\t\u000b=;\u0001\u0019A\u001f\t\u000b\t<\u0001\u0019A2\u0002\u000b\rdW/Z:\u0011\u0005-#\u0017BA3\u000e\u0005\u0015\u0019E.^3t\u0001")
public class Lines
implements scala.Serializable {
    private final Map<Path, String[]> filecache = Map$.MODULE$.empty();

    private Map<Path, String[]> filecache() {
        return this.filecache;
    }

    public String formatLine(Location location, String message) {
        return this.formatLine(location, message, new Clues((List<Clue<?>>)Nil$.MODULE$));
    }

    public String formatPath(Location location) {
        return location.path();
    }

    public Path findPath(String cwd, String path, int max) {
        Path p = PlatformIO$Paths$.MODULE$.get(cwd).resolve(path);
        if (PlatformIO$Files$.MODULE$.exists(p)) {
            return p;
        }
        if (max < 1) {
            throw package$.MODULE$.error(new StringBuilder(14).append(path).append(" was not found").toString());
        }
        if (cwd.contains("\\")) {
            return this.findPath(Lines.getParentPath$1(cwd, "\\"), path, max - 1);
        }
        return this.findPath(Lines.getParentPath$1(cwd, "/"), path, max - 1);
    }

    public String formatLine(Location location, String message, Clues clues) {
        String string;
        try {
            Object object;
            Path path = this.findPath(((Object)PlatformIO$Path$.MODULE$.workingDirectory()).toString(), location.path(), 3);
            String[] lines = (String[])this.filecache().getOrElseUpdate((Object)path, (Function0 & Serializable & scala.Serializable)() -> (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(PlatformIO$Files$.MODULE$.readAllLines(path)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)));
            String[] slice = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).slice(location.line() - 2, location.line() + 1);
            scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
            if (slice.length >= 2) {
                int width = Integer.toString(location.line() + 1).length() + 1;
                boolean isMultilineMessage = new StringOps(Predef$.MODULE$.augmentString(message)).contains((Object)BoxesRunTime.boxToCharacter((char)'\n'));
                out.append(this.formatPath(location)).append(':').append(Integer.toString(location.line()));
                Object object2 = message.length() > 0 && !isMultilineMessage ? out.append(" ").append(message) : BoxedUnit.UNIT;
                out.append('\n').append(Lines.format$1(location.line() - 1, width)).append(slice[0]).append('\n').append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reversed())).append(Lines.format$1(location.line(), width)).append(slice[1]).append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset()));
                Object object3 = slice.length >= 3 ? out.append('\n').append(Lines.format$1(location.line() + 1, width)).append(slice[2]) : BoxedUnit.UNIT;
                Object object4 = isMultilineMessage ? out.append('\n').append(message) : BoxedUnit.UNIT;
                object = clues.values().nonEmpty() ? out.append('\n').append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                string = clues.values().isEmpty() ? message : new StringBuilder(1).append(message).append("\n").append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())).toString();
            }
            throw throwable;
        }
        return string;
    }

    private static final String getParentPath$1(String somePath, String sep) {
        String somePath1 = somePath.endsWith(sep) ? (String)new StringOps(Predef$.MODULE$.augmentString(somePath)).dropRight(sep.length()) : somePath;
        String string = sep;
        String string2 = "\\";
        String sep1 = !(string != null ? !string.equals(string2) : string2 != null) ? "\\\\" : sep;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])somePath1.split(sep1))).dropRight(1))).mkString(sep);
    }

    private static final String format$1(int n, int width$1) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1).append(n).append(":").toString())).padTo(width$1, (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom());
    }
}

