/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.io.Serializable;
import munit.diff.console.AnsiColors$;
import munit.internal.PlatformCompat$;
import munit.internal.junitinterface.JUnitEvent;
import munit.internal.junitinterface.JUnitEvent$;
import munit.internal.junitinterface.RunSettings;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Logger;
import sbt.testing.OptionalThrowable;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.Status$;
import sbt.testing.TaskDef;
import sbt.testing.TestSelector;
import scala.Function1;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005-h\u0001B\u0013'\u00055B\u0001\u0002\u000e\u0001\u0003\u0002\u0003\u0006I!\u000e\u0005\t{\u0001\u0011\t\u0011)A\u0005}!AA\t\u0001B\u0001B\u0003%Q\t\u0003\u0005J\u0001\t\u0005\t\u0015!\u0003K\u0011\u0015i\u0005\u0001\"\u0001O\u0011\u001d!\u0006A1A\u0005\nUCa!\u0017\u0001!\u0002\u00131\u0006\"\u0002.\u0001\t\u0003Y\u0006\"B0\u0001\t\u0003\u0001\u0007\"\u00028\u0001\t\u0003y\u0007\"\u0002=\u0001\t\u0003I\bbBA\t\u0001\u0011\u0005\u00111\u0003\u0005\b\u00033\u0001A\u0011AA\u000e\u0011\u001d\t)\u0003\u0001C\u0005\u0003OAq!!\f\u0001\t\u0013\ty\u0003C\u0005\u0002H\u0001\t\n\u0011\"\u0003\u0002J!9\u0011q\f\u0001\u0005\n\u0005\u0005\u0004bBA<\u0001\u0011%\u0011\u0011\u0010\u0005\b\u0003o\u0002A\u0011BAA\u0011\u001d\tI\t\u0001C\u0005\u0003\u0017Cq!a$\u0001\t\u0013\t\t\nC\u0004\u00026\u0002!I!a.\t\u000f\u0005\u0005\u0007\u0001\"\u0003\u0002D\"9\u0011q\u0019\u0001\u0005\n\u0005%\u0007bBAh\u0001\u0011%\u0011\u0011\u001b\u0005\n\u0003+\u0004!\u0019!C\u0005\u0003/D\u0001\"!7\u0001A\u0003%\u0011Q\u000e\u0005\n\u00037\u0004!\u0019!C\u0005\u0003/D\u0001\"!8\u0001A\u0003%\u0011Q\u000e\u0005\n\u0003?\u0004!\u0019!C\u0005\u0003/D\u0001\"!9\u0001A\u0003%\u0011Q\u000e\u0005\n\u0003G\u0004!\u0019!C\u0005\u0003/D\u0001\"!:\u0001A\u0003%\u0011Q\u000e\u0005\n\u0003O\u0004!\u0019!C\u0005\u0003/D\u0001\"!;\u0001A\u0003%\u0011QN\u0003\u0007\u0003W\u0002A!!\u001c\u0003\u001b)+f.\u001b;SKB|'\u000f^3s\u0015\t9\u0003&\u0001\bkk:LG/\u001b8uKJ4\u0017mY3\u000b\u0005%R\u0013\u0001C5oi\u0016\u0014h.\u00197\u000b\u0003-\nQ!\\;oSR\u001c\u0001a\u0005\u0002\u0001]A\u0011qFM\u0007\u0002a)\t\u0011'A\u0003tG\u0006d\u0017-\u0003\u00024a\t1\u0011I\\=SK\u001a\fA\"\u001a<f]RD\u0015M\u001c3mKJ\u0004\"AN\u001e\u000e\u0003]R!\u0001O\u001d\u0002\u000fQ,7\u000f^5oO*\t!(A\u0002tERL!\u0001P\u001c\u0003\u0019\u00153XM\u001c;IC:$G.\u001a:\u0002\u000f1|wmZ3sgB\u0019qfP!\n\u0005\u0001\u0003$!B!se\u0006L\bC\u0001\u001cC\u0013\t\u0019uG\u0001\u0004M_\u001e<WM]\u0001\tg\u0016$H/\u001b8hgB\u0011aiR\u0007\u0002M%\u0011\u0001J\n\u0002\f%Vt7+\u001a;uS:<7/A\u0004uCN\\G)\u001a4\u0011\u0005YZ\u0015B\u0001'8\u0005\u001d!\u0016m]6EK\u001a\fa\u0001P5oSRtD#B(Q#J\u001b\u0006C\u0001$\u0001\u0011\u0015!T\u00011\u00016\u0011\u0015iT\u00011\u0001?\u0011\u0015!U\u00011\u0001F\u0011\u0015IU\u00011\u0001K\u0003=I7/\u00118tSN+\b\u000f]8si\u0016$W#\u0001,\u0011\u0005=:\u0016B\u0001-1\u0005\u001d\u0011un\u001c7fC:\f\u0001#[:B]NL7+\u001e9q_J$X\r\u001a\u0011\u0002-I,\u0007o\u001c:u)\u0016\u001cHoU;ji\u0016\u001cF/\u0019:uK\u0012$\u0012\u0001\u0018\t\u0003_uK!A\u0018\u0019\u0003\tUs\u0017\u000e^\u0001\u0012e\u0016\u0004xN\u001d;UKN$8\u000b^1si\u0016$GC\u0001/b\u0011\u0015\u0011\u0017\u00021\u0001d\u0003\u0019iW\r\u001e5pIB\u0011Am\u001b\b\u0003K&\u0004\"A\u001a\u0019\u000e\u0003\u001dT!\u0001\u001b\u0017\u0002\rq\u0012xn\u001c;?\u0013\tQ\u0007'\u0001\u0004Qe\u0016$WMZ\u0005\u0003Y6\u0014aa\u0015;sS:<'B\u000161\u0003E\u0011X\r]8siR+7\u000f^%h]>\u0014X\r\u001a\u000b\u00059B\fh\u000fC\u0003c\u0015\u0001\u00071\rC\u0003s\u0015\u0001\u00071/A\u0007fY\u0006\u00048/\u001a3NS2d\u0017n\u001d\t\u0003_QL!!\u001e\u0019\u0003\r\u0011{WO\u00197f\u0011\u00159(\u00021\u0001d\u0003\u0019\u0019XO\u001a4jq\u0006I\"/\u001a9peR\f5o];naRLwN\u001c,j_2\fG/[8o)\u0011a&p_?\t\u000b\t\\\u0001\u0019A2\t\u000bq\\\u0001\u0019A:\u0002\u001bQLW.Z%o'\u0016\u001cwN\u001c3t\u0011\u0015q8\u00021\u0001\u0000\u0003\u0005)\u0007\u0003BA\u0001\u0003\u0017qA!a\u0001\u0002\b9\u0019a-!\u0002\n\u0003EJ1!!\u00031\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0004\u0002\u0010\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u0013\u0001\u0014\u0001\u0005:fa>\u0014H\u000fV3tiB\u000b7o]3e)\u0015a\u0016QCA\f\u0011\u0015\u0011G\u00021\u0001d\u0011\u0015\u0011H\u00021\u0001t\u0003A\u0011X\r]8siR+7\u000f\u001e$bS2,G\rF\u0004]\u0003;\ty\"a\t\t\u000b\tl\u0001\u0019A2\t\r\u0005\u0005R\u00021\u0001\u0000\u0003\t)\u0007\u0010C\u0003s\u001b\u0001\u00071/A\u0003ue\u0006\u001cW\rF\u0002]\u0003SAa!a\u000b\u000f\u0001\u0004y\u0018!\u0001;\u0002\u0013\u0015l\u0017\u000e^#wK:$Hc\u0002/\u00022\u0005M\u0012Q\b\u0005\u0006E>\u0001\ra\u0019\u0005\b\u0003ky\u0001\u0019AA\u001c\u0003\u0019\u0019H/\u0019;vgB\u0019a'!\u000f\n\u0007\u0005mrG\u0001\u0004Ti\u0006$Xo\u001d\u0005\n\u0003\u007fy\u0001\u0013!a\u0001\u0003\u0003\n\u0011\u0002\u001e5s_^\f'\r\\3\u0011\u0007Y\n\u0019%C\u0002\u0002F]\u0012\u0011c\u00149uS>t\u0017\r\u001c+ie><\u0018M\u00197f\u0003M)W.\u001b;Fm\u0016tG\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\tYE\u000b\u0003\u0002B\u000553FAA(!\u0011\t\t&a\u0017\u000e\u0005\u0005M#\u0002BA+\u0003/\n\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005e\u0003'\u0001\u0006b]:|G/\u0019;j_:LA!!\u0018\u0002T\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002\u00071|w\rF\u0003]\u0003G\n\u0019\bC\u0004\u0002fE\u0001\r!a\u001a\u0002\u000b1,g/\u001a7\u0011\u0007\u0005%D%D\u0001\u0001\u0005\u0015aUM^3m!\ry\u0013qN\u0005\u0004\u0003c\u0002$aA%oi\"1\u0011QO\tA\u0002\r\f\u0011a]\u0001\u0013M&dG/\u001a:B]NL\u0017J\u001a(fK\u0012,G\rF\u0003d\u0003w\ny\b\u0003\u0004\u0002~I\u0001\r!Q\u0001\u0002Y\"1\u0011Q\u000f\nA\u0002\r$RaYAB\u0003\u000fCa!!\"\u0014\u0001\u00041\u0016\u0001E5t\u0007>dwN]*vaB|'\u000f^3e\u0011\u0019\t)h\u0005a\u0001G\u0006AAn\\4Ue\u0006\u001cW\rF\u0002]\u0003\u001bCa!a\u000b\u0015\u0001\u0004y\u0018!\u00057pON#\u0018mY6Ue\u0006\u001cW\rU1siRYA,a%\u0002(\u0006-\u0016qVAY\u0011\u001d\t)#\u0006a\u0001\u0003+\u0003BaL \u0002\u0018B!\u0011\u0011TAR\u001b\t\tYJ\u0003\u0003\u0002\u001e\u0006}\u0015\u0001\u00027b]\u001eT!!!)\u0002\t)\fg/Y\u0005\u0005\u0003K\u000bYJA\tTi\u0006\u001c7\u000e\u0016:bG\u0016,E.Z7f]RDq!!+\u0016\u0001\u0004\ti'A\u0001n\u0011\u001d\ti+\u0006a\u0001\u0003[\naB\u001a:b[\u0016\u001c\u0018J\\\"p[6|g\u000e\u0003\u0004\u0002,U\u0001\ra \u0005\u0007\u0003g+\u0002\u0019A2\u0002\u0019Q,7\u000f\u001e$jY\u0016t\u0015-\\3\u0002)1|wm\u0015;bG.$&/Y2f\u0003N\u001c\u0015-^:f)\u001da\u0016\u0011XA_\u0003\u007fCq!a/\u0017\u0001\u0004\t)*A\u0006dCV\u001cX\r\u001a+sC\u000e,\u0007BBA\u0016-\u0001\u0007q\u0010\u0003\u0004\u00024Z\u0001\raY\u0001\u0011M&tG\rV3ti\u001aKG.\u001a(b[\u0016$2aYAc\u0011\u001d\t)c\u0006a\u0001\u0003+\u000b\u0011d\u001d;bG.$&/Y2f\u000b2,W.\u001a8u)>\u001cFO]5oOR)1-a3\u0002N\"1a\u0010\u0007a\u0001\u0003/Ca!a-\u0019\u0001\u0004\u0019\u0017A\u00034pe6\fG\u000fV5nKR\u00191-a5\t\u000bIL\u0002\u0019A:\u0002\u000bQ\u0013\u0018mY3\u0016\u0005\u00055\u0014A\u0002+sC\u000e,\u0007%A\u0003EK\n,x-\u0001\u0004EK\n,x\rI\u0001\u0005\u0013:4w.A\u0003J]\u001a|\u0007%\u0001\u0003XCJt\u0017!B,be:\u0004\u0013!B#se>\u0014\u0018AB#se>\u0014\b\u0005")
public final class JUnitReporter {
    private final EventHandler eventHandler;
    private final Logger[] loggers;
    private final RunSettings settings;
    private final TaskDef taskDef;
    private final boolean isAnsiSupported;
    private final int Trace;
    private final int Debug;
    private final int Info;
    private final int Warn;
    private final int Error;

    private boolean isAnsiSupported() {
        return this.isAnsiSupported;
    }

    public void reportTestSuiteStarted() {
        this.log(this.Info(), AnsiColors$.MODULE$.c(new StringBuilder(1).append(this.taskDef.fullyQualifiedName()).append(":").toString(), AnsiColors$.MODULE$.GREEN()));
    }

    public void reportTestStarted(String method) {
        if (this.settings.verbose()) {
            this.log(this.Info(), new StringBuilder(8).append(method).append(" started").toString());
            return;
        }
    }

    public void reportTestIgnored(String method, double elapsedMillis, String suffix) {
        String suffixed = suffix.isEmpty() ? "" : new StringBuilder(1).append(" ").append(suffix).toString();
        this.log(this.Info(), new StringBuilder(1).append(AnsiColors$.MODULE$.c(new StringBuilder(14).append("==> i ").append(method).append(suffixed).append(" ignored").toString(), AnsiColors$.MODULE$.YELLOW())).append(" ").append(this.formatTime(elapsedMillis)).toString());
        this.emitEvent(method, Status$.MODULE$.Ignored(), this.emitEvent$default$3());
    }

    public void reportAssumptionViolation(String method, double timeInSeconds, Throwable e) {
        this.log(this.Info(), AnsiColors$.MODULE$.c(new StringBuilder(14).append("==> s ").append(method).append(" skipped").toString(), AnsiColors$.MODULE$.YELLOW()));
        this.emitEvent(method, Status$.MODULE$.Skipped(), new OptionalThrowable(e));
    }

    public void reportTestPassed(String method, double elapsedMillis) {
        this.log(this.Info(), new StringBuilder(1).append(AnsiColors$.MODULE$.c(new StringBuilder(4).append("  + ").append(method).toString(), AnsiColors$.MODULE$.GREEN())).append(" ").append(this.formatTime(elapsedMillis)).toString());
        this.emitEvent(method, Status$.MODULE$.Success(), this.emitEvent$default$3());
    }

    public void reportTestFailed(String method, Throwable ex, double elapsedMillis) {
        this.log(this.Info(), new scala.collection.mutable.StringBuilder().append(AnsiColors$.MODULE$.c(new StringBuilder(7).append("==> X ").append(this.taskDef.fullyQualifiedName()).append(".").append(method).toString(), AnsiColors$.MODULE$.LightRed())).append(" ").append(this.formatTime(elapsedMillis)).append(" ").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).toString());
        this.emitEvent(method, Status$.MODULE$.Failure(), new OptionalThrowable(ex));
    }

    private void trace(Throwable t) {
        if (!(t instanceof AssertionError) || this.settings.logAssert()) {
            this.logTrace(t);
            return;
        }
    }

    private void emitEvent(String method, Status status, OptionalThrowable throwable) {
        String testName = new StringBuilder(1).append(this.taskDef.fullyQualifiedName()).append(".").append(this.settings.decodeName(method)).toString();
        TestSelector selector = new TestSelector(testName);
        this.eventHandler.handle((Event)new JUnitEvent(this.taskDef, testName, status, (Selector)selector, throwable, JUnitEvent$.MODULE$.$lessinit$greater$default$6()));
    }

    private OptionalThrowable emitEvent$default$3() {
        return new OptionalThrowable();
    }

    private void log(int level, String s) {
        if (this.settings.useSbtLoggers()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.loggers)).foreach((Function1 & Serializable & scala.Serializable)l -> {
                JUnitReporter.$anonfun$log$1(this, s, level, l);
                return BoxedUnit.UNIT;
            });
            return;
        }
        int n = level;
        if ((this.Debug() == n ? true : this.Trace() == n) && !this.settings.verbose()) {
            return;
        }
        Predef$.MODULE$.println((Object)this.filterAnsiIfNeeded(this.isAnsiSupported(), s));
    }

    private String filterAnsiIfNeeded(Logger l, String s) {
        return this.filterAnsiIfNeeded(l.ansiCodesSupported(), s);
    }

    private String filterAnsiIfNeeded(boolean isColorSupported, String s) {
        if (isColorSupported && this.settings.color()) {
            return s;
        }
        return AnsiColors$.MODULE$.filterAnsi(s);
    }

    private void logTrace(Throwable t) {
        StackTraceElement[] trace = (StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])t.getStackTrace())).dropWhile((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)JUnitReporter.$anonfun$logTrace$1(p)));
        String testFileName = this.settings.color() ? this.findTestFileName(trace) : null;
        int i = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trace)).indexWhere((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)JUnitReporter.$anonfun$logTrace$2(p))) - 1;
        int m = i > 0 ? i : trace.length - 1;
        this.logStackTracePart(trace, m, trace.length - m - 1, t, testFileName);
    }

    private void logStackTracePart(StackTraceElement[] trace, int m, int framesInCommon, Throwable t, String testFileName) {
        int top;
        int m0 = m;
        int m2 = m;
        for (int i2 = top = 0; i2 <= m2; ++i2) {
            if (!trace[i2].toString().startsWith("org.junit.") && !trace[i2].toString().startsWith("org.hamcrest.")) continue;
            if (i2 == top) {
                ++top;
                continue;
            }
            m2 = i2 - 1;
            boolean bl = false;
            while (m2 > top && !bl) {
                String s = trace[m2].toString();
                if (!s.startsWith("java.lang.reflect.") && !s.startsWith("sun.reflect.")) {
                    bl = true;
                    continue;
                }
                --m2;
            }
            i2 = m2;
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(top), m2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.log(this.Error(), this.stackTraceElementToString(trace[i], testFileName)));
        if (m0 != m2) {
            this.log(this.Error(), "    ...");
        } else if (framesInCommon != 0) {
            this.log(this.Error(), new StringBuilder(13).append("    ... ").append(framesInCommon).append(" more").toString());
        }
        this.logStackTraceAsCause(trace, t.getCause(), testFileName);
    }

    private void logStackTraceAsCause(StackTraceElement[] causedTrace, Throwable t, String testFileName) {
        if (t != null) {
            StackTraceElement[] trace = t.getStackTrace();
            int m = trace.length - 1;
            for (int n = causedTrace.length - 1; m >= 0 && n >= 0; --m, --n) {
                StackTraceElement stackTraceElement = trace[m];
                StackTraceElement stackTraceElement2 = causedTrace[n];
                if (stackTraceElement != null ? !((Object)stackTraceElement).equals(stackTraceElement2) : stackTraceElement2 != null) break;
            }
            this.log(this.Error(), new StringBuilder(11).append("Caused by: ").append(t).toString());
            this.logStackTracePart(trace, m, trace.length - 1 - m, t, testFileName);
            return;
        }
    }

    private String findTestFileName(StackTraceElement[] trace) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trace)).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JUnitReporter.$anonfun$findTestFileName$1(this, x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getFileName()).orNull(Predef$.MODULE$.$conforms());
    }

    private String stackTraceElementToString(StackTraceElement e, String testFileName) {
        String string;
        boolean highlight = this.settings.color() && e.getFileName() != null && e.getFileName().contains("file:/");
        boolean canHighlight = !PlatformCompat$.MODULE$.isNative();
        scala.collection.mutable.StringBuilder stringBuilder = new scala.collection.mutable.StringBuilder().append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset())).append(!canHighlight ? "" : (highlight ? AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Bold()) : AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.DarkGrey()))).append("    at ").append(this.settings.decodeName(new StringBuilder(0).append(e.getClassName()).append('.').append(e.getMethodName()).toString())).append('(');
        if (e.isNativeMethod()) {
            string = "Native Method";
        } else if (e.getFileName() == null) {
            string = "Unknown Source";
        } else {
            int file = e.getFileName().indexOf("file:/");
            int https = file >= 0 ? file : e.getFileName().indexOf("https:/");
            String filename = https >= 0 ? e.getFileName().substring(https) : e.getFileName();
            string = e.getLineNumber() >= 0 ? new StringBuilder(1).append(filename).append(":").append(e.getLineNumber()).toString() : filename;
        }
        return stringBuilder.append(string).append(')').append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset())).toString();
    }

    private String formatTime(double elapsedMillis) {
        return AnsiColors$.MODULE$.c(new StringOps(Predef$.MODULE$.augmentString("%.3fs")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(elapsedMillis / 1000.0))})), AnsiColors$.MODULE$.DarkGrey());
    }

    private int Trace() {
        return this.Trace;
    }

    private int Debug() {
        return this.Debug;
    }

    private int Info() {
        return this.Info;
    }

    private int Warn() {
        return this.Warn;
    }

    private int Error() {
        return this.Error;
    }

    public static final /* synthetic */ void $anonfun$log$1(JUnitReporter $this, String s$1, int level$1, Logger l) {
        String msg = $this.filterAnsiIfNeeded(l, s$1);
        int n = level$1;
        if ($this.Debug() == n) {
            l.debug(msg);
            return;
        }
        if ($this.Info() == n) {
            l.info(msg);
            return;
        }
        if ($this.Warn() == n) {
            l.warn(msg);
            return;
        }
        if ($this.Error() == n) {
            l.error(msg);
            return;
        }
        l.error(msg);
    }

    public static final /* synthetic */ boolean $anonfun$logTrace$1(StackTraceElement p) {
        return p.getFileName() != null && (p.getFileName().contains("StackTrace.scala") || p.getFileName().contains("Throwables.scala"));
    }

    public static final /* synthetic */ boolean $anonfun$logTrace$2(StackTraceElement p) {
        return p.getFileName() != null && p.getFileName().contains("JUnitExecuteTest.scala");
    }

    public static final /* synthetic */ boolean $anonfun$findTestFileName$1(JUnitReporter $this, StackTraceElement x$2) {
        String string = x$2.getClassName();
        String string2 = $this.taskDef.fullyQualifiedName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JUnitReporter(EventHandler eventHandler, Logger[] loggers, RunSettings settings, TaskDef taskDef) {
        this.eventHandler = eventHandler;
        this.loggers = loggers;
        this.settings = settings;
        this.taskDef = taskDef;
        this.isAnsiSupported = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])loggers)).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.ansiCodesSupported())) && settings.color();
        this.Trace = 0;
        this.Debug = 1;
        this.Info = 2;
        this.Warn = 3;
        this.Error = 4;
    }
}

