package munit.internal.junitinterface

import sbt.testing.Fingerprint
import sbt.testing.SubclassFingerprint

class CustomRunners(val runners: List[CustomFingerprint]) {
  private val superclasses = runners.iterator.map(_.suite).toSet

  def matchesFingerprint(fingerprint: Fingerprint): Boolean =
    fingerprint match {
      case s: SubclassFingerprint => superclasses.contains(s.superclassName())
      case _ => false
    }

}
