/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import java.io.Serializable;
import java.nio.file.Path;
import munit.Clues;
import munit.Clues$;
import munit.Location;
import munit.diff.console.AnsiColors$;
import munit.internal.console.Printers$;
import munit.internal.io.PlatformIO$Files$;
import munit.internal.io.PlatformIO$Path$;
import munit.internal.io.PlatformIO$Paths$;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001a4A!\u0003\u0006\u0001#!)1\u0004\u0001C\u00019!9q\u0004\u0001b\u0001\n\u0013\u0001\u0003B\u0002$\u0001A\u0003%\u0011\u0005C\u0003H\u0001\u0011\u0005\u0001\nC\u0003P\u0001\u0011\u0005\u0001\u000bC\u0003[\u0001\u0011\u00051\fC\u0004j\u0001E\u0005I\u0011\u00016\t\u000fU\u0004\u0011\u0013!C\u0001m\n)A*\u001b8fg*\u00111\u0002D\u0001\bG>t7o\u001c7f\u0015\tia\"\u0001\u0005j]R,'O\\1m\u0015\u0005y\u0011!B7v]&$8\u0001A\n\u0004\u0001IA\u0002CA\n\u0017\u001b\u0005!\"\"A\u000b\u0002\u000bM\u001c\u0017\r\\1\n\u0005]!\"AB!osJ+g\r\u0005\u0002\u00143%\u0011!\u0004\u0006\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003u\u0001\"A\b\u0001\u000e\u0003)\t\u0011BZ5mK\u000e\f7\r[3\u0016\u0003\u0005\u0002BAI\u0014*w5\t1E\u0003\u0002%K\u00059Q.\u001e;bE2,'B\u0001\u0014\u0015\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Q\r\u00121!T1q!\tQ\u0003H\u0004\u0002,k9\u0011Af\r\b\u0003[Ir!AL\u0019\u000e\u0003=R!\u0001\r\t\u0002\rq\u0012xn\u001c;?\u0013\u0005y\u0011BA\u0007\u000f\u0013\t!D\"\u0001\u0002j_&\u0011agN\u0001\u000b!2\fGOZ8s[&{%B\u0001\u001b\r\u0013\tI$H\u0001\u0003QCRD'B\u0001\u001c8!\r\u0019BHP\u0005\u0003{Q\u0011Q!\u0011:sCf\u0004\"aP\"\u000f\u0005\u0001\u000b\u0005C\u0001\u0018\u0015\u0013\t\u0011E#\u0001\u0004Qe\u0016$WMZ\u0005\u0003\t\u0016\u0013aa\u0015;sS:<'B\u0001\"\u0015\u0003)1\u0017\u000e\\3dC\u000eDW\rI\u0001\u000bM>\u0014X.\u0019;QCRDGC\u0001 J\u0011\u0015QE\u00011\u0001L\u0003!awnY1uS>t\u0007C\u0001'N\u001b\u0005q\u0011B\u0001(\u000f\u0005!aunY1uS>t\u0017\u0001\u00034j]\u0012\u0004\u0016\r\u001e5\u0015\t%\n6+\u0016\u0005\u0006%\u0016\u0001\rAP\u0001\u0004G^$\u0007\"\u0002+\u0006\u0001\u0004q\u0014\u0001\u00029bi\"DQAV\u0003A\u0002]\u000b1!\\1y!\t\u0019\u0002,\u0003\u0002Z)\t\u0019\u0011J\u001c;\u0002\u0015\u0019|'/\\1u\u0019&tW\rF\u0003?9v{F\rC\u0003K\r\u0001\u00071\nC\u0003_\r\u0001\u0007a(A\u0004nKN\u001c\u0018mZ3\t\u000f\u00014\u0001\u0013!a\u0001C\u0006)1\r\\;fgB\u0011AJY\u0005\u0003G:\u0011Qa\u00117vKNDq!\u001a\u0004\u0011\u0002\u0003\u0007a-\u0001\u0003b]NL\u0007CA\nh\u0013\tAGCA\u0004C_>dW-\u00198\u0002)\u0019|'/\\1u\u0019&tW\r\n3fM\u0006,H\u000e\u001e\u00134+\u0005Y'FA1mW\u0005i\u0007C\u00018t\u001b\u0005y'B\u00019r\u0003%)hn\u00195fG.,GM\u0003\u0002s)\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\u0005Q|'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0006!bm\u001c:nCRd\u0015N\\3%I\u00164\u0017-\u001e7uIQ*\u0012a\u001e\u0016\u0003M2\u0004")
public class Lines
implements scala.Serializable {
    private final Map<Path, String[]> filecache = Map$.MODULE$.empty();

    private Map<Path, String[]> filecache() {
        return this.filecache;
    }

    public String formatPath(Location location) {
        return location.path();
    }

    public Path findPath(String cwd, String path, int max) {
        Path p = PlatformIO$Paths$.MODULE$.get(cwd).resolve(path);
        if (PlatformIO$Files$.MODULE$.exists(p)) {
            return p;
        }
        if (max < 1) {
            throw package$.MODULE$.error(new StringBuilder(14).append(path).append(" was not found").toString());
        }
        if (cwd.contains("\\")) {
            return this.findPath(Lines.getParentPath$1(cwd, "\\"), path, max - 1);
        }
        return this.findPath(Lines.getParentPath$1(cwd, "/"), path, max - 1);
    }

    public String formatLine(Location location, String message, Clues clues, boolean ansi) {
        String string;
        try {
            Object object;
            Path path = this.findPath(((Object)PlatformIO$Path$.MODULE$.workingDirectory()).toString(), location.path(), 3);
            String[] lines = (String[])this.filecache().getOrElseUpdate((Object)path, (Function0 & Serializable & scala.Serializable)() -> (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(PlatformIO$Files$.MODULE$.readAllLines(path)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)));
            String[] slice = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).slice(location.line() - 2, location.line() + 1);
            scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
            if (slice.length >= 2) {
                int width = Integer.toString(location.line() + 1).length() + 1;
                boolean isMultilineMessage = new StringOps(Predef$.MODULE$.augmentString(message)).contains((Object)BoxesRunTime.boxToCharacter((char)'\n'));
                out.append(this.formatPath(location)).append(':').append(location.line());
                Object object2 = new StringOps(Predef$.MODULE$.augmentString(message)).nonEmpty() && !isMultilineMessage ? out.append(" ").append(message) : BoxedUnit.UNIT;
                out.append('\n').append(Lines.format$1(location.line() - 1, width)).append(slice[0]).append('\n');
                AnsiColors$.MODULE$.c(AnsiColors$.MODULE$.Reversed(), ansi, (Function1 & Serializable & scala.Serializable)x$1 -> {
                    Lines.$anonfun$formatLine$2(location, slice, width, x$1);
                    return BoxedUnit.UNIT;
                }, out);
                Object object3 = slice.length >= 3 ? out.append('\n').append(Lines.format$1(location.line() + 1, width)).append(slice[2]) : BoxedUnit.UNIT;
                Object object4 = isMultilineMessage ? out.append('\n').append(message) : BoxedUnit.UNIT;
                object = clues.values().nonEmpty() ? out.append('\n').append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                string = clues.values().isEmpty() ? message : new StringBuilder(1).append(message).append("\n").append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())).toString();
            }
            throw throwable;
        }
        return string;
    }

    public Clues formatLine$default$3() {
        return Clues$.MODULE$.empty();
    }

    public boolean formatLine$default$4() {
        return true;
    }

    private static final String getParentPath$1(String somePath, String sep) {
        String somePath1 = somePath.endsWith(sep) ? (String)new StringOps(Predef$.MODULE$.augmentString(somePath)).dropRight(sep.length()) : somePath;
        String string = sep;
        String string2 = "\\";
        String sep1 = !(string != null ? !string.equals(string2) : string2 != null) ? "\\\\" : sep;
        return new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])somePath1.split(sep1))).dropRight(1))).mkString(sep);
    }

    private static final String format$1(int n, int width$1) {
        return (String)new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(1).append(n).append(":").toString())).padTo(width$1, (Object)BoxesRunTime.boxToCharacter((char)' '), Predef$.MODULE$.StringCanBuildFrom());
    }

    public static final /* synthetic */ void $anonfun$formatLine$2(Location location$1, String[] slice$1, int width$1, scala.collection.mutable.StringBuilder x$1) {
        x$1.append(Lines.format$1(location$1.line(), width$1)).append(slice$1[1]);
    }
}

