/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.io.Serializable;
import munit.diff.console.AnsiColors$;
import munit.internal.PlatformCompat$;
import munit.internal.junitinterface.JUnitEvent;
import munit.internal.junitinterface.RunSettings;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Logger;
import sbt.testing.OptionalThrowable;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.Status$;
import sbt.testing.TaskDef;
import sbt.testing.TestSelector;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\u0005Eg\u0001\u0002\u0013&\u00051B\u0001b\r\u0001\u0003\u0002\u0003\u0006I\u0001\u000e\u0005\ty\u0001\u0011\t\u0011)A\u0005{!A1\t\u0001B\u0001B\u0003%A\t\u0003\u0005I\u0001\t\u0005\t\u0015!\u0003J\u0011\u0015a\u0005\u0001\"\u0001N\u0011\u001d\u0019\u0006A1A\u0005\nQCa\u0001\u0017\u0001!\u0002\u0013)\u0006\"B-\u0001\t\u0003Q\u0006\"\u00020\u0001\t\u0003y\u0006\"B7\u0001\t\u0003q\u0007\"B<\u0001\t\u0003A\bbBA\u0007\u0001\u0011\u0005\u0011q\u0002\u0005\b\u0003+\u0001A\u0011AA\f\u0011\u001d\t\t\u0003\u0001C\u0005\u0003GAq!!\u000b\u0001\t\u0013\tY\u0003C\u0004\u0002F\u0001!I!a\u0012\t\u000f\u0005u\u0003\u0001\"\u0003\u0002`!9\u0011Q\f\u0001\u0005\n\u0005\u001d\u0004bBA8\u0001\u0011%\u0011\u0011\u000f\u0005\b\u0003k\u0002A\u0011BA<\u0011\u001d\tY\n\u0001C\u0005\u0003;Cq!a*\u0001\t\u0013\tI\u000bC\u0004\u0002.\u0002!I!a,\t\u000f\u0005U\u0006\u0001\"\u0003\u00028\"I\u00111\u0018\u0001C\u0002\u0013%\u0011Q\u0018\u0005\t\u0003\u007f\u0003\u0001\u0015!\u0003\u0002T!I\u0011\u0011\u0019\u0001C\u0002\u0013%\u0011Q\u0018\u0005\t\u0003\u0007\u0004\u0001\u0015!\u0003\u0002T!I\u0011Q\u0019\u0001C\u0002\u0013%\u0011Q\u0018\u0005\t\u0003\u000f\u0004\u0001\u0015!\u0003\u0002T!I\u0011\u0011\u001a\u0001C\u0002\u0013%\u0011Q\u0018\u0005\t\u0003\u0017\u0004\u0001\u0015!\u0003\u0002T!I\u0011Q\u001a\u0001C\u0002\u0013%\u0011Q\u0018\u0005\t\u0003\u001f\u0004\u0001\u0015!\u0003\u0002T\u00151\u0011\u0011\u000b\u0001\u0005\u0003'\u0012QBS+oSR\u0014V\r]8si\u0016\u0014(B\u0001\u0014(\u00039QWO\\5uS:$XM\u001d4bG\u0016T!\u0001K\u0015\u0002\u0011%tG/\u001a:oC2T\u0011AK\u0001\u0006[Vt\u0017\u000e^\u0002\u0001'\t\u0001Q\u0006\u0005\u0002/c5\tqFC\u00011\u0003\u0015\u00198-\u00197b\u0013\t\u0011tF\u0001\u0004B]f\u0014VMZ\u0001\rKZ,g\u000e\u001e%b]\u0012dWM\u001d\t\u0003kij\u0011A\u000e\u0006\u0003oa\nq\u0001^3ti&twMC\u0001:\u0003\r\u0019(\r^\u0005\u0003wY\u0012A\"\u0012<f]RD\u0015M\u001c3mKJ\fq\u0001\\8hO\u0016\u00148\u000fE\u0002/}\u0001K!aP\u0018\u0003\u000b\u0005\u0013(/Y=\u0011\u0005U\n\u0015B\u0001\"7\u0005\u0019aunZ4fe\u0006A1/\u001a;uS:<7\u000f\u0005\u0002F\r6\tQ%\u0003\u0002HK\tY!+\u001e8TKR$\u0018N\\4t\u0003\u001d!\u0018m]6EK\u001a\u0004\"!\u000e&\n\u0005-3$a\u0002+bg.$UMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u000b9{\u0005+\u0015*\u0011\u0005\u0015\u0003\u0001\"B\u001a\u0006\u0001\u0004!\u0004\"\u0002\u001f\u0006\u0001\u0004i\u0004\"B\"\u0006\u0001\u0004!\u0005\"\u0002%\u0006\u0001\u0004I\u0015aD5t\u0003:\u001c\u0018nU;qa>\u0014H/\u001a3\u0016\u0003U\u0003\"A\f,\n\u0005]{#a\u0002\"p_2,\u0017M\\\u0001\u0011SN\fen]5TkB\u0004xN\u001d;fI\u0002\naC]3q_J$H+Z:u'VLG/Z*uCJ$X\r\u001a\u000b\u00027B\u0011a\u0006X\u0005\u0003;>\u0012A!\u00168ji\u0006\t\"/\u001a9peR$Vm\u001d;Ti\u0006\u0014H/\u001a3\u0015\u0005m\u0003\u0007\"B1\n\u0001\u0004\u0011\u0017AB7fi\"|G\r\u0005\u0002dU:\u0011A\r\u001b\t\u0003K>j\u0011A\u001a\u0006\u0003O.\na\u0001\u0010:p_Rt\u0014BA50\u0003\u0019\u0001&/\u001a3fM&\u00111\u000e\u001c\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005%|\u0013!\u0005:fa>\u0014H\u000fV3ti&;gn\u001c:fIR!1l\u001c9v\u0011\u0015\t'\u00021\u0001c\u0011\u0015\t(\u00021\u0001s\u00035)G.\u00199tK\u0012l\u0015\u000e\u001c7jgB\u0011af]\u0005\u0003i>\u0012a\u0001R8vE2,\u0007\"\u0002<\u000b\u0001\u0004\u0011\u0017AB:vM\u001aL\u00070A\rsKB|'\u000f^!tgVl\u0007\u000f^5p]ZKw\u000e\\1uS>tG\u0003B.zunDQ!Y\u0006A\u0002\tDQ!]\u0006A\u0002IDQ\u0001`\u0006A\u0002u\f\u0011!\u001a\t\u0004}\u0006\u001dabA@\u0002\u00049\u0019Q-!\u0001\n\u0003AJ1!!\u00020\u0003\u001d\u0001\u0018mY6bO\u0016LA!!\u0003\u0002\f\tIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0004\u0003\u000by\u0013\u0001\u0005:fa>\u0014H\u000fV3tiB\u000b7o]3e)\u0015Y\u0016\u0011CA\n\u0011\u0015\tG\u00021\u0001c\u0011\u0015\tH\u00021\u0001s\u0003A\u0011X\r]8siR+7\u000f\u001e$bS2,G\rF\u0004\\\u00033\tY\"a\b\t\u000b\u0005l\u0001\u0019\u00012\t\r\u0005uQ\u00021\u0001~\u0003\t)\u0007\u0010C\u0003r\u001b\u0001\u0007!/A\u0003ue\u0006\u001cW\rF\u0002\\\u0003KAa!a\n\u000f\u0001\u0004i\u0018!\u0001;\u0002\u0013\u0015l\u0017\u000e^#wK:$H#C.\u0002.\u0005=\u0012\u0011HA\"\u0011\u0015\tw\u00021\u0001c\u0011\u001d\t\td\u0004a\u0001\u0003g\taa\u001d;biV\u001c\bcA\u001b\u00026%\u0019\u0011q\u0007\u001c\u0003\rM#\u0018\r^;t\u0011\u001d\tYd\u0004a\u0001\u0003{\t\u0011\u0002\u001e5s_^\f'\r\\3\u0011\t9\ny$`\u0005\u0004\u0003\u0003z#AB(qi&|g\u000eC\u0003r\u001f\u0001\u0007!/A\u0002m_\u001e$RaWA%\u00033Bq!a\u0013\u0011\u0001\u0004\ti%A\u0003mKZ,G\u000eE\u0002\u0002P\rj\u0011\u0001\u0001\u0002\u0006\u0019\u00164X\r\u001c\t\u0004]\u0005U\u0013bAA,_\t\u0019\u0011J\u001c;\t\r\u0005m\u0003\u00031\u0001c\u0003\u0005\u0019\u0018A\u00054jYR,'/\u00118tS&3g*Z3eK\u0012$RAYA1\u0003KBa!a\u0019\u0012\u0001\u0004\u0001\u0015!\u00017\t\r\u0005m\u0013\u00031\u0001c)\u0015\u0011\u0017\u0011NA7\u0011\u0019\tYG\u0005a\u0001+\u0006\u0001\u0012n]\"pY>\u00148+\u001e9q_J$X\r\u001a\u0005\u0007\u00037\u0012\u0002\u0019\u00012\u0002\u00111|w\r\u0016:bG\u0016$2aWA:\u0011\u0019\t9c\u0005a\u0001{\u0006\tBn\\4Ti\u0006\u001c7\u000e\u0016:bG\u0016\u0004\u0016M\u001d;\u0015\u0017m\u000bI(!$\u0002\u0012\u0006U\u0015q\u0013\u0005\b\u0003C!\u0002\u0019AA>!\u0011qc(! \u0011\t\u0005}\u0014\u0011R\u0007\u0003\u0003\u0003SA!a!\u0002\u0006\u0006!A.\u00198h\u0015\t\t9)\u0001\u0003kCZ\f\u0017\u0002BAF\u0003\u0003\u0013\u0011c\u0015;bG.$&/Y2f\u000b2,W.\u001a8u\u0011\u001d\ty\t\u0006a\u0001\u0003'\n\u0011!\u001c\u0005\b\u0003'#\u0002\u0019AA*\u000391'/Y7fg&s7i\\7n_:Da!a\n\u0015\u0001\u0004i\bBBAM)\u0001\u0007!-\u0001\u0007uKN$h)\u001b7f\u001d\u0006lW-\u0001\u000bm_\u001e\u001cF/Y2l)J\f7-Z!t\u0007\u0006,8/\u001a\u000b\b7\u0006}\u00151UAS\u0011\u001d\t\t+\u0006a\u0001\u0003w\n1bY1vg\u0016$GK]1dK\"1\u0011qE\u000bA\u0002uDa!!'\u0016\u0001\u0004\u0011\u0017\u0001\u00054j]\u0012$Vm\u001d;GS2,g*Y7f)\r\u0011\u00171\u0016\u0005\b\u0003C1\u0002\u0019AA>\u0003e\u0019H/Y2l)J\f7-Z#mK6,g\u000e\u001e+p'R\u0014\u0018N\\4\u0015\u000b\t\f\t,a-\t\rq<\u0002\u0019AA?\u0011\u0019\tIj\u0006a\u0001E\u0006Qam\u001c:nCR$\u0016.\\3\u0015\u0007\t\fI\fC\u0003r1\u0001\u0007!/A\u0003Ue\u0006\u001cW-\u0006\u0002\u0002T\u00051AK]1dK\u0002\nQ\u0001R3ck\u001e\fa\u0001R3ck\u001e\u0004\u0013\u0001B%oM>\fQ!\u00138g_\u0002\nAaV1s]\u0006)q+\u0019:oA\u0005)QI\u001d:pe\u00061QI\u001d:pe\u0002\u0002")
public final class JUnitReporter {
    private final EventHandler eventHandler;
    private final Logger[] loggers;
    private final RunSettings settings;
    private final TaskDef taskDef;
    private final boolean isAnsiSupported;
    private final int Trace;
    private final int Debug;
    private final int Info;
    private final int Warn;
    private final int Error;

    private boolean isAnsiSupported() {
        return this.isAnsiSupported;
    }

    public void reportTestSuiteStarted() {
        this.log(this.Info(), AnsiColors$.MODULE$.c(new StringBuilder(1).append(this.taskDef.fullyQualifiedName()).append(":").toString(), AnsiColors$.MODULE$.GREEN()));
    }

    public void reportTestStarted(String method) {
        if (this.settings.verbose()) {
            this.log(this.Info(), new StringBuilder(8).append(method).append(" started").toString());
            return;
        }
    }

    public void reportTestIgnored(String method, double elapsedMillis, String suffix) {
        String suffixed = suffix.isEmpty() ? "" : new StringBuilder(1).append(" ").append(suffix).toString();
        this.log(this.Info(), new StringBuilder(1).append(AnsiColors$.MODULE$.c(new StringBuilder(14).append("==> i ").append(method).append(suffixed).append(" ignored").toString(), AnsiColors$.MODULE$.YELLOW())).append(" ").append(this.formatTime(elapsedMillis)).toString());
        this.emitEvent(method, Status$.MODULE$.Ignored(), (Option<Throwable>)None$.MODULE$, elapsedMillis);
    }

    public void reportAssumptionViolation(String method, double elapsedMillis, Throwable e) {
        this.log(this.Info(), AnsiColors$.MODULE$.c(new StringBuilder(14).append("==> s ").append(method).append(" skipped").toString(), AnsiColors$.MODULE$.YELLOW()));
        this.emitEvent(method, Status$.MODULE$.Skipped(), (Option<Throwable>)Option$.MODULE$.apply((Object)e), 0.0);
    }

    public void reportTestPassed(String method, double elapsedMillis) {
        this.log(this.Info(), new StringBuilder(1).append(AnsiColors$.MODULE$.c(new StringBuilder(4).append("  + ").append(method).toString(), AnsiColors$.MODULE$.GREEN())).append(" ").append(this.formatTime(elapsedMillis)).toString());
        this.emitEvent(method, Status$.MODULE$.Success(), (Option<Throwable>)None$.MODULE$, elapsedMillis);
    }

    public void reportTestFailed(String method, Throwable ex, double elapsedMillis) {
        this.log(this.Info(), new scala.collection.mutable.StringBuilder().append(AnsiColors$.MODULE$.c(new StringBuilder(7).append("==> X ").append(this.taskDef.fullyQualifiedName()).append(".").append(method).toString(), AnsiColors$.MODULE$.LightRed())).append(" ").append(this.formatTime(elapsedMillis)).append(" ").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).toString());
        this.emitEvent(method, Status$.MODULE$.Failure(), (Option<Throwable>)Option$.MODULE$.apply((Object)ex), elapsedMillis);
    }

    private void trace(Throwable t) {
        if (!(t instanceof AssertionError) || this.settings.logAssert()) {
            this.logTrace(t);
            return;
        }
    }

    private void emitEvent(String method, Status status, Option<Throwable> throwable, double elapsedMillis) {
        String testName = new StringBuilder(1).append(this.taskDef.fullyQualifiedName()).append(".").append(this.settings.decodeName(method)).toString();
        TestSelector selector = new TestSelector(testName);
        this.eventHandler.handle((Event)new JUnitEvent(this.taskDef, testName, status, (Selector)selector, new OptionalThrowable((Throwable)throwable.orNull(Predef$.MODULE$.$conforms())), (long)elapsedMillis));
    }

    private void log(int level, String s) {
        if (this.settings.useSbtLoggers()) {
            new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.loggers)).foreach((Function1 & Serializable & scala.Serializable)l -> {
                JUnitReporter.$anonfun$log$1(this, s, level, l);
                return BoxedUnit.UNIT;
            });
            return;
        }
        int n = level;
        if ((this.Debug() == n ? true : this.Trace() == n) && !this.settings.verbose()) {
            return;
        }
        Predef$.MODULE$.println((Object)this.filterAnsiIfNeeded(this.isAnsiSupported(), s));
    }

    private String filterAnsiIfNeeded(Logger l, String s) {
        return this.filterAnsiIfNeeded(l.ansiCodesSupported(), s);
    }

    private String filterAnsiIfNeeded(boolean isColorSupported, String s) {
        if (isColorSupported && this.settings.color()) {
            return s;
        }
        return AnsiColors$.MODULE$.filterAnsi(s);
    }

    private void logTrace(Throwable t) {
        StackTraceElement[] trace = (StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])t.getStackTrace())).dropWhile((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)JUnitReporter.$anonfun$logTrace$1(p)));
        String testFileName = this.settings.color() ? this.findTestFileName(trace) : null;
        int i = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trace)).indexWhere((Function1 & Serializable & scala.Serializable)p -> BoxesRunTime.boxToBoolean((boolean)JUnitReporter.$anonfun$logTrace$2(p))) - 1;
        int m = i > 0 ? i : trace.length - 1;
        this.logStackTracePart(trace, m, trace.length - m - 1, t, testFileName);
    }

    private void logStackTracePart(StackTraceElement[] trace, int m, int framesInCommon, Throwable t, String testFileName) {
        int top;
        int m0 = m;
        int m2 = m;
        for (int i2 = top = 0; i2 <= m2; ++i2) {
            if (!trace[i2].toString().startsWith("org.junit.") && !trace[i2].toString().startsWith("org.hamcrest.")) continue;
            if (i2 == top) {
                ++top;
                continue;
            }
            m2 = i2 - 1;
            boolean bl = false;
            while (m2 > top && !bl) {
                String s = trace[m2].toString();
                if (!s.startsWith("java.lang.reflect.") && !s.startsWith("sun.reflect.")) {
                    bl = true;
                    continue;
                }
                --m2;
            }
            i2 = m2;
        }
        RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(top), m2).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.log(this.Error(), this.stackTraceElementToString(trace[i], testFileName)));
        if (m0 != m2) {
            this.log(this.Error(), "    ...");
        } else if (framesInCommon != 0) {
            this.log(this.Error(), new StringBuilder(13).append("    ... ").append(framesInCommon).append(" more").toString());
        }
        this.logStackTraceAsCause(trace, t.getCause(), testFileName);
    }

    private void logStackTraceAsCause(StackTraceElement[] causedTrace, Throwable t, String testFileName) {
        if (t != null) {
            StackTraceElement[] trace = t.getStackTrace();
            int m = trace.length - 1;
            for (int n = causedTrace.length - 1; m >= 0 && n >= 0; --m, --n) {
                StackTraceElement stackTraceElement = trace[m];
                StackTraceElement stackTraceElement2 = causedTrace[n];
                if (stackTraceElement != null ? !((Object)stackTraceElement).equals(stackTraceElement2) : stackTraceElement2 != null) break;
            }
            this.log(this.Error(), new StringBuilder(11).append("Caused by: ").append(t).toString());
            this.logStackTracePart(trace, m, trace.length - 1 - m, t, testFileName);
            return;
        }
    }

    private String findTestFileName(StackTraceElement[] trace) {
        return (String)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])trace)).find((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)JUnitReporter.$anonfun$findTestFileName$1(this, x$2))).map((Function1 & Serializable & scala.Serializable)x$3 -> x$3.getFileName()).orNull(Predef$.MODULE$.$conforms());
    }

    private String stackTraceElementToString(StackTraceElement e, String testFileName) {
        String string;
        boolean highlight = this.settings.color() && e.getFileName() != null && e.getFileName().contains("file:/");
        boolean canHighlight = !PlatformCompat$.MODULE$.isNative();
        scala.collection.mutable.StringBuilder stringBuilder = new scala.collection.mutable.StringBuilder().append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset())).append(!canHighlight ? "" : (highlight ? AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Bold()) : AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.DarkGrey()))).append("    at ").append(this.settings.decodeName(new StringBuilder(0).append(e.getClassName()).append('.').append(e.getMethodName()).toString())).append('(');
        if (e.isNativeMethod()) {
            string = "Native Method";
        } else if (e.getFileName() == null) {
            string = "Unknown Source";
        } else {
            int file = e.getFileName().indexOf("file:/");
            int https = file >= 0 ? file : e.getFileName().indexOf("https:/");
            String filename = https >= 0 ? e.getFileName().substring(https) : e.getFileName();
            string = e.getLineNumber() >= 0 ? new StringBuilder(1).append(filename).append(":").append(e.getLineNumber()).toString() : filename;
        }
        return stringBuilder.append(string).append(')').append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset())).toString();
    }

    private String formatTime(double elapsedMillis) {
        return AnsiColors$.MODULE$.c(new StringOps(Predef$.MODULE$.augmentString("%.3fs")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(elapsedMillis / 1000.0))})), AnsiColors$.MODULE$.DarkGrey());
    }

    private int Trace() {
        return this.Trace;
    }

    private int Debug() {
        return this.Debug;
    }

    private int Info() {
        return this.Info;
    }

    private int Warn() {
        return this.Warn;
    }

    private int Error() {
        return this.Error;
    }

    public static final /* synthetic */ void $anonfun$log$1(JUnitReporter $this, String s$1, int level$1, Logger l) {
        String msg = $this.filterAnsiIfNeeded(l, s$1);
        int n = level$1;
        if ($this.Debug() == n) {
            l.debug(msg);
            return;
        }
        if ($this.Info() == n) {
            l.info(msg);
            return;
        }
        if ($this.Warn() == n) {
            l.warn(msg);
            return;
        }
        if ($this.Error() == n) {
            l.error(msg);
            return;
        }
        l.error(msg);
    }

    public static final /* synthetic */ boolean $anonfun$logTrace$1(StackTraceElement p) {
        return p.getFileName() != null && (p.getFileName().contains("StackTrace.scala") || p.getFileName().contains("Throwables.scala"));
    }

    public static final /* synthetic */ boolean $anonfun$logTrace$2(StackTraceElement p) {
        return p.getFileName() != null && p.getFileName().contains("JUnitExecuteTest.scala");
    }

    public static final /* synthetic */ boolean $anonfun$findTestFileName$1(JUnitReporter $this, StackTraceElement x$2) {
        String string = x$2.getClassName();
        String string2 = $this.taskDef.fullyQualifiedName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    public JUnitReporter(EventHandler eventHandler, Logger[] loggers, RunSettings settings, TaskDef taskDef) {
        this.eventHandler = eventHandler;
        this.loggers = loggers;
        this.settings = settings;
        this.taskDef = taskDef;
        this.isAnsiSupported = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])loggers)).forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)x$1.ansiCodesSupported())) && settings.color();
        this.Trace = 0;
        this.Debug = 1;
        this.Info = 2;
        this.Warn = 3;
        this.Error = 4;
    }
}

