/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import munit.Clue;
import munit.Clues;
import munit.EmptyPrinter$;
import munit.Location;
import munit.Printable;
import munit.Printer;
import munit.internal.Compat$;
import munit.internal.console.AnsiColors$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Product;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

public final class Printers$ {
    public static final Printers$ MODULE$;

    static {
        new Printers$();
    }

    public void log(Object any, Printer printer, Location loc) {
        Predef$.MODULE$.println((Object)loc.toString());
        Predef$.MODULE$.println((Object)this.print(any, printer));
    }

    public Printer log$default$2() {
        return EmptyPrinter$.MODULE$;
    }

    public String print(Object any, Printer printer) {
        IntRef height = IntRef.create((int)printer.height());
        StringBuilder out = new StringBuilder();
        int indentStep = 2;
        this.munit$internal$console$Printers$$loop$1(any, 0, any, printer, height, out, indentStep);
        return AnsiColors$.MODULE$.filterAnsi(out.toString());
    }

    public Printer print$default$2() {
        return EmptyPrinter$.MODULE$;
    }

    private <T> void printApply(String prefix, Iterator<T> it, StringBuilder out, int indent, int nextIndent, String open, String close, String comma, Function1<T, BoxedUnit> fn) {
        out.append(prefix);
        out.append(open);
        if (it.hasNext()) {
            this.printNewline(out, nextIndent);
            while (it.hasNext()) {
                Object value = it.next();
                fn.apply(value);
                if (it.hasNext()) {
                    out.append(comma);
                    this.printNewline(out, nextIndent);
                    continue;
                }
                this.printNewline(out, indent);
            }
        }
        out.append(close);
    }

    private <T> String printApply$default$6() {
        return "(";
    }

    private <T> String printApply$default$7() {
        return ")";
    }

    private <T> String printApply$default$8() {
        return ",";
    }

    private void printNewline(StringBuilder out, int indent) {
        out.append("\n");
        for (int i = 0; i < indent; ++i) {
            out.append(' ');
        }
    }

    private void printString(String string, StringBuilder out, Printer printer) {
        boolean isMultiline = printer.isMultiline(string);
        if (isMultiline) {
            out.append('\"');
            out.append('\"');
            out.append('\"');
            out.append(string);
            out.append('\"');
            out.append('\"');
            out.append('\"');
        } else {
            out.append('\"');
            for (int i = 0; i < string.length(); ++i) {
                this.printChar(string.charAt(i), out);
            }
            out.append('\"');
        }
    }

    private StringBuilder printChar(char c, StringBuilder sb) {
        StringBuilder stringBuilder;
        char c2 = c;
        switch (c2) {
            default: {
                boolean isUnicode = false;
                if (c2 < ' ' || c2 > '~' && isUnicode) {
                    stringBuilder = sb.append(new StringOps(Predef$.MODULE$.augmentString("\\u%04x")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c2)})));
                    break;
                }
                stringBuilder = sb.append(c2);
                break;
            }
            case '\t': {
                stringBuilder = sb.append("\\t");
                break;
            }
            case '\r': {
                stringBuilder = sb.append("\\r");
                break;
            }
            case '\n': {
                stringBuilder = sb.append("\\n");
                break;
            }
            case '\f': {
                stringBuilder = sb.append("\\f");
                break;
            }
            case '\b': {
                stringBuilder = sb.append("\\b");
                break;
            }
            case '\\': {
                stringBuilder = sb.append("\\\\");
                break;
            }
            case '\'': {
                stringBuilder = sb.append("\\'");
                break;
            }
            case '\"': {
                stringBuilder = sb.append("\\\"");
            }
        }
        return stringBuilder;
    }

    public final void munit$internal$console$Printers$$loop$1(Object a, int indent, Object any$1, Printer printer$1, IntRef height$1, StringBuilder out$1, int indentStep$1) {
        --height$1.elem;
        if (height$1.elem < 0) {
            out$1.append("...");
            return;
        }
        int nextIndent = indent + indentStep$1;
        boolean isDone = printer$1.print(a, out$1, indent);
        if (!isDone) {
            Object object = a;
            if (object == null) {
                out$1.append("null");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Printable) {
                Printable printable = (Printable)object;
                printable.print(out$1, indent);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Character) {
                char c = BoxesRunTime.unboxToChar((Object)object);
                out$1.append('\'');
                this.printChar(c, out$1);
                out$1.append('\'');
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Byte) {
                byte by = BoxesRunTime.unboxToByte((Object)object);
                out$1.append(((Object)BoxesRunTime.boxToByte((byte)by)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Short) {
                short s = BoxesRunTime.unboxToShort((Object)object);
                out$1.append(((Object)BoxesRunTime.boxToShort((short)s)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Integer) {
                int n = BoxesRunTime.unboxToInt((Object)object);
                out$1.append(((Object)BoxesRunTime.boxToInteger((int)n)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Long) {
                long l = BoxesRunTime.unboxToLong((Object)object);
                out$1.append(((Object)BoxesRunTime.boxToLong((long)l)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Float) {
                float f = BoxesRunTime.unboxToFloat((Object)object);
                out$1.append(((Object)BoxesRunTime.boxToFloat((float)f)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Double) {
                double d = BoxesRunTime.unboxToDouble((Object)object);
                out$1.append(((Object)BoxesRunTime.boxToDouble((double)d)).toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof String) {
                String string = (String)object;
                this.printString(string, out$1, printer$1);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Clues) {
                Clues clues = (Clues)object;
                this.printApply("Clues", (Iterator)clues.values().iterator(), out$1, indent, nextIndent, " {", "}", "", (Function1)new Serializable(any$1, printer$1, height$1, out$1, indentStep$1, nextIndent){
                    public static final long serialVersionUID = 0L;
                    private final Object any$1;
                    private final Printer printer$1;
                    private final IntRef height$1;
                    private final StringBuilder out$1;
                    private final int indentStep$1;
                    private final int nextIndent$1;

                    public final void apply(Clue<?> clue) {
                        Object object = new StringOps(Predef$.MODULE$.augmentString(clue.source())).nonEmpty() ? this.out$1.append(clue.source()).append(": ") : BoxedUnit.UNIT;
                        Printers$.MODULE$.munit$internal$console$Printers$$loop$1(clue.value(), this.nextIndent$1, this.any$1, this.printer$1, this.height$1, this.out$1, this.indentStep$1);
                    }
                    {
                        this.any$1 = any$1;
                        this.printer$1 = printer$1;
                        this.height$1 = height$1;
                        this.out$1 = out$1;
                        this.indentStep$1 = indentStep$1;
                        this.nextIndent$1 = nextIndent$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (None$.MODULE$.equals(object)) {
                out$1.append("None");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (Nil$.MODULE$.equals(object)) {
                out$1.append("Nil");
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Map) {
                Map map = (Map)object;
                this.printApply(Compat$.MODULE$.collectionClassName((Iterable<?>)map), (Iterator)map.iterator(), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1)new Serializable(any$1, printer$1, height$1, out$1, indentStep$1, nextIndent){
                    public static final long serialVersionUID = 0L;
                    private final Object any$1;
                    private final Printer printer$1;
                    private final IntRef height$1;
                    private final StringBuilder out$1;
                    private final int indentStep$1;
                    private final int nextIndent$1;

                    public final void apply(Tuple2<Object, Object> x0$1) {
                        Tuple2<Object, Object> tuple2 = x0$1;
                        if (tuple2 != null) {
                            Object key = tuple2._1();
                            Object value = tuple2._2();
                            Printers$.MODULE$.munit$internal$console$Printers$$loop$1(key, this.nextIndent$1, this.any$1, this.printer$1, this.height$1, this.out$1, this.indentStep$1);
                            this.out$1.append(" -> ");
                            Printers$.MODULE$.munit$internal$console$Printers$$loop$1(value, this.nextIndent$1, this.any$1, this.printer$1, this.height$1, this.out$1, this.indentStep$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.any$1 = any$1;
                        this.printer$1 = printer$1;
                        this.height$1 = height$1;
                        this.out$1 = out$1;
                        this.indentStep$1 = indentStep$1;
                        this.nextIndent$1 = nextIndent$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Iterable) {
                Iterable iterable = (Iterable)object;
                this.printApply(Compat$.MODULE$.collectionClassName(iterable), (Iterator)iterable.iterator(), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1)new Serializable(any$1, printer$1, height$1, out$1, indentStep$1, nextIndent){
                    public static final long serialVersionUID = 0L;
                    private final Object any$1;
                    private final Printer printer$1;
                    private final IntRef height$1;
                    private final StringBuilder out$1;
                    private final int indentStep$1;
                    private final int nextIndent$1;

                    public final void apply(Object value) {
                        Printers$.MODULE$.munit$internal$console$Printers$$loop$1(value, this.nextIndent$1, this.any$1, this.printer$1, this.height$1, this.out$1, this.indentStep$1);
                    }
                    {
                        this.any$1 = any$1;
                        this.printer$1 = printer$1;
                        this.height$1 = height$1;
                        this.out$1 = out$1;
                        this.indentStep$1 = indentStep$1;
                        this.nextIndent$1 = nextIndent$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                Object object2 = object;
                this.printApply("Array", (Iterator)Predef$.MODULE$.genericArrayOps(object2).iterator(), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1)new Serializable(any$1, printer$1, height$1, out$1, indentStep$1, nextIndent){
                    public static final long serialVersionUID = 0L;
                    private final Object any$1;
                    private final Printer printer$1;
                    private final IntRef height$1;
                    private final StringBuilder out$1;
                    private final int indentStep$1;
                    private final int nextIndent$1;

                    public final void apply(Object value) {
                        Printers$.MODULE$.munit$internal$console$Printers$$loop$1(value, this.nextIndent$1, this.any$1, this.printer$1, this.height$1, this.out$1, this.indentStep$1);
                    }
                    {
                        this.any$1 = any$1;
                        this.printer$1 = printer$1;
                        this.height$1 = height$1;
                        this.out$1 = out$1;
                        this.indentStep$1 = indentStep$1;
                        this.nextIndent$1 = nextIndent$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else if (object instanceof Iterator) {
                BoxedUnit boxedUnit;
                Iterator iterator2 = (Iterator)object;
                if (iterator2.isEmpty()) {
                    out$1.append("empty iterator");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    out$1.append("non-empty iterator");
                    boxedUnit = BoxedUnit.UNIT;
                }
                BoxedUnit boxedUnit2 = boxedUnit;
            } else if (object instanceof Product) {
                Product product = (Product)object;
                Iterator<String> elementNames = Compat$.MODULE$.productElementNames(product);
                Iterator infiniteElementNames = package$.MODULE$.Iterator().continually((Function0)new Serializable(elementNames){
                    public static final long serialVersionUID = 0L;
                    private final Iterator elementNames$1;

                    public final String apply() {
                        return this.elementNames$1.hasNext() ? (String)this.elementNames$1.next() : "";
                    }
                    {
                        this.elementNames$1 = elementNames$1;
                    }
                });
                this.printApply(product.productPrefix(), (Iterator)product.productIterator().zip(infiniteElementNames), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1)new Serializable(any$1, printer$1, height$1, out$1, indentStep$1, nextIndent){
                    public static final long serialVersionUID = 0L;
                    private final Object any$1;
                    private final Printer printer$1;
                    private final IntRef height$1;
                    private final StringBuilder out$1;
                    private final int indentStep$1;
                    private final int nextIndent$1;

                    public final void apply(Tuple2<Object, String> x0$2) {
                        Tuple2<Object, String> tuple2 = x0$2;
                        if (tuple2 != null) {
                            Object value = tuple2._1();
                            String key = (String)tuple2._2();
                            Object object = new StringOps(Predef$.MODULE$.augmentString(key)).nonEmpty() ? this.out$1.append(key).append(" = ") : BoxedUnit.UNIT;
                            Printers$.MODULE$.munit$internal$console$Printers$$loop$1(value, this.nextIndent$1, this.any$1, this.printer$1, this.height$1, this.out$1, this.indentStep$1);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.any$1 = any$1;
                        this.printer$1 = printer$1;
                        this.height$1 = height$1;
                        this.out$1 = out$1;
                        this.indentStep$1 = indentStep$1;
                        this.nextIndent$1 = nextIndent$1;
                    }
                });
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                out$1.append(any$1.toString());
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private Printers$() {
        MODULE$ = this;
    }
}

