/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.difflib;

import java.util.ArrayList;
import java.util.List;
import munit.internal.difflib.ChangeDelta;
import munit.internal.difflib.Chunk;
import munit.internal.difflib.DeleteDelta;
import munit.internal.difflib.Delta;
import munit.internal.difflib.DiffAlgorithm;
import munit.internal.difflib.DiffNode;
import munit.internal.difflib.DifferentiationFailedException;
import munit.internal.difflib.Equalizer;
import munit.internal.difflib.Equalizer$;
import munit.internal.difflib.InsertDelta;
import munit.internal.difflib.Patch;
import munit.internal.difflib.PathNode;
import munit.internal.difflib.Snake;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u3A!\u0001\u0002\u0001\u0013\tIQ*_3sg\u0012KgM\u001a\u0006\u0003\u0007\u0011\tq\u0001Z5gM2L'M\u0003\u0002\u0006\r\u0005A\u0011N\u001c;fe:\fGNC\u0001\b\u0003\u0015iWO\\5u\u0007\u0001)\"AC\f\u0014\u0007\u0001Y\u0011\u0003\u0005\u0002\r\u001f5\tQBC\u0001\u000f\u0003\u0015\u00198-\u00197b\u0013\t\u0001RB\u0001\u0004B]f\u0014VM\u001a\t\u0004%M)R\"\u0001\u0002\n\u0005Q\u0011!!\u0004#jM\u001a\fEnZ8sSRDW\u000e\u0005\u0002\u0017/1\u0001A!\u0002\r\u0001\u0005\u0004I\"!\u0001+\u0012\u0005ii\u0002C\u0001\u0007\u001c\u0013\taRBA\u0004O_RD\u0017N\\4\u0011\u00051q\u0012BA\u0010\u000e\u0005\r\te.\u001f\u0005\tC\u0001\u0011\t\u0011)A\u0005E\u0005IQ-];bY&TXM\u001d\t\u0004%\r*\u0012B\u0001\u0013\u0003\u0005%)\u0015/^1mSj,'\u000fC\u0003'\u0001\u0011\u0005q%\u0001\u0004=S:LGO\u0010\u000b\u0003Q%\u00022A\u0005\u0001\u0016\u0011\u0015\tS\u00051\u0001#\u0011\u00151\u0003\u0001\"\u0001,)\u0005A\u0003\"B\u0017\u0001\t\u0003r\u0013\u0001\u00023jM\u001a$2a\f\u001a=!\r\u0011\u0002'F\u0005\u0003c\t\u0011Q\u0001U1uG\"DQa\r\u0017A\u0002Q\n\u0001b\u001c:jO&t\u0017\r\u001c\t\u0004ki*R\"\u0001\u001c\u000b\u0005]B\u0014\u0001B;uS2T\u0011!O\u0001\u0005U\u00064\u0018-\u0003\u0002<m\t!A*[:u\u0011\u0015iD\u00061\u00015\u0003\u001d\u0011XM^5tK\u0012DQa\u0010\u0001\u0005\n\u0001\u000bQBY;jY\u0012\u0014VM^5tS>tG\u0003B\u0018B\r\"CQA\u0011 A\u0002\r\u000bQa\u00189bi\"\u0004\"A\u0005#\n\u0005\u0015\u0013!\u0001\u0003)bi\"tu\u000eZ3\t\u000b\u001ds\u0004\u0019\u0001\u001b\u0002\t=\u0014\u0018n\u001a\u0005\u0006\u0013z\u0002\r\u0001N\u0001\u0004e\u00164\b\"B&\u0001\t\u0013a\u0015aC2paf|eMU1oO\u0016$B!\u0014)R-B\u0019QGT\u000b\n\u0005=3$!C!se\u0006LH*[:u\u0011\u0015\u0019$\n1\u00015\u0011\u0015\u0011&\n1\u0001T\u0003%1'o\\7J]\u0012,\u0007\u0010\u0005\u0002\r)&\u0011Q+\u0004\u0002\u0004\u0013:$\b\"B,K\u0001\u0004\u0019\u0016A\u0001;p\u0011\u0015I\u0006\u0001\"\u0001[\u0003%\u0011W/\u001b7e!\u0006$\b\u000eF\u0002D7rCQa\u0012-A\u0002QBQ!\u0013-A\u0002Q\u0002")
public class MyersDiff<T>
implements DiffAlgorithm<T> {
    private final Equalizer<T> equalizer;

    @Override
    public Patch<T> diff(List<T> original, List<T> revised) {
        Patch patch;
        try {
            patch = this.buildRevision(this.buildPath(original, revised), original, revised);
        }
        catch (DifferentiationFailedException differentiationFailedException) {
            differentiationFailedException.printStackTrace();
            patch = new Patch();
        }
        return patch;
    }

    private Patch<T> buildRevision(PathNode _path, List<T> orig, List<T> rev) {
        PathNode path = _path;
        Patch<T> patch = new Patch<T>();
        if (path.isSnake()) {
            path = path.prev();
        }
        while (path != null && path.prev() != null && path.prev().j() >= 0) {
            if (path.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i = path.i();
            int j = path.j();
            path = path.prev();
            int ianchor = path.i();
            int janchor = path.j();
            Chunk<T> original = new Chunk<T>(ianchor, this.copyOfRange(orig, ianchor, i));
            Chunk<T> revised = new Chunk<T>(janchor, this.copyOfRange(rev, janchor, j));
            Delta delta = original.size() == 0 && revised.size() != 0 ? new InsertDelta<T>(original, revised) : (original.size() > 0 && revised.size() == 0 ? new DeleteDelta<T>(original, revised) : new ChangeDelta<T>(original, revised));
            patch.addDelta(delta);
            if (!path.isSnake()) continue;
            path = path.prev();
        }
        return patch;
    }

    private ArrayList<T> copyOfRange(List<T> original, int fromIndex, int to) {
        return new ArrayList<T>(original.subList(fromIndex, to));
    }

    public PathNode buildPath(List<T> orig, List<T> rev) {
        int N = orig.size();
        int M = rev.size();
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = size / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new Snake(0, -1, null);
        for (int d = 0; d < MAX; ++d) {
            for (int k = -d; k <= d; k += 2) {
                int j;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                PathNode prev = null;
                int i = 0;
                if (k == -d || k != d && diagonal[kminus].i() < diagonal[kplus].i()) {
                    i = diagonal[kplus].i();
                    prev = diagonal[kplus];
                } else {
                    i = diagonal[kminus].i() + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                PathNode node = new DiffNode(i, j, prev);
                for (j = i - k; i < N && j < M && this.equalizer.equals(orig.get(i), rev.get(j)); ++i, ++j) {
                }
                if (i > node.i()) {
                    node = new Snake(i, j, node);
                }
                diagonal[kmiddle] = node;
                if (i < N || j < M) continue;
                return diagonal[kmiddle];
            }
            diagonal[middle + d - 1] = null;
        }
        throw new DifferentiationFailedException("could not find a diff path");
    }

    public MyersDiff(Equalizer<T> equalizer) {
        this.equalizer = equalizer;
    }

    public MyersDiff() {
        this(Equalizer$.MODULE$.default());
    }
}

