/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import java.io.Serializable;
import java.nio.file.Files$;
import java.nio.file.Path;
import java.nio.file.Paths$;
import munit.Clue;
import munit.Clues;
import munit.Location;
import munit.internal.console.AnsiColors$;
import munit.internal.console.Printers$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

@ScalaSignature(bytes="\u0006\u0001E3AAB\u0004\u0001\u001d!)\u0001\u0004\u0001C\u00013!9A\u0004\u0001b\u0001\n\u0013i\u0002B\u0002 \u0001A\u0003%a\u0004C\u0003@\u0001\u0011\u0005\u0001\tC\u0003@\u0001\u0011\u0005\u0011JA\u0003MS:,7O\u0003\u0002\t\u0013\u000591m\u001c8t_2,'B\u0001\u0006\f\u0003!Ig\u000e^3s]\u0006d'\"\u0001\u0007\u0002\u000b5,h.\u001b;\u0004\u0001M\u0019\u0001aD\u000b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g!\t\u0001b#\u0003\u0002\u0018#\ta1+\u001a:jC2L'0\u00192mK\u00061A(\u001b8jiz\"\u0012A\u0007\t\u00037\u0001i\u0011aB\u0001\nM&dWmY1dQ\u0016,\u0012A\b\t\u0005?\u00112\u0003'D\u0001!\u0015\t\t#%A\u0004nkR\f'\r\\3\u000b\u0005\r\n\u0012AC2pY2,7\r^5p]&\u0011Q\u0005\t\u0002\u0004\u001b\u0006\u0004\bCA\u0014/\u001b\u0005A#BA\u0015+\u0003\u00111\u0017\u000e\\3\u000b\u0005-b\u0013a\u00018j_*\tQ&\u0001\u0003kCZ\f\u0017BA\u0018)\u0005\u0011\u0001\u0016\r\u001e5\u0011\u0007A\t4'\u0003\u00023#\t)\u0011I\u001d:bsB\u0011Ag\u000f\b\u0003ke\u0002\"AN\t\u000e\u0003]R!\u0001O\u0007\u0002\rq\u0012xn\u001c;?\u0013\tQ\u0014#\u0001\u0004Qe\u0016$WMZ\u0005\u0003yu\u0012aa\u0015;sS:<'B\u0001\u001e\u0012\u0003)1\u0017\u000e\\3dC\u000eDW\rI\u0001\u000bM>\u0014X.\u0019;MS:,GcA\u001aB\u000f\")!\t\u0002a\u0001\u0007\u0006AAn\\2bi&|g\u000e\u0005\u0002E\u000b6\t1\"\u0003\u0002G\u0017\tAAj\\2bi&|g\u000eC\u0003I\t\u0001\u00071'A\u0004nKN\u001c\u0018mZ3\u0015\tMR5\n\u0014\u0005\u0006\u0005\u0016\u0001\ra\u0011\u0005\u0006\u0011\u0016\u0001\ra\r\u0005\u0006\u001b\u0016\u0001\rAT\u0001\u0006G2,Xm\u001d\t\u0003\t>K!\u0001U\u0006\u0003\u000b\rcW/Z:")
public class Lines
implements scala.Serializable {
    private final Map<Path, String[]> filecache = Map$.MODULE$.empty();

    private Map<Path, String[]> filecache() {
        return this.filecache;
    }

    public String formatLine(Location location, String message) {
        return this.formatLine(location, message, new Clues((List<Clue<?>>)Nil$.MODULE$));
    }

    public String formatLine(Location location, String message, Clues clues) {
        String string;
        try {
            Object object;
            Path path = Paths$.MODULE$.get(location.path(), Paths$.MODULE$.get$default$2());
            String[] lines = (String[])this.filecache().getOrElseUpdate((Object)path, (Function0 & Serializable & scala.Serializable)() -> (String[])((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(Files$.MODULE$.readAllLines(path)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class)));
            String[] slice = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])lines)).slice(location.line() - 2, location.line() + 1);
            scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
            if (slice.length == 3) {
                int width = ((Object)BoxesRunTime.boxToInteger((int)(location.line() + 1))).toString().length();
                boolean isMultilineMessage = new StringOps(Predef$.MODULE$.augmentString(message)).contains((Object)BoxesRunTime.boxToCharacter((char)'\n'));
                out.append(location.path()).append(':').append(((Object)BoxesRunTime.boxToInteger((int)location.line())).toString());
                Object object2 = message.length() > 0 && !isMultilineMessage ? out.append(" ").append(message) : BoxedUnit.UNIT;
                out.append('\n').append(Lines.format$1(location.line() - 1, width)).append(slice[0]).append('\n').append(AnsiColors$.MODULE$.Reversed()).append(Lines.format$1(location.line(), width)).append(slice[1]).append(AnsiColors$.MODULE$.Reset()).append('\n').append(Lines.format$1(location.line() + 1, width)).append(slice[2]);
                Object object3 = isMultilineMessage ? out.append('\n').append(message) : BoxedUnit.UNIT;
                object = clues.values().nonEmpty() ? out.append('\n').append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())) : BoxedUnit.UNIT;
            } else {
                object = BoxedUnit.UNIT;
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (option.isEmpty()) {
                throw throwable;
            }
            String string2 = clues.values().isEmpty() ? message : new StringBuilder(1).append(message).append("\n").append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())).toString();
            string = string2;
        }
        return string;
    }

    private static final String format$1(int n, int width$1) {
        String number = new StringBuilder(1).append(((Object)BoxesRunTime.boxToInteger((int)n)).toString()).append(":").toString();
        String padding = new StringOps(Predef$.MODULE$.augmentString(" ")).$times(width$1 - number.length() + 1);
        return new StringBuilder(0).append(number).append(padding).toString();
    }
}

