/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.difflib;

import java.util.ArrayList;
import java.util.List;
import munit.internal.difflib.ChangeDelta;
import munit.internal.difflib.Chunk;
import munit.internal.difflib.DeleteDelta;
import munit.internal.difflib.Delta;
import munit.internal.difflib.DiffAlgorithm;
import munit.internal.difflib.DiffNode;
import munit.internal.difflib.DifferentiationFailedException;
import munit.internal.difflib.Equalizer;
import munit.internal.difflib.Equalizer$;
import munit.internal.difflib.InsertDelta;
import munit.internal.difflib.Patch;
import munit.internal.difflib.PathNode;
import munit.internal.difflib.Snake;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001u3A\u0001C\u0005\u0001!!Aq\u0005\u0001B\u0001B\u0003%\u0001\u0006C\u0003,\u0001\u0011\u0005A\u0006C\u0003,\u0001\u0011\u0005q\u0006C\u00031\u0001\u0011\u0005\u0013\u0007C\u0003B\u0001\u0011%!\tC\u0003M\u0001\u0011%Q\nC\u0003Z\u0001\u0011\u0005!LA\u0005Ns\u0016\u00148\u000fR5gM*\u0011!bC\u0001\bI&4g\r\\5c\u0015\taQ\"\u0001\u0005j]R,'O\\1m\u0015\u0005q\u0011!B7v]&$8\u0001A\u000b\u0003#y\u00192\u0001\u0001\n\u0019!\t\u0019b#D\u0001\u0015\u0015\u0005)\u0012!B:dC2\f\u0017BA\f\u0015\u0005\u0019\te.\u001f*fMB\u0019\u0011D\u0007\u000f\u000e\u0003%I!aG\u0005\u0003\u001b\u0011KgMZ!mO>\u0014\u0018\u000e\u001e5n!\tib\u0004\u0004\u0001\u0005\u000b}\u0001!\u0019\u0001\u0011\u0003\u0003Q\u000b\"!\t\u0013\u0011\u0005M\u0011\u0013BA\u0012\u0015\u0005\u001dqu\u000e\u001e5j]\u001e\u0004\"aE\u0013\n\u0005\u0019\"\"aA!os\u0006IQ-];bY&TXM\u001d\t\u00043%b\u0012B\u0001\u0016\n\u0005%)\u0015/^1mSj,'/\u0001\u0004=S:LGO\u0010\u000b\u0003[9\u00022!\u0007\u0001\u001d\u0011\u00159#\u00011\u0001))\u0005i\u0013\u0001\u00023jM\u001a$2AM\u001b@!\rI2\u0007H\u0005\u0003i%\u0011Q\u0001U1uG\"DQA\u000e\u0003A\u0002]\n\u0001b\u001c:jO&t\u0017\r\u001c\t\u0004qubR\"A\u001d\u000b\u0005iZ\u0014\u0001B;uS2T\u0011\u0001P\u0001\u0005U\u00064\u0018-\u0003\u0002?s\t!A*[:u\u0011\u0015\u0001E\u00011\u00018\u0003\u001d\u0011XM^5tK\u0012\fQBY;jY\u0012\u0014VM^5tS>tG\u0003\u0002\u001aD\u0011*CQ\u0001R\u0003A\u0002\u0015\u000bQa\u00189bi\"\u0004\"!\u0007$\n\u0005\u001dK!\u0001\u0003)bi\"tu\u000eZ3\t\u000b%+\u0001\u0019A\u001c\u0002\t=\u0014\u0018n\u001a\u0005\u0006\u0017\u0016\u0001\raN\u0001\u0004e\u00164\u0018aC2paf|eMU1oO\u0016$BAT)S/B\u0019\u0001h\u0014\u000f\n\u0005AK$!C!se\u0006LH*[:u\u0011\u00151d\u00011\u00018\u0011\u0015\u0019f\u00011\u0001U\u0003%1'o\\7J]\u0012,\u0007\u0010\u0005\u0002\u0014+&\u0011a\u000b\u0006\u0002\u0004\u0013:$\b\"\u0002-\u0007\u0001\u0004!\u0016A\u0001;p\u0003%\u0011W/\u001b7e!\u0006$\b\u000eF\u0002F7rCQ!S\u0004A\u0002]BQaS\u0004A\u0002]\u0002")
public class MyersDiff<T>
implements DiffAlgorithm<T> {
    private final Equalizer<T> equalizer;

    @Override
    public Patch<T> diff(List<T> original, List<T> revised) {
        Patch patch;
        try {
            patch = this.buildRevision(this.buildPath(original, revised), original, revised);
        }
        catch (DifferentiationFailedException e) {
            e.printStackTrace();
            patch = new Patch();
        }
        return patch;
    }

    private Patch<T> buildRevision(PathNode _path, List<T> orig, List<T> rev) {
        PathNode path = _path;
        Patch<T> patch = new Patch<T>();
        if (path.isSnake()) {
            path = path.prev();
        }
        while (path != null && path.prev() != null && path.prev().j() >= 0) {
            if (path.isSnake()) {
                throw new IllegalStateException("bad diffpath: found snake when looking for diff");
            }
            int i = path.i();
            int j = path.j();
            path = path.prev();
            int ianchor = path.i();
            int janchor = path.j();
            Chunk<T> original = new Chunk<T>(ianchor, this.copyOfRange(orig, ianchor, i));
            Chunk<T> revised = new Chunk<T>(janchor, this.copyOfRange(rev, janchor, j));
            Delta delta = original.size() == 0 && revised.size() != 0 ? new InsertDelta<T>(original, revised) : (original.size() > 0 && revised.size() == 0 ? new DeleteDelta<T>(original, revised) : new ChangeDelta<T>(original, revised));
            patch.addDelta(delta);
            if (!path.isSnake()) continue;
            path = path.prev();
        }
        return patch;
    }

    private ArrayList<T> copyOfRange(List<T> original, int fromIndex, int to) {
        return new ArrayList<T>(original.subList(fromIndex, to));
    }

    public PathNode buildPath(List<T> orig, List<T> rev) {
        int N = orig.size();
        int M = rev.size();
        int MAX = N + M + 1;
        int size = 1 + 2 * MAX;
        int middle = size / 2;
        PathNode[] diagonal = new PathNode[size];
        diagonal[middle + 1] = new Snake(0, -1, null);
        for (int d = 0; d < MAX; ++d) {
            for (int k = -d; k <= d; k += 2) {
                int j;
                int kmiddle = middle + k;
                int kplus = kmiddle + 1;
                int kminus = kmiddle - 1;
                PathNode prev = null;
                int i = 0;
                if (k == -d || k != d && diagonal[kminus].i() < diagonal[kplus].i()) {
                    i = diagonal[kplus].i();
                    prev = diagonal[kplus];
                } else {
                    i = diagonal[kminus].i() + 1;
                    prev = diagonal[kminus];
                }
                diagonal[kminus] = null;
                PathNode node = new DiffNode(i, j, prev);
                for (j = i - k; i < N && j < M && this.equalizer.equals(orig.get(i), rev.get(j)); ++i, ++j) {
                }
                if (i > node.i()) {
                    node = new Snake(i, j, node);
                }
                diagonal[kmiddle] = node;
                if (i < N || j < M) continue;
                return diagonal[kmiddle];
            }
            diagonal[middle + d - 1] = null;
        }
        throw new DifferentiationFailedException("could not find a diff path");
    }

    public MyersDiff(Equalizer<T> equalizer) {
        this.equalizer = equalizer;
    }

    public MyersDiff() {
        this(Equalizer$.MODULE$.default());
    }
}

