/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.difflib;

import java.util.List;
import munit.internal.console.AnsiColors$;
import munit.internal.console.Printers$;
import munit.internal.difflib.DiffUtils$;
import munit.internal.difflib.Patch;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u0001\u0003\u0001%\u0011A\u0001R5gM*\u00111\u0001B\u0001\bI&4g\r\\5c\u0015\t)a!\u0001\u0005j]R,'O\\1m\u0015\u00059\u0011!B7v]&$8\u0001A\n\u0004\u0001)\u0001\u0002CA\u0006\u000f\u001b\u0005a!\"A\u0007\u0002\u000bM\u001c\u0017\r\\1\n\u0005=a!AB!osJ+g\r\u0005\u0002\f#%\u0011!\u0003\u0004\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.\u001a\u0005\t)\u0001\u0011)\u0019!C\u0001+\u0005AqN\u0019;bS:,G-F\u0001\u0017!\t9\"D\u0004\u0002\f1%\u0011\u0011\u0004D\u0001\u0007!J,G-\u001a4\n\u0005ma\"AB*ue&twM\u0003\u0002\u001a\u0019!Aa\u0004\u0001B\u0001B\u0003%a#A\u0005pER\f\u0017N\\3eA!A\u0001\u0005\u0001BC\u0002\u0013\u0005Q#\u0001\u0005fqB,7\r^3e\u0011!\u0011\u0003A!A!\u0002\u00131\u0012!C3ya\u0016\u001cG/\u001a3!\u0011\u0015!\u0003\u0001\"\u0001&\u0003\u0019a\u0014N\\5u}Q\u0019a\u0005K\u0015\u0011\u0005\u001d\u0002Q\"\u0001\u0002\t\u000bQ\u0019\u0003\u0019\u0001\f\t\u000b\u0001\u001a\u0003\u0019\u0001\f\t\u000f-\u0002!\u0019!C\u0001+\u0005iqN\u0019;bS:,Gm\u00117fC:Da!\f\u0001!\u0002\u00131\u0012AD8ci\u0006Lg.\u001a3DY\u0016\fg\u000e\t\u0005\b_\u0001\u0011\r\u0011\"\u0001\u0016\u00035)\u0007\u0010]3di\u0016$7\t\\3b]\"1\u0011\u0007\u0001Q\u0001\nY\ta\"\u001a=qK\u000e$X\rZ\"mK\u0006t\u0007\u0005C\u00044\u0001\t\u0007I\u0011\u0001\u001b\u0002\u001b=\u0014G/Y5oK\u0012d\u0015N\\3t+\u0005)\u0004c\u0001\u001c?-9\u0011q\u0007\u0010\b\u0003qmj\u0011!\u000f\u0006\u0003u!\ta\u0001\u0010:p_Rt\u0014\"A\u0007\n\u0005ub\u0011a\u00029bG.\fw-Z\u0005\u0003\u007f\u0001\u00131aU3r\u0015\tiD\u0002\u0003\u0004C\u0001\u0001\u0006I!N\u0001\u000f_\n$\u0018-\u001b8fI2Kg.Z:!\u0011\u001d!\u0005A1A\u0005\u0002Q\nQ\"\u001a=qK\u000e$X\r\u001a'j]\u0016\u001c\bB\u0002$\u0001A\u0003%Q'\u0001\bfqB,7\r^3e\u0019&tWm\u001d\u0011\t\u000f!\u0003!\u0019!C\u0001+\u0005YQO\\5gS\u0016$G)\u001b4g\u0011\u0019Q\u0005\u0001)A\u0005-\u0005aQO\\5gS\u0016$G)\u001b4gA!)A\n\u0001C\u0001\u001b\u00069\u0011n]#naRLX#\u0001(\u0011\u0005-y\u0015B\u0001)\r\u0005\u001d\u0011un\u001c7fC:DQA\u0015\u0001\u0005\u0002M\u000bAb\u0019:fCR,'+\u001a9peR$2A\u0006+W\u0011\u0015)\u0016\u000b1\u0001\u0017\u0003\u0015!\u0018\u000e\u001e7f\u0011\u001d9\u0016\u000b%AA\u00029\u000b!\u0004\u001d:j]R|%\r^1j]\u0016$\u0017i]*ue&\u0004X*\u0019:hS:DQ!\u0017\u0001\u0005\u0002i\u000bAc\u0019:fCR,G)\u001b4g\u001f:d\u0017PU3q_J$H#\u0001\f\t\u000bq\u0003A\u0011B/\u0002)\u0005\u0004\b/\u001a8e\t&4gm\u00148msJ+\u0007o\u001c:u)\tq\u0016\r\u0005\u0002\f?&\u0011\u0001\r\u0004\u0002\u0005+:LG\u000fC\u0003c7\u0002\u00071-\u0001\u0002tEB\u0011a\u0007Z\u0005\u0003K\u0002\u0013Qb\u0015;sS:<')^5mI\u0016\u0014\b\"B4\u0001\t\u0013A\u0017!D1t'R\u0014\u0018\u000e]'be\u001eLg\u000e\u0006\u0002\u0017S\")AC\u001aa\u0001-!)1\u000e\u0001C\u0005Y\u00061\u0001.Z1eKJ$2aY7p\u0011\u0015q'\u000e1\u0001\u0017\u0003\u0005!\b\"\u00022k\u0001\u0004\u0019\u0007\"B9\u0001\t\u0013\u0011\u0018!E2sK\u0006$X-\u00168jM&,G\rR5gMR\u0019ac];\t\u000bQ\u0004\b\u0019A\u001b\u0002\u0011=\u0014\u0018nZ5oC2DQA\u001e9A\u0002U\nqA]3wSN,G\rC\u0003y\u0001\u0011%\u00110\u0001\bta2LG/\u00138u_2Kg.Z:\u0015\u0005UR\b\"B>x\u0001\u00041\u0012AB:ue&tw\rC\u0004~\u0001E\u0005I\u0011\u0001@\u0002-\r\u0014X-\u0019;f%\u0016\u0004xN\u001d;%I\u00164\u0017-\u001e7uII*\u0012a \u0016\u0004\u001d\u0006\u00051FAA\u0002!\u0011\t)!a\u0004\u000e\u0005\u0005\u001d!\u0002BA\u0005\u0003\u0017\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u00055A\"\u0001\u0006b]:|G/\u0019;j_:LA!!\u0005\u0002\b\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public class Diff
implements Serializable {
    private final String obtained;
    private final String expected;
    private final String obtainedClean;
    private final String expectedClean;
    private final Seq<String> obtainedLines;
    private final Seq<String> expectedLines;
    private final String unifiedDiff;

    public String obtained() {
        return this.obtained;
    }

    public String expected() {
        return this.expected;
    }

    public String obtainedClean() {
        return this.obtainedClean;
    }

    public String expectedClean() {
        return this.expectedClean;
    }

    public Seq<String> obtainedLines() {
        return this.obtainedLines;
    }

    public Seq<String> expectedLines() {
        return this.expectedLines;
    }

    public String unifiedDiff() {
        return this.unifiedDiff;
    }

    public boolean isEmpty() {
        return this.unifiedDiff().isEmpty();
    }

    public String createReport(String title, boolean printObtainedAsStripMargin) {
        BoxedUnit boxedUnit;
        StringBuilder sb = new StringBuilder();
        Object object = new StringOps(Predef$.MODULE$.augmentString(title)).nonEmpty() ? sb.append(title).append("\n") : BoxedUnit.UNIT;
        if (this.obtainedClean().length() < 1000) {
            this.header("Obtained", sb).append("\n");
            StringBuilder stringBuilder = printObtainedAsStripMargin ? sb.append(this.asStripMargin(this.obtainedClean())) : sb.append(this.obtainedClean());
            boxedUnit = sb.append("\n");
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.appendDiffOnlyReport(sb);
        return sb.toString();
    }

    public boolean createReport$default$2() {
        return true;
    }

    public String createDiffOnlyReport() {
        StringBuilder out = new StringBuilder();
        this.appendDiffOnlyReport(out);
        return out.toString();
    }

    private void appendDiffOnlyReport(StringBuilder sb) {
        this.header("Diff", sb);
        sb.append(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{" (", "- obtained", ", ", "+ expected", ")"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{AnsiColors$.MODULE$.LightRed(), AnsiColors$.MODULE$.Reset(), AnsiColors$.MODULE$.LightGreen(), AnsiColors$.MODULE$.Reset()}))).append("\n");
        sb.append(this.unifiedDiff());
    }

    private String asStripMargin(String obtained) {
        String string;
        if (obtained.contains("\n")) {
            StringBuilder out = new StringBuilder();
            Iterator lines = new StringOps(Predef$.MODULE$.augmentString(obtained.trim())).linesIterator();
            String head = lines.hasNext() ? (String)lines.next() : "";
            out.append(new StringBuilder().append((Object)"    \"\"\"|").append((Object)head).append((Object)"\n").toString());
            lines.foreach((Function1)new Serializable(this, out){
                public static final long serialVersionUID = 0L;
                private final StringBuilder out$1;

                public final StringBuilder apply(String line) {
                    return this.out$1.append("       |").append(line).append("\n");
                }
                {
                    this.out$1 = out$1;
                }
            });
            out.append("       |\"\"\".stripMargin");
            string = out.toString();
        } else {
            string = Printers$.MODULE$.print(obtained, Printers$.MODULE$.print$default$2());
        }
        return string;
    }

    private StringBuilder header(String t, StringBuilder sb) {
        return sb.append(AnsiColors$.MODULE$.c(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"=> ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{t})), AnsiColors$.MODULE$.Bold()));
    }

    private String createUnifiedDiff(Seq<String> original, Seq<String> revised) {
        Patch<String> diff = DiffUtils$.MODULE$.diff((List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava(), (List)JavaConverters$.MODULE$.seqAsJavaListConverter(revised).asJava());
        String result = diff.getDeltas().isEmpty() ? "" : ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(DiffUtils$.MODULE$.generateUnifiedDiff("obtained", "expected", (List)JavaConverters$.MODULE$.seqAsJavaListConverter(original).asJava(), diff, 1)).asScala()).iterator().drop(2).filterNot((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x$1) {
                return x$1.startsWith("@@");
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String line) {
                return line.isEmpty() ? line : (BoxesRunTime.unboxToChar((Object)new StringOps(Predef$.MODULE$.augmentString(line)).last()) == ' ' ? new StringBuilder().append((Object)line).append((Object)"\u2219").toString() : line);
            }
        }).map((Function1)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(String line) {
                return line.startsWith("-") ? AnsiColors$.MODULE$.c(line, AnsiColors$.MODULE$.LightRed()) : (line.startsWith("+") ? AnsiColors$.MODULE$.c(line, AnsiColors$.MODULE$.LightGreen()) : line);
            }
        }).mkString("\n");
        return result;
    }

    private Seq<String> splitIntoLines(String string) {
        return Predef$.MODULE$.refArrayOps((Object[])string.trim().replace("\r\n", "\n").split("\n")).toIndexedSeq();
    }

    public Diff(String obtained, String expected) {
        this.obtained = obtained;
        this.expected = expected;
        this.obtainedClean = AnsiColors$.MODULE$.filterAnsi(obtained);
        this.expectedClean = AnsiColors$.MODULE$.filterAnsi(expected);
        this.obtainedLines = this.splitIntoLines(this.obtainedClean());
        this.expectedLines = this.splitIntoLines(this.expectedClean());
        this.unifiedDiff = this.createUnifiedDiff(this.obtainedLines(), this.expectedLines());
    }
}

