/*
 * Decompiled with CFR 0.152.
 */
package munit.internal;

import java.io.File;
import java.io.File$;
import java.io.Serializable;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.WatchEvent;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.util.Iterator;
import java.util.regex.Pattern;
import munit.internal.JSIO$;
import munit.internal.JSPath$;
import munit.internal.NodeNIOPath$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

public class NodeNIOPath
implements Iterable,
Path,
Product,
Serializable {
    private final String filename;
    private final String escapedSeparator;

    public static NodeNIOPath apply(String string) {
        return NodeNIOPath$.MODULE$.apply(string);
    }

    public static NodeNIOPath fromProduct(Product product) {
        return NodeNIOPath$.MODULE$.fromProduct(product);
    }

    public static NodeNIOPath unapply(NodeNIOPath nodeNIOPath) {
        return NodeNIOPath$.MODULE$.unapply(nodeNIOPath);
    }

    public static NodeNIOPath workingDirectory() {
        return NodeNIOPath$.MODULE$.workingDirectory();
    }

    public NodeNIOPath(String filename) {
        this.filename = filename;
        this.escapedSeparator = Pattern.quote(File$.MODULE$.separator());
    }

    public int hashCode() {
        return ScalaRunTime$.MODULE$._hashCode((Product)this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof NodeNIOPath)) return false;
        NodeNIOPath nodeNIOPath = (NodeNIOPath)object;
        String string = this.filename();
        String string2 = nodeNIOPath.filename();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!nodeNIOPath.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof NodeNIOPath;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "NodeNIOPath";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return this._1();
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 != n2) {
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }
        return "filename";
    }

    public String filename() {
        return this.filename;
    }

    public FileSystem getFileSystem() {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public Path toRealPath(Seq<LinkOption> x) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public WatchKey register(WatchService x, WatchEvent.Kind<?>[] y, Seq<WatchEvent.Modifier> z) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public WatchKey register(WatchService x, Seq<WatchEvent.Kind<?>> y) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    public int compareTo(Path x) {
        throw Predef$.MODULE$.$qmark$qmark$qmark();
    }

    private int adjustIndex(int idx) {
        return this.isAbsolute() ? idx + 1 : idx;
    }

    @Override
    public Path subpath(int beginIndex, int endIndex) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.filename().split(this.escapedSeparator));
        return NodeNIOPath$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.slice$extension(object, this.adjustIndex(beginIndex), this.adjustIndex(endIndex))).mkString());
    }

    @Override
    public File toFile() {
        return new File(this.filename());
    }

    @Override
    public boolean isAbsolute() {
        return JSIO$.MODULE$.isNode() ? JSPath$.MODULE$.isAbsolute(this.filename()) : this.filename().startsWith(File$.MODULE$.separator());
    }

    @Override
    public Path getName(int index) {
        return NodeNIOPath$.MODULE$.apply((String)((Option)Predef$.MODULE$.wrapRefArray((Object[])this.filename().split(this.escapedSeparator)).lift().apply((Object)BoxesRunTime.boxToInteger((int)this.adjustIndex(index)))).getOrElse(NodeNIOPath::getName$$anonfun$1));
    }

    @Override
    public Path getParent() {
        return NodeNIOPath$.MODULE$.apply(JSPath$.MODULE$.dirname(this.filename()));
    }

    @Override
    public Path toAbsolutePath() {
        return this.isAbsolute() ? this : NodeNIOPath$.MODULE$.workingDirectory().resolve(this);
    }

    @Override
    public Path relativize(Path other) {
        return NodeNIOPath$.MODULE$.apply(JSPath$.MODULE$.relative(this.filename(), other.toString()));
    }

    @Override
    public int getNameCount() {
        String strippeddrive = this.filename().length() > 1 && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.filename()), 1) == ':' ? this.filename().substring(2) : this.filename();
        Object object = Predef$.MODULE$.refArrayOps((Object[])strippeddrive.split(this.escapedSeparator + "+"));
        Tuple2 tuple2 = ArrayOps$.MODULE$.span$extension(object, (Function1 & Serializable)_$1 -> _$1.isEmpty());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] first = (String[])tuple2._1();
        String[] remaining = (String[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)first, (Object)remaining);
        String[] first2 = (String[])tuple22._1();
        Object[] remaining2 = (String[])tuple22._2();
        Object object2 = Predef$.MODULE$.refArrayOps(remaining2);
        return ArrayOps$.MODULE$.isEmpty$extension(object2) ? first2.length : remaining2.length;
    }

    @Override
    public URI toUri() {
        return this.toFile().toURI();
    }

    @Override
    public Path getFileName() {
        return NodeNIOPath$.MODULE$.apply(JSPath$.MODULE$.basename(this.filename()));
    }

    @Override
    public Path getRoot() {
        return !this.isAbsolute() ? null : NodeNIOPath$.MODULE$.apply(File$.MODULE$.separator());
    }

    @Override
    public Path normalize() {
        return JSIO$.MODULE$.isNode() ? NodeNIOPath$.MODULE$.apply(JSPath$.MODULE$.normalize(this.filename())) : this;
    }

    @Override
    public boolean endsWith(Path other) {
        return this.endsWith(other.toString());
    }

    @Override
    public boolean endsWith(String other) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.paths(this.filename()));
        return ArrayOps$.MODULE$.endsWith$extension(object, (Object)this.paths(other));
    }

    private Path adjustResolvedPath(Path resolved) {
        return this.isAbsolute() ? resolved : NodeNIOPath$.MODULE$.workingDirectory().relativize(resolved);
    }

    @Override
    public Path resolveSibling(Path other) {
        return this.resolveSibling(other.toString());
    }

    @Override
    public Path resolveSibling(String other) {
        return this.adjustResolvedPath(NodeNIOPath$.MODULE$.apply(JSPath$.MODULE$.resolve((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{JSPath$.MODULE$.dirname(this.filename()), other}))));
    }

    @Override
    public Path resolve(Path other) {
        return this.resolve(other.toString());
    }

    @Override
    public Path resolve(String other) {
        return this.adjustResolvedPath(NodeNIOPath$.MODULE$.apply(JSPath$.MODULE$.resolve((Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.filename(), other}))));
    }

    @Override
    public boolean startsWith(Path other) {
        return this.startsWith(other.toString());
    }

    @Override
    public boolean startsWith(String other) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.paths(this.filename()));
        return ArrayOps$.MODULE$.startsWith$extension(object, (Object)this.paths(other));
    }

    private String[] paths(String name) {
        return name.split(this.escapedSeparator);
    }

    public String toString() {
        return this.filename();
    }

    @Override
    public Iterator<Path> iterator() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.filename().split(File$.MODULE$.separator()));
        return (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(ArrayOps$.MODULE$.iterator$extension(object).map((Function1 & Serializable)name -> NodeNIOPath$.MODULE$.apply((String)name))).asJava();
    }

    public NodeNIOPath copy(String filename) {
        return new NodeNIOPath(filename);
    }

    public String copy$default$1() {
        return this.filename();
    }

    public String _1() {
        return this.filename();
    }

    private static final String getName$$anonfun$1() {
        throw new IllegalArgumentException();
    }
}

