/*
 * Decompiled with CFR 0.152.
 */
package munit;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import munit.FailSuiteException;
import munit.GenericAfterEach;
import munit.GenericBeforeEach;
import munit.GenericTest;
import munit.Location$;
import munit.MUnitRunner$;
import munit.Suite;
import munit.Tag;
import munit.TestValues;
import munit.TestValues$;
import munit.internal.Compat$;
import munit.internal.FutureCompat$;
import munit.internal.PlatformCompat$;
import munit.internal.console.Printers$;
import munit.internal.console.StackTraces$;
import munit.internal.junitinterface.Configurable;
import munit.internal.junitinterface.Settings;
import munit.internal.junitinterface.Settings$;
import munit.package$;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Description$;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.Duration$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.util.Failure$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class MUnitRunner
extends Runner
implements Filterable,
Configurable {
    private final Class cls;
    private final Suite suite;
    private final ExecutionContext ec;
    private volatile Settings settings;
    public volatile boolean munit$MUnitRunner$$suiteAborted;
    private final Map<GenericTest<Object>, Description> descriptions;
    private final Set<String> testNames;
    private ArrayBuffer munitTests$lzy1;
    private boolean munitTestsbitmap$1;

    public MUnitRunner(Class<? extends Suite> cls, Function0<Suite> newInstance) {
        this.cls = cls;
        this.suite = (Suite)newInstance.apply();
        this.ec = this.suite().munitExecutionContext();
        this.settings = Settings$.MODULE$.defaults();
        this.munit$MUnitRunner$$suiteAborted = false;
        this.descriptions = (Map)Map$.MODULE$.empty();
        this.testNames = (Set)Set$.MODULE$.empty();
    }

    public Class<? extends Suite> cls() {
        return this.cls;
    }

    public MUnitRunner(Class<? extends Suite> cls) {
        this(MUnitRunner$.MODULE$.munit$MUnitRunner$$$ensureEligibleConstructor(cls), MUnitRunner.MUnitRunner$superArg$1(cls));
    }

    public Suite suite() {
        return this.suite;
    }

    private ArrayBuffer<GenericTest<Object>> munitTests() {
        if (!this.munitTestsbitmap$1) {
            this.munitTests$lzy1 = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(this.suite().munitTests());
            this.munitTestsbitmap$1 = true;
        }
        return this.munitTests$lzy1;
    }

    @Override
    public void filter(Filter filter) {
        ArrayBuffer newTests = (ArrayBuffer)this.munitTests().filter((Function1 & Serializable)t -> filter.shouldRun(this.createTestDescription((GenericTest)t)));
        this.munitTests().clear();
        this.munitTests().$plus$plus$eq((IterableOnce)newTests);
    }

    @Override
    public void configure(Settings settings) {
        this.settings = settings;
    }

    public Description createTestDescription(GenericTest test) {
        return (Description)this.descriptions.getOrElseUpdate((Object)test, () -> this.createTestDescription$$anonfun$1(test));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Description getDescription() {
        void var1_1;
        Description description2 = Description$.MODULE$.createSuiteDescription(this.cls());
        try {
            ArrayBuffer suiteTests = (ArrayBuffer)StackTraces$.MODULE$.dropOutside(this::$anonfun$2);
            suiteTests.iterator().map((Function1 & Serializable)test -> this.createTestDescription((GenericTest)test)).foreach((Function1 & Serializable)description -> description2.addChild((Description)description));
        }
        catch (Throwable ex) {
            this.munit$MUnitRunner$$trimStackTrace(ex);
            ex.printStackTrace();
        }
        return var1_1;
    }

    @Override
    public void run(RunNotifier notifier) {
        Await$.MODULE$.result(this.runAsync(notifier), (Duration)Duration$.MODULE$.Inf());
    }

    public Future<BoxedUnit> runAsync(RunNotifier notifier) {
        Future future;
        Description description = this.getDescription();
        notifier.fireTestSuiteStarted(description);
        try {
            try {
                future = this.runAll(notifier);
            }
            catch (Throwable ex) {
                this.fireHiddenTest(notifier, "expected error running tests", ex);
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
            }
        }
        finally {
            notifier.fireTestSuiteFinished(description);
        }
        return future;
    }

    private Future<BoxedUnit> runAsyncTestsSynchronously(RunNotifier notifier) {
        return this.loop$1(notifier, this.munitTests().iterator());
    }

    private Future<BoxedUnit> runAll(RunNotifier notifier) {
        boolean isContinue;
        boolean bl;
        if (PlatformCompat$.MODULE$.isIgnoreSuite(this.cls())) {
            Description description = this.getDescription();
            notifier.fireTestIgnored(description);
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        BooleanRef isBeforeAllRun = BooleanRef.create((boolean)false);
        isBeforeAllRun.elem = bl = (isContinue = this.runBeforeAll(notifier));
        Future result = isContinue ? this.runAsyncTestsSynchronously(notifier) : Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        return FutureCompat$.MODULE$.ExtensionFuture(result).transformCompat((Function1 & Serializable)s -> {
            if (isBeforeAllRun$1.elem) {
                this.runAfterAll(notifier);
            }
            return s;
        }, this.ec);
    }

    private boolean runBeforeAll(RunNotifier notifier) {
        BooleanRef isContinue = BooleanRef.create((boolean)this.runHiddenTest(notifier, "beforeAll", (Function0 & Serializable)() -> {
            this.$anonfun$9();
            return BoxedUnit.UNIT;
        }));
        this.suite().munitFixtures().foreach((Function1 & Serializable)fixture -> {
            this.runBeforeAll$$anonfun$3(notifier, isContinue, (Suite.Fixture)fixture);
            return BoxedUnit.UNIT;
        });
        return isContinue.elem;
    }

    private void runAfterAll(RunNotifier notifier) {
        this.suite().munitFixtures().foreach((Function1 & Serializable)fixture -> this.runHiddenTest(notifier, "afterAllFixture(" + fixture.fixtureName() + ")", (Function0 & Serializable)() -> {
            MUnitRunner.runAfterAll$$anonfun$2$$anonfun$1(fixture);
            return BoxedUnit.UNIT;
        }));
        this.runHiddenTest(notifier, "afterAll", (Function0 & Serializable)() -> {
            this.runAfterAll$$anonfun$4();
            return BoxedUnit.UNIT;
        });
    }

    private BeforeEachResult runBeforeEach(GenericTest test) {
        GenericBeforeEach beforeEach = new GenericBeforeEach(test);
        ListBuffer fixtures = ListBuffer$.MODULE$.empty();
        Try<BoxedUnit> error = this.foreachUnsafe((Iterable<Function0<BoxedUnit>>)((Iterable)((IterableOps)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(Function0 & Serializable)() -> {
            this.$anonfun$10(beforeEach);
            return BoxedUnit.UNIT;
        }}))).$plus$plus((IterableOnce)this.suite().munitFixtures().map((Function1 & Serializable)fixture -> (Function0 & Serializable)() -> {
            MUnitRunner.$anonfun$11$$anonfun$1(beforeEach, fixtures, fixture);
            return BoxedUnit.UNIT;
        }))));
        return new BeforeEachResult(this, (Option<Throwable>)error.failed().toOption(), fixtures.toList());
    }

    private void runAfterEach(GenericTest<Object> test, List<Suite.Fixture<?>> fixtures) {
        GenericAfterEach<Object> afterEach = new GenericAfterEach<Object>(test);
        Try<BoxedUnit> error = this.foreachUnsafe((Iterable<Function0<BoxedUnit>>)((Iterable)fixtures.map((Function1 & Serializable)fixture -> (Function0 & Serializable)() -> {
            fixture.afterEach(afterEach);
            return BoxedUnit.UNIT;
        }).$plus$plus((IterableOnce)scala.package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Function0[]{(Function0 & Serializable)() -> {
            this.$anonfun$15(afterEach);
            return BoxedUnit.UNIT;
        }})))));
        error.get();
    }

    private Future<Object> runTest(RunNotifier notifier, GenericTest<Object> test) {
        Future future;
        Description description = this.createTestDescription(test);
        if (this.munit$MUnitRunner$$suiteAborted) {
            notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)((Object)new FailSuiteException("Suite has been aborted", test.location()))));
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        notifier.fireTestStarted(description);
        if (test.tags().apply((Object)package$.MODULE$.Ignore())) {
            notifier.fireTestIgnored(description);
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        Serializable onError = new Serializable(notifier, description, this){
            private final RunNotifier notifier$1;
            private final Description description$1;
            private final MUnitRunner $outer;
            {
                this.notifier$1 = notifier$11;
                this.description$1 = description$5;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                boolean bl;
                Throwable throwable = x;
                if (throwable instanceof AssumptionViolatedException) {
                    AssumptionViolatedException ex = (AssumptionViolatedException)throwable;
                    bl = true;
                } else if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = (Throwable)option.get();
                    bl = true;
                } else {
                    bl = false;
                }
                return bl;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Object object;
                Throwable throwable = x;
                if (throwable instanceof AssumptionViolatedException) {
                    AssumptionViolatedException ex = (AssumptionViolatedException)throwable;
                    this.$outer.munit$MUnitRunner$$trimStackTrace((Throwable)ex);
                    object = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                } else if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = (Throwable)option.get();
                    this.$outer.munit$MUnitRunner$$trimStackTrace(ex);
                    Throwable cause = this.$outer.munit$MUnitRunner$$rootCause(ex);
                    Failure failure = new Failure(this.description$1, cause);
                    Throwable throwable3 = cause;
                    if (throwable3 instanceof AssumptionViolatedException) {
                        this.notifier$1.fireTestAssumptionFailed(failure);
                    } else if (throwable3 instanceof FailSuiteException) {
                        this.$outer.munit$MUnitRunner$$suiteAborted = true;
                        this.notifier$1.fireTestFailure(failure);
                    } else {
                        this.notifier$1.fireTestFailure(failure);
                    }
                    object = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                } else {
                    object = function1.apply((Object)x);
                }
                return object;
            }
        };
        try {
            future = this.runTestBody(notifier, description, test).recoverWith((PartialFunction)onError, this.ec);
        }
        catch (Throwable ex$) {
            Serializable $1$ = onError;
            if ($1$.isDefinedAt(ex$)) {
                future = (Future)$1$.apply(ex$);
            }
            throw ex$;
        }
        Future result = future;
        return result.map((Function1 & Serializable)_$2 -> {
            notifier.fireTestFinished(description);
            return true;
        }, this.ec);
    }

    public Throwable munit$MUnitRunner$$rootCause(Throwable x) {
        Throwable throwable;
        MUnitRunner mUnitRunner = this;
        Throwable throwable2 = x;
        while ((throwable = throwable2) instanceof InvocationTargetException || throwable instanceof ExceptionInInitializerError || throwable instanceof UndeclaredThrowableException || throwable instanceof ExecutionException) {
            if (throwable2.getCause() == null) break;
            MUnitRunner mUnitRunner2 = mUnitRunner;
            Throwable throwable3 = throwable2.getCause();
            mUnitRunner = mUnitRunner2;
            throwable2 = throwable3;
        }
        return throwable2;
    }

    private Future<Object> futureFromAny(Object any) {
        Future f;
        Object object = any;
        return object instanceof Future ? (f = (Future)object) : Future$.MODULE$.successful(any);
    }

    private Future<BoxedUnit> runTestBody(RunNotifier notifier, Description description, GenericTest<Object> test) {
        Future result = (Future)StackTraces$.MODULE$.dropOutside(() -> this.$anonfun$5(test));
        return result.map((Function1 & Serializable)x$1 -> {
            this.runTestBody$$anonfun$1(notifier, description, x$1);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    private Try<BoxedUnit> foreachUnsafe(Iterable<Function0<BoxedUnit>> thunks) {
        Success success;
        ObjectRef errors = ObjectRef.create((Object)ListBuffer$.MODULE$.empty());
        thunks.foreach((Function1 & Serializable)thunk -> MUnitRunner.liftedTree1$1(errors, thunk));
        List list = ((ListBuffer)errors.elem).toList();
        if (list instanceof .colon.colon) {
            .colon.colon colon2 = (.colon.colon)list;
            List list2 = colon2.next$access$1();
            Throwable head = (Throwable)colon2.head();
            List tail = list2;
            tail.foreach((Function1 & Serializable)e -> {
                MUnitRunner.foreachUnsafe$$anonfun$2(head, e);
                return BoxedUnit.UNIT;
            });
            success = Failure$.MODULE$.apply(head);
        } else {
            success = Success$.MODULE$.apply((Object)BoxedUnit.UNIT);
        }
        return success;
    }

    private boolean runHiddenTest(RunNotifier notifier, String name, Function0 thunk) {
        boolean bl;
        try {
            StackTraces$.MODULE$.dropOutside(thunk);
            bl = true;
        }
        catch (Throwable ex) {
            this.fireHiddenTest(notifier, name, ex);
            bl = false;
        }
        return bl;
    }

    private void fireHiddenTest(RunNotifier notifier, String name, Throwable ex) {
        GenericTest test = new GenericTest(name, (Function0 & Serializable)() -> {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }, (scala.collection.immutable.Set<Tag>)Predef$.MODULE$.Set().empty(), Location$.MODULE$.empty());
        Description description = this.createTestDescription(test);
        notifier.fireTestStarted(description);
        this.munit$MUnitRunner$$trimStackTrace(ex);
        notifier.fireTestFailure(new Failure(description, ex));
        notifier.fireTestFinished(description);
    }

    public void munit$MUnitRunner$$trimStackTrace(Throwable ex) {
        if (this.settings.trimStackTraces()) {
            StackTraces$.MODULE$.trimStackTrace(ex);
        }
    }

    private static Function0<Suite> MUnitRunner$superArg$1(Class<? extends Suite> cls) {
        return (Function0 & Serializable)() -> (Suite)cls.newInstance();
    }

    private static final /* synthetic */ String $anonfun$7(String escapedName$1, int x$1) {
        String string;
        int n = x$1;
        if (0 == n) {
            string = escapedName$1;
        } else {
            int n2 = n;
            string = "" + escapedName$1 + "-" + n2;
        }
        return string;
    }

    private final Description createTestDescription$$anonfun$1(GenericTest test$1) {
        String escapedName = Printers$.MODULE$.escapeNonVisible(test$1.name());
        String testName = (String)Option$.MODULE$.option2Iterable(Compat$.MODULE$.LazyList().from(0).map((Function1 & Serializable)x$1 -> MUnitRunner.$anonfun$7(escapedName, BoxesRunTime.unboxToInt((Object)x$1))).find((Function1 & Serializable)candidate -> !this.testNames.contains(candidate))).head();
        this.testNames.$plus$eq((Object)testName);
        Description desc = Description$.MODULE$.createTestDescription(this.cls(), testName, (Seq<Annotation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])test$1.annotations()));
        return desc;
    }

    private final ArrayBuffer $anonfun$2() {
        return this.munitTests();
    }

    private final /* synthetic */ Future loop$2$$anonfun$1(RunNotifier notifier$2, Iterator it$1, boolean _$1) {
        return this.loop$1(notifier$2, it$1);
    }

    private final Future loop$1(RunNotifier notifier$1, Iterator it) {
        Future future;
        block3: {
            Future<Object> future2;
            Option option;
            do {
                if (it.hasNext()) continue;
                future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                break block3;
            } while ((option = (future2 = this.runTest(notifier$1, (GenericTest)it.next())).value()) instanceof Some);
            if (None$.MODULE$.equals(option)) {
                future = future2.flatMap((Function1 & Serializable)_$1 -> this.loop$2$$anonfun$1(notifier$1, it, BoxesRunTime.unboxToBoolean((Object)_$1)), this.ec);
            } else {
                throw new MatchError((Object)option);
            }
        }
        return future;
    }

    private final void $anonfun$9() {
        this.suite().beforeAll();
    }

    private static final void runBeforeAll$$anonfun$1$$anonfun$1(Suite.Fixture fixture$1) {
        fixture$1.beforeAll();
    }

    private final /* synthetic */ void runBeforeAll$$anonfun$3(RunNotifier notifier$4, BooleanRef isContinue$1, Suite.Fixture fixture) {
        boolean bl;
        isContinue$1.elem = bl = isContinue$1.elem & this.runHiddenTest(notifier$4, "beforeAllFixture(" + fixture.fixtureName() + ")", (Function0 & Serializable)() -> {
            MUnitRunner.runBeforeAll$$anonfun$1$$anonfun$1(fixture);
            return BoxedUnit.UNIT;
        });
    }

    private static final void runAfterAll$$anonfun$2$$anonfun$1(Suite.Fixture fixture$2) {
        fixture$2.afterAll();
    }

    private final void runAfterAll$$anonfun$4() {
        this.suite().afterAll();
    }

    private final /* synthetic */ void $anonfun$10(GenericBeforeEach beforeEach$1) {
        this.suite().beforeEach(beforeEach$1);
    }

    private static final /* synthetic */ void $anonfun$11$$anonfun$1(GenericBeforeEach beforeEach$2, ListBuffer fixtures$1, Suite.Fixture fixture$3) {
        fixture$3.beforeEach(beforeEach$2);
        fixtures$1.$plus$eq((Object)fixture$3);
    }

    private final /* synthetic */ void $anonfun$15(GenericAfterEach afterEach$3) {
        this.suite().afterEach(afterEach$3);
    }

    private final Future $anonfun$5(GenericTest test$2) {
        Object object;
        BeforeEachResult beforeEachResult = this.runBeforeEach(test$2);
        Option<Throwable> option = beforeEachResult.error();
        if (None$.MODULE$.equals(option)) {
            try {
                object = test$2.body().apply();
            }
            finally {
                this.runAfterEach(test$2, beforeEachResult.loadedFixtures());
            }
        } else {
            if (option instanceof Some) {
                Throwable error = (Throwable)((Some)option).value();
                try {
                    this.runAfterEach(test$2, beforeEachResult.loadedFixtures());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                finally {
                    throw error;
                }
            }
            throw new MatchError(option);
        }
        Object any = object;
        return this.futureFromAny(any);
    }

    private final /* synthetic */ void runTestBody$$anonfun$1(RunNotifier notifier$8, Description description$4, Object x$1) {
        block1: {
            Object object;
            block0: {
                object = x$1;
                if (!(object instanceof TestValues.FlakyFailure)) break block0;
                TestValues.FlakyFailure f = (TestValues.FlakyFailure)object;
                this.munit$MUnitRunner$$trimStackTrace((Throwable)((Object)f));
                notifier$8.fireTestAssumptionFailed(new Failure(description$4, (Throwable)((Object)f)));
                break block1;
            }
            Tag tag = TestValues$.MODULE$.Ignore();
            Object object2 = object;
            if (tag != null ? !((Object)tag).equals(object2) : object2 != null) break block1;
            notifier$8.fireTestIgnored(description$4);
        }
    }

    private static final Object liftedTree1$1(ObjectRef errors$1, Function0 thunk$1) {
        Object object;
        try {
            object = thunk$1.apply();
        }
        catch (Throwable throwable) {
            Throwable throwable2;
            Throwable ex = throwable2 = throwable;
            if (NonFatal$.MODULE$.apply(ex)) {
                object = (ListBuffer)((ListBuffer)errors$1.elem).$plus$eq((Object)ex);
            }
            throw throwable;
        }
        return object;
    }

    private static final /* synthetic */ void foreachUnsafe$$anonfun$2(Throwable head$1, Throwable e) {
        if (e != head$1) {
            head$1.addSuppressed(e);
        }
    }

    public class BeforeEachResult {
        private final Option error;
        private final List loadedFixtures;
        private final MUnitRunner $outer;

        public BeforeEachResult(MUnitRunner $outer, Option<Throwable> error, List<Suite.Fixture<?>> loadedFixtures) {
            this.error = error;
            this.loadedFixtures = loadedFixtures;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public Option<Throwable> error() {
            return this.error;
        }

        public List<Suite.Fixture<?>> loadedFixtures() {
            return this.loadedFixtures;
        }

        public final MUnitRunner munit$MUnitRunner$BeforeEachResult$$$outer() {
            return this.$outer;
        }
    }
}

