/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.io.Serializable;
import munit.internal.junitinterface.CustomRunners;
import munit.internal.junitinterface.JUnitRunner;
import munit.internal.junitinterface.RunSettings;
import munit.internal.junitinterface.Settings;
import munit.internal.junitinterface.Settings$;
import munit.internal.junitinterface.TagsFilter;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Runner;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public abstract class JUnitFramework
implements Framework {
    private final String name;

    public JUnitFramework() {
        this.name = "Scala.js JUnit test framework";
    }

    public String name() {
        return this.name;
    }

    public abstract CustomRunners customRunners();

    public Fingerprint[] fingerprints() {
        return (Fingerprint[])this.customRunners().runners().toArray(ClassTag$.MODULE$.apply(Fingerprint.class));
    }

    public Runner runner(String[] args, String[] remoteArgs, ClassLoader testClassLoader) {
        return new JUnitRunner(args, remoteArgs, this.parseRunSettings(args), testClassLoader, this.customRunners());
    }

    public Runner slaveRunner(String[] args, String[] remoteArgs, ClassLoader testClassLoader, Function1<String, BoxedUnit> send) {
        return new JUnitRunner(args, remoteArgs, this.parseRunSettings(args), testClassLoader, this.customRunners());
    }

    private RunSettings parseRunSettings(String[] args) {
        Settings defaults = Settings$.MODULE$.defaults();
        BooleanRef verbose = BooleanRef.create((boolean)false);
        BooleanRef noColor = BooleanRef.create((boolean)false);
        BooleanRef decodeScalaNames = BooleanRef.create((boolean)false);
        BooleanRef logAssert = BooleanRef.create((boolean)false);
        BooleanRef notLogExceptionClass = BooleanRef.create((boolean)false);
        BooleanRef useSbtLoggers = BooleanRef.create((boolean)false);
        BooleanRef trimStackTraces = BooleanRef.create((boolean)defaults.trimStackTraces());
        ObjectRef includeTags = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ObjectRef excludeTags = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)str -> {
            JUnitFramework.parseRunSettings$$anonfun$1(verbose, noColor, decodeScalaNames, logAssert, notLogExceptionClass, includeTags, excludeTags, str);
            return BoxedUnit.UNIT;
        });
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])args);
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)s -> {
            JUnitFramework.parseRunSettings$$anonfun$2(verbose, noColor, decodeScalaNames, logAssert, notLogExceptionClass, useSbtLoggers, trimStackTraces, s);
            return BoxedUnit.UNIT;
        });
        return new RunSettings(!noColor.elem, decodeScalaNames.elem, verbose.elem, logAssert.elem, notLogExceptionClass.elem, useSbtLoggers.elem, trimStackTraces.elem, new TagsFilter((Set<String>)((Set)includeTags.elem), (Set<String>)((Set)excludeTags.elem)));
    }

    private static final /* synthetic */ void parseRunSettings$$anonfun$1(BooleanRef verbose$1, BooleanRef noColor$1, BooleanRef decodeScalaNames$1, BooleanRef logAssert$1, BooleanRef notLogExceptionClass$1, ObjectRef includeTags$1, ObjectRef excludeTags$1, String str) {
        String string = str;
        if ("-v".equals(string)) {
            boolean bl;
            verbose$1.elem = bl = true;
        } else if ("-n".equals(string)) {
            boolean bl;
            noColor$1.elem = bl = true;
        } else if ("-s".equals(string)) {
            boolean bl;
            decodeScalaNames$1.elem = bl = true;
        } else if ("-a".equals(string)) {
            boolean bl;
            logAssert$1.elem = bl = true;
        } else if ("-c".equals(string)) {
            boolean bl;
            notLogExceptionClass$1.elem = bl = true;
        } else {
            String s = string;
            if (s.startsWith("-tests=")) {
                throw new UnsupportedOperationException("-tests");
            }
            String s2 = string;
            if (s2.startsWith("--tests=")) {
                throw new UnsupportedOperationException("--tests");
            }
            String s3 = string;
            if (s3.startsWith("--ignore-runners=")) {
                throw new UnsupportedOperationException("--ignore-runners");
            }
            String s4 = string;
            if (s4.startsWith("--run-listener=")) {
                throw new UnsupportedOperationException("--run-listener");
            }
            String s5 = string;
            if (s5.startsWith("--exclude-tags=")) {
                Set set = (Set)((Set)excludeTags$1.elem).$plus((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s5), "--exclude-tags="));
                excludeTags$1.elem = set;
            } else {
                String s6 = string;
                if (s6.startsWith("--include-tags=")) {
                    Set set = (Set)((Set)includeTags$1.elem).$plus((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s6), "--include-tags="));
                    includeTags$1.elem = set;
                } else {
                    String s7 = string;
                    if (s7.startsWith("--include-categories=")) {
                        throw new UnsupportedOperationException("--include-categories");
                    }
                    String s8 = string;
                    if (s8.startsWith("--exclude-categories=")) {
                        throw new UnsupportedOperationException("--exclude-categories");
                    }
                    String s9 = string;
                    if (s9.startsWith("-D") && s9.contains("=")) {
                        throw new UnsupportedOperationException("-Dkey=value");
                    }
                    String s10 = string;
                    if (!s10.startsWith("-") && !s10.startsWith("+")) {
                        throw new UnsupportedOperationException(s10);
                    }
                }
            }
        }
    }

    private static final /* synthetic */ void parseRunSettings$$anonfun$2(BooleanRef verbose$2, BooleanRef noColor$2, BooleanRef decodeScalaNames$2, BooleanRef logAssert$2, BooleanRef notLogExceptionClass$2, BooleanRef useSbtLoggers$1, BooleanRef trimStackTraces$1, String s) {
        block1: {
            boolean bl;
            String string;
            block8: {
                boolean bl2;
                block7: {
                    boolean bl3;
                    block6: {
                        boolean bl4;
                        block5: {
                            boolean bl5;
                            block4: {
                                boolean bl6;
                                block3: {
                                    boolean bl7;
                                    block2: {
                                        boolean bl8;
                                        block0: {
                                            boolean bl9;
                                            string = s;
                                            if (!"+v".equals(string)) break block0;
                                            verbose$2.elem = bl9 = false;
                                            break block1;
                                        }
                                        if (!"+n".equals(string)) break block2;
                                        noColor$2.elem = bl8 = false;
                                        break block1;
                                    }
                                    if (!"+s".equals(string)) break block3;
                                    decodeScalaNames$2.elem = bl7 = false;
                                    break block1;
                                }
                                if (!"+a".equals(string)) break block4;
                                logAssert$2.elem = bl6 = false;
                                break block1;
                            }
                            if (!"+c".equals(string)) break block5;
                            notLogExceptionClass$2.elem = bl5 = false;
                            break block1;
                        }
                        if (!"+l".equals(string)) break block6;
                        useSbtLoggers$1.elem = bl4 = true;
                        break block1;
                    }
                    if (!"-l".equals(string)) break block7;
                    useSbtLoggers$1.elem = bl3 = false;
                    break block1;
                }
                if (!"+F".equals(string)) break block8;
                trimStackTraces$1.elem = bl2 = true;
                break block1;
            }
            if (!"-F".equals(string)) break block1;
            trimStackTraces$1.elem = bl = false;
        }
    }
}

