/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import munit.internal.junitinterface.JUnitReporter;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;

public class MUnitRunNotifier
implements RunNotifier {
    private final JUnitReporter reporter;
    private int ignored;
    private int total;
    private long startedTimestamp;
    private final Set isFailed;

    public MUnitRunNotifier(JUnitReporter reporter) {
        this.reporter = reporter;
        this.ignored = 0;
        this.total = 0;
        this.startedTimestamp = 0L;
        this.isFailed = (Set)Set$.MODULE$.empty();
    }

    public int ignored() {
        return this.ignored;
    }

    public void ignored_$eq(int x$1) {
        this.ignored = x$1;
    }

    public int total() {
        return this.total;
    }

    public void total_$eq(int x$1) {
        this.total = x$1;
    }

    public long startedTimestamp() {
        return this.startedTimestamp;
    }

    public void startedTimestamp_$eq(long x$1) {
        this.startedTimestamp = x$1;
    }

    public Set<String> isFailed() {
        return this.isFailed;
    }

    @Override
    public void fireTestSuiteStarted(Description description) {
        this.reporter.reportTestSuiteStarted();
    }

    @Override
    public void fireTestStarted(Description description) {
        this.startedTimestamp_$eq(System.nanoTime());
        this.reporter.reportTestStarted(description.getMethodName());
    }

    public double elapsedMillis() {
        long elapsedNanos = System.nanoTime() - this.startedTimestamp();
        return (double)elapsedNanos / 1000000.0;
    }

    @Override
    public void fireTestIgnored(Description description) {
        this.ignored_$eq(this.ignored() + 1);
        this.reporter.reportTestIgnored(description.getMethodName());
    }

    @Override
    public void fireTestAssumptionFailed(Failure failure) {
        this.reporter.reportAssumptionViolation(failure.description().getMethodName(), this.elapsedMillis(), failure.ex());
    }

    @Override
    public void fireTestFailure(Failure failure) {
        String methodName = failure.description().getMethodName();
        this.isFailed().$plus$eq((Object)methodName);
        this.reporter.reportTestFailed(methodName, failure.ex(), this.elapsedMillis());
    }

    @Override
    public void fireTestFinished(Description description) {
        String methodName = description.getMethodName();
        this.total_$eq(this.total() + 1);
        if (!this.isFailed().apply((Object)methodName)) {
            this.reporter.reportTestPassed(methodName, this.elapsedMillis());
        }
    }

    @Override
    public void fireTestSuiteFinished(Description description) {
    }
}

