/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import java.io.Serializable;
import munit.Clue;
import munit.Clues;
import munit.EmptyPrinter$;
import munit.Location;
import munit.Printable;
import munit.Printer;
import munit.internal.Compat$;
import munit.internal.console.AnsiColors$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Predef$;
import scala.Product;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.StringBuilder;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;

public final class Printers$
implements Serializable {
    public static final Printers$ MODULE$ = new Printers$();

    private Printers$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Printers$.class);
    }

    public void log(Object any, Printer printer, Location loc) {
        Predef$.MODULE$.println((Object)loc.toString());
        Predef$.MODULE$.println((Object)this.print(any, printer));
    }

    public Printer log$default$2() {
        return EmptyPrinter$.MODULE$;
    }

    public String print(Object any, Printer printer) {
        IntRef height = IntRef.create((int)printer.height());
        StringBuilder out = new StringBuilder();
        int indentStep = 2;
        this.loop$1(printer, height, out, indentStep, any, 0);
        return AnsiColors$.MODULE$.filterAnsi(out.toString());
    }

    public Printer print$default$2() {
        return EmptyPrinter$.MODULE$;
    }

    private <T> void printApply(String prefix, Iterator<T> it, StringBuilder out, int indent, int nextIndent, String open, String close, String comma, Function1<T, BoxedUnit> fn) {
        out.append(prefix);
        out.append(open);
        if (it.hasNext()) {
            this.printNewline(out, nextIndent);
            while (it.hasNext()) {
                Object value = it.next();
                fn.apply(value);
                if (it.hasNext()) {
                    out.append(comma);
                    this.printNewline(out, nextIndent);
                    continue;
                }
                this.printNewline(out, indent);
            }
        }
        out.append(close);
    }

    private <T> String printApply$default$6() {
        return "(";
    }

    private <T> String printApply$default$7() {
        return ")";
    }

    private <T> String printApply$default$8() {
        return ",";
    }

    private void printNewline(StringBuilder out, int indent) {
        out.append("\n");
        for (int i = 0; i < indent; ++i) {
            out.append(' ');
        }
    }

    private void printString(String string, StringBuilder out, Printer printer) {
        boolean isMultiline = printer.isMultiline(string);
        if (isMultiline) {
            out.append('\"');
            out.append('\"');
            out.append('\"');
            out.append(string);
            out.append('\"');
            out.append('\"');
            out.append('\"');
        } else {
            out.append('\"');
            for (int i = 0; i < string.length(); ++i) {
                this.printChar(string.charAt(i), out, this.printChar$default$3());
            }
            out.append('\"');
        }
    }

    public String escapeNonVisible(String string) {
        StringBuilder out = new StringBuilder();
        for (int i = 0; i < string.length(); ++i) {
            StringBuilder stringBuilder;
            char ch = string.charAt(i);
            char c = ch;
            if ('\"' == c || '\'' == c) {
                stringBuilder = out.append(ch);
                continue;
            }
            this.printChar(ch, out, false);
            stringBuilder = BoxedUnit.UNIT;
        }
        return out.toString();
    }

    private void printChar(char c, StringBuilder sb, boolean isEscapeUnicode) {
        char c2 = c;
        switch (c2) {
            case '\"': {
                sb.append("\\\"");
                break;
            }
            case '\\': {
                sb.append("\\\\");
                break;
            }
            case '\b': {
                sb.append("\\b");
                break;
            }
            case '\f': {
                sb.append("\\f");
                break;
            }
            case '\n': {
                sb.append("\\n");
                break;
            }
            case '\r': {
                sb.append("\\r");
                break;
            }
            case '\t': {
                sb.append("\\t");
                break;
            }
            default: {
                boolean isNonReadableAscii;
                char c3 = c2;
                boolean bl = isNonReadableAscii = c3 < ' ' || c3 > '~' && isEscapeUnicode;
                if (isNonReadableAscii && !Character.isLetter(c3)) {
                    sb.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("\\u%04x"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)c3)})));
                    break;
                }
                sb.append(c3);
                break;
            }
        }
    }

    private boolean printChar$default$3() {
        return true;
    }

    private final /* synthetic */ void loop$2$$anonfun$1(Printer printer$2, IntRef height$2, StringBuilder out$2, int indentStep$2, int nextIndent$1, Clue clue) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(clue.source()))) {
            out$2.append(clue.source());
        }
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(clue.valueType()))) {
            out$2.append(": ").append(clue.valueType());
        }
        out$2.append(" = ");
        this.loop$1(printer$2, height$2, out$2, indentStep$2, clue.value(), nextIndent$1);
    }

    private final /* synthetic */ void loop$4$$anonfun$2(Printer printer$3, IntRef height$3, StringBuilder out$3, int indentStep$3, int nextIndent$2, Tuple2 x$1) {
        Tuple2 tuple2 = x$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Object key = tuple2._1();
        Object value = tuple2._2();
        this.loop$1(printer$3, height$3, out$3, indentStep$3, key, nextIndent$2);
        out$3.append(" -> ");
        this.loop$1(printer$3, height$3, out$3, indentStep$3, value, nextIndent$2);
    }

    private final /* synthetic */ void loop$6$$anonfun$3(Printer printer$4, IntRef height$4, StringBuilder out$4, int indentStep$4, int nextIndent$3, Object value) {
        this.loop$1(printer$4, height$4, out$4, indentStep$4, value, nextIndent$3);
    }

    private final /* synthetic */ void loop$8$$anonfun$4(Printer printer$5, IntRef height$5, StringBuilder out$5, int indentStep$5, int nextIndent$4, Object value) {
        this.loop$1(printer$5, height$5, out$5, indentStep$5, value, nextIndent$4);
    }

    private final String $anonfun$1(Iterator elementNames$1) {
        return elementNames$1.hasNext() ? (String)elementNames$1.next() : "";
    }

    private final /* synthetic */ void loop$10$$anonfun$5(Printer printer$6, IntRef height$6, StringBuilder out$6, int indentStep$6, int nextIndent$5, Tuple2 x$1) {
        Object value;
        Tuple2 tuple2 = x$1;
        if (tuple2 != null) {
            value = tuple2._1();
            String key = (String)tuple2._2();
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(key))) {
                out$6.append(key).append(" = ");
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        this.loop$1(printer$6, height$6, out$6, indentStep$6, value, nextIndent$5);
    }

    private final void loop$1(Printer printer$1, IntRef height$1, StringBuilder out$1, int indentStep$1, Object a, int indent) {
        block41: {
            int n;
            height$1.elem = n = height$1.elem - 1;
            if (height$1.elem < 0) {
                out$1.append("...");
                return;
            }
            int nextIndent = indent + indentStep$1;
            boolean isDone = printer$1.print(a, out$1, indent);
            if (isDone) break block41;
            Object object = a;
            if (object == null) {
                out$1.append("null");
            } else if (object instanceof Printable) {
                Printable x = (Printable)object;
                x.print(out$1, indent);
            } else if (object instanceof Character) {
                StringBuilder stringBuilder;
                char x = BoxesRunTime.unboxToChar((Object)object);
                out$1.append('\'');
                if (x == '\'') {
                    stringBuilder = out$1.append("\\'");
                } else {
                    this.printChar(x, out$1, this.printChar$default$3());
                    stringBuilder = BoxedUnit.UNIT;
                }
                out$1.append('\'');
            } else if (object instanceof Byte) {
                byte x = BoxesRunTime.unboxToByte((Object)object);
                out$1.append(BoxesRunTime.boxToByte((byte)x).toString());
            } else if (object instanceof Short) {
                short x = BoxesRunTime.unboxToShort((Object)object);
                out$1.append(BoxesRunTime.boxToShort((short)x).toString());
            } else if (object instanceof Integer) {
                int x = BoxesRunTime.unboxToInt((Object)object);
                out$1.append(BoxesRunTime.boxToInteger((int)x).toString());
            } else if (object instanceof Long) {
                long x = BoxesRunTime.unboxToLong((Object)object);
                out$1.append(BoxesRunTime.boxToLong((long)x).toString());
            } else if (object instanceof Float) {
                float x = BoxesRunTime.unboxToFloat((Object)object);
                out$1.append(BoxesRunTime.boxToFloat((float)x).toString());
            } else if (object instanceof Double) {
                double x = BoxesRunTime.unboxToDouble((Object)object);
                out$1.append(BoxesRunTime.boxToDouble((double)x).toString());
            } else if (object instanceof String) {
                String x = (String)object;
                this.printString(x, out$1, printer$1);
            } else if (object instanceof Clues) {
                Clues x = (Clues)object;
                this.printApply("Clues", x.values().iterator(), out$1, indent, nextIndent, " {", "}", "", (Function1 & Serializable)clue -> {
                    this.loop$2$$anonfun$1(printer$1, height$1, out$1, indentStep$1, nextIndent, (Clue)clue);
                    return BoxedUnit.UNIT;
                });
            } else if (None$.MODULE$.equals(object)) {
                out$1.append("None");
            } else {
                Nil$ nil$ = package$.MODULE$.Nil();
                Object object2 = object;
                if (!(nil$ != null ? !nil$.equals(object2) : object2 != null)) {
                    out$1.append("Nil");
                } else if (object instanceof Map) {
                    Map x = (Map)object;
                    this.printApply(Compat$.MODULE$.collectionClassName((Iterable<?>)x), x.iterator(), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1 & Serializable)x$1 -> {
                        this.loop$4$$anonfun$2(printer$1, height$1, out$1, indentStep$1, nextIndent, (Tuple2)x$1);
                        return BoxedUnit.UNIT;
                    });
                } else if (object instanceof Iterable) {
                    Iterable x = (Iterable)object;
                    this.printApply(Compat$.MODULE$.collectionClassName(x), x.iterator(), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1 & Serializable)value -> {
                        this.loop$6$$anonfun$3(printer$1, height$1, out$1, indentStep$1, nextIndent, value);
                        return BoxedUnit.UNIT;
                    });
                } else if (ScalaRunTime$.MODULE$.isArray(object, 1)) {
                    Object x = object;
                    Object object3 = Predef$.MODULE$.genericArrayOps(x);
                    this.printApply("Array", ArrayOps$.MODULE$.iterator$extension(object3), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1 & Serializable)value -> {
                        this.loop$8$$anonfun$4(printer$1, height$1, out$1, indentStep$1, nextIndent, value);
                        return BoxedUnit.UNIT;
                    });
                } else if (object instanceof Iterator) {
                    Iterator it = (Iterator)object;
                    if (it.isEmpty()) {
                        out$1.append("empty iterator");
                    } else {
                        out$1.append("non-empty iterator");
                    }
                } else if (object instanceof Product) {
                    Product p = (Product)object;
                    Iterator<String> elementNames = Compat$.MODULE$.productElementNames(p);
                    Iterator infiniteElementNames = package$.MODULE$.Iterator().continually(() -> this.$anonfun$1(elementNames));
                    this.printApply(p.productPrefix(), p.productIterator().zip((IterableOnce)infiniteElementNames), out$1, indent, nextIndent, this.printApply$default$6(), this.printApply$default$7(), this.printApply$default$8(), (Function1 & Serializable)x$1 -> {
                        this.loop$10$$anonfun$5(printer$1, height$1, out$1, indentStep$1, nextIndent, (Tuple2)x$1);
                        return BoxedUnit.UNIT;
                    });
                } else {
                    out$1.append(a.toString());
                }
            }
        }
    }
}

