/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.difflib;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import munit.internal.difflib.Delta;
import munit.internal.difflib.MyersDiff;
import munit.internal.difflib.Patch;
import scala.Function1;
import scala.Predef$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ObjectRef;
import scala.runtime.RichInt$;

public final class DiffUtils$
implements Serializable {
    public static final DiffUtils$ MODULE$ = new DiffUtils$();

    private DiffUtils$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(DiffUtils$.class);
    }

    public List<String> generateUnifiedDiff(String original, String revised, List<String> originalLines, Patch<String> patch, int contextSize) {
        ArrayList<String> arrayList;
        if (!patch.getDeltas().isEmpty()) {
            ArrayList<String> ret = new ArrayList<String>();
            ret.add(new StringBuilder(4).append("--- ").append(original).toString());
            ret.add(new StringBuilder(4).append("+++ ").append(revised).toString());
            ArrayList<Delta<String>> patchDeltas = new ArrayList<Delta<String>>(patch.getDeltas());
            ArrayList<Delta<String>> deltas = new ArrayList<Delta<String>>();
            ObjectRef delta = ObjectRef.create((Object)((Delta)patchDeltas.get(0)));
            deltas.add((Delta)delta.elem);
            if (patchDeltas.size() > 1) {
                RichInt$.MODULE$.until$extension(Predef$.MODULE$.intWrapper(1), patchDeltas.size()).foreach((Function1 & Serializable)v1 -> {
                    this.generateUnifiedDiff$$anonfun$1(originalLines, contextSize, ret, patchDeltas, deltas, delta, BoxesRunTime.unboxToInt((Object)v1));
                    return BoxedUnit.UNIT;
                });
            }
            ArrayList<String> curBlock = this.processDeltas(originalLines, deltas, contextSize);
            ret.addAll(curBlock);
            arrayList = ret;
        } else {
            arrayList = new ArrayList<String>();
        }
        return arrayList;
    }

    public Patch<String> diff(List<String> original, List<String> revised) {
        return new MyersDiff<String>().diff(original, revised);
    }

    private ArrayList<String> processDeltas(List<String> origLines, List<Delta<String>> deltas, int contextSize) {
        int contextStart;
        int revStart;
        ArrayList<String> buffer = new ArrayList<String>();
        int origTotal = 0;
        int revTotal = 0;
        int line = 0;
        Delta<String> curDelta = deltas.get(0);
        int origStart = curDelta.getOriginal().getPosition() + 1 - contextSize;
        if (origStart < 1) {
            origStart = 1;
        }
        if ((revStart = curDelta.getRevised().getPosition() + 1 - contextSize) < 1) {
            revStart = 1;
        }
        if ((contextStart = curDelta.getOriginal().getPosition() - contextSize) < 0) {
            contextStart = 0;
        }
        line = contextStart;
        while (line < curDelta.getOriginal().getPosition()) {
            buffer.add(new StringBuilder(1).append(" ").append((Object)origLines.get(line)).toString());
            ++origTotal;
            ++revTotal;
            ++line;
        }
        buffer.addAll(this.getDeltaText(curDelta));
        origTotal += curDelta.getOriginal().getLines().size();
        revTotal += curDelta.getRevised().getLines().size();
        int deltaIndex = 1;
        while (deltaIndex < deltas.size()) {
            int intermediateStart;
            Delta<String> nextDelta = deltas.get(deltaIndex);
            line = intermediateStart = curDelta.getOriginal().getPosition() + curDelta.getOriginal().getLines().size();
            while (line < nextDelta.getOriginal().getPosition()) {
                buffer.add(new StringBuilder(1).append(" ").append((Object)origLines.get(line)).toString());
                ++origTotal;
                ++revTotal;
                ++line;
            }
            buffer.addAll(this.getDeltaText(nextDelta));
            origTotal += nextDelta.getOriginal().getLines().size();
            revTotal += nextDelta.getRevised().getLines().size();
            curDelta = nextDelta;
            ++deltaIndex;
        }
        line = contextStart = curDelta.getOriginal().getPosition() + curDelta.getOriginal().getLines().size();
        while (line < contextStart + contextSize && line < origLines.size()) {
            buffer.add(new StringBuilder(1).append(" ").append((Object)origLines.get(line)).toString());
            ++origTotal;
            ++revTotal;
            ++line;
        }
        StringBuffer header = new StringBuffer();
        header.append("@@ -");
        header.append(origStart);
        header.append(",");
        header.append(origTotal);
        header.append(" +");
        header.append(revStart);
        header.append(",");
        header.append(revTotal);
        header.append(" @@");
        buffer.add(0, header.toString());
        return buffer;
    }

    /*
     * WARNING - void declaration
     */
    private ArrayList<String> getDeltaText(Delta<String> delta) {
        void var2_2;
        ArrayList buffer = new ArrayList();
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(delta.getOriginal().getLines()).asScala()).foreach((Function1 & Serializable)line -> buffer.add(new StringBuilder(1).append("-").append((String)line).toString()));
        ((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(delta.getRevised().getLines()).asScala()).foreach((Function1 & Serializable)line -> buffer.add(new StringBuilder(1).append("+").append((String)line).toString()));
        return var2_2;
    }

    private final /* synthetic */ void generateUnifiedDiff$$anonfun$1(List originalLines$1, int contextSize$1, List ret$1, List patchDeltas$1, List deltas$1, ObjectRef delta$1, int i) {
        boolean bl;
        int position = ((Delta)delta$1.elem).getOriginal().getPosition();
        Delta nextDelta = (Delta)patchDeltas$1.get(i);
        if (position + ((Delta)delta$1.elem).getOriginal().size() + contextSize$1 >= nextDelta.getOriginal().getPosition() - contextSize$1) {
            bl = deltas$1.add(nextDelta);
        } else {
            ArrayList<String> curBlock = this.processDeltas(originalLines$1, deltas$1, contextSize$1);
            ret$1.addAll(curBlock);
            deltas$1.clear();
            bl = deltas$1.add(nextDelta);
        }
        Delta delta = nextDelta;
        delta$1.elem = delta;
        delta = null;
    }
}

