/*
 * Decompiled with CFR 0.152.
 */
package munit;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import munit.AfterEach;
import munit.AnyFixture;
import munit.BeforeEach;
import munit.Exceptions$;
import munit.FailSuiteException;
import munit.Fixture;
import munit.FunSuite;
import munit.Location$;
import munit.MUnitRunner$;
import munit.Suite;
import munit.Tag;
import munit.Test;
import munit.TestValues;
import munit.TestValues$;
import munit.internal.Compat$;
import munit.internal.FutureCompat$;
import munit.internal.PlatformCompat$;
import munit.internal.console.Printers$;
import munit.internal.console.StackTraces$;
import munit.internal.junitinterface.Configurable;
import munit.internal.junitinterface.Settings;
import munit.internal.junitinterface.Settings$;
import munit.package$;
import org.junit.AssumptionViolatedException;
import org.junit.runner.Description;
import org.junit.runner.Description$;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayBuffer$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Success;
import scala.util.Success$;
import scala.util.Try;
import scala.util.control.NonFatal$;

public class MUnitRunner
extends Runner
implements Filterable,
Configurable {
    private final Class cls;
    private final Suite suite;
    private final ExecutionContext ec;
    private volatile Settings settings;
    public volatile boolean munit$MUnitRunner$$suiteAborted;
    private final Map<Test, Description> descriptions;
    private final Set<String> testNames;
    private ArrayBuffer munitTests$lzy1;
    private boolean munitTestsbitmap$1;
    private Fixture<BoxedUnit> suiteFixtureBefore;
    private Fixture<BoxedUnit> suiteFixtureAfter;
    private List munitFixtures$lzy1;
    private boolean munitFixturesbitmap$1;

    public MUnitRunner(Class<? extends Suite> cls, Function0<Suite> newInstance) {
        this.cls = cls;
        this.suite = (Suite)newInstance.apply();
        this.ec = this.suite().munitExecutionContext();
        this.settings = Settings$.MODULE$.defaults();
        this.munit$MUnitRunner$$suiteAborted = false;
        this.descriptions = (Map)Map$.MODULE$.empty();
        this.testNames = (Set)Set$.MODULE$.empty();
        this.suiteFixtureBefore = new Fixture<BoxedUnit>(cls, this){
            private final /* synthetic */ MUnitRunner $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(MUnitRunner.munit$MUnitRunner$$_$$anon$superArg$1$1(cls$5));
            }

            public void apply() {
            }

            public void beforeAll() {
                this.$outer.suite().beforeAll();
            }

            public void beforeEach(BeforeEach context) {
                this.$outer.suite().beforeEach(context);
            }
        };
        this.suiteFixtureAfter = new Fixture<BoxedUnit>(cls, this){
            private final /* synthetic */ MUnitRunner $outer;
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                super(MUnitRunner.munit$MUnitRunner$$_$$anon$superArg$2$1(cls$6));
            }

            public void apply() {
            }

            public void afterEach(AfterEach context) {
                this.$outer.suite().afterEach(context);
            }

            public void afterAll() {
                this.$outer.suite().afterAll();
            }
        };
    }

    public Class<? extends Suite> cls() {
        return this.cls;
    }

    public MUnitRunner(Class<? extends Suite> cls) {
        this(MUnitRunner$.MODULE$.munit$MUnitRunner$$$ensureEligibleConstructor(cls), MUnitRunner.MUnitRunner$superArg$1(cls));
    }

    public Suite suite() {
        return this.suite;
    }

    private ArrayBuffer<Test> munitTests() {
        if (!this.munitTestsbitmap$1) {
            this.munitTests$lzy1 = (ArrayBuffer)ArrayBuffer$.MODULE$.apply(this.suite().munitTests());
            this.munitTestsbitmap$1 = true;
        }
        return this.munitTests$lzy1;
    }

    private List<AnyFixture<?>> munitFixtures() {
        if (!this.munitFixturesbitmap$1) {
            List list = this.suite().munitFixtures().toList();
            this.munitFixtures$lzy1 = scala.package$.MODULE$.Nil().$colon$colon(this.suiteFixtureAfter).$colon$colon$colon(list).$colon$colon(this.suiteFixtureBefore);
            this.munitFixturesbitmap$1 = true;
            this.suiteFixtureAfter = null;
            this.suiteFixtureBefore = null;
        }
        return this.munitFixtures$lzy1;
    }

    @Override
    public void filter(Filter filter) {
        ArrayBuffer newTests = (ArrayBuffer)this.munitTests().filter((Function1 & Serializable)t -> filter.shouldRun(this.createTestDescription((Test)t)));
        this.munitTests().clear();
        this.munitTests().$plus$plus$eq((IterableOnce)newTests);
    }

    @Override
    public void configure(Settings settings) {
        this.settings = settings;
    }

    private Description createTestDescription(Test test) {
        return (Description)this.descriptions.getOrElseUpdate((Object)test, () -> this.createTestDescription$$anonfun$1(test));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Description getDescription() {
        void var1_1;
        Description description2 = Description$.MODULE$.createSuiteDescription(this.cls());
        try {
            ArrayBuffer suiteTests = (ArrayBuffer)StackTraces$.MODULE$.dropOutside(this::$anonfun$4);
            suiteTests.iterator().map((Function1 & Serializable)test -> this.createTestDescription((Test)test)).foreach((Function1 & Serializable)description -> description2.addChild((Description)description));
        }
        catch (Throwable ex) {
            this.munit$MUnitRunner$$trimStackTrace(ex);
            ex.printStackTrace();
        }
        return var1_1;
    }

    @Override
    public void run(RunNotifier notifier) {
        PlatformCompat$.MODULE$.awaitResult(this.runAsync(notifier));
    }

    public Future<BoxedUnit> runAsync(RunNotifier notifier) {
        Description description = this.getDescription();
        notifier.fireTestSuiteStarted(description);
        return FutureCompat$.MODULE$.ExtensionFuture(this.runAll(notifier)).transformCompat((Function1 & Serializable)result -> {
            result.failed().foreach((Function1 & Serializable)ex -> {
                this.runAsync$$anonfun$1$$anonfun$1(notifier, (Throwable)ex);
                return BoxedUnit.UNIT;
            });
            notifier.fireTestSuiteFinished(description);
            return Success$.MODULE$.apply((Object)BoxedUnit.UNIT);
        }, this.ec);
    }

    private Future<List<Try<Object>>> runTests(RunNotifier notifier) {
        return this.sequenceFutures(this.munitTests().iterator().map((Function1 & Serializable)t -> this.runTest(notifier, (Test)t)));
    }

    private <A> Future<List<Try<A>>> sequenceFutures(Iterator<Future<A>> futures) {
        return this.loop$1(futures, ListBuffer$.MODULE$.empty());
    }

    private Option<Duration> munitTimeout() {
        None$ none$;
        Suite suite = this.suite();
        if (suite instanceof FunSuite) {
            FunSuite funSuite = (FunSuite)suite;
            none$ = Some$.MODULE$.apply((Object)funSuite.munitTimeout());
        } else {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private Future<BoxedUnit> runAll(RunNotifier notifier) {
        if (PlatformCompat$.MODULE$.isIgnoreSuite(this.cls()) || this.munitTests().isEmpty()) {
            Description description = this.getDescription();
            notifier.fireTestIgnored(description);
            return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        return this.runBeforeAll(notifier).flatMap((Function1 & Serializable)beforeAll -> (beforeAll.isSuccess() ? this.runTests(notifier) : Future$.MODULE$.successful((Object)scala.package$.MODULE$.Nil())).flatMap((Function1 & Serializable)x$12 -> {
            List list = x$12;
            return this.runAfterAll(notifier, (BeforeAllResult)beforeAll).map((Function1 & Serializable)x$1 -> {
                boxedUnit = x$1;
                return BoxedUnit.UNIT;
            }, this.ec);
        }, this.ec), this.ec);
    }

    private Future<BeforeAllResult> runBeforeAll(RunNotifier notifier) {
        Future result = this.sequenceFutures(this.munitFixtures().iterator().map((Function1 & Serializable)f -> this.runHiddenTest(notifier, new StringBuilder(11).append("beforeAll(").append(f.fixtureName()).append(")").toString(), (Function0<Object>)(Function0 & Serializable)() -> f.beforeAll()).map((Function1 & Serializable)isSuccess -> MUnitRunner.$anonfun$5$$anonfun$2(f, BoxesRunTime.unboxToBoolean((Object)isSuccess)), this.ec)));
        return result.map((Function1 & Serializable)results -> {
            List loadedFixtures = results.collect((PartialFunction)new Serializable(){

                /*
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                public final boolean isDefinedAt(Try x) {
                    Try try_ = x;
                    if (!(try_ instanceof Success)) return false;
                    Tuple2 tuple2 = (Tuple2)((Success)try_).value();
                    if (tuple2 == null) return false;
                    AnyFixture fixture = (AnyFixture)tuple2._1();
                    if (true != BoxesRunTime.unboxToBoolean((Object)tuple2._2())) return false;
                    return true;
                }

                /*
                 * Enabled aggressive block sorting
                 */
                public final Object applyOrElse(Try x, Function1 function1) {
                    Object object;
                    Tuple2 tuple2;
                    Try try_ = x;
                    if (try_ instanceof Success && (tuple2 = (Tuple2)((Success)try_).value()) != null) {
                        AnyFixture fixture = (AnyFixture)tuple2._1();
                        if (BoxesRunTime.unboxToBoolean((Object)tuple2._2())) {
                            object = fixture;
                            return object;
                        }
                    }
                    object = function1.apply((Object)x);
                    return object;
                }
            });
            List errors = results.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Try x) {
                    boolean bl;
                    Try try_ = x;
                    if (try_ instanceof scala.util.Failure) {
                        Throwable ex = ((scala.util.Failure)try_).exception();
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Object object;
                    Try try_ = x;
                    if (try_ instanceof scala.util.Failure) {
                        Throwable ex = ((scala.util.Failure)try_).exception();
                        object = ex;
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            });
            boolean isSuccess = loadedFixtures.length() == results.length();
            return new BeforeAllResult(this, isSuccess, loadedFixtures, (List<Throwable>)errors);
        }, this.ec);
    }

    private Future<BoxedUnit> runAfterAll(RunNotifier notifier, BeforeAllResult beforeAll) {
        return this.sequenceFutures(beforeAll.loadedFixtures().iterator().map((Function1 & Serializable)f -> this.runHiddenTest(notifier, new StringBuilder(10).append("afterAll(").append(f.fixtureName()).append(")").toString(), (Function0<Object>)(Function0 & Serializable)() -> f.afterAll()))).map((Function1 & Serializable)_$1 -> {
            MUnitRunner.runAfterAll$$anonfun$2(_$1);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    private Future<BeforeAllResult> runBeforeEach(Test test) {
        BeforeEach context = new BeforeEach(test);
        ListBuffer fixtures = ListBuffer$.MODULE$.empty();
        return this.sequenceFutures(this.munitFixtures().iterator().map((Function1 & Serializable)f -> this.valueTransform((Function0<Object>)(Function0 & Serializable)() -> f.beforeEach(context)).map((Function1 & Serializable)_$2 -> f, this.ec))).map((Function1 & Serializable)results -> {
            List loadedFixtures = results.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Try x) {
                    boolean bl;
                    Try try_ = x;
                    if (try_ instanceof Success) {
                        AnyFixture f = (AnyFixture)((Success)try_).value();
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Object object;
                    Try try_ = x;
                    if (try_ instanceof Success) {
                        AnyFixture f = (AnyFixture)((Success)try_).value();
                        object = f;
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            });
            List errors = results.collect((PartialFunction)new Serializable(){

                public final boolean isDefinedAt(Try x) {
                    boolean bl;
                    Try try_ = x;
                    if (try_ instanceof scala.util.Failure) {
                        Throwable ex = ((scala.util.Failure)try_).exception();
                        bl = true;
                    } else {
                        bl = false;
                    }
                    return bl;
                }

                public final Object applyOrElse(Try x, Function1 function1) {
                    Object object;
                    Try try_ = x;
                    if (try_ instanceof scala.util.Failure) {
                        Throwable ex = ((scala.util.Failure)try_).exception();
                        object = ex;
                    } else {
                        object = function1.apply((Object)x);
                    }
                    return object;
                }
            });
            boolean isSuccess = loadedFixtures.length() == results.length();
            return new BeforeAllResult(this, isSuccess, loadedFixtures, (List<Throwable>)errors);
        }, this.ec);
    }

    private Future<BoxedUnit> runAfterEach(Test test, List<AnyFixture<?>> fixtures) {
        AfterEach context = new AfterEach(test);
        return this.sequenceFutures(fixtures.iterator().map((Function1 & Serializable)f -> this.valueTransform((Function0<Object>)(Function0 & Serializable)() -> f.afterEach(context)))).map((Function1 & Serializable)_$3 -> {
            MUnitRunner.runAfterEach$$anonfun$2(_$3);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    private Future<Object> runTest(RunNotifier notifier, Test test) {
        Future future;
        Description description = this.createTestDescription(test);
        if (this.munit$MUnitRunner$$suiteAborted) {
            notifier.fireTestAssumptionFailed(new Failure(description, (Throwable)((Object)new FailSuiteException("Suite has been aborted", test.location()))));
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        if (test.tags().apply((Object)package$.MODULE$.Ignore())) {
            notifier.fireTestIgnored(description);
            return Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        notifier.fireTestStarted(description);
        Serializable onError = new Serializable(notifier, description, this){
            private final RunNotifier notifier$9;
            private final Description description$4;
            private final /* synthetic */ MUnitRunner $outer;
            {
                this.notifier$9 = notifier$15;
                this.description$4 = description$7;
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }

            public final boolean isDefinedAt(Throwable x) {
                Option option;
                boolean bl;
                Throwable throwable = x;
                if (throwable instanceof AssumptionViolatedException) {
                    AssumptionViolatedException ex = (AssumptionViolatedException)throwable;
                    bl = true;
                } else if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = (Throwable)option.get();
                    bl = true;
                } else if (throwable instanceof StackOverflowError) {
                    StackOverflowError ex = (StackOverflowError)throwable;
                    bl = true;
                } else {
                    Throwable ex = throwable;
                    bl = true;
                }
                return bl;
            }

            public final Object applyOrElse(Throwable x, Function1 function1) {
                Option option;
                Future future;
                Throwable throwable = x;
                if (throwable instanceof AssumptionViolatedException) {
                    AssumptionViolatedException ex = (AssumptionViolatedException)throwable;
                    this.$outer.munit$MUnitRunner$$trimStackTrace((Throwable)ex);
                    this.notifier$9.fireTestAssumptionFailed(new Failure(this.description$4, (Throwable)ex));
                    future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                } else if (throwable != null && !(option = NonFatal$.MODULE$.unapply(throwable)).isEmpty()) {
                    Throwable throwable2;
                    Throwable ex = throwable2 = (Throwable)option.get();
                    future = this.$outer.munit$MUnitRunner$$_$handleNonFatalOrStackOverflow$1(this.notifier$9, this.description$4, ex);
                } else if (throwable instanceof StackOverflowError) {
                    StackOverflowError ex = (StackOverflowError)throwable;
                    future = this.$outer.munit$MUnitRunner$$_$handleNonFatalOrStackOverflow$1(this.notifier$9, this.description$4, ex);
                } else {
                    Throwable ex = throwable;
                    this.$outer.munit$MUnitRunner$$suiteAborted = true;
                    this.notifier$9.fireTestFailure(new Failure(this.description$4, ex));
                    future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
                }
                return future;
            }
        };
        try {
            future = this.runTestBody(notifier, description, test).recoverWith((PartialFunction)onError, this.ec);
        }
        catch (Throwable ex$) {
            Serializable $1$ = onError;
            if ($1$.isDefinedAt(ex$)) {
                future = (Future)$1$.apply(ex$);
            }
            throw ex$;
        }
        Future result = future;
        return result.map((Function1 & Serializable)_$4 -> {
            notifier.fireTestFinished(description);
            return true;
        }, this.ec);
    }

    private Future<Object> futureFromAny(Object any) {
        Future f;
        Object object = any;
        return object instanceof Future ? (f = (Future)object) : Future$.MODULE$.successful(any);
    }

    private Future<BoxedUnit> runTestBody(RunNotifier notifier, Description description, Test test) {
        Future result = this.runBeforeEach(test).flatMap((Function1 & Serializable)beforeEach -> {
            List<Throwable> list = beforeEach.errors();
            Nil$ nil$ = scala.package$.MODULE$.Nil();
            List<Throwable> list2 = list;
            if (nil$ == null ? list2 != null : !nil$.equals(list2)) {
                if (list instanceof .colon.colon) {
                    .colon.colon colon2 = (.colon.colon)list;
                    List list3 = colon2.next$access$1();
                    Throwable error = (Throwable)colon2.head();
                    List errors = list3;
                    errors.foreach((Function1 & Serializable)err -> {
                        error.addSuppressed(err);
                        return BoxedUnit.UNIT;
                    });
                    try {
                        Future<BoxedUnit> future = this.runAfterEach(test, beforeEach.loadedFixtures());
                    }
                    finally {
                        throw error;
                    }
                }
                throw new MatchError(list);
            }
            return FutureCompat$.MODULE$.ExtensionFuture(StackTraces$.MODULE$.dropOutside(test.body())).transformWithCompat((Function1 & Serializable)result -> FutureCompat$.MODULE$.ExtensionFuture(this.runAfterEach(test, beforeEach.loadedFixtures())).transformCompat((Function1 & Serializable)_$5 -> result, this.ec), this.ec);
        }, this.ec);
        return result.map((Function1 & Serializable)x$1 -> {
            this.runTestBody$$anonfun$1(notifier, description, x$1);
            return BoxedUnit.UNIT;
        }, this.ec);
    }

    private Future<Object> runHiddenTest(RunNotifier notifier, String name, Function0<Object> thunk) {
        Future future;
        try {
            future = (Future)StackTraces$.MODULE$.dropOutside(() -> this.runHiddenTest$$anonfun$1(notifier, name, thunk));
        }
        catch (Throwable ex) {
            this.fireFailedHiddenTest(notifier, name, ex);
            future = Future$.MODULE$.successful((Object)BoxesRunTime.boxToBoolean((boolean)false));
        }
        return future;
    }

    private void fireFailedHiddenTest(RunNotifier notifier, String name, Throwable ex) {
        Test test = new Test(name, (Function0<Future<Object>>)(Function0 & Serializable)() -> {
            throw Predef$.MODULE$.$qmark$qmark$qmark();
        }, (scala.collection.immutable.Set<Tag>)Predef$.MODULE$.Set().empty(), Location$.MODULE$.empty());
        Description description = this.createTestDescription(test);
        notifier.fireTestStarted(description);
        this.munit$MUnitRunner$$trimStackTrace(ex);
        notifier.fireTestFailure(new Failure(description, Exceptions$.MODULE$.rootCause(ex)));
        notifier.fireTestFinished(description);
    }

    public void munit$MUnitRunner$$trimStackTrace(Throwable ex) {
        if (this.settings.trimStackTraces()) {
            StackTraces$.MODULE$.trimStackTrace(ex);
        }
    }

    private Future<Object> valueTransform(Function0<Object> thunk) {
        Future future;
        Suite suite = this.suite();
        if (suite instanceof FunSuite) {
            FunSuite funSuite = (FunSuite)suite;
            future = funSuite.munitValueTransform((Function0)thunk);
        } else {
            future = this.futureFromAny(thunk.apply());
        }
        return future;
    }

    private static Function0<Suite> MUnitRunner$superArg$1(Class<? extends Suite> cls) {
        return (Function0 & Serializable)() -> (Suite)cls.newInstance();
    }

    public static final String munit$MUnitRunner$$_$$anon$superArg$1$1(Class cls$1) {
        return cls$1.getName();
    }

    public static final String munit$MUnitRunner$$_$$anon$superArg$2$1(Class cls$2) {
        return cls$2.getName();
    }

    private static final /* synthetic */ String $anonfun$2(String escapedName$1, int x$1) {
        String string;
        int n = x$1;
        if (0 == n) {
            string = escapedName$1;
        } else {
            int n2 = n;
            string = new StringBuilder(1).append(escapedName$1).append("-").append(n2).toString();
        }
        return string;
    }

    private final Description createTestDescription$$anonfun$1(Test test$1) {
        String escapedName = Printers$.MODULE$.escapeNonVisible(test$1.name());
        String testName = (String)Option$.MODULE$.option2Iterable(Compat$.MODULE$.LazyList().from(0).map((Function1 & Serializable)x$1 -> MUnitRunner.$anonfun$2(escapedName, BoxesRunTime.unboxToInt((Object)x$1))).find((Function1 & Serializable)candidate -> !this.testNames.contains(candidate))).head();
        this.testNames.$plus$eq((Object)testName);
        Description desc = Description$.MODULE$.createTestDescription(this.cls(), testName, (Seq<Annotation>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])test$1.annotations()));
        return desc;
    }

    private final ArrayBuffer $anonfun$4() {
        return this.munitTests();
    }

    private final /* synthetic */ void runAsync$$anonfun$1$$anonfun$1(RunNotifier notifier$2, Throwable ex) {
        this.fireFailedHiddenTest(notifier$2, "unexpected error running tests", ex);
    }

    private final Future loop$1(Iterator it, ListBuffer acc) {
        Future future;
        block4: {
            Option option;
            Future future2;
            while (true) {
                if (!it.hasNext()) {
                    future = Future$.MODULE$.successful((Object)acc.toList());
                    break block4;
                }
                future2 = (Future)it.next();
                option = future2.value();
                if (!(option instanceof Some)) break;
                Try value = (Try)((Some)option).value();
                acc.$plus$eq((Object)value);
            }
            if (None$.MODULE$.equals(option)) {
                future = future2.flatMap((Function1 & Serializable)t -> {
                    acc.$plus$eq((Object)Success$.MODULE$.apply(t));
                    return this.loop$1(it, acc);
                }, this.ec);
            } else {
                throw new MatchError((Object)option);
            }
        }
        return future;
    }

    private static final /* synthetic */ Tuple2 $anonfun$5$$anonfun$2(AnyFixture f$2, boolean isSuccess) {
        AnyFixture anyFixture = (AnyFixture)Predef$.MODULE$.ArrowAssoc((Object)f$2);
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension((Object)anyFixture, (Object)BoxesRunTime.boxToBoolean((boolean)isSuccess));
    }

    private static final /* synthetic */ void runAfterAll$$anonfun$2(List _$1) {
    }

    private static final /* synthetic */ void runAfterEach$$anonfun$2(List _$3) {
    }

    public final Future munit$MUnitRunner$$_$handleNonFatalOrStackOverflow$1(RunNotifier notifier$8, Description description$3, Throwable ex) {
        this.munit$MUnitRunner$$trimStackTrace(ex);
        Throwable cause = Exceptions$.MODULE$.rootCause(ex);
        Failure failure = new Failure(description$3, cause);
        Throwable throwable = cause;
        if (throwable instanceof AssumptionViolatedException) {
            notifier$8.fireTestAssumptionFailed(failure);
        } else if (throwable instanceof FailSuiteException) {
            this.munit$MUnitRunner$$suiteAborted = true;
            notifier$8.fireTestFailure(failure);
        } else {
            notifier$8.fireTestFailure(failure);
        }
        return Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
    }

    private final /* synthetic */ void runTestBody$$anonfun$1(RunNotifier notifier$11, Description description$6, Object x$1) {
        block1: {
            Object object;
            block0: {
                object = x$1;
                if (!(object instanceof TestValues.FlakyFailure)) break block0;
                TestValues.FlakyFailure f = (TestValues.FlakyFailure)object;
                this.munit$MUnitRunner$$trimStackTrace((Throwable)((Object)f));
                notifier$11.fireTestAssumptionFailed(new Failure(description$6, (Throwable)((Object)f)));
                break block1;
            }
            Tag tag = TestValues$.MODULE$.Ignore();
            Object object2 = object;
            if (tag != null ? !((Object)tag).equals(object2) : object2 != null) break block1;
            notifier$11.fireTestIgnored(description$6);
        }
    }

    private final Future runHiddenTest$$anonfun$1(RunNotifier notifier$12, String name$1, Function0 thunk$1) {
        return FutureCompat$.MODULE$.ExtensionFuture(this.valueTransform((Function0<Object>)thunk$1)).transformCompat((Function1 & Serializable)x$1 -> {
            Success success;
            Try try_ = x$1;
            if (try_ instanceof Success) {
                Object value = ((Success)try_).value();
                success = Success$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)true));
            } else if (try_ instanceof scala.util.Failure) {
                Throwable exception = ((scala.util.Failure)try_).exception();
                this.fireFailedHiddenTest(notifier$12, name$1, exception);
                success = Success$.MODULE$.apply((Object)BoxesRunTime.boxToBoolean((boolean)false));
            } else {
                throw new MatchError((Object)try_);
            }
            return success;
        }, this.ec);
    }

    public class BeforeAllResult {
        private final boolean isSuccess;
        private final List loadedFixtures;
        private final List errors;
        private final /* synthetic */ MUnitRunner $outer;

        public BeforeAllResult(MUnitRunner $outer, boolean isSuccess, List<AnyFixture<?>> loadedFixtures, List<Throwable> errors) {
            this.isSuccess = isSuccess;
            this.loadedFixtures = loadedFixtures;
            this.errors = errors;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public boolean isSuccess() {
            return this.isSuccess;
        }

        public List<AnyFixture<?>> loadedFixtures() {
            return this.loadedFixtures;
        }

        public List<Throwable> errors() {
            return this.errors;
        }

        public final /* synthetic */ MUnitRunner munit$MUnitRunner$BeforeAllResult$$$outer() {
            return this.$outer;
        }
    }

    public class BeforeEachResult {
        private final Option error;
        private final List loadedFixtures;
        private final /* synthetic */ MUnitRunner $outer;

        public BeforeEachResult(MUnitRunner $outer, Option<Throwable> error, List<AnyFixture<?>> loadedFixtures) {
            this.error = error;
            this.loadedFixtures = loadedFixtures;
            if ($outer == null) {
                throw new NullPointerException();
            }
            this.$outer = $outer;
        }

        public Option<Throwable> error() {
            return this.error;
        }

        public List<AnyFixture<?>> loadedFixtures() {
            return this.loadedFixtures;
        }

        public final /* synthetic */ MUnitRunner munit$MUnitRunner$BeforeEachResult$$$outer() {
            return this.$outer;
        }
    }
}

