/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.io.Serializable;
import munit.diff.console.AnsiColors$;
import munit.internal.PlatformCompat$;
import munit.internal.junitinterface.JUnitEvent;
import munit.internal.junitinterface.JUnitEvent$;
import munit.internal.junitinterface.RunSettings;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Logger;
import sbt.testing.OptionalThrowable;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.Status$;
import sbt.testing.TaskDef;
import sbt.testing.TestSelector;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class JUnitReporter {
    private final EventHandler eventHandler;
    private final Logger[] loggers;
    private final RunSettings settings;
    private final TaskDef taskDef;
    private final boolean isAnsiSupported;
    private final int Trace;
    private final int Debug;
    private final int Info;
    private final int Warn;
    private final int Error;

    public JUnitReporter(EventHandler eventHandler, Logger[] loggers, RunSettings settings, TaskDef taskDef) {
        this.eventHandler = eventHandler;
        this.loggers = loggers;
        this.settings = settings;
        this.taskDef = taskDef;
        Object object = Predef$.MODULE$.refArrayOps((Object[])loggers);
        this.isAnsiSupported = ArrayOps$.MODULE$.forall$extension(object, (Function1 & Serializable)_$1 -> _$1.ansiCodesSupported()) && settings.color();
        this.Trace = 0;
        this.Debug = 1;
        this.Info = 2;
        this.Warn = 3;
        this.Error = 4;
    }

    public void reportTestSuiteStarted() {
        this.log(this.Info, AnsiColors$.MODULE$.c(new StringBuilder(1).append(this.taskDef.fullyQualifiedName()).append(":").toString(), AnsiColors$.MODULE$.GREEN()));
    }

    public void reportTestStarted(String method) {
        if (this.settings.verbose()) {
            this.log(this.Info, new StringBuilder(8).append(method).append(" started").toString());
            return;
        }
    }

    public void reportTestIgnored(String method) {
        this.log(this.Info, AnsiColors$.MODULE$.c(new StringBuilder(14).append("==> i ").append(method).append(" ignored").toString(), AnsiColors$.MODULE$.YELLOW()));
        this.emitEvent(method, Status$.MODULE$.Ignored(), this.emitEvent$default$3());
    }

    public void reportAssumptionViolation(String method, double timeInSeconds, Throwable e) {
        this.log(this.Info, AnsiColors$.MODULE$.c(new StringBuilder(14).append("==> s ").append(method).append(" skipped").toString(), AnsiColors$.MODULE$.YELLOW()));
        this.emitEvent(method, Status$.MODULE$.Skipped(), new OptionalThrowable(e));
    }

    public void reportTestPassed(String method, double elapsedMillis) {
        this.log(this.Info, new StringBuilder(1).append(AnsiColors$.MODULE$.c(new StringBuilder(4).append("  + ").append(method).toString(), AnsiColors$.MODULE$.GREEN())).append(" ").append(this.formatTime(elapsedMillis)).toString());
        this.emitEvent(method, Status$.MODULE$.Success(), this.emitEvent$default$3());
    }

    public void reportTestFailed(String method, Throwable ex, double elapsedMillis) {
        this.log(this.Info, new scala.collection.mutable.StringBuilder().append(AnsiColors$.MODULE$.c(new StringBuilder(7).append("==> X ").append(this.taskDef.fullyQualifiedName()).append(".").append(method).toString(), AnsiColors$.MODULE$.LightRed())).append(" ").append(this.formatTime(elapsedMillis)).append(" ").append(ex.getClass().getName()).append(": ").append(ex.getMessage()).toString());
        this.trace(ex);
        this.emitEvent(method, Status$.MODULE$.Failure(), new OptionalThrowable(ex));
    }

    private void trace(Throwable t) {
        if (!(t instanceof AssertionError) || this.settings.logAssert()) {
            this.logTrace(t);
            return;
        }
    }

    private void emitEvent(String method, Status status, OptionalThrowable throwable) {
        String testName = new StringBuilder(1).append(this.taskDef.fullyQualifiedName()).append(".").append(this.settings.decodeName(method)).toString();
        TestSelector selector = new TestSelector(testName);
        this.eventHandler.handle((Event)new JUnitEvent(this.taskDef, testName, status, (Selector)selector, throwable, JUnitEvent$.MODULE$.$lessinit$greater$default$6()));
    }

    private OptionalThrowable emitEvent$default$3() {
        return new OptionalThrowable();
    }

    private void log(int level, String s) {
        if (this.settings.useSbtLoggers()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.loggers);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)l -> {
                this.log$$anonfun$1(s, level, (Logger)l);
                return BoxedUnit.UNIT;
            });
            return;
        }
        int n = level;
        if (this.Debug == n || this.Trace == n) {
            if (!this.settings.verbose()) {
                return;
            }
        }
        Predef$.MODULE$.println((Object)this.filterAnsiIfNeeded(this.isAnsiSupported, s));
    }

    private String filterAnsiIfNeeded(Logger l, String s) {
        return this.filterAnsiIfNeeded(l.ansiCodesSupported(), s);
    }

    private String filterAnsiIfNeeded(boolean isColorSupported, String s) {
        if (isColorSupported && this.settings.color()) {
            return s;
        }
        return AnsiColors$.MODULE$.filterAnsi(s);
    }

    private void logTrace(Throwable t) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])t.getStackTrace());
        Object[] trace = (StackTraceElement[])ArrayOps$.MODULE$.dropWhile$extension(object, (Function1 & Serializable)p -> p.getFileName() != null && (p.getFileName().contains("StackTrace.scala") || p.getFileName().contains("Throwables.scala")));
        String testFileName = this.settings.color() ? this.findTestFileName((StackTraceElement[])trace) : null;
        Object object2 = Predef$.MODULE$.refArrayOps(trace);
        int i = ArrayOps$.MODULE$.indexWhere$extension(object2, (Function1 & Serializable)p -> p.getFileName() != null && p.getFileName().contains("JUnitExecuteTest.scala"), ArrayOps$.MODULE$.indexWhere$default$2$extension(object2)) - 1;
        int m = i > 0 ? i : trace.length - 1;
        this.logStackTracePart((StackTraceElement[])trace, m, trace.length - m - 1, t, testFileName);
    }

    private void logStackTracePart(StackTraceElement[] trace, int m, int framesInCommon, Throwable t, String testFileName) {
        int top;
        int m0 = m;
        int m2 = m;
        for (int i = top = 0; i <= m2; ++i) {
            if (!trace[i].toString().startsWith("org.junit.") && !trace[i].toString().startsWith("org.hamcrest.")) continue;
            if (i == top) {
                ++top;
                continue;
            }
            m2 = i - 1;
            boolean bl = false;
            while (m2 > top && !bl) {
                String s = trace[m2].toString();
                if (!s.startsWith("java.lang.reflect.") && !s.startsWith("sun.reflect.")) {
                    bl = true;
                    continue;
                }
                --m2;
            }
            i = m2;
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(top), m2).foreach((Function1 & Serializable)v1 -> {
            this.logStackTracePart$$anonfun$1(trace, testFileName, BoxesRunTime.unboxToInt((Object)v1));
            return BoxedUnit.UNIT;
        });
        if (m0 != m2) {
            this.log(this.Error, "    ...");
        } else if (framesInCommon != 0) {
            this.log(this.Error, new StringBuilder(13).append("    ... ").append(framesInCommon).append(" more").toString());
        }
        this.logStackTraceAsCause(trace, t.getCause(), testFileName);
    }

    private void logStackTraceAsCause(StackTraceElement[] causedTrace, Throwable t, String testFileName) {
        if (t != null) {
            StackTraceElement[] trace = t.getStackTrace();
            int m = trace.length - 1;
            for (int n = causedTrace.length - 1; m >= 0 && n >= 0; --m, --n) {
                StackTraceElement stackTraceElement = trace[m];
                StackTraceElement stackTraceElement2 = causedTrace[n];
                if (stackTraceElement != null ? !((Object)stackTraceElement).equals(stackTraceElement2) : stackTraceElement2 != null) break;
            }
            this.log(this.Error, new StringBuilder(11).append("Caused by: ").append(t).toString());
            this.logStackTracePart(trace, m, trace.length - 1 - m, t, testFileName);
            return;
        }
    }

    private String findTestFileName(StackTraceElement[] trace) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])trace);
        return (String)ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)_$2 -> {
            String string = _$2.getClassName();
            String string2 = this.taskDef.fullyQualifiedName();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)_$3 -> _$3.getFileName()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private String stackTraceElementToString(StackTraceElement e, String testFileName) {
        String string;
        boolean highlight = this.settings.color() && e.getFileName() != null && e.getFileName().contains("file:/");
        boolean canHighlight = !PlatformCompat$.MODULE$.isNative();
        scala.collection.mutable.StringBuilder stringBuilder = new scala.collection.mutable.StringBuilder().append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset())).append(!canHighlight ? "" : (highlight ? AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Bold()) : AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.DarkGrey()))).append("    at ").append(this.settings.decodeName(new StringBuilder(11).append(e.getClassName()).append('.').append(e.getMethodName()).toString())).append('(');
        if (e.isNativeMethod()) {
            string = "Native Method";
        } else if (e.getFileName() == null) {
            string = "Unknown Source";
        } else {
            int file = e.getFileName().indexOf("file:/");
            int https = file >= 0 ? file : e.getFileName().indexOf("https:/");
            String filename = https >= 0 ? e.getFileName().substring(https) : e.getFileName();
            string = e.getLineNumber() >= 0 ? new StringBuilder(1).append(filename).append(":").append(e.getLineNumber()).toString() : filename;
        }
        return stringBuilder.append(string).append(')').append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset())).toString();
    }

    private String formatTime(double elapsedMillis) {
        return AnsiColors$.MODULE$.c(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.2fs"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)(elapsedMillis / 1000.0))})), AnsiColors$.MODULE$.DarkGrey());
    }

    private final /* synthetic */ void log$$anonfun$1(String s$1, int level$1, Logger l) {
        String msg = this.filterAnsiIfNeeded(l, s$1);
        int n = level$1;
        if (this.Debug == n) {
            l.debug(msg);
            return;
        }
        if (this.Info == n) {
            l.info(msg);
            return;
        }
        if (this.Warn == n) {
            l.warn(msg);
            return;
        }
        if (this.Error == n) {
            l.error(msg);
            return;
        }
        l.error(msg);
    }

    private final /* synthetic */ void logStackTracePart$$anonfun$1(StackTraceElement[] trace$1, String testFileName$1, int i) {
        this.log(this.Error, this.stackTraceElementToString(trace$1[i], testFileName$1));
    }
}

