/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.io;

import java.net.URI;
import munit.internal.io.File$;
import munit.internal.io.JSIO$;
import munit.internal.io.MunitPath;
import munit.internal.io.MunitPath$;

public class File {
    private final String path;

    public static File[] listRoots() {
        return File$.MODULE$.listRoots();
    }

    public static String pathSeparator() {
        return File$.MODULE$.pathSeparator();
    }

    public static String separator() {
        return File$.MODULE$.separator();
    }

    public static char separatorChar() {
        return File$.MODULE$.separatorChar();
    }

    public File(String path) {
        this.path = path;
    }

    public File(String parent, String child) {
        this(new StringBuilder(0).append(parent).append(File$.MODULE$.separator()).append(child).toString());
    }

    public File(File parent, String child) {
        this(parent.getPath(), child);
    }

    public File(URI uri) {
        String string = uri.getScheme();
        String string2 = "file";
        if (string == null ? string2 != null : !string.equals(string2)) {
            throw new IllegalArgumentException("URI scheme is not \"file\"");
        }
        this(uri.getPath());
    }

    public MunitPath toPath() {
        return MunitPath$.MODULE$.apply(this.path);
    }

    public URI toURI() {
        String file = this.getAbsoluteFile().toString();
        String uripath = file.startsWith("/") ? file : new StringBuilder(1).append("/").append(file.replace(File$.MODULE$.separator(), "/")).toString();
        String withslash = this.isDirectory() && !uripath.endsWith("/") ? new StringBuilder(1).append(uripath).append("/").toString() : uripath;
        return new URI("file", null, withslash, null);
    }

    public File getAbsoluteFile() {
        return this.toPath().toAbsolutePath().toFile();
    }

    public String getAbsolutePath() {
        return this.getAbsoluteFile().toString();
    }

    public File getParentFile() {
        return this.toPath().getParent().toFile();
    }

    public void mkdirs() {
        throw new UnsupportedOperationException("mkdirs() is not supported in Scala.js");
    }

    public String getPath() {
        return this.path;
    }

    public boolean exists() {
        return JSIO$.MODULE$.exists(this.path);
    }

    public boolean isFile() {
        return JSIO$.MODULE$.isFile(this.path);
    }

    public boolean isDirectory() {
        return JSIO$.MODULE$.isDirectory(this.path);
    }

    public String toString() {
        return this.path;
    }
}

