/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.io.Serializable;
import munit.internal.junitinterface.CustomRunners;
import munit.internal.junitinterface.JUnitRunner;
import munit.internal.junitinterface.RunSettings;
import munit.internal.junitinterface.Settings;
import munit.internal.junitinterface.Settings$;
import munit.internal.junitinterface.TagsFilter;
import sbt.testing.Fingerprint;
import sbt.testing.Framework;
import sbt.testing.Runner;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Set;
import scala.reflect.ClassTag$;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

public abstract class JUnitFramework
implements Framework {
    public String name() {
        return "Scala.js JUnit test framework";
    }

    public abstract CustomRunners customRunners();

    public Fingerprint[] fingerprints() {
        return (Fingerprint[])this.customRunners().runners().toArray(ClassTag$.MODULE$.apply(Fingerprint.class));
    }

    public Runner runner(String[] args, String[] remoteArgs, ClassLoader testClassLoader) {
        return new JUnitRunner(args, remoteArgs, this.parseRunSettings(args), testClassLoader, this.customRunners());
    }

    public Runner slaveRunner(String[] args, String[] remoteArgs, ClassLoader testClassLoader, Function1<String, BoxedUnit> send) {
        return new JUnitRunner(args, remoteArgs, this.parseRunSettings(args), testClassLoader, this.customRunners());
    }

    private RunSettings parseRunSettings(String[] args) {
        Settings defaults = Settings$.MODULE$.defaults();
        BooleanRef verbose = BooleanRef.create((boolean)false);
        BooleanRef noColor = BooleanRef.create((boolean)false);
        BooleanRef decodeScalaNames = BooleanRef.create((boolean)false);
        BooleanRef logAssert = BooleanRef.create((boolean)false);
        BooleanRef notLogExceptionClass = BooleanRef.create((boolean)false);
        BooleanRef useSbtLoggers = BooleanRef.create((boolean)false);
        BooleanRef trimStackTraces = BooleanRef.create((boolean)defaults.trimStackTraces());
        ObjectRef includeTags = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        ObjectRef excludeTags = ObjectRef.create((Object)Predef$.MODULE$.Set().empty());
        Object object = Predef$.MODULE$.refArrayOps((Object[])args);
        ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)str -> {
            JUnitFramework.parseRunSettings$$anonfun$1(verbose, noColor, decodeScalaNames, logAssert, notLogExceptionClass, excludeTags, includeTags, str);
            return BoxedUnit.UNIT;
        });
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])args);
        ArrayOps$.MODULE$.foreach$extension(object2, (Function1 & Serializable)s -> {
            JUnitFramework.parseRunSettings$$anonfun$2(verbose, noColor, decodeScalaNames, logAssert, notLogExceptionClass, useSbtLoggers, trimStackTraces, s);
            return BoxedUnit.UNIT;
        });
        return new RunSettings(!noColor.elem, decodeScalaNames.elem, verbose.elem, logAssert.elem, notLogExceptionClass.elem, useSbtLoggers.elem, trimStackTraces.elem, new TagsFilter((Set<String>)((Set)includeTags.elem), (Set<String>)((Set)excludeTags.elem)));
    }

    private static final /* synthetic */ void parseRunSettings$$anonfun$1(BooleanRef verbose$1, BooleanRef noColor$1, BooleanRef decodeScalaNames$1, BooleanRef logAssert$1, BooleanRef notLogExceptionClass$1, ObjectRef excludeTags$1, ObjectRef includeTags$1, String str) {
        String string = str;
        switch (string == null ? 0 : string.hashCode()) {
            case 1492: {
                if (!"-a".equals(string)) break;
                logAssert$1.elem = true;
                return;
            }
            case 1494: {
                if (!"-c".equals(string)) break;
                notLogExceptionClass$1.elem = true;
                return;
            }
            case 1505: {
                if (!"-n".equals(string)) break;
                noColor$1.elem = true;
                return;
            }
            case 1510: {
                if (!"-s".equals(string)) break;
                decodeScalaNames$1.elem = true;
                return;
            }
            case 1513: {
                if (!"-v".equals(string)) break;
                verbose$1.elem = true;
                return;
            }
        }
        String s = string;
        if (s.startsWith("-tests=")) {
            throw new UnsupportedOperationException("-tests");
        }
        String s2 = string;
        if (s2.startsWith("--tests=")) {
            throw new UnsupportedOperationException("--tests");
        }
        String s3 = string;
        if (s3.startsWith("--ignore-runners=")) {
            throw new UnsupportedOperationException("--ignore-runners");
        }
        String s4 = string;
        if (s4.startsWith("--run-listener=")) {
            throw new UnsupportedOperationException("--run-listener");
        }
        String s5 = string;
        if (s5.startsWith("--exclude-tags=")) {
            excludeTags$1.elem = (Set)((Set)excludeTags$1.elem).$plus((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s5), "--exclude-tags="));
            return;
        }
        String s6 = string;
        if (s6.startsWith("--include-tags=")) {
            includeTags$1.elem = (Set)((Set)includeTags$1.elem).$plus((Object)StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(s6), "--include-tags="));
            return;
        }
        String s7 = string;
        if (s7.startsWith("--include-categories=")) {
            throw new UnsupportedOperationException("--include-categories");
        }
        String s8 = string;
        if (s8.startsWith("--exclude-categories=")) {
            throw new UnsupportedOperationException("--exclude-categories");
        }
        String s9 = string;
        if (s9.startsWith("-D") && s9.contains("=")) {
            throw new UnsupportedOperationException("-Dkey=value");
        }
        String s10 = string;
        if (!s10.startsWith("-") && !s10.startsWith("+")) {
            throw new UnsupportedOperationException(s10);
        }
    }

    private static final /* synthetic */ void parseRunSettings$$anonfun$2(BooleanRef verbose$2, BooleanRef noColor$2, BooleanRef decodeScalaNames$2, BooleanRef logAssert$2, BooleanRef notLogExceptionClass$2, BooleanRef useSbtLoggers$1, BooleanRef trimStackTraces$1, String s) {
        String string = s;
        switch (string == null ? 0 : string.hashCode()) {
            case 1403: {
                if (!"+F".equals(string)) break;
                trimStackTraces$1.elem = true;
                return;
            }
            case 1430: {
                if (!"+a".equals(string)) break;
                logAssert$2.elem = false;
                return;
            }
            case 1432: {
                if (!"+c".equals(string)) break;
                notLogExceptionClass$2.elem = false;
                return;
            }
            case 1441: {
                if (!"+l".equals(string)) break;
                useSbtLoggers$1.elem = true;
                return;
            }
            case 1443: {
                if (!"+n".equals(string)) break;
                noColor$2.elem = false;
                return;
            }
            case 1448: {
                if (!"+s".equals(string)) break;
                decodeScalaNames$2.elem = false;
                return;
            }
            case 1451: {
                if (!"+v".equals(string)) break;
                verbose$2.elem = false;
                return;
            }
            case 1465: {
                if (!"-F".equals(string)) break;
                trimStackTraces$1.elem = false;
                return;
            }
            case 1503: {
                if (!"-l".equals(string)) break;
                useSbtLoggers$1.elem = false;
                return;
            }
        }
    }
}

