/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.console;

import java.io.Serializable;
import munit.Clues;
import munit.Clues$;
import munit.Location;
import munit.diff.console.AnsiColors$;
import munit.internal.console.Printers$;
import munit.internal.io.MunitPath;
import munit.internal.io.PlatformIO$;
import munit.internal.io.PlatformIO$Files$;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnceOps;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.mutable.Map;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.sys.package$;
import scala.util.control.NonFatal$;

public class Lines
implements Serializable {
    private final Map<MunitPath, String[]> filecache = (Map)Map$.MODULE$.empty();

    public String formatPath(Location location) {
        return location.path();
    }

    public MunitPath findPath(String cwd, String path, int max) {
        MunitPath p = PlatformIO$.MODULE$.Paths().get(cwd, PlatformIO$.MODULE$.Paths().get$default$2()).resolve(path);
        if (PlatformIO$Files$.MODULE$.exists(p)) {
            return p;
        }
        if (max < 1) {
            throw package$.MODULE$.error(new StringBuilder(14).append(path).append(" was not found").toString());
        }
        if (cwd.contains("\\")) {
            return this.findPath(Lines.getParentPath$1(cwd, "\\"), path, max - 1);
        }
        return this.findPath(Lines.getParentPath$1(cwd, "/"), path, max - 1);
    }

    public String formatLine(Location location, String message, Clues clues, boolean ansi) {
        String string;
        try {
            MunitPath path = this.findPath(PlatformIO$.MODULE$.Path().workingDirectory().toString(), location.path(), 3);
            Object[] lines = (String[])this.filecache.getOrElseUpdate((Object)path, () -> Lines.$anonfun$1(path));
            Object object = Predef$.MODULE$.refArrayOps(lines);
            String[] slice = (String[])ArrayOps$.MODULE$.slice$extension(object, location.line() - 2, location.line() + 1);
            scala.collection.mutable.StringBuilder out = new scala.collection.mutable.StringBuilder();
            if (slice.length >= 2) {
                int width = BoxesRunTime.boxToInteger((int)(location.line() + 1)).toString().length() + 1;
                boolean isMultilineMessage = StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(message), '\n');
                out.append(this.formatPath(location)).append(':').append(location.line());
                if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(message)) && !isMultilineMessage) {
                    out.append(" ").append(message);
                }
                out.append('\n').append(Lines.format$1(width, location.line() - 1)).append(slice[0]).append('\n');
                AnsiColors$.MODULE$.c(AnsiColors$.MODULE$.Reversed(), ansi, (Function1 & Serializable)_$1 -> {
                    Lines.formatLine$$anonfun$1(location, slice, width, _$1);
                    return BoxedUnit.UNIT;
                }, out);
                if (slice.length >= 3) {
                    out.append('\n').append(Lines.format$1(width, location.line() + 1)).append(slice[2]);
                }
                if (isMultilineMessage) {
                    out.append('\n').append(message);
                }
                if (clues.values().nonEmpty()) {
                    out.append('\n').append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2()));
                }
            }
            string = out.toString();
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable throwable3 = (Throwable)option.get();
                string = clues.values().isEmpty() ? message : new StringBuilder(1).append(message).append("\n").append(Printers$.MODULE$.print(clues, Printers$.MODULE$.print$default$2())).toString();
            }
            throw throwable;
        }
        return string;
    }

    public Clues formatLine$default$3() {
        return Clues$.MODULE$.empty();
    }

    public boolean formatLine$default$4() {
        return true;
    }

    private static final String getParentPath$1(String somePath, String sep) {
        String somePath1 = somePath.endsWith(sep) ? StringOps$.MODULE$.dropRight$extension(Predef$.MODULE$.augmentString(somePath), sep.length()) : somePath;
        String string = sep;
        String string2 = "\\";
        String sep1 = !(string != null ? !string.equals(string2) : string2 != null) ? "\\\\" : sep;
        Object object = Predef$.MODULE$.refArrayOps((Object[])somePath1.split(sep1));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.dropRight$extension(object, 1)).mkString(sep);
    }

    private static final String[] $anonfun$1(MunitPath path$1) {
        return (String[])((IterableOnceOps)JavaConverters$.MODULE$.asScalaBufferConverter(PlatformIO$Files$.MODULE$.readAllLines(path$1)).asScala()).toArray(ClassTag$.MODULE$.apply(String.class));
    }

    private static final String format$1(int width$1, int n) {
        return StringOps$.MODULE$.padTo$extension(Predef$.MODULE$.augmentString(new StringBuilder(1).append(n).append(":").toString()), width$1, ' ');
    }

    private static final /* synthetic */ void formatLine$$anonfun$1(Location location$1, String[] slice$1, int width$2, scala.collection.mutable.StringBuilder _$1) {
        _$1.append(Lines.format$1(width$2, location$1.line())).append(slice$1[1]);
    }
}

