/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.io;

import java.io.Serializable;
import java.net.URI;
import java.util.Iterator;
import java.util.regex.Pattern;
import munit.internal.io.File;
import munit.internal.io.File$;
import munit.internal.io.JSIO$;
import munit.internal.io.MunitPath$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.JavaConverters$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Dynamic;
import scala.util.hashing.MurmurHash3$;

public class MunitPath
implements Product,
Serializable {
    private final String filename;
    private final String escapedSeparator;

    public static MunitPath apply(String string) {
        return MunitPath$.MODULE$.apply(string);
    }

    public static MunitPath fromProduct(Product product) {
        return MunitPath$.MODULE$.fromProduct(product);
    }

    public static MunitPath unapply(MunitPath munitPath) {
        return MunitPath$.MODULE$.unapply(munitPath);
    }

    public static MunitPath workingDirectory() {
        return MunitPath$.MODULE$.workingDirectory();
    }

    public MunitPath(String filename) {
        this.filename = filename;
        this.escapedSeparator = Pattern.quote(File$.MODULE$.separator());
    }

    public int hashCode() {
        return MurmurHash3$.MODULE$.productHash((Product)this, -39387196, true);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$0) {
        if (this == x$0) return true;
        Object object = x$0;
        if (!(object instanceof MunitPath)) return false;
        MunitPath munitPath = (MunitPath)object;
        String string = this.filename();
        String string2 = munitPath.filename();
        if (string == null) {
            if (string2 != null) {
                return false;
            }
        } else if (!string.equals(string2)) return false;
        if (!munitPath.canEqual(this)) return false;
        return true;
    }

    public boolean canEqual(Object that) {
        return that instanceof MunitPath;
    }

    public int productArity() {
        return 1;
    }

    public String productPrefix() {
        return "MunitPath";
    }

    public Object productElement(int n) {
        int n2 = n;
        if (0 == n2) {
            return this._1();
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String productElementName(int n) {
        int n2 = n;
        if (0 == n2) {
            return "filename";
        }
        throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
    }

    public String filename() {
        return this.filename;
    }

    private int adjustIndex(int idx) {
        if (this.isAbsolute()) {
            return idx + 1;
        }
        return idx;
    }

    public MunitPath subpath(int beginIndex, int endIndex) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.filename().split(this.escapedSeparator));
        return MunitPath$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.slice$extension(object, this.adjustIndex(beginIndex), this.adjustIndex(endIndex))).mkString());
    }

    public File toFile() {
        return new File(this.filename());
    }

    public boolean isAbsolute() {
        Option<Dynamic> option = JSIO$.MODULE$.path();
        if (option instanceof Some) {
            Dynamic path = (Dynamic)((Some)option).value();
            return BoxesRunTime.unboxToBoolean((Object)path.applyDynamic("isAbsolute", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{Any$.MODULE$.fromString(this.filename())})));
        }
        if (None$.MODULE$.equals(option)) {
            return this.filename().startsWith(File$.MODULE$.separator());
        }
        throw new MatchError(option);
    }

    public MunitPath getName(int index) {
        return MunitPath$.MODULE$.apply((String)((Option)Predef$.MODULE$.wrapRefArray((Object[])this.filename().split(this.escapedSeparator)).lift().apply((Object)BoxesRunTime.boxToInteger((int)this.adjustIndex(index)))).getOrElse(MunitPath::getName$$anonfun$1));
    }

    public MunitPath getParent() {
        Option<Dynamic> option = JSIO$.MODULE$.path();
        if (option instanceof Some) {
            Dynamic path = (Dynamic)((Some)option).value();
            return MunitPath$.MODULE$.apply((String)path.applyDynamic("dirname", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{Any$.MODULE$.fromString(this.filename())})));
        }
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedOperationException("Path.getParent() is only supported in Node.js");
        }
        throw new MatchError(option);
    }

    public MunitPath toAbsolutePath() {
        if (this.isAbsolute()) {
            return this;
        }
        return MunitPath$.MODULE$.workingDirectory().resolve(this);
    }

    public MunitPath relativize(MunitPath other) {
        Option<Dynamic> option = JSIO$.MODULE$.path();
        if (option instanceof Some) {
            Dynamic path = (Dynamic)((Some)option).value();
            return MunitPath$.MODULE$.apply((String)path.applyDynamic("relative", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{Any$.MODULE$.fromString(this.filename()), Any$.MODULE$.fromString(other.toString())})));
        }
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedOperationException("Path.relativize() is only supported in Node.js");
        }
        throw new MatchError(option);
    }

    public int getNameCount() {
        String strippeddrive = this.filename().length() > 1 && StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(this.filename()), 1) == ':' ? this.filename().substring(2) : this.filename();
        Object object = Predef$.MODULE$.refArrayOps((Object[])strippeddrive.split(new StringBuilder(1).append(this.escapedSeparator).append("+").toString()));
        Tuple2 tuple2 = ArrayOps$.MODULE$.span$extension(object, (Function1 & Serializable)_$1 -> _$1.isEmpty());
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        String[] first = (String[])tuple2._1();
        String[] remaining = (String[])tuple2._2();
        Tuple2 tuple22 = Tuple2$.MODULE$.apply((Object)first, (Object)remaining);
        String[] first2 = (String[])tuple22._1();
        Object[] remaining2 = (String[])tuple22._2();
        Object object2 = Predef$.MODULE$.refArrayOps(remaining2);
        if (ArrayOps$.MODULE$.isEmpty$extension(object2)) {
            return first2.length;
        }
        return remaining2.length;
    }

    public URI toUri() {
        return this.toFile().toURI();
    }

    public MunitPath getFileName() {
        Option<Dynamic> option = JSIO$.MODULE$.path();
        if (option instanceof Some) {
            Dynamic path = (Dynamic)((Some)option).value();
            return MunitPath$.MODULE$.apply((String)path.applyDynamic("basename", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{Any$.MODULE$.fromString(this.filename())})));
        }
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedOperationException("Path.getFileName() is only supported in Node.js");
        }
        throw new MatchError(option);
    }

    public MunitPath getRoot() {
        if (!this.isAbsolute()) {
            return null;
        }
        return MunitPath$.MODULE$.apply(File$.MODULE$.separator());
    }

    public MunitPath normalize() {
        Option<Dynamic> option = JSIO$.MODULE$.path();
        if (option instanceof Some) {
            Dynamic path = (Dynamic)((Some)option).value();
            return MunitPath$.MODULE$.apply((String)path.applyDynamic("normalize", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{Any$.MODULE$.fromString(this.filename())})));
        }
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedOperationException("Path.normalize() is only supported in Node.js");
        }
        throw new MatchError(option);
    }

    public boolean endsWith(MunitPath other) {
        return this.endsWith(other.toString());
    }

    public boolean endsWith(String other) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.paths(this.filename()));
        return ArrayOps$.MODULE$.endsWith$extension(object, (Object)this.paths(other));
    }

    private MunitPath adjustResolvedPath(MunitPath resolved) {
        if (this.isAbsolute()) {
            return resolved;
        }
        return MunitPath$.MODULE$.workingDirectory().relativize(resolved);
    }

    public MunitPath resolveSibling(MunitPath other) {
        return this.resolveSibling(other.toString());
    }

    public MunitPath resolveSibling(String other) {
        Option<Dynamic> option = JSIO$.MODULE$.path();
        if (option instanceof Some) {
            Dynamic path = (Dynamic)((Some)option).value();
            return this.adjustResolvedPath(MunitPath$.MODULE$.apply((String)path.applyDynamic("resolve", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{Any$.MODULE$.fromString((String)path.applyDynamic("dirname", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{Any$.MODULE$.fromString(this.filename())}))), Any$.MODULE$.fromString(other)}))));
        }
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedOperationException("Path.normalize() is only supported in Node.js");
        }
        throw new MatchError(option);
    }

    public MunitPath resolve(MunitPath other) {
        return this.resolve(other.toString());
    }

    public MunitPath resolve(String other) {
        Option<Dynamic> option = JSIO$.MODULE$.path();
        if (option instanceof Some) {
            Dynamic path = (Dynamic)((Some)option).value();
            return this.adjustResolvedPath(MunitPath$.MODULE$.apply((String)path.applyDynamic("resolve", (Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Any[]{Any$.MODULE$.fromString(this.filename()), Any$.MODULE$.fromString(other)}))));
        }
        if (None$.MODULE$.equals(option)) {
            throw new UnsupportedOperationException("Path.normalize() is only supported in Node.js");
        }
        throw new MatchError(option);
    }

    public boolean startsWith(MunitPath other) {
        return this.startsWith(other.toString());
    }

    public boolean startsWith(String other) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.paths(this.filename()));
        return ArrayOps$.MODULE$.startsWith$extension(object, (Object)this.paths(other));
    }

    private String[] paths(String name) {
        return name.split(this.escapedSeparator);
    }

    public String toString() {
        return this.filename();
    }

    public Iterator<MunitPath> iterator() {
        Object object = Predef$.MODULE$.refArrayOps((Object[])this.filename().split(File$.MODULE$.separator()));
        return (Iterator)JavaConverters$.MODULE$.asJavaIteratorConverter(ArrayOps$.MODULE$.iterator$extension(object).map((Function1 & Serializable)name -> MunitPath$.MODULE$.apply((String)name))).asJava();
    }

    public MunitPath copy(String filename) {
        return new MunitPath(filename);
    }

    public String copy$default$1() {
        return this.filename();
    }

    public String _1() {
        return this.filename();
    }

    private static final String getName$$anonfun$1() {
        throw new IllegalArgumentException();
    }
}

