/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.io.Serializable;
import munit.diff.console.AnsiColors$;
import munit.internal.junitinterface.JUnitEvent;
import munit.internal.junitinterface.JUnitReporter$;
import munit.internal.junitinterface.RunSettings;
import sbt.testing.Event;
import sbt.testing.EventHandler;
import sbt.testing.Logger;
import sbt.testing.OptionalThrowable;
import sbt.testing.Selector;
import sbt.testing.Status;
import sbt.testing.Status$;
import sbt.testing.SuiteSelector;
import sbt.testing.TaskDef;
import sbt.testing.TestSelector;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;

public final class JUnitReporter {
    private final EventHandler eventHandler;
    private final Logger[] loggers;
    private final RunSettings settings;
    private final TaskDef taskDef;
    private long suiteStartNanos;
    private final boolean isAnsiSupported;

    public JUnitReporter(EventHandler eventHandler, Logger[] loggers, RunSettings settings, TaskDef taskDef) {
        this.eventHandler = eventHandler;
        this.loggers = loggers;
        this.settings = settings;
        this.taskDef = taskDef;
        this.suiteStartNanos = Long.MAX_VALUE;
        Object object = Predef$.MODULE$.refArrayOps((Object[])loggers);
        this.isAnsiSupported = ArrayOps$.MODULE$.forall$extension(object, (Function1 & Serializable)_$1 -> _$1.ansiCodesSupported()) && settings.color();
    }

    private void logEvent(String method, String color, boolean fq, String prefix, String suffix, long nanos, Function1<scala.collection.mutable.StringBuilder, BoxedUnit> extra) {
        scala.collection.mutable.StringBuilder sb2 = new scala.collection.mutable.StringBuilder();
        AnsiColors$.MODULE$.c(color, true, (Function1 & Serializable)sb -> {
            this.logEvent$$anonfun$1(prefix, fq, method, suffix, (scala.collection.mutable.StringBuilder)sb);
            return BoxedUnit.UNIT;
        }, sb2);
        if (nanos >= 0L) {
            sb2.append(' ');
            AnsiColors$.MODULE$.c(AnsiColors$.MODULE$.DarkGrey(), true, (Function1 & Serializable)_$2 -> {
                _$2.append(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("%.3fs"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToDouble((double)((double)nanos / 1.0E9))})));
                return BoxedUnit.UNIT;
            }, sb2);
        }
        if (extra != null) {
            extra.apply((Object)sb2.append(' '));
        }
        this.log(JUnitReporter$.munit$internal$junitinterface$JUnitReporter$$$Info, sb2.toString());
    }

    private String logEvent$default$2() {
        return null;
    }

    private boolean logEvent$default$3() {
        return false;
    }

    private String logEvent$default$4(String method, String color, boolean fq) {
        return "";
    }

    private String logEvent$default$5(String method, String color, boolean fq) {
        return "";
    }

    private long logEvent$default$6(String method, String color, boolean fq) {
        return -1L;
    }

    private Function1<scala.collection.mutable.StringBuilder, BoxedUnit> logEvent$default$7(String method, String color, boolean fq) {
        return null;
    }

    public void reportTestSuiteStarted() {
        this.suiteStartNanos = System.nanoTime();
        String string = AnsiColors$.MODULE$.GREEN();
        this.logEvent("", string, true, this.logEvent$default$4("", string, true), ":", this.logEvent$default$6("", string, true), this.logEvent$default$7("", string, true));
    }

    public void reportTestSuiteError(Throwable ex) {
        String string = AnsiColors$.MODULE$.LightRed();
        String string2 = "==> X";
        Function1 & Serializable intersect = (Function1 & Serializable)_$3 -> {
            JUnitReporter.$anonfun$1(ex, _$3);
            return BoxedUnit.UNIT;
        };
        String string3 = this.logEvent$default$5("", string, true);
        long l = this.logEvent$default$6("", string, true);
        this.logEvent("", string, true, string2, string3, l, (Function1<scala.collection.mutable.StringBuilder, BoxedUnit>)intersect);
        this.emitEvent("", Status$.MODULE$.Error(), (Option<Throwable>)Option$.MODULE$.apply((Object)ex), 0L);
    }

    public void reportTestStarted(String method) {
        if (this.settings.verbose()) {
            String string = this.logEvent$default$2();
            boolean bl = this.logEvent$default$3();
            this.logEvent(method, string, bl, this.logEvent$default$4(method, string, bl), " started", this.logEvent$default$6(method, string, bl), this.logEvent$default$7(method, string, bl));
            return;
        }
    }

    public void reportTestIgnored(String method, String suffix) {
        String suffixed = suffix.isEmpty() ? "" : new StringBuilder(1).append(" ").append(suffix).toString();
        String string = AnsiColors$.MODULE$.YELLOW();
        boolean bl = this.logEvent$default$3();
        this.logEvent(method, string, bl, "==> i", new StringBuilder(8).append(suffixed).append(" ignored").toString(), System.nanoTime() - this.suiteStartNanos, this.logEvent$default$7(method, string, bl));
        this.emitEvent(method, Status$.MODULE$.Ignored(), (Option<Throwable>)None$.MODULE$, 0L);
    }

    public void reportAssumptionViolation(String method, Throwable e) {
        String string = AnsiColors$.MODULE$.YELLOW();
        boolean bl = this.logEvent$default$3();
        this.logEvent(method, string, bl, "==> s", " skipped", this.logEvent$default$6(method, string, bl), this.logEvent$default$7(method, string, bl));
        this.emitEvent(method, Status$.MODULE$.Skipped(), (Option<Throwable>)Option$.MODULE$.apply((Object)e), 0L);
    }

    public void reportTestPassed(String method, long elapsedNanos) {
        String string = AnsiColors$.MODULE$.GREEN();
        boolean bl = this.logEvent$default$3();
        this.logEvent(method, string, bl, "  +", this.logEvent$default$5(method, string, bl), elapsedNanos, this.logEvent$default$7(method, string, bl));
        this.emitEvent(method, Status$.MODULE$.Success(), (Option<Throwable>)None$.MODULE$, elapsedNanos);
    }

    public void reportTestFailed(String method, Throwable ex, long elapsedNanos) {
        String string = AnsiColors$.MODULE$.LightRed();
        String string2 = "==> X";
        Function1 & Serializable intersect = (Function1 & Serializable)_$4 -> {
            JUnitReporter.$anonfun$2(ex, _$4);
            return BoxedUnit.UNIT;
        };
        String string3 = this.logEvent$default$5(method, string, true);
        this.logEvent(method, string, true, string2, string3, elapsedNanos, (Function1<scala.collection.mutable.StringBuilder, BoxedUnit>)intersect);
        this.emitEvent(method, Status$.MODULE$.Failure(), (Option<Throwable>)Option$.MODULE$.apply((Object)ex), elapsedNanos);
    }

    private void trace(Throwable t) {
        if (!(t instanceof AssertionError) || this.settings.logAssert()) {
            this.logTrace(t);
            return;
        }
    }

    private void emitEvent(String method, Status status, Option<Throwable> throwable, long elapsedNanos) {
        Tuple2 tuple2;
        String suite = this.taskDef.fullyQualifiedName();
        if (method.isEmpty()) {
            tuple2 = Tuple2$.MODULE$.apply((Object)suite, (Object)new SuiteSelector());
        } else {
            String name = new StringBuilder(1).append(suite).append(".").append(this.settings.decodeName(method)).toString();
            tuple2 = Tuple2$.MODULE$.apply((Object)name, (Object)new TestSelector(name));
        }
        Tuple2 tuple22 = tuple2;
        String testName = (String)tuple22._1();
        Selector selector = (Selector)tuple22._2();
        this.eventHandler.handle((Event)new JUnitEvent(this.taskDef, testName, status, selector, new OptionalThrowable((Throwable)throwable.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl())), elapsedNanos / 1000000L));
    }

    private void log(int level, String s) {
        if (this.settings.useSbtLoggers()) {
            Object object = Predef$.MODULE$.refArrayOps((Object[])this.loggers);
            ArrayOps$.MODULE$.foreach$extension(object, (Function1 & Serializable)l -> {
                this.log$$anonfun$1(s, level, (Logger)l);
                return BoxedUnit.UNIT;
            });
            return;
        }
        int n = level;
        if (JUnitReporter$.munit$internal$junitinterface$JUnitReporter$$$Debug == n || JUnitReporter$.munit$internal$junitinterface$JUnitReporter$$$Trace == n) {
            if (!this.settings.verbose()) {
                return;
            }
        }
        Predef$.MODULE$.println((Object)this.filterAnsiIfNeeded(this.isAnsiSupported, s));
    }

    private String filterAnsiIfNeeded(Logger l, String s) {
        return this.filterAnsiIfNeeded(l.ansiCodesSupported(), s);
    }

    private String filterAnsiIfNeeded(boolean isColorSupported, String s) {
        if (isColorSupported && this.settings.color()) {
            return s;
        }
        return AnsiColors$.MODULE$.filterAnsi(s);
    }

    private void logTrace(Throwable t) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])t.getStackTrace());
        Object[] trace = (StackTraceElement[])ArrayOps$.MODULE$.dropWhile$extension(object, (Function1 & Serializable)p -> p.getFileName() != null && (p.getFileName().contains("StackTrace.scala") || p.getFileName().contains("Throwables.scala")));
        String testFileName = this.settings.color() ? this.findTestFileName((StackTraceElement[])trace) : null;
        Object object2 = Predef$.MODULE$.refArrayOps(trace);
        int i = ArrayOps$.MODULE$.indexWhere$extension(object2, (Function1 & Serializable)p -> p.getFileName() != null && p.getFileName().contains("JUnitExecuteTest.scala"), ArrayOps$.MODULE$.indexWhere$default$2$extension(object2)) - 1;
        int m = i > 0 ? i : trace.length - 1;
        this.logStackTracePart((StackTraceElement[])trace, m, trace.length - m - 1, t, testFileName);
    }

    private void logStackTracePart(StackTraceElement[] trace, int m, int framesInCommon, Throwable t, String testFileName) {
        int top;
        int m0 = m;
        int m2 = m;
        for (int i = top = 0; i <= m2; ++i) {
            if (!trace[i].toString().startsWith("org.junit.") && !trace[i].toString().startsWith("org.hamcrest.")) continue;
            if (i == top) {
                ++top;
                continue;
            }
            m2 = i - 1;
            boolean bl = false;
            while (m2 > top && !bl) {
                String s = trace[m2].toString();
                if (!s.startsWith("java.lang.reflect.") && !s.startsWith("sun.reflect.")) {
                    bl = true;
                    continue;
                }
                --m2;
            }
            i = m2;
        }
        RichInt$.MODULE$.to$extension(Predef$.MODULE$.intWrapper(top), m2).foreach((Function1 & Serializable)v1 -> {
            this.logStackTracePart$$anonfun$1(trace, testFileName, BoxesRunTime.unboxToInt((Object)v1));
            return BoxedUnit.UNIT;
        });
        if (m0 != m2) {
            this.log(JUnitReporter$.munit$internal$junitinterface$JUnitReporter$$$Error, "    ...");
        } else if (framesInCommon != 0) {
            this.log(JUnitReporter$.munit$internal$junitinterface$JUnitReporter$$$Error, new StringBuilder(13).append("    ... ").append(framesInCommon).append(" more").toString());
        }
        this.logStackTraceAsCause(trace, t.getCause(), testFileName);
    }

    private void logStackTraceAsCause(StackTraceElement[] causedTrace, Throwable t, String testFileName) {
        if (t != null) {
            StackTraceElement[] trace = t.getStackTrace();
            int m = trace.length - 1;
            for (int n = causedTrace.length - 1; m >= 0 && n >= 0; --m, --n) {
                StackTraceElement stackTraceElement = trace[m];
                StackTraceElement stackTraceElement2 = causedTrace[n];
                if (stackTraceElement != null ? !((Object)stackTraceElement).equals(stackTraceElement2) : stackTraceElement2 != null) break;
            }
            this.log(JUnitReporter$.munit$internal$junitinterface$JUnitReporter$$$Error, new StringBuilder(11).append("Caused by: ").append(t).toString());
            this.logStackTracePart(trace, m, trace.length - 1 - m, t, testFileName);
            return;
        }
    }

    private String findTestFileName(StackTraceElement[] trace) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])trace);
        return (String)ArrayOps$.MODULE$.find$extension(object, (Function1 & Serializable)_$5 -> {
            String string = _$5.getClassName();
            String string2 = this.taskDef.fullyQualifiedName();
            return !(string != null ? !string.equals(string2) : string2 != null);
        }).map((Function1 & Serializable)_$6 -> _$6.getFileName()).orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
    }

    private String stackTraceElementToString(StackTraceElement e, String testFileName) {
        String string;
        boolean highlight = this.settings.color() && e.getFileName() != null && e.getFileName().contains("file:/");
        boolean canHighlight = true;
        scala.collection.mutable.StringBuilder stringBuilder = new scala.collection.mutable.StringBuilder().append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset())).append(!canHighlight ? "" : (highlight ? AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Bold()) : AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.DarkGrey()))).append("    at ").append(this.settings.decodeName(new StringBuilder(11).append(e.getClassName()).append('.').append(e.getMethodName()).toString())).append('(');
        if (e.isNativeMethod()) {
            string = "Native Method";
        } else if (e.getFileName() == null) {
            string = "Unknown Source";
        } else {
            int file = e.getFileName().indexOf("file:/");
            int https = file >= 0 ? file : e.getFileName().indexOf("https:/");
            String filename = https >= 0 ? e.getFileName().substring(https) : e.getFileName();
            string = e.getLineNumber() >= 0 ? new StringBuilder(1).append(filename).append(":").append(e.getLineNumber()).toString() : filename;
        }
        return stringBuilder.append(string).append(')').append(AnsiColors$.MODULE$.use(AnsiColors$.MODULE$.Reset())).toString();
    }

    private final /* synthetic */ void logEvent$$anonfun$1(String prefix$3, boolean fq$5, String method$1, String suffix$3, scala.collection.mutable.StringBuilder sb) {
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(prefix$3))) {
            sb.append(prefix$3).append(' ');
        }
        if (fq$5) {
            sb.append(this.taskDef.fullyQualifiedName());
            if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(method$1))) {
                sb.append('.');
            }
        }
        sb.append(method$1).append(suffix$3);
    }

    private static final /* synthetic */ void $anonfun$1(Throwable ex$1, scala.collection.mutable.StringBuilder _$3) {
        _$3.append(ex$1.getClass().getName()).append(": ").append(ex$1.getMessage());
    }

    private static final /* synthetic */ void $anonfun$2(Throwable ex$2, scala.collection.mutable.StringBuilder _$4) {
        _$4.append(ex$2.getClass().getName()).append(": ").append(ex$2.getMessage());
    }

    private final /* synthetic */ void log$$anonfun$1(String s$1, int level$1, Logger l) {
        String msg = this.filterAnsiIfNeeded(l, s$1);
        int n = level$1;
        if (JUnitReporter$.munit$internal$junitinterface$JUnitReporter$$$Debug == n) {
            l.debug(msg);
            return;
        }
        if (JUnitReporter$.munit$internal$junitinterface$JUnitReporter$$$Info == n) {
            l.info(msg);
            return;
        }
        if (JUnitReporter$.munit$internal$junitinterface$JUnitReporter$$$Warn == n) {
            l.warn(msg);
            return;
        }
        if (JUnitReporter$.munit$internal$junitinterface$JUnitReporter$$$Error == n) {
            l.error(msg);
            return;
        }
        l.error(msg);
    }

    private final /* synthetic */ void logStackTracePart$$anonfun$1(StackTraceElement[] trace$1, String testFileName$1, int i) {
        this.log(JUnitReporter$.munit$internal$junitinterface$JUnitReporter$$$Error, this.stackTraceElementToString(trace$1[i], testFileName$1));
    }
}

