/*
 * Decompiled with CFR 0.152.
 */
package munit.internal.junitinterface;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import munit.Tag;
import munit.internal.junitinterface.JUnitReporter;
import munit.package;
import munit.package$;
import org.junit.runner.Description;
import org.junit.runner.notification.Failure;
import org.junit.runner.notification.RunNotifier;
import scala.Function1;
import scala.PartialFunction;
import scala.collection.IterableOnce;
import scala.collection.immutable.List;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;

public class MUnitRunNotifier
implements RunNotifier {
    private final JUnitReporter reporter;
    private long startedTimestamp;
    private final Set isReported;

    public MUnitRunNotifier(JUnitReporter reporter) {
        this.reporter = reporter;
        this.startedTimestamp = 0L;
        this.isReported = (Set)Set$.MODULE$.empty();
    }

    public long startedTimestamp() {
        return this.startedTimestamp;
    }

    public void startedTimestamp_$eq(long x$1) {
        this.startedTimestamp = x$1;
    }

    public Set<Description> isReported() {
        return this.isReported;
    }

    @Override
    public void fireTestSuiteStarted(Description description) {
        this.reporter.reportTestSuiteStarted();
    }

    @Override
    public void fireTestStarted(Description description) {
        this.startedTimestamp_$eq(System.nanoTime());
        this.reporter.reportTestStarted(description.getMethodName());
    }

    private long elapsedNanos() {
        return System.nanoTime() - this.startedTimestamp();
    }

    @Override
    public void fireTestIgnored(Description description) {
        this.isReported().$plus$eq((Object)description);
        List<Annotation> annotations = description.getAnnotations();
        List isPending = (List)annotations.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Annotation x) {
                Annotation annotation = x;
                Tag tag = package$.MODULE$.Pending();
                Annotation annotation2 = annotation;
                return !(tag != null ? !((Object)tag).equals(annotation2) : annotation2 != null);
            }

            public final Object applyOrElse(Annotation x, Function1 function1) {
                Annotation annotation = x;
                Tag tag = package$.MODULE$.Pending();
                Annotation annotation2 = annotation;
                if (!(tag != null ? !((Object)tag).equals(annotation2) : annotation2 != null)) {
                    return "PENDING";
                }
                return function1.apply((Object)x);
            }
        }).distinct();
        List pendingComments = annotations.collect((PartialFunction)new Serializable(){

            public final boolean isDefinedAt(Annotation x) {
                Annotation annotation = x;
                if (annotation instanceof package.PendingComment) {
                    package.PendingComment tag = (package.PendingComment)annotation;
                    return true;
                }
                return false;
            }

            public final Object applyOrElse(Annotation x, Function1 function1) {
                Annotation annotation = x;
                if (annotation instanceof package.PendingComment) {
                    package.PendingComment tag = (package.PendingComment)annotation;
                    return tag.value();
                }
                return function1.apply((Object)x);
            }
        });
        List pendingSuffixes = (List)isPending.$plus$plus((IterableOnce)pendingComments);
        this.reporter.reportTestIgnored(description.getMethodName(), pendingSuffixes.mkString(" "));
    }

    @Override
    public void fireTestAssumptionFailed(Failure failure) {
        this.isReported().$plus$eq((Object)failure.description());
        this.reporter.reportAssumptionViolation(failure.description().getMethodName(), failure.ex());
    }

    @Override
    public void fireTestFailure(Failure failure) {
        String methodName = failure.description().getMethodName();
        this.isReported().$plus$eq((Object)failure.description());
        this.reporter.reportTestFailed(methodName, failure.ex(), this.elapsedNanos());
    }

    @Override
    public void fireTestFinished(Description description) {
        String methodName = description.getMethodName();
        if (!this.isReported().apply((Object)description)) {
            this.reporter.reportTestPassed(methodName, this.elapsedNanos());
            return;
        }
    }

    @Override
    public void fireTestSuiteFinished(Description description) {
    }
}

