/*
 * Decompiled with CFR 0.152.
 */
package munit.sbtmunit;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import munit.sbtmunit.MUnitReportListener;
import munit.sbtmunit.MUnitTestReport;
import munit.sbtmunit.MUnitTestReport$Group$;
import munit.sbtmunit.MUnitTestReport$Summary$;
import munit.sbtmunit.MUnitTestReport$TestEvent$;
import munit.sbtmunit.MUnitTestReport$TestException$;
import sbt.TestEvent;
import sbt.TestReportListener;
import sbt.TestsListener;
import sbt.package$;
import sbt.protocol.testing.TestResult;
import sbt.testing.Event;
import sbt.testing.Status;
import scala.Array$;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option$;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.reflect.ClassTag$;

public class MUnitTestsListener
implements TestReportListener,
TestsListener {
    private final MUnitReportListener listener;
    private final String repository;
    private final String ref;
    private final String sha;
    private final String scalaVersion;
    private final String projectName;
    private final ConcurrentHashMap<String, ConcurrentLinkedQueue<TestEvent>> groups;
    private volatile String currentGroup;
    private final SimpleDateFormat ISO_8601;

    public MUnitTestsListener(MUnitReportListener listener, String repository, String reportName, String ref, String sha, String scalaVersion, String projectName) {
        this.listener = listener;
        this.repository = repository;
        this.ref = ref;
        this.sha = sha;
        this.scalaVersion = scalaVersion;
        this.projectName = projectName;
        this.groups = new ConcurrentHashMap();
        this.currentGroup = "unknown";
        this.ISO_8601 = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ", Locale.US);
    }

    public void startGroup(String name) {
        this.currentGroup = name;
    }

    public void testEvent(TestEvent event) {
        ConcurrentLinkedQueue group = this.groups.computeIfAbsent(this.currentGroup, _$1 -> new ConcurrentLinkedQueue());
        group.add(event);
    }

    public void endGroup(String name, Throwable t) {
    }

    public void endGroup(String name, TestResult result) {
    }

    public void doInit() {
        this.groups.clear();
    }

    public void doComplete(TestResult finalResult) {
        this.listener.onReport(this.newReport(finalResult));
    }

    public SimpleDateFormat ISO_8601() {
        return this.ISO_8601;
    }

    private MUnitTestReport.Summary newReport(TestResult testResult) {
        return MUnitTestReport$Summary$.MODULE$.apply(this.repository, this.ref, this.sha, this.ISO_8601().format(new Date()), this.scalaVersion, this.projectName, System.getProperty("java.version"), System.getProperty("os.name"), (MUnitTestReport.Group[])((IterableOnce)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(this.groups).asScala()).iterator().map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                String group = (String)tuple2._1();
                ConcurrentLinkedQueue events = (ConcurrentLinkedQueue)tuple2._2();
                return MUnitTestReport$Group$.MODULE$.apply(group, this.overallResult((Iterable<TestEvent>)((Iterable)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)events).asScala())).toString(), (MUnitTestReport.TestEvent[])((IterableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter((Collection)events).asScala()).iterator().flatMap((Function1 & Serializable)_$2 -> _$2.detail()).map((Function1 & Serializable)event -> this.newTestEvent((Event)event)).toArray(ClassTag$.MODULE$.apply(MUnitTestReport.TestEvent.class)));
            }
            throw new MatchError((Object)tuple2);
        }).toArray(ClassTag$.MODULE$.apply(MUnitTestReport.Group.class)));
    }

    private MUnitTestReport.TestEvent newTestEvent(Event event) {
        return MUnitTestReport$TestEvent$.MODULE$.apply(event.status().toString(), event.fullyQualifiedName(), event.duration(), event.throwable().isEmpty() ? null : this.newTestException(event.throwable().get()));
    }

    private MUnitTestReport.TestException newTestException(Throwable ex) {
        Tuple2 tuple2;
        String plainClassName;
        if (ex == null) {
            return null;
        }
        String plainMessage = (String)Option$.MODULE$.apply((Object)ex.getMessage()).map((Function1 & Serializable)s -> this.filterAnsi((String)s)).getOrElse(MUnitTestsListener::$anonfun$3);
        String string = plainClassName = ex.getClass().getName();
        String string2 = "sbt.ForkMain$ForkError";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            boolean customClassNameHasSpace;
            int colon2 = plainMessage.indexOf(": ");
            int space = plainMessage.indexOf(32);
            boolean bl = customClassNameHasSpace = space >= 0 && space < colon2;
            tuple2 = colon2 < 0 || customClassNameHasSpace ? Tuple2$.MODULE$.apply((Object)plainClassName, (Object)plainMessage) : Tuple2$.MODULE$.apply((Object)plainMessage.substring(0, colon2), (Object)plainMessage.substring(colon2 + 2));
        } else {
            tuple2 = Tuple2$.MODULE$.apply((Object)plainClassName, (Object)plainMessage);
        }
        Tuple2 tuple22 = tuple2;
        String className = (String)tuple22._1();
        String message = (String)tuple22._2();
        Object object = Predef$.MODULE$.refArrayOps((Object[])Option$.MODULE$.apply((Object)ex.getStackTrace()).getOrElse(MUnitTestsListener::newTestException$$anonfun$1));
        return MUnitTestReport$TestException$.MODULE$.apply(className, message, (String[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$3 -> _$3.toString(), ClassTag$.MODULE$.apply(String.class)), this.newTestException(ex.getCause()));
    }

    private String filterAnsi(String s) {
        if (s == null) {
            return null;
        }
        String r = "";
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            char c = s.charAt(i);
            if (c == '\u001b') {
                ++i;
                while (i < len && s.charAt(i) != 'm') {
                    ++i;
                }
                continue;
            }
            r = new StringBuilder(0).append(r).append(c).toString();
        }
        return r;
    }

    private TestResult overallResult(Iterable<TestEvent> events) {
        Iterator iterator = events.iterator().flatMap((Function1 & Serializable)_$4 -> _$4.detail());
        package$.MODULE$.TestResult();
        return (TestResult)iterator.foldLeft((Object)TestResult.Passed$.MODULE$, (Function2 & Serializable)(sum, event) -> {
            TestResult.Passed$ passed$;
            Tuple2 tuple2 = Tuple2$.MODULE$.apply(sum, (Object)event.status());
            if (tuple2 != null) {
                TestResult testResult = (TestResult)tuple2._1();
                Status status = (Status)tuple2._2();
                package$.MODULE$.TestResult();
                if (TestResult.Error$.MODULE$.equals(testResult)) {
                    package$.MODULE$.TestResult();
                    passed$ = TestResult.Error$.MODULE$;
                    return (TestResult)passed$;
                }
                Status status2 = Status.Error;
                Status status3 = status;
                if (!(status2 != null ? !status2.equals(status3) : status3 != null)) {
                    package$.MODULE$.TestResult();
                    passed$ = TestResult.Error$.MODULE$;
                    return (TestResult)passed$;
                }
                package$.MODULE$.TestResult();
                if (TestResult.Failed$.MODULE$.equals(testResult)) {
                    package$.MODULE$.TestResult();
                    passed$ = TestResult.Failed$.MODULE$;
                    return (TestResult)passed$;
                }
                Status status4 = Status.Failure;
                Status status5 = status;
                if (!(status4 != null ? !status4.equals(status5) : status5 != null)) {
                    package$.MODULE$.TestResult();
                    passed$ = TestResult.Failed$.MODULE$;
                    return (TestResult)passed$;
                }
            }
            package$.MODULE$.TestResult();
            passed$ = TestResult.Passed$.MODULE$;
            return (TestResult)passed$;
        });
    }

    private static final String $anonfun$3() {
        return "";
    }

    private static final StackTraceElement[] newTestException$$anonfun$1() {
        return (StackTraceElement[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(StackTraceElement.class));
    }
}

