/*
 * Decompiled with CFR 0.152.
 */
package com.google.protobuf;

import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.FieldSet;
import com.google.protobuf.MapFieldLite;
import com.google.protobuf.MessageLite;
import com.google.protobuf.WireFormat;
import java.io.IOException;
import java.util.AbstractMap;
import java.util.Map;

public class MapEntryLite<K, V> {
    private static final int KEY_FIELD_NUMBER = 1;
    private static final int VALUE_FIELD_NUMBER = 2;
    private final Metadata<K, V> metadata;
    private final K key;
    private final V value;

    private MapEntryLite(WireFormat.FieldType keyType2, K defaultKey, WireFormat.FieldType valueType2, V defaultValue2) {
        this.metadata = new Metadata<K, V>(keyType2, defaultKey, valueType2, defaultValue2);
        this.key = defaultKey;
        this.value = defaultValue2;
    }

    private MapEntryLite(Metadata<K, V> metadata, K key2, V value2) {
        this.metadata = metadata;
        this.key = key2;
        this.value = value2;
    }

    public K getKey() {
        return this.key;
    }

    public V getValue() {
        return this.value;
    }

    public static <K, V> MapEntryLite<K, V> newDefaultInstance(WireFormat.FieldType keyType2, K defaultKey, WireFormat.FieldType valueType2, V defaultValue2) {
        return new MapEntryLite<K, V>(keyType2, defaultKey, valueType2, defaultValue2);
    }

    static <K, V> void writeTo(CodedOutputStream output, Metadata<K, V> metadata, K key2, V value2) throws IOException {
        FieldSet.writeElement(output, metadata.keyType, 1, key2);
        FieldSet.writeElement(output, metadata.valueType, 2, value2);
    }

    static <K, V> int computeSerializedSize(Metadata<K, V> metadata, K key2, V value2) {
        return FieldSet.computeElementSize(metadata.keyType, 1, key2) + FieldSet.computeElementSize(metadata.valueType, 2, value2);
    }

    static <T> T parseField(CodedInputStream input, ExtensionRegistryLite extensionRegistry, WireFormat.FieldType type2, T value2) throws IOException {
        switch (type2) {
            case MESSAGE: {
                MessageLite.Builder subBuilder = ((MessageLite)value2).toBuilder();
                input.readMessage(subBuilder, extensionRegistry);
                return (T)subBuilder.buildPartial();
            }
            case ENUM: {
                return (T)Integer.valueOf(input.readEnum());
            }
            case GROUP: {
                throw new RuntimeException("Groups are not allowed in maps.");
            }
        }
        return (T)FieldSet.readPrimitiveField(input, type2, true);
    }

    public void serializeTo(CodedOutputStream output, int fieldNumber, K key2, V value2) throws IOException {
        output.writeTag(fieldNumber, 2);
        output.writeUInt32NoTag(MapEntryLite.computeSerializedSize(this.metadata, key2, value2));
        MapEntryLite.writeTo(output, this.metadata, key2, value2);
    }

    public int computeMessageSize(int fieldNumber, K key2, V value2) {
        return CodedOutputStream.computeTagSize(fieldNumber) + CodedOutputStream.computeLengthDelimitedFieldSize(MapEntryLite.computeSerializedSize(this.metadata, key2, value2));
    }

    public Map.Entry<K, V> parseEntry(ByteString bytes, ExtensionRegistryLite extensionRegistry) throws IOException {
        return MapEntryLite.parseEntry(bytes.newCodedInput(), this.metadata, extensionRegistry);
    }

    static <K, V> Map.Entry<K, V> parseEntry(CodedInputStream input, Metadata<K, V> metadata, ExtensionRegistryLite extensionRegistry) throws IOException {
        int tag;
        Object key2 = metadata.defaultKey;
        Object value2 = metadata.defaultValue;
        while ((tag = input.readTag()) != 0) {
            if (tag == WireFormat.makeTag(1, metadata.keyType.getWireType())) {
                key2 = MapEntryLite.parseField(input, extensionRegistry, metadata.keyType, key2);
                continue;
            }
            if (tag == WireFormat.makeTag(2, metadata.valueType.getWireType())) {
                value2 = MapEntryLite.parseField(input, extensionRegistry, metadata.valueType, value2);
                continue;
            }
            if (input.skipField(tag)) continue;
            break;
        }
        return new AbstractMap.SimpleImmutableEntry(key2, value2);
    }

    public void parseInto(MapFieldLite<K, V> map, CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        int tag;
        int length = input.readRawVarint32();
        int oldLimit = input.pushLimit(length);
        Object key2 = this.metadata.defaultKey;
        Object value2 = this.metadata.defaultValue;
        while ((tag = input.readTag()) != 0) {
            if (tag == WireFormat.makeTag(1, this.metadata.keyType.getWireType())) {
                key2 = MapEntryLite.parseField(input, extensionRegistry, this.metadata.keyType, key2);
                continue;
            }
            if (tag == WireFormat.makeTag(2, this.metadata.valueType.getWireType())) {
                value2 = MapEntryLite.parseField(input, extensionRegistry, this.metadata.valueType, value2);
                continue;
            }
            if (input.skipField(tag)) continue;
            break;
        }
        input.checkLastTagWas(0);
        input.popLimit(oldLimit);
        map.put(key2, value2);
    }

    Metadata<K, V> getMetadata() {
        return this.metadata;
    }

    static class Metadata<K, V> {
        public final WireFormat.FieldType keyType;
        public final K defaultKey;
        public final WireFormat.FieldType valueType;
        public final V defaultValue;

        public Metadata(WireFormat.FieldType keyType2, K defaultKey, WireFormat.FieldType valueType2, V defaultValue2) {
            this.keyType = keyType2;
            this.defaultKey = defaultKey;
            this.valueType = valueType2;
            this.defaultValue = defaultValue2;
        }
    }
}

