/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.syntactic.parsers;

import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.Seq;
import scala.meta.syntactic.parsers.Chars$;
import scala.meta.syntactic.parsers.TokenData;
import scala.runtime.BoxesRunTime;
import scala.util.Try;
import scala.util.Try$;

public abstract class TokenData$class {
    public static TokenData copyFrom(TokenData $this, TokenData td) {
        $this.token_$eq(td.token());
        $this.offset_$eq(td.offset());
        $this.lastOffset_$eq(td.lastOffset());
        $this.endOffset_$eq(td.endOffset());
        $this.name_$eq(td.name());
        $this.strVal_$eq(td.strVal());
        $this.base_$eq(td.base());
        return $this;
    }

    public static String toString(TokenData $this) {
        return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"{token = ", ", position = ", "..", ", lastOffset = ", ", name = ", ", strVal = ", ", base = ", "}"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)$this.token()), BoxesRunTime.boxToInteger((int)$this.offset()), BoxesRunTime.boxToInteger((int)$this.endOffset()), BoxesRunTime.boxToInteger((int)$this.lastOffset()), $this.name(), $this.strVal(), BoxesRunTime.boxToInteger((int)$this.base())}));
    }

    public static char charVal(TokenData $this) {
        return $this.strVal().length() > 0 ? $this.strVal().charAt(0) : (char)'\u0000';
    }

    public static Try intVal(TokenData $this, boolean negated) {
        return Try$.MODULE$.apply((Function0)new Serializable($this, negated){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ TokenData $outer;
            public final boolean negated$1;

            public final long apply() {
                return TokenData$class.inner$1(this.$outer, this.negated$1);
            }

            public long apply$mcJ$sp() {
                return TokenData$class.inner$1(this.$outer, this.negated$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.negated$1 = negated$1;
            }
        });
    }

    public static Try floatVal(TokenData $this, boolean negated) {
        return Try$.MODULE$.apply((Function0)new Serializable($this, negated){
            public static final long serialVersionUID = 0L;
            public final /* synthetic */ TokenData $outer;
            public final boolean negated$2;

            public final double apply() {
                return TokenData$class.inner$2(this.$outer, this.negated$2);
            }

            public double apply$mcD$sp() {
                return TokenData$class.inner$2(this.$outer, this.negated$2);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.negated$2 = negated$2;
            }
        });
    }

    public static final long inner$1(TokenData $this, boolean negated$1) {
        long l;
        if ($this.token() == 1 && !negated$1) {
            l = $this.charVal();
        } else {
            String input = $this.strVal();
            if (input.startsWith("0x") || input.startsWith("0X")) {
                input = input.substring(2);
            }
            if (input.endsWith("l") || input.endsWith("L")) {
                input = input.substring(0, input.length() - 1);
            }
            long value = 0L;
            int divider = $this.base() == 10 ? 1 : 2;
            long limit = $this.token() == 3 ? Long.MAX_VALUE : Integer.MAX_VALUE;
            int len = input.length();
            for (int i = 0; i < len; ++i) {
                int d = Chars$.MODULE$.digit2int(input.charAt(i), $this.base());
                if (d < 0) {
                    throw new Exception("malformed integer number");
                }
                if (value < 0L || limit / (long)($this.base() / divider) < value || limit - (long)(d / divider) < value * (long)($this.base() / divider) && (!negated$1 || limit != value * (long)$this.base() - 1L + (long)d)) {
                    throw new Exception("integer number too large");
                }
                value = value * (long)$this.base() + (long)d;
            }
            l = negated$1 ? -value : value;
        }
        return l;
    }

    private static final boolean isDeprecatedForm$1(TokenData $this) {
        int idx = $this.strVal().indexOf(46);
        return idx == $this.strVal().length() - 1 || idx >= 0 && idx + 1 < $this.strVal().length() && !Character.isDigit($this.strVal().charAt(idx + 1));
    }

    public static final double inner$2(TokenData $this, boolean negated$2) {
        double limit = $this.token() == 5 ? Double.MAX_VALUE : 3.4028234663852886E38;
        double value = Double.valueOf($this.strVal());
        if (value > limit) {
            throw new Exception("floating point number too large");
        }
        if (TokenData$class.isDeprecatedForm$1($this)) {
            throw new Exception("floating point number is missing digit after dot");
        }
        return negated$2 ? -value : value;
    }

    public static void $init$(TokenData $this) {
        $this.token_$eq(-3);
        $this.offset_$eq(0);
        $this.lastOffset_$eq(0);
        $this.endOffset_$eq(0);
        $this.name_$eq(null);
        $this.strVal_$eq(null);
        $this.base_$eq(0);
    }
}

