/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.contrib;

import java.io.Serializable;
import org.scalameta.logger$;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.IterableOnceOps;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.meta.Dialect$;
import scala.meta.Tree;
import scala.meta.contrib.AssociatedComments$;
import scala.meta.package$;
import scala.meta.tokens.Token;
import scala.meta.tokens.Token$;
import scala.meta.tokens.Tokens;

public abstract class AssociatedComments {
    private final Map<Token, List<Token.Comment>> leadingMap;
    private final Map<Token, List<Token.Comment>> trailingMap;

    public static AssociatedComments apply(Tokens tokens) {
        return AssociatedComments$.MODULE$.apply(tokens);
    }

    public static AssociatedComments apply(Tree tree) {
        return AssociatedComments$.MODULE$.apply(tree);
    }

    public AssociatedComments(Map<Token, List<Token.Comment>> leadingMap, Map<Token, List<Token.Comment>> trailingMap) {
        this.leadingMap = leadingMap;
        this.trailingMap = trailingMap;
    }

    private String pretty(Map<Token, List<Token.Comment>> map) {
        return ((IterableOnceOps)map.map((Function1 & Serializable)x$1 -> {
            Tuple2 tuple2 = x$1;
            if (tuple2 != null) {
                Token tok = (Token)tuple2._1();
                List comments = (List)tuple2._2();
                List commentStructure = comments.map((Function1 & Serializable)comment -> logger$.MODULE$.revealWhitespace(package$.MODULE$.XtensionSyntax(comment, Token$.MODULE$.showSyntax(Dialect$.MODULE$.current())).syntax()));
                return new StringBuilder(8).append("    ").append(package$.MODULE$.XtensionStructure(tok, Token$.MODULE$.showStructure()).structure()).append(" => ").append(commentStructure).toString();
            }
            throw new MatchError((Object)tuple2);
        })).mkString("\n");
    }

    public String syntax() {
        return StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString(new StringBuilder(104).append("|AssociatedComments(\n        |  Leading =\n        |").append(this.pretty(this.leadingMap)).append("\n        |\n        |  Trailing =\n        |").append(this.pretty(this.trailingMap)).append("\n        |)").toString()));
    }

    public String toString() {
        return this.syntax();
    }

    public Set<Token.Comment> leading(Tree tree) {
        return ((IterableOnceOps)tree.tokens().headOption().flatMap((Function1 & Serializable)token -> this.leadingMap.get(token).map((Function1 & Serializable)comments -> comments)).getOrElse(AssociatedComments::leading$$anonfun$2)).toSet();
    }

    public Set<Token.Comment> trailing(Tree tree) {
        return ((IterableOnceOps)tree.tokens().lastOption().flatMap((Function1 & Serializable)token -> this.trailingMap.get(token).map((Function1 & Serializable)comments -> comments)).getOrElse(AssociatedComments::trailing$$anonfun$2)).toSet();
    }

    public boolean hasComment(Tree tree) {
        return this.trailing(tree).nonEmpty() || this.leading(tree).nonEmpty();
    }

    private static final List leading$$anonfun$2() {
        return scala.package$.MODULE$.Nil();
    }

    private static final List trailing$$anonfun$2() {
        return scala.package$.MODULE$.Nil();
    }
}

