/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.testkit;

import java.io.File;
import java.net.URI;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.meta.testkit.Corpus;
import scala.meta.testkit.CorpusFile;
import scala.meta.testkit.FileOps$;
import scala.meta.testkit.Phase$;
import scala.runtime.Nothing$;
import scala.sys.process.package$;

public final class Corpus$
implements Serializable {
    public static final Corpus$ MODULE$;
    private final Corpus fastparse;

    static {
        new Corpus$();
    }

    public Corpus fastparse() {
        return this.fastparse;
    }

    private File createReposDir(Corpus corpus) {
        String name = "repos";
        File localDirectory = FileOps$.MODULE$.getFile("target", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}));
        if (!localDirectory.isDirectory()) {
            File localTarball = FileOps$.MODULE$.getFile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tar.gz"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
            if (!localTarball.isFile()) {
                this.downloadReposTar(corpus, localTarball);
            }
            this.extractReposTar(localTarball, FileOps$.MODULE$.workingDirectory());
        }
        return FileOps$.MODULE$.getFile("target", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}));
    }

    private void extractReposTar(File tarball, File destination) {
        Phase$.MODULE$.run(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"extract ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tarball})), new Serializable(tarball, destination){
            public static final long serialVersionUID = 0L;
            private final File tarball$1;
            private final File destination$2;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                Archiver archiver = ArchiverFactory.createArchiver((String)"tar", (String)"gz");
                archiver.extract(this.tarball$1, this.destination$2);
            }
            {
                this.tarball$1 = tarball$1;
                this.destination$2 = destination$2;
            }
        });
    }

    private void downloadReposTar(Corpus corpus, File destination) {
        Phase$.MODULE$.run(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"download ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{corpus.url()})), new Serializable(corpus, destination){
            public static final long serialVersionUID = 0L;
            private final Corpus corpus$1;
            private final File destination$1;

            public final String apply() {
                return package$.MODULE$.urlToProcess(new URI(this.corpus$1.url()).toURL()).$hash$greater(this.destination$1).$bang$bang();
            }
            {
                this.corpus$1 = corpus$1;
                this.destination$1 = destination$1;
            }
        });
    }

    public Iterator<CorpusFile> files(Corpus corpus) {
        File repos = this.createReposDir(corpus);
        File[] files2 = (File[])Option$.MODULE$.apply((Object)repos.listFiles()).getOrElse((Function0)new Serializable(repos){
            public static final long serialVersionUID = 0L;
            private final File repos$1;

            public final Nothing$ apply() {
                throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a directory! Please delete if it's a file and retry."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.repos$1.getAbsolutePath()})));
            }
            {
                this.repos$1 = repos$1;
            }
        });
        return Predef$.MODULE$.refArrayOps((Object[])files2).iterator().flatMap((Function1)new Serializable(corpus){
            public static final long serialVersionUID = 0L;
            private final Corpus corpus$2;

            public final Iterator<CorpusFile> apply(File repo) {
                String commit = FileOps$.MODULE$.readFile(new File(repo, "COMMIT")).trim();
                String url = FileOps$.MODULE$.readFile(new File(repo, "URL")).trim();
                return FileOps$.MODULE$.listFiles(repo).filter((Function1)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(String sourceFile) {
                        return sourceFile.endsWith(".scala");
                    }
                }).filter(this.corpus$2.filter()).map((Function1)new Serializable(this, commit, url, repo){
                    public static final long serialVersionUID = 0L;
                    private final String commit$1;
                    private final String url$1;
                    private final File repo$1;

                    public final CorpusFile apply(String sourceFile) {
                        String filename = new StringOps(Predef$.MODULE$.augmentString(sourceFile)).stripPrefix(this.repo$1.getPath());
                        return new CorpusFile(filename.trim(), this.url$1, this.commit$1);
                    }
                    {
                        this.commit$1 = commit$1;
                        this.url$1 = url$1;
                        this.repo$1 = repo$1;
                    }
                });
            }
            {
                this.corpus$2 = corpus$2;
            }
        });
    }

    public Corpus apply(String url, Function1<String, Object> filter) {
        return new Corpus(url, filter);
    }

    public Option<Tuple2<String, Function1<String, Object>>> unapply(Corpus x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.url(), x$0.filter()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Corpus$() {
        MODULE$ = this;
        this.fastparse = new Corpus("https://github.com/scalameta/scalafmt/releases/download/v0.1.4/repos.tar.gz", (Function1<String, Object>)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(String x) {
                return !List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"target/repos/sbt/main-settings/src/main/scala/sbt/std/InputWrapper.scala", "target/repos/sbt/sbt/src/sbt-test/source-dependencies/inherited-macros", "target/repos/sbt/sbt/src/sbt-test/source-dependencies/macro", "target/repos/lila/modules/lobby/src/main/SocketHandler.scala", "target/repos/scalatest/common-test/src/main/scala/munit.OperatorNames.scala", "target/repos/scalatest/scalatest-test/src/test/scala/munit.OperatorNames.scala", "target/repos/scala/test/files/neg/t5510.scala", "target/repos/scala/test/files/neg/t8015-ffb.scala", "target/repos/scala/test/files/pos/t389.scala", "target/repos/scala/test/files/run/literals.scala", "target/repos/scala/test/files/run/t3835.scala", "target/repos/scala/test/files/neg/t8266-invalid-interp.scala", "target/repos/scala/test/disabled/", "target/repos/scala/test/files/neg/", "target/repos/scala/test/files/presentation/infix-completion/src/Snippet.scala", "target/repos/scala/src/scaladoc/scala/tools/nsc/doc/html/page/Entity.scala", "target/repos/scala/src/scaladoc/scala/tools/nsc/doc/html/HtmlPage.scala", "target/repos/scala/src/scaladoc/scala/tools/nsc/doc/html/page/Template.scala", "target/repos/kafka/core/src/main/scala/kafka/server/KafkaConfig.scala"})).exists((Function1)new Serializable(this, x){
                    public static final long serialVersionUID = 0L;
                    private final String x$1;

                    public final boolean apply(String x$1) {
                        return this.x$1.startsWith(x$1);
                    }
                    {
                        this.x$1 = x$1;
                    }
                });
            }
        });
    }
}

