/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.testkit;

import geny.Generator;
import geny.Generator$;
import java.io.File;
import java.net.URL;
import org.apache.commons.io.FileUtils;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.meta.testkit.Corpus;
import scala.meta.testkit.CorpusFile;
import scala.meta.testkit.FileOps$;
import scala.meta.testkit.Phase$;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class Corpus$
implements Serializable {
    public static Corpus$ MODULE$;
    private final Corpus fastparse;

    static {
        new Corpus$();
    }

    public Corpus fastparse() {
        return this.fastparse;
    }

    private File createReposDir(Corpus corpus) {
        File localDirectory;
        String name = "repos";
        File localTarball = FileOps$.MODULE$.getFile(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".tar.gz"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{name})), (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[0]));
        if (!localTarball.isFile()) {
            this.downloadReposTar(corpus, localTarball);
        }
        if (!(localDirectory = FileOps$.MODULE$.getFile("target", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}))).isDirectory()) {
            this.extractReposTar(localTarball, FileOps$.MODULE$.workingDirectory());
        }
        return FileOps$.MODULE$.getFile("target", (Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])new String[]{name}));
    }

    private void extractReposTar(File tarball, File destination) {
        Phase$.MODULE$.run(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"extract ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{tarball})), (JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> {
            Archiver archiver = ArchiverFactory.createArchiver((String)"tar", (String)"gz");
            archiver.extract(tarball, destination);
        });
    }

    private void downloadReposTar(Corpus corpus, File destination) {
        Phase$.MODULE$.run(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"download ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{corpus.url()})), (JFunction0.mcV.sp & java.io.Serializable & Serializable)() -> FileUtils.copyURLToFile((URL)new URL(corpus.url()), (File)destination));
    }

    public Generator<CorpusFile> files(Corpus corpus) {
        File repos = this.createReposDir(corpus);
        File[] files = (File[])Option$.MODULE$.apply((Object)repos.listFiles()).getOrElse((Function0 & java.io.Serializable & Serializable)() -> {
            throw new IllegalStateException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " is not a directory! Please delete if it's a file and retry."})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{repos.getAbsolutePath()})));
        });
        return Generator$.MODULE$.fromIterable((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])files)).toIterable(), (Function1)Predef$.MODULE$.$conforms()).flatMap((Function1 & java.io.Serializable & Serializable)repo -> {
            String commit = FileOps$.MODULE$.readFile(new File((File)repo, "COMMIT")).trim();
            String url = FileOps$.MODULE$.readFile(new File((File)repo, "URL")).trim();
            return FileOps$.MODULE$.listFiles((File)repo).filter((Function1 & java.io.Serializable & Serializable)sourceFile -> BoxesRunTime.boxToBoolean((boolean)sourceFile.endsWith(".scala"))).filter(corpus.filter()).map((Function1 & java.io.Serializable & Serializable)sourceFile -> {
                String filename = new StringOps(Predef$.MODULE$.augmentString(sourceFile)).stripPrefix(repo.getPath());
                return new CorpusFile(filename.trim(), url, commit);
            });
        });
    }

    public Corpus apply(String url, Function1<String, Object> filter) {
        return new Corpus(url, filter);
    }

    public Option<Tuple2<String, Function1<String, Object>>> unapply(Corpus x$0) {
        return x$0 == null ? None$.MODULE$ : new Some((Object)new Tuple2((Object)x$0.url(), x$0.filter()));
    }

    private Object readResolve() {
        return MODULE$;
    }

    public static final /* synthetic */ boolean $anonfun$fastparse$1(String x) {
        return !((IterableLike)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"target/repos/sbt/main-settings/src/main/scala/sbt/std/InputWrapper.scala", "target/repos/sbt/sbt/src/sbt-test/source-dependencies/inherited-macros", "target/repos/sbt/sbt/src/sbt-test/source-dependencies/macro", "target/repos/lila/modules/lobby/src/main/SocketHandler.scala", "target/repos/scalatest/common-test/src/main/scala/org/scalatest/OperatorNames.scala", "target/repos/scalatest/scalatest-test/src/test/scala/org/scalatest/OperatorNames.scala", "target/repos/scala/test/files/neg/t5510.scala", "target/repos/scala/test/files/neg/t8015-ffb.scala", "target/repos/scala/test/files/pos/t389.scala", "target/repos/scala/test/files/run/literals.scala", "target/repos/scala/test/files/run/t3835.scala", "target/repos/scala/test/files/neg/t8266-invalid-interp.scala", "target/repos/scala/test/disabled/", "target/repos/scala/test/files/neg/", "target/repos/scala/test/files/presentation/infix-completion/src/Snippet.scala", "target/repos/scala/src/scaladoc/scala/tools/nsc/doc/html/page/Entity.scala", "target/repos/scala/src/scaladoc/scala/tools/nsc/doc/html/HtmlPage.scala", "target/repos/scala/src/scaladoc/scala/tools/nsc/doc/html/page/Template.scala"}))).exists((Function1 & java.io.Serializable & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x.startsWith(x$12)));
    }

    private Corpus$() {
        MODULE$ = this;
        this.fastparse = new Corpus("https://github.com/scalameta/scalafmt/releases/download/v0.1.4/repos.tar.gz", (Function1<String, Object>)(Function1 & java.io.Serializable & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Corpus$.$anonfun$fastparse$1(x)));
    }
}

