/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.testkit;

import java.nio.charset.MalformedInputException;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.scalameta.UnreachableError;
import org.scalameta.invariants.InvariantFailedException;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.meta.Dialect$;
import scala.meta.Source;
import scala.meta.package$;
import scala.meta.parsers.Parse$;
import scala.meta.parsers.Parsed;
import scala.meta.testkit.CorpusFile;
import scala.meta.testkit.Phase$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SyntaxAnalysis$ {
    public static SyntaxAnalysis$ MODULE$;

    static {
        new SyntaxAnalysis$();
    }

    public <T> Buffer<Tuple2<CorpusFile, T>> run(GenIterable<CorpusFile> corpus, Function1<CorpusFile, List<T>> f) {
        return (Buffer)Phase$.MODULE$.run("syntax analysis", (Function0 & java.io.Serializable & Serializable)() -> {
            CopyOnWriteArrayList results = new CopyOnWriteArrayList();
            AtomicInteger counter = new AtomicInteger();
            AtomicInteger errors = new AtomicInteger();
            corpus.foreach((Function1 & java.io.Serializable & Serializable)file -> {
                SyntaxAnalysis$.analyze$1(file, f, results, counter, errors);
                return BoxedUnit.UNIT;
            });
            return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(results).asScala();
        });
    }

    public <A> Buffer<Tuple2<CorpusFile, A>> onParsed(GenIterable<CorpusFile> corpus, Function1<Source, List<A>> f) {
        return this.run(corpus, (Function1 & java.io.Serializable & Serializable)x$1 -> {
            Nil$ nil$;
            Source ast;
            Parsed.Success success;
            Option option;
            Parsed parsed = package$.MODULE$.XtensionParseInputLike((Object)x$1.jFile()).parse(package$.MODULE$.fileToInput(), Parse$.MODULE$.parseSource(), Dialect$.MODULE$.current());
            if (parsed instanceof Parsed.Success && !(option = Parsed.Success$.MODULE$.unapply(success = (Parsed.Success)parsed)).isEmpty() && (ast = (Source)option.get()) != null) {
                Source source = ast;
                nil$ = (List)f.apply((Object)source);
            } else {
                nil$ = Nil$.MODULE$;
            }
            return nil$;
        });
    }

    private static final void analyze$1(CorpusFile file, Function1 f$1, CopyOnWriteArrayList results$1, AtomicInteger counter$1, AtomicInteger errors$1) {
        int n = counter$1.incrementAndGet();
        if (n % 1000 == 0) {
            Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)n));
        }
        try {
            ((List)f$1.apply((Object)file)).foreach((Function1 & java.io.Serializable & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)results$1.add(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), t))));
        }
        catch (Throwable throwable) {
            Throwable throwable2 = throwable;
            if (throwable2 instanceof UnreachableError) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof InvariantFailedException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof MalformedInputException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            if (throwable2 instanceof NoSuchElementException) {
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            Option option = NonFatal$.MODULE$.unapply(throwable2);
            if (!option.isEmpty()) {
                Throwable e = (Throwable)option.get();
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unexpected error analysing file: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{file})));
                Predef$.MODULE$.println((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error: ", " ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getClass().getName(), e})));
                StackTraceElement[] stack = (StackTraceElement[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace())).take(10);
                new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])stack)).foreach((Function1 & java.io.Serializable & Serializable)x -> {
                    Predef$.MODULE$.println(x);
                    return BoxedUnit.UNIT;
                });
                int i = errors$1.incrementAndGet();
                if (i > 10) {
                    throw new IllegalStateException("Too many unexpected errors (printed to console), fix your analysis.");
                }
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
            throw throwable;
        }
    }

    private SyntaxAnalysis$() {
        MODULE$ = this;
    }
}

