/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.testkit;

import java.io.Serializable;
import java.nio.charset.MalformedInputException;
import java.util.NoSuchElementException;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicInteger;
import org.scalameta.UnreachableError;
import org.scalameta.invariants.InvariantFailedException;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterable;
import scala.collection.IterableOnce;
import scala.collection.IterableOnce$;
import scala.collection.IterableOnceExtensionMethods$;
import scala.collection.JavaConverters$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Buffer;
import scala.meta.Dialect$;
import scala.meta.Source;
import scala.meta.inputs.Input$;
import scala.meta.package$;
import scala.meta.parsers.Parse$;
import scala.meta.parsers.Parsed;
import scala.meta.testkit.CorpusFile;
import scala.meta.testkit.Phase$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;

public final class SyntaxAnalysis$ {
    public static final SyntaxAnalysis$ MODULE$ = new SyntaxAnalysis$();

    public <T> Buffer<Tuple2<CorpusFile, T>> run(IterableOnce<CorpusFile> corpus, Function1<CorpusFile, List<T>> f) {
        return (Buffer)Phase$.MODULE$.run("syntax analysis", (Function0 & Serializable)() -> {
            CopyOnWriteArrayList results = new CopyOnWriteArrayList();
            AtomicInteger counter = new AtomicInteger();
            AtomicInteger errors = new AtomicInteger();
            IterableOnceExtensionMethods$.MODULE$.foreach$extension(IterableOnce$.MODULE$.iterableOnceExtensionMethods(corpus), (Function1 & Serializable)file -> {
                SyntaxAnalysis$.analyze$1(file, counter, f, results, errors);
                return BoxedUnit.UNIT;
            });
            return (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(results).asScala();
        });
    }

    public <A> Buffer<Tuple2<CorpusFile, A>> onParsed(Iterable<CorpusFile> corpus, Function1<Source, List<A>> f) {
        return this.run((IterableOnce<CorpusFile>)corpus, (Function1)(Function1 & Serializable)x$1 -> {
            Parsed.Success success;
            Source ast;
            Parsed parsed = package$.MODULE$.XtensionParseInputLike((Object)x$1.jFile()).parse(Input$.MODULE$.fileToInput(), Parse$.MODULE$.parseSource(), Dialect$.MODULE$.current());
            if (parsed instanceof Parsed.Success && (ast = (Source)(success = (Parsed.Success)parsed).tree()) != null) {
                Source source = ast;
                return (List)f.apply((Object)source);
            }
            return Nil$.MODULE$;
        });
    }

    private static final void analyze$1(CorpusFile file, AtomicInteger counter$1, Function1 f$1, CopyOnWriteArrayList results$1, AtomicInteger errors$1) {
        int n = counter$1.incrementAndGet();
        if (n % 1000 == 0) {
            Predef$.MODULE$.println((Object)BoxesRunTime.boxToInteger((int)n));
        }
        try {
            ((List)f$1.apply((Object)file)).foreach((Function1 & Serializable)t -> BoxesRunTime.boxToBoolean((boolean)results$1.add(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)file), t))));
        }
        catch (Throwable throwable) {
            Option option;
            Throwable throwable2 = throwable;
            if (throwable2 instanceof UnreachableError) {
            }
            if (throwable2 instanceof InvariantFailedException) {
            }
            if (throwable2 instanceof MalformedInputException) {
            }
            if (throwable2 instanceof NoSuchElementException) {
            }
            if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                Throwable e = (Throwable)option.get();
                Predef$.MODULE$.println((Object)new StringBuilder(33).append("Unexpected error analysing file: ").append(file).toString());
                Predef$.MODULE$.println((Object)new StringBuilder(8).append("Error: ").append(e.getClass().getName()).append(" ").append(e).toString());
                StackTraceElement[] stack = (StackTraceElement[])ArrayOps$.MODULE$.take$extension(Predef$.MODULE$.refArrayOps((Object[])e.getStackTrace()), 10);
                ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps((Object[])stack), (Function1 & Serializable)x -> {
                    Predef$.MODULE$.println(x);
                    return BoxedUnit.UNIT;
                });
                int i = errors$1.incrementAndGet();
                if (i > 10) {
                    throw new IllegalStateException("Too many unexpected errors (printed to console), fix your analysis.");
                }
            }
            throw throwable;
        }
    }

    private SyntaxAnalysis$() {
    }
}

