/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.testkit;

import java.io.File;
import java.io.Serializable;
import java.net.URL;
import org.rauschig.jarchivelib.Archiver;
import org.rauschig.jarchivelib.ArchiverFactory;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.ArrayOps$;
import scala.collection.Iterator;
import scala.collection.StringOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.meta.testkit.Corpus;
import scala.meta.testkit.CorpusFile;
import scala.meta.testkit.FileOps$;
import scala.meta.testkit.Phase$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ModuleSerializationProxy;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

public final class Corpus$
implements Serializable {
    public static final Corpus$ MODULE$ = new Corpus$();
    private static final Corpus fastparse = new Corpus("https://github.com/scalameta/scalafmt/releases/download/v0.1.4/repos.tar.gz", (Function1<String, Object>)(Function1 & Serializable)x -> BoxesRunTime.boxToBoolean((boolean)Corpus$.$anonfun$fastparse$1(x)));

    public Corpus fastparse() {
        return fastparse;
    }

    private File createReposDir(Corpus corpus) {
        String name = "repos";
        File localDirectory = FileOps$.MODULE$.getFile("target", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name}));
        if (!localDirectory.isDirectory()) {
            File localTarball = FileOps$.MODULE$.getFile(new StringBuilder(7).append(name).append(".tar.gz").toString(), (Seq<String>)Nil$.MODULE$);
            if (!localTarball.isFile()) {
                this.downloadReposTar(corpus, localTarball);
            }
            this.extractReposTar(localTarball, FileOps$.MODULE$.workingDirectory());
        }
        return FileOps$.MODULE$.getFile("target", (Seq<String>)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{name}));
    }

    private void extractReposTar(File tarball, File destination) {
        Phase$.MODULE$.run(new StringBuilder(8).append("extract ").append(tarball).toString(), (JFunction0.mcV.sp & Serializable)() -> {
            Archiver archiver = ArchiverFactory.createArchiver((String)"tar", (String)"gz");
            archiver.extract(tarball, destination);
        });
    }

    private void downloadReposTar(Corpus corpus, File destination) {
        Phase$.MODULE$.run(new StringBuilder(9).append("download ").append(corpus.url()).toString(), (Function0 & Serializable)() -> scala.sys.process.package$.MODULE$.urlToProcess(new URL(corpus.url())).$hash$greater(destination).$bang$bang());
    }

    public Iterator<CorpusFile> files(Corpus corpus) {
        File repos = this.createReposDir(corpus);
        File[] files = (File[])Option$.MODULE$.apply((Object)repos.listFiles()).getOrElse((Function0 & Serializable)() -> {
            throw new IllegalStateException(new StringBuilder(60).append(repos.getAbsolutePath()).append(" is not a directory! Please delete if it's a file and retry.").toString());
        });
        return ArrayOps$.MODULE$.iterator$extension(Predef$.MODULE$.refArrayOps((Object[])files)).flatMap((Function1 & Serializable)repo -> {
            String commit = FileOps$.MODULE$.readFile(new File((File)repo, "COMMIT")).trim();
            String url = FileOps$.MODULE$.readFile(new File((File)repo, "URL")).trim();
            return FileOps$.MODULE$.listFiles((File)repo).filter((Function1 & Serializable)sourceFile -> BoxesRunTime.boxToBoolean((boolean)sourceFile.endsWith(".scala"))).filter(corpus.filter()).map((Function1 & Serializable)sourceFile -> {
                String filename = StringOps$.MODULE$.stripPrefix$extension(Predef$.MODULE$.augmentString(sourceFile), repo.getPath());
                return new CorpusFile(filename.trim(), url, commit);
            });
        });
    }

    public Corpus apply(String url, Function1<String, Object> filter) {
        return new Corpus(url, filter);
    }

    public Option<Tuple2<String, Function1<String, Object>>> unapply(Corpus x$0) {
        if (x$0 == null) {
            return None$.MODULE$;
        }
        return new Some((Object)new Tuple2((Object)x$0.url(), x$0.filter()));
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(Corpus$.class);
    }

    public static final /* synthetic */ boolean $anonfun$fastparse$1(String x) {
        return !((List)package$.MODULE$.List().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{"target/repos/sbt/main-settings/src/main/scala/sbt/std/InputWrapper.scala", "target/repos/sbt/sbt/src/sbt-test/source-dependencies/inherited-macros", "target/repos/sbt/sbt/src/sbt-test/source-dependencies/macro", "target/repos/lila/modules/lobby/src/main/SocketHandler.scala", "target/repos/scalatest/common-test/src/main/scala/munit.OperatorNames.scala", "target/repos/scalatest/scalatest-test/src/test/scala/munit.OperatorNames.scala", "target/repos/scala/test/files/neg/t5510.scala", "target/repos/scala/test/files/neg/t8015-ffb.scala", "target/repos/scala/test/files/pos/t389.scala", "target/repos/scala/test/files/run/literals.scala", "target/repos/scala/test/files/run/t3835.scala", "target/repos/scala/test/files/neg/t8266-invalid-interp.scala", "target/repos/scala/test/disabled/", "target/repos/scala/test/files/neg/", "target/repos/scala/test/files/presentation/infix-completion/src/Snippet.scala", "target/repos/scala/src/scaladoc/scala/tools/nsc/doc/html/page/Entity.scala", "target/repos/scala/src/scaladoc/scala/tools/nsc/doc/html/HtmlPage.scala", "target/repos/scala/src/scaladoc/scala/tools/nsc/doc/html/page/Template.scala", "target/repos/kafka/core/src/main/scala/kafka/server/KafkaConfig.scala"}))).exists((Function1 & Serializable)x$12 -> BoxesRunTime.boxToBoolean((boolean)x.startsWith(x$12)));
    }

    private Corpus$() {
    }
}

