/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.tokenizers;

import org.langmeta.inputs.Input;
import scala.Predef$;
import scala.meta.Dialect;
import scala.meta.internal.tokenizers.CharArrayReaderData;
import scala.meta.internal.tokenizers.CharArrayReaderData$class;
import scala.meta.internal.tokenizers.Chars$;
import scala.meta.internal.tokenizers.Reporter;
import scala.reflect.ScalaSignature;
import scala.runtime.TraitSetter;

@ScalaSignature(bytes="\u0006\u000194A!\u0001\u0002\u0001\u0017\ty1\t[1s\u0003J\u0014\u0018-\u001f*fC\u0012,'O\u0003\u0002\u0004\t\u0005QAo\\6f]&TXM]:\u000b\u0005\u00151\u0011\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u001dA\u0011\u0001B7fi\u0006T\u0011!C\u0001\u0006g\u000e\fG.Y\u0002\u0001'\r\u0001A\u0002\u0005\t\u0003\u001b9i\u0011\u0001C\u0005\u0003\u001f!\u0011a!\u00118z%\u00164\u0007CA\t\u0013\u001b\u0005\u0011\u0011BA\n\u0003\u0005M\u0019\u0005.\u0019:BeJ\f\u0017PU3bI\u0016\u0014H)\u0019;b\u0011!)\u0002A!A!\u0002\u00131\u0012!B5oaV$\bCA\f&\u001d\tA\"E\u0004\u0002\u001aA9\u0011!d\b\b\u00037yi\u0011\u0001\b\u0006\u0003;)\ta\u0001\u0010:p_Rt\u0014\"A\u0005\n\u0005\u001dA\u0011BA\u0011\u0007\u0003\u0019Ig\u000e];ug&\u00111\u0005J\u0001\ba\u0006\u001c7.Y4f\u0015\t\tc!\u0003\u0002'O\t)\u0011J\u001c9vi&\u0011\u0001&\u000b\u0002\b\u00032L\u0017m]3t\u0015\t\t#F\u0003\u0002,Y\u0005AA.\u00198h[\u0016$\u0018MC\u0001.\u0003\ry'o\u001a\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u00059A-[1mK\u000e$\bCA\u00193\u001b\u00051\u0011BA\u001a\u0007\u0005\u001d!\u0015.\u00197fGRD\u0001\"\u000e\u0001\u0003\u0002\u0003\u0006IAN\u0001\te\u0016\u0004xN\u001d;feB\u0011\u0011cN\u0005\u0003q\t\u0011\u0001BU3q_J$XM\u001d\u0005\u0006u\u0001!\taO\u0001\u0007y%t\u0017\u000e\u001e \u0015\tqjdh\u0010\t\u0003#\u0001AQ!F\u001dA\u0002YAQaL\u001dA\u0002ABQ!N\u001dA\u0002YBq!\u0011\u0001C\u0002\u0013\u0005!)A\u0002ck\u001a,\u0012a\u0011\t\u0004\u001b\u00113\u0015BA#\t\u0005\u0015\t%O]1z!\tiq)\u0003\u0002I\u0011\t!1\t[1s\u0011\u0019Q\u0005\u0001)A\u0005\u0007\u0006!!-\u001e4!\u0011\u0015a\u0005\u0001\"\u0001N\u0003=I7/\u00168jG>$W-R:dCB,W#\u0001(\u0011\u00055y\u0015B\u0001)\t\u0005\u001d\u0011un\u001c7fC:DQA\u0015\u0001\u0005\u0006M\u000b\u0001B\\3yi\u000eC\u0017M\u001d\u000b\u0002)B\u0011Q\"V\u0005\u0003-\"\u0011A!\u00168ji\")\u0001\f\u0001C\u0003'\u0006Ya.\u001a=u%\u0006<8\t[1s\u0011\u0015Q\u0006\u0001\"\u0003T\u0003A\u0001x\u000e^3oi&\fG.\u00168jG>$W\rC\u0003]\u0001\u0011%1+\u0001\u0004tW&\u00048I\u0015\u0005\u0006=\u0002!IaU\u0001\u0011a>$XM\u001c;jC2d\u0015N\\3F]\u0012DQ\u0001\u0019\u0001\u0005\u0002\u0005\fq\u0002\\8pW\u0006DW-\u00193SK\u0006$WM]\u000b\u0002EB\u00111\rZ\u0007\u0002\u0001\u0019!Q\r\u0001\u0001g\u0005a\u0019\u0005.\u0019:BeJ\f\u0017\u0010T8pW\u0006DW-\u00193SK\u0006$WM]\n\u0003IrBQA\u000f3\u0005\u0002!$\u0012A\u0019\u0005\u0006U\u0012$\ta[\u0001\u0005O\u0016$8\rF\u0001G\u0011\u0015iG\r\"\u0001l\u0003\u00119W\r^;")
public class CharArrayReader
implements CharArrayReaderData {
    public final Input scala$meta$internal$tokenizers$CharArrayReader$$input;
    public final Dialect scala$meta$internal$tokenizers$CharArrayReader$$dialect;
    public final Reporter scala$meta$internal$tokenizers$CharArrayReader$$reporter;
    private final char[] buf;
    private char ch;
    private int charOffset;
    private int lineStartOffset;
    private int lastLineStartOffset;
    private int lastUnicodeOffset;

    @Override
    public char ch() {
        return this.ch;
    }

    @Override
    @TraitSetter
    public void ch_$eq(char x$1) {
        this.ch = x$1;
    }

    @Override
    public int charOffset() {
        return this.charOffset;
    }

    @Override
    @TraitSetter
    public void charOffset_$eq(int x$1) {
        this.charOffset = x$1;
    }

    @Override
    public int lineStartOffset() {
        return this.lineStartOffset;
    }

    @Override
    @TraitSetter
    public void lineStartOffset_$eq(int x$1) {
        this.lineStartOffset = x$1;
    }

    @Override
    public int lastLineStartOffset() {
        return this.lastLineStartOffset;
    }

    @Override
    @TraitSetter
    public void lastLineStartOffset_$eq(int x$1) {
        this.lastLineStartOffset = x$1;
    }

    @Override
    public int lastUnicodeOffset() {
        return this.lastUnicodeOffset;
    }

    @Override
    @TraitSetter
    public void lastUnicodeOffset_$eq(int x$1) {
        this.lastUnicodeOffset = x$1;
    }

    public char[] buf() {
        return this.buf;
    }

    public boolean isUnicodeEscape() {
        return this.charOffset() == this.lastUnicodeOffset();
    }

    public final void nextChar() {
        if (this.charOffset() >= this.buf().length) {
            this.ch_$eq('\u001a');
        } else {
            char c = this.buf()[this.charOffset()];
            this.ch_$eq(c);
            this.charOffset_$eq(this.charOffset() + 1);
            if (c == '\\') {
                this.scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
            }
            if (this.ch() < ' ') {
                this.skipCR();
                this.potentialLineEnd();
            }
            if (this.ch() == '\"' && !this.scala$meta$internal$tokenizers$CharArrayReader$$dialect.allowMultilinePrograms()) {
                throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("double quotes are not allowed in single-line quasiquotes", this.charOffset() - 1);
            }
        }
    }

    public final void nextRawChar() {
        if (this.charOffset() >= this.buf().length) {
            this.ch_$eq('\u001a');
        } else {
            char c = this.buf()[this.charOffset()];
            this.ch_$eq(c);
            this.charOffset_$eq(this.charOffset() + 1);
            if (c == '\\') {
                this.scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
            }
        }
    }

    public void scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode() {
        if (this.charOffset() < this.buf().length && this.buf()[this.charOffset()] == 'u' && this.evenSlashPrefix$1()) {
            do {
                this.charOffset_$eq(this.charOffset() + 1);
            } while (this.charOffset() < this.buf().length && this.buf()[this.charOffset()] == 'u');
            int code = this.udigit$1() << 12 | this.udigit$1() << 8 | this.udigit$1() << 4 | this.udigit$1();
            this.lastUnicodeOffset_$eq(this.charOffset());
            this.ch_$eq((char)code);
        }
    }

    private void skipCR() {
        if (this.ch() == '\r' && this.charOffset() < this.buf().length) {
            char c = this.buf()[this.charOffset()];
            switch (c) {
                case '\\': {
                    if (this.lookaheadReader().getu() != '\n') break;
                    this.scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
                    break;
                }
                case '\n': {
                    this.charOffset_$eq(this.charOffset() + 1);
                    this.ch_$eq('\n');
                }
            }
        }
    }

    private void potentialLineEnd() {
        if (this.ch() == '\n' || this.ch() == '\f') {
            if (this.scala$meta$internal$tokenizers$CharArrayReader$$dialect.allowMultilinePrograms()) {
                this.lastLineStartOffset_$eq(this.lineStartOffset());
                this.lineStartOffset_$eq(this.charOffset());
            } else {
                throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("line breaks are not allowed in single-line quasiquotes", this.charOffset() - 1);
            }
        }
    }

    public CharArrayLookaheadReader lookaheadReader() {
        return new CharArrayLookaheadReader();
    }

    private final boolean evenSlashPrefix$1() {
        int p;
        for (p = this.charOffset() - 2; p >= 0 && this.buf()[p] == '\\'; --p) {
        }
        return (this.charOffset() - p) % 2 == 0;
    }

    /*
     * WARNING - void declaration
     */
    private final int udigit$1() {
        if (this.charOffset() >= this.buf().length) {
            throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("incomplete unicode escape", this.charOffset() - 1);
        }
        int d = Chars$.MODULE$.digit2int(this.buf()[this.charOffset()], 16);
        if (d >= 0) {
            void var1_1;
            this.charOffset_$eq(this.charOffset() + 1);
            return (int)var1_1;
        }
        throw this.scala$meta$internal$tokenizers$CharArrayReader$$reporter.readerError("error in unicode escape", this.charOffset());
    }

    public CharArrayReader(Input input, Dialect dialect, Reporter reporter) {
        this.scala$meta$internal$tokenizers$CharArrayReader$$input = input;
        this.scala$meta$internal$tokenizers$CharArrayReader$$dialect = dialect;
        this.scala$meta$internal$tokenizers$CharArrayReader$$reporter = reporter;
        CharArrayReaderData$class.$init$(this);
        this.buf = input.chars();
    }

    public class CharArrayLookaheadReader
    extends CharArrayReader {
        public char getc() {
            this.nextChar();
            return this.ch();
        }

        public char getu() {
            Predef$.MODULE$.require(this.buf()[this.charOffset()] == '\\');
            this.ch_$eq('\\');
            this.charOffset_$eq(this.charOffset() + 1);
            this.scala$meta$internal$tokenizers$CharArrayReader$CharArrayLookaheadReader$$$outer().scala$meta$internal$tokenizers$CharArrayReader$$potentialUnicode();
            return this.ch();
        }

        public /* synthetic */ CharArrayReader scala$meta$internal$tokenizers$CharArrayReader$CharArrayLookaheadReader$$$outer() {
            return CharArrayReader.this;
        }

        public CharArrayLookaheadReader() {
            if (CharArrayReader.this == null) {
                throw null;
            }
            super(CharArrayReader.this.scala$meta$internal$tokenizers$CharArrayReader$$input, CharArrayReader.this.scala$meta$internal$tokenizers$CharArrayReader$$dialect, CharArrayReader.this.scala$meta$internal$tokenizers$CharArrayReader$$reporter);
            this.charOffset_$eq(CharArrayReader.this.charOffset());
            this.ch_$eq(CharArrayReader.this.ch());
        }
    }
}

