/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.prettyprinters;

import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps$;
import scala.meta.Lit;
import scala.meta.Name;
import scala.meta.Name$Indeterminate$;
import scala.meta.Term;
import scala.meta.Tree;
import scala.meta.internal.prettyprinters.DoubleQuotes$;
import scala.meta.internal.trees.Quasi;
import scala.meta.prettyprinters.Show;
import scala.meta.prettyprinters.Show$;
import scala.meta.prettyprinters.Structure;
import scala.meta.prettyprinters.Structure$;
import scala.runtime.BoxedUnit;

public final class TreeStructure$ {
    public static TreeStructure$ MODULE$;

    static {
        new TreeStructure$();
    }

    public <T extends Tree> Structure<T> apply() {
        return Structure$.MODULE$.apply((Function1 & java.io.Serializable & Serializable)tree -> MODULE$.anyTree((Tree)tree));
    }

    private Show.Result anyStructure(Object x) {
        Object object = x;
        if (object instanceof String) {
            String string = (String)object;
            return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)DoubleQuotes$.MODULE$.apply(string))}));
        }
        if (object instanceof Tree) {
            Tree tree = (Tree)object;
            return this.anyTree(tree);
        }
        if (None$.MODULE$.equals(object)) {
            return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)"None")}));
        }
        if (object instanceof Some) {
            Some some = (Some)object;
            Object el = some.value();
            return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)"Some("), Show$.MODULE$.indent(this.anyStructure(el)), Show$.MODULE$.newline((Object)")", Show$.MODULE$.printString())}));
        }
        if (object instanceof List) {
            List list = (List)object;
            return this.iterableStructure((Seq<?>)list, "List");
        }
        if (object instanceof Seq) {
            Seq seq = (Seq)object;
            return this.iterableStructure(seq, "Seq");
        }
        return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)object.toString())}));
    }

    private Show.Result iterableStructure(Seq<?> xs, String cls) {
        if (xs.isEmpty()) {
            return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)"Nil")}));
        }
        return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)new StringBuilder(1).append(cls).append("(").toString()), Show$.MODULE$.repeat((Seq)xs.map((Function1 & java.io.Serializable & Serializable)x -> Show$.MODULE$.indent(MODULE$.anyStructure(x)), Seq$.MODULE$.canBuildFrom()), ",", Show$.MODULE$.printResult()), Show$.MODULE$.newline((Object)")", Show$.MODULE$.printString())}));
    }

    private Show.Result anyTree(Tree tree) {
        List args;
        Term.ParamClause paramClause;
        Term.ArgClause argClause;
        List list;
        Name.Indeterminate indeterminate;
        Option<String> option;
        Tree tree2 = tree;
        if (tree2 instanceof Name.Anonymous) {
            return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)"Name.Anonymous()")}));
        }
        if (tree2 instanceof Name.This) {
            return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)"Name.This()")}));
        }
        if (tree2 instanceof Name.Placeholder) {
            return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)"Name.Placeholder()")}));
        }
        if (tree2 instanceof Name.Indeterminate && !(option = Name$Indeterminate$.MODULE$.unapply(indeterminate = (Name.Indeterminate)tree2)).isEmpty()) {
            String value = (String)option.get();
            return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)"Name("), Show$.MODULE$.printString().apply((Object)DoubleQuotes$.MODULE$.apply(value)), Show$.MODULE$.printString().apply((Object)")")}));
        }
        Tree tree3 = tree2;
        if (tree3 instanceof Quasi) {
            list = TreeStructure$.default$1(tree2);
        } else if (tree3 instanceof Lit.String) {
            Lit.String string = (Lit.String)tree3;
            String string2 = DoubleQuotes$.MODULE$.orTriple(string.value());
            list = Nil$.MODULE$.$colon$colon((Object)Show$.MODULE$.stringAsResult(string2));
        } else if (tree3 instanceof Lit.Char) {
            Lit.Char char_ = (Lit.Char)tree3;
            String string = new StringBuilder(2).append("'").append(char_.value()).append("'").toString();
            list = Nil$.MODULE$.$colon$colon((Object)Show$.MODULE$.stringAsResult(string));
        } else if (tree3 instanceof Lit.Symbol) {
            Lit.Symbol symbol = (Lit.Symbol)tree3;
            String string = new StringBuilder(10).append("Symbol(\"").append(symbol.value().name()).append("\")").toString();
            list = Nil$.MODULE$.$colon$colon((Object)Show$.MODULE$.stringAsResult(string));
        } else if (tree3 instanceof Lit.Unit ? true : tree3 instanceof Lit.Null) {
            list = Nil$.MODULE$;
        } else if (tree3 instanceof Lit.Double) {
            Lit.Double double_ = (Lit.Double)tree3;
            String string = this.asFloat(double_.format(), 'd');
            list = Nil$.MODULE$.$colon$colon((Object)Show$.MODULE$.stringAsResult(string));
        } else if (tree3 instanceof Lit.Float) {
            Lit.Float float_ = (Lit.Float)tree3;
            String string = this.asFloat(float_.format(), 'f');
            list = Nil$.MODULE$.$colon$colon((Object)Show$.MODULE$.stringAsResult(string));
        } else if (tree3 instanceof Lit.Long) {
            Lit.Long longVal = (Lit.Long)tree3;
            String string = new StringBuilder(0).append(Long.toString(longVal.value())).append('L').toString();
            list = Nil$.MODULE$.$colon$colon((Object)Show$.MODULE$.stringAsResult(string));
        } else if (tree3 instanceof Lit) {
            Lit lit = (Lit)tree3;
            String string = lit.value().toString();
            list = Nil$.MODULE$.$colon$colon((Object)Show$.MODULE$.stringAsResult(string));
        } else if (tree3 instanceof Term.ArgClause && (argClause = (Term.ArgClause)tree3).mod().isEmpty()) {
            Show.Result result = this.anyStructure(argClause.values());
            list = Nil$.MODULE$.$colon$colon((Object)result);
        } else if (tree3 instanceof Term.ParamClause && (paramClause = (Term.ParamClause)tree3).mod().isEmpty()) {
            Show.Result result = this.anyStructure(paramClause.values());
            list = Nil$.MODULE$.$colon$colon((Object)result);
        } else {
            list = args = TreeStructure$.default$1(tree2);
        }
        if (args.lengthCompare(1) > 0) {
            return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)tree2.productPrefix()), Show$.MODULE$.printString().apply((Object)"("), Show$.MODULE$.repeat((Seq)args.map((Function1 & java.io.Serializable & Serializable)res -> Show$.MODULE$.indent(res), List$.MODULE$.canBuildFrom()), ",", Show$.MODULE$.printResult()), Show$.MODULE$.newline((Object)")", Show$.MODULE$.printString())}));
        }
        return Show$.MODULE$.mkseq((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Show.Result[]{Show$.MODULE$.printString().apply((Object)tree2.productPrefix()), Show$.MODULE$.printString().apply((Object)"("), Show$.MODULE$.repeat((Seq)args, Show$.MODULE$.repeat$default$2(), Show$.MODULE$.printResult()), Show$.MODULE$.printString().apply((Object)")")}));
    }

    private String asFloat(String value, char suffix) {
        StringBuilder sb = new StringBuilder();
        int end = value.length() - 1;
        int noSuffixEnd = Character.toLowerCase(StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value), end)) == suffix ? end - 1 : end;
        this.removeZerosAndDot$1(noSuffixEnd, value, sb, noSuffixEnd);
        sb.append(suffix);
        return sb.toString();
    }

    private static final List default$1(Tree x1$1) {
        return x1$1.productIterator().map((Function1 & java.io.Serializable & Serializable)x -> MODULE$.anyStructure(x)).toList();
    }

    private static final StringBuilder appendNoSuffix$1(StringBuilder sb$1, String value$1, int noSuffixEnd$1) {
        return sb$1.append(value$1, 0, noSuffixEnd$1 + 1);
    }

    private final void removeZerosAndDot$1(int idx, String value$1, StringBuilder sb$1, int noSuffixEnd$1) {
        block4: while (true) {
            BoxedUnit boxedUnit;
            if (idx < 0) {
                TreeStructure$.appendNoSuffix$1(sb$1, value$1, noSuffixEnd$1);
                boxedUnit = BoxedUnit.UNIT;
                break;
            }
            char c = StringOps$.MODULE$.apply$extension(Predef$.MODULE$.augmentString(value$1), idx);
            switch (c) {
                case '0': {
                    --idx;
                    continue block4;
                }
                case '.': {
                    if (idx == 0) {
                        sb$1.append('0');
                        boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    sb$1.append(value$1, 0, idx);
                    boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
                default: {
                    if (value$1.lastIndexOf(46, idx - 1) < 0) {
                        TreeStructure$.appendNoSuffix$1(sb$1, value$1, noSuffixEnd$1);
                        boxedUnit = BoxedUnit.UNIT;
                        break block4;
                    }
                    sb$1.append(value$1, 0, idx + 1);
                    boxedUnit = BoxedUnit.UNIT;
                    break block4;
                }
            }
            break;
        }
    }

    private TreeStructure$() {
        MODULE$ = this;
    }
}

