/*
 * Decompiled with CFR 0.152.
 */
package scala.meta.internal.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths$;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.Builder;
import scala.meta.internal.io.JSFs$;
import scala.meta.internal.io.JSIO$;
import scala.meta.internal.io.ListFiles;
import scala.meta.internal.semanticdb.TextDocument;
import scala.meta.internal.semanticdb.TextDocuments;
import scala.meta.internal.semanticdb.TextDocuments$;
import scala.meta.io.AbsolutePath;
import scala.meta.io.AbsolutePath$;
import scala.meta.io.RelativePath;
import scala.meta.io.RelativePath$;
import scala.package$;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.scalajs.js.Array;
import scala.scalajs.js.JSConverters;
import scala.scalajs.js.JSConverters$;
import scalapb.GeneratedMessage;

public final class PlatformFileIO$ {
    public static final PlatformFileIO$ MODULE$ = new PlatformFileIO$();

    public InputStream newInputStream(URI uri) {
        return new ByteArrayInputStream(this.readAllBytes(uri));
    }

    public byte[] readAllBytes(URI uri) {
        String string = uri.getScheme();
        String string2 = "file";
        if (!(string != null ? !string.equals(string2) : string2 != null)) {
            Path filepath = Paths$.MODULE$.get(uri);
            return this.readAllBytes(AbsolutePath$.MODULE$.apply(filepath.toString(), AbsolutePath$.MODULE$.workingDirectory()));
        }
        throw new UnsupportedOperationException(new StringBuilder(26).append("Can't read ").append(uri).append(" as InputStream").toString());
    }

    public byte[] readAllBytes(AbsolutePath path) {
        return (byte[])JSIO$.MODULE$.inNode((Function0 & Serializable)() -> {
            Array<Object> jsArray = JSFs$.MODULE$.readFileSync(path.toString());
            int len = jsArray.length();
            byte[] result = new byte[len];
            for (int curr = 0; curr < len; ++curr) {
                result[curr] = (byte)BoxesRunTime.unboxToInt((Object)jsArray.apply(curr));
            }
            return result;
        });
    }

    public Seq<TextDocument> readAllDocuments(AbsolutePath path) {
        return (Seq)JSIO$.MODULE$.inNode((Function0 & Serializable)() -> {
            byte[] bytes = MODULE$.readAllBytes(path);
            return ((TextDocuments)TextDocuments$.MODULE$.parseFrom(bytes)).documents();
        });
    }

    public void write(AbsolutePath path, GeneratedMessage proto) {
        JSIO$.MODULE$.inNode((JFunction0.mcV.sp & Serializable)() -> {
            JSFs$.MODULE$.mkdirSync(path.toNIO().getParent().toString());
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            proto.writeTo((OutputStream)os);
            Array buffer = JSConverters.JSRichIterableOnce$.MODULE$.toJSArray$extension(JSConverters$.MODULE$.iterableOnceConvertible2JSRichIterableOnce(ArrayOps$.MODULE$.map$extension(Predef$.MODULE$.byteArrayOps(os.toByteArray()), (Function1 & Serializable)x$1 -> BoxesRunTime.boxToInteger((int)BoxesRunTime.unboxToByte((Object)x$1)), (ClassTag)ClassTag$.MODULE$.Int()), (Function1 & Serializable)xs -> Predef$.MODULE$.wrapIntArray(xs)));
            JSFs$.MODULE$.writeFileSync(path.toString(), (Array<Object>)buffer);
        });
    }

    public String slurp(AbsolutePath path, Charset charset) {
        return (String)JSIO$.MODULE$.inNode((Function0 & Serializable)() -> JSFs$.MODULE$.readFileSync(path.toString(), charset.toString()));
    }

    public ListFiles listFiles(AbsolutePath path) {
        return (ListFiles)JSIO$.MODULE$.inNode((Function0 & Serializable)() -> {
            if (path.isFile()) {
                return new ListFiles(path, (List<RelativePath>)Nil$.MODULE$);
            }
            Array<String> jsArray = JSFs$.MODULE$.readdirSync(path.toString());
            Builder builder = package$.MODULE$.List().newBuilder();
            builder.sizeHint(jsArray.length());
            for (int curr = 0; curr < jsArray.length(); ++curr) {
                builder.$plus$eq((Object)RelativePath$.MODULE$.apply((String)jsArray.apply(curr)));
            }
            return new ListFiles(path, (List<RelativePath>)((List)builder.result()));
        });
    }

    public boolean isFile(AbsolutePath path) {
        return JSIO$.MODULE$.isFile(path.toString());
    }

    public boolean isDirectory(AbsolutePath path) {
        return JSIO$.MODULE$.isDirectory(path.toString());
    }

    public ListFiles listAllFilesRecursively(AbsolutePath root) {
        Builder builder = package$.MODULE$.List().newBuilder();
        this.loop$1(root, builder, root);
        return new ListFiles(root, (List<RelativePath>)((List)builder.result()));
    }

    public AbsolutePath jarRootPath(AbsolutePath jarFile) {
        throw new UnsupportedOperationException("Can't expand jar file in Scala.js");
    }

    public <T> T withJarFileSystem(AbsolutePath path, boolean create, boolean close, Function1<AbsolutePath, T> f) {
        throw new UnsupportedOperationException("Can't expand jar file in Scala.js");
    }

    public <T> boolean withJarFileSystem$default$3() {
        return false;
    }

    private final void loop$1(AbsolutePath path2, Builder builder$1, AbsolutePath root$1) {
        if (path2.isDirectory()) {
            this.listFiles(path2).foreach((Function1 & Serializable)path -> {
                this.loop$1(path, builder$1, root$1);
                return BoxedUnit.UNIT;
            });
            return;
        }
        builder$1.$plus$eq((Object)path2.toRelative(root$1));
    }

    private PlatformFileIO$() {
    }
}

