package codegen.boilerplate.api

import codegen.BoilerplateGenBase

object _Nested extends BoilerplateGenBase("Nested", "/api") {
  val content = {
    val traits = (0 to 21).map(arity => Trait(arity).body).mkString("\n")
    s"""// GENERATED CODE ********************************
       |package molecule.boilerplate.api
       |
       |import molecule.boilerplate.ast.Model._
       |
       |$traits
       |""".stripMargin
  }

  case class Trait(arity: Int) extends TemplateVals(arity) {
    val body =
      s"""
         |class Nested2TxInit_$n0[${`A..V, `}NestedTpl, Tx[${`_, _, _`}]](es: List[Element], tx: Tx[${`A..V, `}Seq[NestedTpl], Nothing]) extends Molecule_$n1[${`A..V, `}Seq[NestedTpl]] {
         |  def Tx: Tx[${`A..V, `}Seq[NestedTpl], Nothing] = tx
         |  override val elements: List[Element] = es
         |}
         |trait ${fileName}Op${_0}[${`A..V, `}Tx[${`_, _, _`}]] {
         |  protected def _nestedMan2tx[NestedTpl](nestedElements: List[Element]): Nested2TxInit_$n0[${`A..V, `}NestedTpl, Tx] = ???
         |  protected def _nestedOpt2tx[NestedTpl](nestedElements: List[Element]): Nested2TxInit_$n0[${`A..V, `}NestedTpl, Tx] = ???
         |}
         |trait $fileName_$arity[${`A..V, `}Tx[${`_, _, _`}]] { self: ${fileName}Op${_0}[${`A..V, `}Tx] =>
         |  final def * [a                                                               ] (nested: Elements_01[a                                                               ]): Nested2TxInit_$n0[${`A..V, `}a                                                                 , Tx] = _nestedMan2tx[a                                                                 ](nested.elements)
         |  final def * [a, b                                                            ] (nested: Elements_02[a, b                                                            ]): Nested2TxInit_$n0[${`A..V, `}(a, b                                                            ), Tx] = _nestedMan2tx[(a, b                                                            )](nested.elements)
         |  final def * [a, b, c                                                         ] (nested: Elements_03[a, b, c                                                         ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c                                                         ), Tx] = _nestedMan2tx[(a, b, c                                                         )](nested.elements)
         |  final def * [a, b, c, d                                                      ] (nested: Elements_04[a, b, c, d                                                      ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d                                                      ), Tx] = _nestedMan2tx[(a, b, c, d                                                      )](nested.elements)
         |  final def * [a, b, c, d, e                                                   ] (nested: Elements_05[a, b, c, d, e                                                   ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e                                                   ), Tx] = _nestedMan2tx[(a, b, c, d, e                                                   )](nested.elements)
         |  final def * [a, b, c, d, e, f                                                ] (nested: Elements_06[a, b, c, d, e, f                                                ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f                                                ), Tx] = _nestedMan2tx[(a, b, c, d, e, f                                                )](nested.elements)
         |  final def * [a, b, c, d, e, f, g                                             ] (nested: Elements_07[a, b, c, d, e, f, g                                             ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g                                             ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g                                             )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h                                          ] (nested: Elements_08[a, b, c, d, e, f, g, h                                          ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h                                          ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h                                          )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i                                       ] (nested: Elements_09[a, b, c, d, e, f, g, h, i                                       ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i                                       ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i                                       )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j                                    ] (nested: Elements_10[a, b, c, d, e, f, g, h, i, j                                    ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j                                    ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j                                    )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: Elements_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k                                 ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j, k                                 )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: Elements_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: Elements_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: Elements_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: Elements_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nested.elements)
         |  final def * [a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: Elements_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx] = _nestedMan2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nested.elements)
         |
         |  final def *?[a                                                               ] (nested: Elements_01[a                                                               ]): Nested2TxInit_$n0[${`A..V, `}a                                                                 , Tx] = _nestedOpt2tx[a                                                                 ](nested.elements)
         |  final def *?[a, b                                                            ] (nested: Elements_02[a, b                                                            ]): Nested2TxInit_$n0[${`A..V, `}(a, b                                                            ), Tx] = _nestedOpt2tx[(a, b                                                            )](nested.elements)
         |  final def *?[a, b, c                                                         ] (nested: Elements_03[a, b, c                                                         ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c                                                         ), Tx] = _nestedOpt2tx[(a, b, c                                                         )](nested.elements)
         |  final def *?[a, b, c, d                                                      ] (nested: Elements_04[a, b, c, d                                                      ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d                                                      ), Tx] = _nestedOpt2tx[(a, b, c, d                                                      )](nested.elements)
         |  final def *?[a, b, c, d, e                                                   ] (nested: Elements_05[a, b, c, d, e                                                   ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e                                                   ), Tx] = _nestedOpt2tx[(a, b, c, d, e                                                   )](nested.elements)
         |  final def *?[a, b, c, d, e, f                                                ] (nested: Elements_06[a, b, c, d, e, f                                                ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f                                                ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f                                                )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g                                             ] (nested: Elements_07[a, b, c, d, e, f, g                                             ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g                                             ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g                                             )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h                                          ] (nested: Elements_08[a, b, c, d, e, f, g, h                                          ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h                                          ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h                                          )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i                                       ] (nested: Elements_09[a, b, c, d, e, f, g, h, i                                       ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i                                       ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i                                       )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j                                    ] (nested: Elements_10[a, b, c, d, e, f, g, h, i, j                                    ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j                                    ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j                                    )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k                                 ] (nested: Elements_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k                                 ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j, k                                 )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l                              ] (nested: Elements_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m                           ] (nested: Elements_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ] (nested: Elements_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ] (nested: Elements_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ] (nested: Elements_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ] (nested: Elements_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ] (nested: Elements_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ] (nested: Elements_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ] (nested: Elements_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ] (nested: Elements_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nested.elements)
         |  final def *?[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v] (nested: Elements_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Nested2TxInit_$n0[${`A..V, `}(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx] = _nestedOpt2tx[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nested.elements)
         |}
         |""".stripMargin
  }
}
