// GENERATED CODE ********************************
package molecule.boilerplate.api

import molecule.boilerplate.ast.Model._

/** Build composite molecule.
 * <br><br>
 * Composite molecules model entities with attributes from different namespaces that are
 * not necessarily related. Each group of attributes is modelled by a molecule and the
 * "sub-molecules" are tied together with `+` methods to form a composite molecule.
 * <br><br>
 * The attributes of the first sub-molecule are tied
 * together in a tuple of its own before being merged with the tuple of attribute values
 * of the second sub-molecule. If any of the sub-molecules are of arity-1, then no tuple is created:
 * {{{
 * for {
 *   // Arity 1 + 1
 *   _ <- m(Article.name + Tag.category).get.map(_ ==> List(
 *     ("Battle of Waterloo", "History")
 *   ))
 *
 *   // Arity 1 + 2
 *   _ <- m(Article.name + Tag.category.weight).get.map(_ ==> List(
 *     ("Battle of Waterloo", ("History", 5))
 *   ))
 *
 *   // Arity 2 + 1
 *   _ <- m(Article.name.author + Tag.category).get.map(_ ==> List(
 *     (("Battle of Waterloo", "Ben Bridge"), "History")
 *   ))
 *
 *   // Arity 2 + 2
 *   _ <- m(Article.name.author + Tag.category.weight).get.map(_ ==> List(
 *     (("Battle of Waterloo", "Ben Bridge"), ("History", 5))
 *   ))
 *
 *   // Arity 3 + 2 etc...
 *   _ <- m(Article.name.author.editor + Tag.category.weight).get.map(_ ==> List(
 *     (("Battle of Waterloo", "Ben Bridge", "Joe Moe"), ("History", 5))
 *   ))
 * } yield ()
 * }}}
 */
trait CompositeInitBase


trait CompositeInit_0[Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[Nothing] =>
  protected def _compositeInit00    (nextMolecule: List[Element]): Composite_00[    Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit01[T2](nextMolecule: List[Element]): Composite_01[T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_00[                                                                    Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit00                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_01[a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_01[(a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_01[(a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_01[(a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_01[(a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_01[(a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_01[(a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_01[(a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_01[(a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_01[(a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_1[A, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[A] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[A    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[A, T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[A,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[A, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[A, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[A, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[A, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[A, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[A, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[A, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[A, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[A, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[A, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_2[A, B, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_3[A, B, C, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_4[A, B, C, D, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_5[A, B, C, D, E, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_6[A, B, C, D, E, F, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_7[A, B, C, D, E, F, G, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_8[A, B, C, D, E, F, G, H, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_9[A, B, C, D, E, F, G, H, I, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_10[A, B, C, D, E, F, G, H, I, J, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_11[A, B, C, D, E, F, G, H, I, J, K, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J, K)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J, K)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J, K),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_12[A, B, C, D, E, F, G, H, I, J, K, L, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J, K, L)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_13[A, B, C, D, E, F, G, H, I, J, K, L, M, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J, K, L, M)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_14[A, B, C, D, E, F, G, H, I, J, K, L, M, N, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J, K, L, M, N)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_15[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_16[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_17[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_18[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_19[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_20[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_21[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}

trait CompositeInit_22[A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]] extends CompositeInitBase { self: Molecule[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V)] =>
  protected def _compositeInit01    (nextMolecule: List[Element]): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V)    , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
  protected def _compositeInit02[T2](nextMolecule: List[Element]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), T2, Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V),                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit01                                                                    (nextMolecule.elements)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[a                                                                 ](nextMolecule.elements)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b                                                            )](nextMolecule.elements)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c                                                         )](nextMolecule.elements)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d                                                      )](nextMolecule.elements)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e                                                   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f                                                )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g                                             )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h                                          )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i                                       )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j                                    )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k                                 )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l                              )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m                           )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   )](nextMolecule.elements)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[(A, B, C, D, E, F, G, H, I, J, K, L, M, N, O, P, Q, R, S, T, U, V), (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = _compositeInit02[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v)](nextMolecule.elements)
}
