// GENERATED CODE ********************************
package molecule.boilerplate.api

import molecule.boilerplate.ast.Model._

/** Add sub-molecule to composite molecule.
 * <br><br>
 * Composite molecules model entities with attributes from different namespaces that are
 * not necessarily related. Each group of attributes is modelled by a molecule and these
 * "sub-molecules" are tied together with `+` methods to form a composite molecule.
 * <br><br>
 * `+` methods of this interface adds a new sub-molecule to the composite.
 * {{{
 * //                                          | add sub-molecule
 * m(Article.name.author + Tag.category.weight + Publisher.name).get.map(_ ==> List(
 *   (("Battle of Waterloo", "Ben Bridge"), ("History", 5), "Bestseller Publications Inc.")
 * ))
 * }}}
 */
trait CompositeBase

case class Composite_00[Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_00 {
  def Tx: Tx0[Nothing] with TxMetaData_0 = txs._compositeTx_00(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_00[                                                                    Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_00(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_01[a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_01[(a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_01[(a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_01[(a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_01[(a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_01[(a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_01[(a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_01[(a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_01[(a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_01[(a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_01[(a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_01[T1, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_01[T1] {
  def Tx: Tx1[T1, Nothing] with TxMetaData_1[T1] = txs._compositeTx_01(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_01[T1,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_01(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_02[T1, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_02[T1, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_02[T1, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_02[T1, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_02[T1, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_02[T1, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_02[T1, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_02[T1, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_02[T1, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_02[T1, T2, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_02[T1, T2] {
  def Tx: Tx2[T1, T2, Nothing] with TxMetaData_2[T1, T2] = txs._compositeTx_02(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_02[T1, T2,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_02(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_03[T1, T2, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_03[T1, T2, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_03[T1, T2, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_03[T1, T2, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_03[T1, T2, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_03[T1, T2, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_03[T1, T2, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_03[T1, T2, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_03[T1, T2, T3, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_03[T1, T2, T3] {
  def Tx: Tx3[T1, T2, T3, Nothing] with TxMetaData_3[T1, T2, T3] = txs._compositeTx_03(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_03[T1, T2, T3,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_03(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_04[T1, T2, T3, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_04[T1, T2, T3, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_04[T1, T2, T3, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_04[T1, T2, T3, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_04[T1, T2, T3, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_04[T1, T2, T3, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_04[T1, T2, T3, T4, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_04[T1, T2, T3, T4] {
  def Tx: Tx4[T1, T2, T3, T4, Nothing] with TxMetaData_4[T1, T2, T3, T4] = txs._compositeTx_04(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_04[T1, T2, T3, T4,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_04(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_05[T1, T2, T3, T4, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_05[T1, T2, T3, T4, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_05[T1, T2, T3, T4, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_05[T1, T2, T3, T4, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_05[T1, T2, T3, T4, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_05[T1, T2, T3, T4, T5, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_05[T1, T2, T3, T4, T5] {
  def Tx: Tx5[T1, T2, T3, T4, T5, Nothing] with TxMetaData_5[T1, T2, T3, T4, T5] = txs._compositeTx_05(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_05[T1, T2, T3, T4, T5,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_05(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_06[T1, T2, T3, T4, T5, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_06[T1, T2, T3, T4, T5, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_06[T1, T2, T3, T4, T5, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_06[T1, T2, T3, T4, T5, T6, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_06[T1, T2, T3, T4, T5, T6] {
  def Tx: Tx6[T1, T2, T3, T4, T5, T6, Nothing] with TxMetaData_6[T1, T2, T3, T4, T5, T6] = txs._compositeTx_06(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_06[T1, T2, T3, T4, T5, T6,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_06(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_07[T1, T2, T3, T4, T5, T6, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_07[T1, T2, T3, T4, T5, T6, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_07[T1, T2, T3, T4, T5, T6, T7, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_07[T1, T2, T3, T4, T5, T6, T7] {
  def Tx: Tx7[T1, T2, T3, T4, T5, T6, T7, Nothing] with TxMetaData_7[T1, T2, T3, T4, T5, T6, T7] = txs._compositeTx_07(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_07[T1, T2, T3, T4, T5, T6, T7,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_07(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_08[T1, T2, T3, T4, T5, T6, T7, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_08[T1, T2, T3, T4, T5, T6, T7, T8, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_08[T1, T2, T3, T4, T5, T6, T7, T8] {
  def Tx: Tx8[T1, T2, T3, T4, T5, T6, T7, T8, Nothing] with TxMetaData_8[T1, T2, T3, T4, T5, T6, T7, T8] = txs._compositeTx_08(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_08[T1, T2, T3, T4, T5, T6, T7, T8,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_08(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, T9, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_09[T1, T2, T3, T4, T5, T6, T7, T8, T9] {
  def Tx: Tx9[T1, T2, T3, T4, T5, T6, T7, T8, T9, Nothing] with TxMetaData_9[T1, T2, T3, T4, T5, T6, T7, T8, T9] = txs._compositeTx_09(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_09[T1, T2, T3, T4, T5, T6, T7, T8, T9,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_09(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10] {
  def Tx: Tx10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, Nothing] with TxMetaData_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10] = txs._compositeTx_10(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_10[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_10(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11] {
  def Tx: Tx11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, Nothing] with TxMetaData_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11] = txs._compositeTx_11(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_11[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_11(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12] {
  def Tx: Tx12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, Nothing] with TxMetaData_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12] = txs._compositeTx_12(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_12[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_12(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13] {
  def Tx: Tx13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, Nothing] with TxMetaData_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13] = txs._compositeTx_13(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_13[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_13(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14] {
  def Tx: Tx14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, Nothing] with TxMetaData_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14] = txs._compositeTx_14(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_14[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_14(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15] {
  def Tx: Tx15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, Nothing] with TxMetaData_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15] = txs._compositeTx_15(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_15[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_15(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16] {
  def Tx: Tx16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, Nothing] with TxMetaData_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16] = txs._compositeTx_16(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_16[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_16(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17] {
  def Tx: Tx17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, Nothing] with TxMetaData_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17] = txs._compositeTx_17(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_17[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_17(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18] {
  def Tx: Tx18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, Nothing] with TxMetaData_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18] = txs._compositeTx_18(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_18[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_18(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19] {
  def Tx: Tx19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, Nothing] with TxMetaData_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19] = txs._compositeTx_19(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_19[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_19(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20] {
  def Tx: Tx20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, Nothing] with TxMetaData_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20] = txs._compositeTx_20(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_20[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_20(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21] {
  def Tx: Tx21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, Nothing] with TxMetaData_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21] = txs._compositeTx_21(elements)

  final def +                                                                  (nextMolecule: Molecule_00                                                                  ): Composite_21[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21,                                                                     Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_21(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a                                                               ](nextMolecule: Molecule_01[a                                                               ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, a                                                                 , Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b                                                            ](nextMolecule: Molecule_02[a, b                                                            ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b                                                            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c                                                         ](nextMolecule: Molecule_03[a, b, c                                                         ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c                                                         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d                                                      ](nextMolecule: Molecule_04[a, b, c, d                                                      ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d                                                      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e                                                   ](nextMolecule: Molecule_05[a, b, c, d, e                                                   ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e                                                   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f                                                ](nextMolecule: Molecule_06[a, b, c, d, e, f                                                ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f                                                ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g                                             ](nextMolecule: Molecule_07[a, b, c, d, e, f, g                                             ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g                                             ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h                                          ](nextMolecule: Molecule_08[a, b, c, d, e, f, g, h                                          ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h                                          ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i                                       ](nextMolecule: Molecule_09[a, b, c, d, e, f, g, h, i                                       ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i                                       ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j                                    ](nextMolecule: Molecule_10[a, b, c, d, e, f, g, h, i, j                                    ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j                                    ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k                                 ](nextMolecule: Molecule_11[a, b, c, d, e, f, g, h, i, j, k                                 ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k                                 ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l                              ](nextMolecule: Molecule_12[a, b, c, d, e, f, g, h, i, j, k, l                              ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l                              ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m                           ](nextMolecule: Molecule_13[a, b, c, d, e, f, g, h, i, j, k, l, m                           ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m                           ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ](nextMolecule: Molecule_14[a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n                        ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ](nextMolecule: Molecule_15[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o                     ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ](nextMolecule: Molecule_16[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p                  ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ](nextMolecule: Molecule_17[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q               ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ](nextMolecule: Molecule_18[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r            ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ](nextMolecule: Molecule_19[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s         ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ](nextMolecule: Molecule_20[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t      ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ](nextMolecule: Molecule_21[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u   ), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
  final def +[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v](nextMolecule: Molecule_22[a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v]): Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, (a, b, c, d, e, f, g, h, i, j, k, l, m, n, o, p, q, r, s, t, u, v), Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22] = Composite_22(elements :+ Composite(nextMolecule.elements), txs)
}

case class Composite_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, Tx0[_], Tx1[_,_], Tx2[_,_,_], Tx3[_,_,_,_], Tx4[_,_,_,_,_], Tx5[_,_,_,_,_,_], Tx6[_,_,_,_,_,_,_], Tx7[_,_,_,_,_,_,_,_], Tx8[_,_,_,_,_,_,_,_,_], Tx9[_,_,_,_,_,_,_,_,_,_], Tx10[_,_,_,_,_,_,_,_,_,_,_], Tx11[_,_,_,_,_,_,_,_,_,_,_,_], Tx12[_,_,_,_,_,_,_,_,_,_,_,_,_], Tx13[_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx14[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx15[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx16[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx17[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx18[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx19[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx20[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx21[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_], Tx22[_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_,_]](
  override val elements: List[Element],
  txs: CompositeTx_[Tx0, Tx1, Tx2, Tx3, Tx4, Tx5, Tx6, Tx7, Tx8, Tx9, Tx10, Tx11, Tx12, Tx13, Tx14, Tx15, Tx16, Tx17, Tx18, Tx19, Tx20, Tx21, Tx22]
) extends CompositeBase with Elements_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22] {
  def Tx: Tx22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22, Nothing] with TxMetaData_22[T1, T2, T3, T4, T5, T6, T7, T8, T9, T10, T11, T12, T13, T14, T15, T16, T17, T18, T19, T20, T21, T22] = txs._compositeTx_22(elements)
}
