package codegen.boilerplate.api.expression

import codegen.BoilerplateGenBase

object _ExprAttr extends BoilerplateGenBase("ExprAttr", "/api/expression") {
  val content = {
    val traits = (1 to 22).map(arity => Trait(arity).body).mkString("\n")
    s"""// GENERATED CODE ********************************
       |package molecule.boilerplate.api.expression
       |
       |import molecule.base.ast._
       |import molecule.boilerplate.api._
       |import molecule.boilerplate.ast.Model._
       |import scala.language.higherKinds
       |
       |
       |trait ExprAttr_0[t, Ns1[_], Ns2[_, _]] extends ExprBase {
       |  protected def _attrTac[   ns1[_]   , ns2[_, _]   ](op: Op, a: ModelOps_0[   t, ns1, ns2]): Ns1[   t] = ???
       |  protected def _attrMan[X, ns1[_, _], ns2[_, _, _]](op: Op, a: ModelOps_1[X, t, ns1, ns2]): Ns2[X, t] = ???
       |}
       |$traits""".stripMargin
  }

  case class Trait(arity: Int) extends TemplateVals(arity) {
    val body   = if (arity == 22) {
      s"""
         |trait $fileName_$arity[${`A..V`}, t, Ns1[${`_, _`}], Ns2[${`_, _, _`}]] extends ExprBase {
         |  protected def _attrSortTac[   ns1[_]   , ns2[_, _]   ](op: Op, a: ModelOps_0[   t, ns1, ns2] with CardOne): Ns1[${`A..V`},    t] with SortAttrs${_0}[${`A..V`},    t, Ns1] = ???
         |  protected def _attrTac    [   ns1[_]   , ns2[_, _]   ](op: Op, a: ModelOps_0[   t, ns1, ns2]             ): Ns1[${`A..V`},    t] = ???
         |}""".stripMargin
    } else {
      s"""
         |trait $fileName_$arity[${`A..V`}, t, Ns1[${`_, _`}], Ns2[${`_, _, _`}]] extends ExprBase {
         |  protected def _attrSortTac[   ns1[_]   , ns2[_, _]   ](op: Op, a: ModelOps_0[   t, ns1, ns2] with CardOne): Ns1[${`A..V`},    t] with SortAttrs${_0}[${`A..V`},    t, Ns1] = ???
         |  protected def _attrSortMan[   ns1[_, _], ns2[_, _, _]](op: Op, a: ModelOps_1[$V, t, ns1, ns2]             ): Ns2[${`A..V`}, $V, t] with SortAttrs${_1}[${`A..V`}, $V, t, Ns2] = ???
         |  protected def _attrTac    [   ns1[_]   , ns2[_, _]   ](op: Op, a: ModelOps_0[   t, ns1, ns2]             ): Ns1[${`A..V`},    t] = ???
         |  protected def _attrMan    [X, ns1[_, _], ns2[_, _, _]](op: Op, a: ModelOps_1[X, t, ns1, ns2]             ): Ns2[${`A..V`}, X, t] = ???
         |}""".stripMargin
    }
  }
}
